/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.gdface.facelog.DuplicateRecordException;
import net.gdface.facelog.FuzzyMatchCountExceedLimitException;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.LockWakeupResponse;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.MatchEntry;
import net.gdface.facelog.PersonDataPackage;
import net.gdface.facelog.ServiceSecurityException;
import net.gdface.facelog.TmpPwdTargetType;
import net.gdface.facelog.TmpwdTargetInfo;
import net.gdface.facelog.Token;
import net.gdface.facelog.TopGroupInfo;
import net.gdface.facelog.client.thrift.DeviceBean;
import net.gdface.facelog.client.thrift.IFaceLogClient;
import net.gdface.facelog.client.thrift.LogBean;
import net.gdface.facelog.client.thrift.LogLightBean;
import net.gdface.facelog.client.thrift.StringMatchType;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.ErrorLogBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.facelog.thrift.ServiceRuntimeException;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.ThriftUtils;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class IFaceLogThriftClient
implements IFaceLog {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public IFaceLogThriftClient(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public IFaceLogThriftClient(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    public IFaceLogThriftClient(HostAndPort hostAndPort) {
        this(ClientFactory.builder().setHostAndPort(hostAndPort));
    }

    public boolean testConnect() {
        return this.factory.testConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, L> R syncCall(final Function<L, R> transformer, ServiceAsyncCall<L> serviceCall) throws Throwable {
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        final AtomicReference<Object> err = new AtomicReference<Object>(null);
        final Object lock = new Object();
        final ServiceMethodCallback callback = new ServiceMethodCallback<L>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(L result) {
                res.set(transformer.apply(result));
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable error) {
                err.set(error);
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        };
        AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                callback.onError(error);
            }
        };
        IFaceLogClient service = (IFaceLogClient)this.factory.applyInstance(IFaceLogClient.class, closeListener);
        Object object = lock;
        synchronized (object) {
            try {
                serviceCall.call(service, callback);
                lock.wait();
            }
            catch (InterruptedException e) {
                err.set(e);
            }
            finally {
                try {
                    service.close();
                }
                catch (IOException iOException) {}
            }
        }
        Throwable e = err.get();
        if (null != e) {
            ThriftUtils.returnNull((Throwable)e);
        }
        return res.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClient [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public void addErrorLog(final ErrorLogBean errorLogBean, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addErrorLog((net.gdface.facelog.client.thrift.ErrorLogBean)TypeTransformer.getInstance().to((Object)errorLogBean, ErrorLogBean.class, net.gdface.facelog.client.thrift.ErrorLogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FeatureBean addFeature(final byte[] feature, final String featureVersion, final Integer personId, final boolean asIdPhotoIfAbsent, final byte[] featurePhoto, final FaceBean faceBean, final String removed, final Token token) throws DuplicateRecordException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback) {
                    service.addFeatureWithImage((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, asIdPhotoIfAbsent, (ByteString)TypeTransformer.getInstance().to((Object)featurePhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), removed, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FeatureBean addFeature(final byte[] feature, final String featureVersion, final Integer personId, final List<FaceBean> faecBeans, final String removed, final Token token) throws DuplicateRecordException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback) {
                    service.addFeature((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, TypeTransformer.getInstance().to(faecBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), removed, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FeatureBean addFeature(final byte[] feature, final String featureVersion, final Integer personId, final List<byte[]> photos, final List<FaceBean> faces, final String removed, final Token token) throws DuplicateRecordException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback) {
                    service.addFeatureMulti((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, TypeTransformer.getInstance().to(photos, byte[].class, ByteString.class), TypeTransformer.getInstance().to(faces, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), removed, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ImageBean addImage(final byte[] imageData, final Integer deviceId, final FaceBean faceBean, final Integer personId, final Token token) throws DuplicateRecordException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.ImageBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.ImageBean> nativeCallback) {
                    service.addImage((ByteString)TypeTransformer.getInstance().to((Object)imageData, byte[].class, ByteString.class), deviceId, (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addLog(final net.gdface.facelog.db.LogBean logBean, final byte[] faceImage, final Token token) throws DuplicateRecordException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addLogWithFaceImage((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (ByteString)TypeTransformer.getInstance().to((Object)faceImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addLog(final net.gdface.facelog.db.LogBean logBean, final Token token) throws DuplicateRecordException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addLog((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addLog(final net.gdface.facelog.db.LogBean logBean, final FaceBean faceBean, final byte[] featureImage, final Token token) throws DuplicateRecordException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addLogFull((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (ByteString)TypeTransformer.getInstance().to((Object)featureImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addLogs(final List<net.gdface.facelog.db.LogBean> logBeans, final List<FaceBean> faceBeans, final List<byte[]> featureImages, final Token token) throws DuplicateRecordException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addLogsFull(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), TypeTransformer.getInstance().to(featureImages, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addLogs(final List<net.gdface.facelog.db.LogBean> logBeans, final List<byte[]> faceImages, final Token token) throws DuplicateRecordException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addLogsWithFaceImage(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), TypeTransformer.getInstance().to(faceImages, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addLogs(final List<net.gdface.facelog.db.LogBean> logBeans, final Token token) throws DuplicateRecordException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.addLogs(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.DuplicateRecordException e) {
            throw (DuplicateRecordException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.DuplicateRecordException.class, DuplicateRecordException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String applyAckChannel(final int duration, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.applyAckChannelWithDuration(duration, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String applyAckChannel(final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.applyAckChannel((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int applyCmdSn(final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.applyCmdSn((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Token applyPersonToken(final int personId, final String password, final boolean isMd5) throws ServiceSecurityException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback) {
                    service.applyPersonToken(personId, password, isMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Token applyRootToken(final String password, final boolean isMd5) throws ServiceSecurityException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback) {
                    service.applyRootToken(password, isMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Token applyUserToken(final int userid, final String password, final boolean isMd5) throws ServiceSecurityException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback) {
                    service.applyUserToken(userid, password, isMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void bindBorder(final int personGroupId, final int deviceGroupId, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.bindBorder(personGroupId, deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> childListForDeviceGroup(final int deviceGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.childListForDeviceGroup(deviceGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> childListForPersonGroup(final int personGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.childListForPersonGroup(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countDeviceByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countDeviceByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countDeviceByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countDeviceByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countDeviceGroupByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countDeviceGroupByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countDeviceGroupByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countDeviceGroupByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countErrorLogByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countErrorLogByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogLightByVerifyTime(final String timestamp) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogLightByVerifyTimeTimestr(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogLightByVerifyTime(final String timestamp, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogLightByVerifyTimeTimestrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogLightByVerifyTime(final long timestamp) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogLightByVerifyTime(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogLightByVerifyTime(final long timestamp, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogLightByVerifyTimeSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogLightByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogLightByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countLogLightByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countLogLightByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countPersonByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countPersonByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countPersonByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countPersonByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countPersonGroupByWhere(final String where) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countPersonGroupByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int countPersonGroupByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.countPersonGroupByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Integer> countPersonLog(final int personId, final Long startDate, final Long endDate) {
        try {
            return this.syncCall(new Function<Map<String, Integer>, Map<String, Integer>>(){

                public Map<String, Integer> apply(Map<String, Integer> input) {
                    return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
                }
            }, new ServiceAsyncCall<Map<String, Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, Integer>> nativeCallback) {
                    service.countPersonLog(personId, startDate, endDate, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Integer> countPersonLog(final int personId, final Long startDate, final Long endDate, final Token token) {
        try {
            return this.syncCall(new Function<Map<String, Integer>, Map<String, Integer>>(){

                public Map<String, Integer> apply(Map<String, Integer> input) {
                    return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
                }
            }, new ServiceAsyncCall<Map<String, Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, Integer>> nativeCallback) {
                    service.countPersonLogSafe(personId, startDate, endDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Integer> countPersonLog(final int personId, final String startDate, final String endDate) {
        try {
            return this.syncCall(new Function<Map<String, Integer>, Map<String, Integer>>(){

                public Map<String, Integer> apply(Map<String, Integer> input) {
                    return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
                }
            }, new ServiceAsyncCall<Map<String, Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, Integer>> nativeCallback) {
                    service.countPersonLogTimeStr(personId, startDate, endDate, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Integer> countPersonLog(final int personId, final String startDate, final String endDate, final Token token) {
        try {
            return this.syncCall(new Function<Map<String, Integer>, Map<String, Integer>>(){

                public Map<String, Integer> apply(Map<String, Integer> input) {
                    return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
                }
            }, new ServiceAsyncCall<Map<String, Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, Integer>> nativeCallback) {
                    service.countPersonLogTimeStrSafe(personId, startDate, endDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String createTempPwd(final int targetId, final TmpPwdTargetType targetType, final int duration, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.createTempPwdWithDuration(targetId, (net.gdface.facelog.client.thrift.TmpPwdTargetType)((Object)TypeTransformer.getInstance().to((Object)targetType, TmpPwdTargetType.class, net.gdface.facelog.client.thrift.TmpPwdTargetType.class)), duration, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String createTempPwd(final int targetId, final TmpPwdTargetType targetType, final String expiryDate, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.createTempPwd(targetId, (net.gdface.facelog.client.thrift.TmpPwdTargetType)((Object)TypeTransformer.getInstance().to((Object)targetType, TmpPwdTargetType.class, net.gdface.facelog.client.thrift.TmpPwdTargetType.class)), expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteAllFeaturesByPersonId(final int personId, final boolean deleteImage, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deleteAllFeaturesByPersonId(personId, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean deleteDevice(final int id, final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.deleteDevice(id, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean deleteDeviceByMac(final String mac, final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.deleteDeviceByMac(mac, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteDeviceGroup(final int deviceGroupId, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deleteDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteErrorLogByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deleteErrorLogByWhere(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> deleteFeature(final String featureMd5, final boolean deleteImage, final Token token) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.deleteFeature(featureMd5, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteGroupPermitOnDeviceGroup(final int deviceGroupId, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deleteGroupPermitOnDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteImage(final String imageMd5, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deleteImage(imageMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteLogByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deleteLogByWhere(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePermit(final int deviceGroupId, final int personGroupId, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePermitById(deviceGroupId, personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePerson(final int personId, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePerson(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersonByMobilePhone(final String mobilePhone, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersonByMobilePhone(mobilePhone, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersonByPapersNum(final String papersNum, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersonByPapersNum(papersNum, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersonGroup(final int personGroupId, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersonGroup(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersonGroupPermit(final int personGroupId, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersonGroupPermit(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersons(final List<Integer> personIdList, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersons(personIdList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersonsByMobilePhone(final List<String> mobilePhoneList, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersonsByMobilePhone(mobilePhoneList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int deletePersonsByPapersNum(final List<String> papersNumList, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.deletePersonsByPapersNum(papersNumList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void disablePerson(final int personId, final Integer moveToGroupId, final boolean deletePhoto, final boolean deleteFeature, final boolean deleteLog, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.disablePerson(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void disablePerson(final List<Integer> personIdList, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.disablePersonList(personIdList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean existsDevice(final int id) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.existsDevice(id, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean existsFeature(final String md5) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.existsFeature(md5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean existsImage(final String md5) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.existsImage(md5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean existsPerson(final int persionId) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.existsPerson(persionId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int faceRecognizePersonPermitted(final byte[] imageData, final Float threshold, final int group, final int deviceId, final boolean searchInPermited) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.faceRecognizePersonPermitted((ByteString)TypeTransformer.getInstance().to((Object)imageData, byte[].class, ByteString.class), threshold == null ? null : Double.valueOf(threshold.doubleValue()), group, deviceId, searchInPermited, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<MatchEntry> fuzzySearch(final String tablename, final String column, final String pattern, final gu.sql2java.StringMatchType matchType, final int matchFlags, final int parentGroupId, final int maxMatchCount) throws FuzzyMatchCountExceedLimitException {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.MatchEntry>, List<MatchEntry>>(){

                public List<MatchEntry> apply(List<net.gdface.facelog.client.thrift.MatchEntry> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MatchEntry.class, MatchEntry.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.MatchEntry>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.MatchEntry>> nativeCallback) {
                    service.fuzzySearch(tablename, column, pattern, (StringMatchType)((Object)TypeTransformer.getInstance().to((Object)matchType, gu.sql2java.StringMatchType.class, StringMatchType.class)), matchFlags, parentGroupId, maxMatchCount, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.FuzzyMatchCountExceedLimitException e) {
            throw (FuzzyMatchCountExceedLimitException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.FuzzyMatchCountExceedLimitException.class, FuzzyMatchCountExceedLimitException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<MatchEntry> fuzzySearchPerson(final String column, final String pattern, final gu.sql2java.StringMatchType matchType, final int matchFlags, final int parentGroupId, final int maxMatchCount, final Token token) throws FuzzyMatchCountExceedLimitException {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.MatchEntry>, List<MatchEntry>>(){

                public List<MatchEntry> apply(List<net.gdface.facelog.client.thrift.MatchEntry> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MatchEntry.class, MatchEntry.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.MatchEntry>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.MatchEntry>> nativeCallback) {
                    service.fuzzySearchPerson(column, pattern, (StringMatchType)((Object)TypeTransformer.getInstance().to((Object)matchType, gu.sql2java.StringMatchType.class, StringMatchType.class)), matchFlags, parentGroupId, maxMatchCount, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.FuzzyMatchCountExceedLimitException e) {
            throw (FuzzyMatchCountExceedLimitException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.FuzzyMatchCountExceedLimitException.class, FuzzyMatchCountExceedLimitException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public net.gdface.facelog.db.DeviceBean getDevice(final int deviceId) {
        try {
            return this.syncCall(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

                public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                    return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<DeviceBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<DeviceBean> nativeCallback) {
                    service.getDevice(deviceId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public net.gdface.facelog.db.DeviceBean getDeviceByMac(final String mac) {
        try {
            return this.syncCall(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

                public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                    return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<DeviceBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<DeviceBean> nativeCallback) {
                    service.getDeviceByMac(mac, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DeviceGroupBean getDeviceGroup(final int deviceGroupId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

                public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                    return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceGroupBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback) {
                    service.getDeviceGroup(deviceGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<DeviceGroupBean> getDeviceGroups(final List<Integer> groupIdList) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>, List<DeviceGroupBean>>(){

                public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.DeviceGroupBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.DeviceGroupBean>> nativeCallback) {
                    service.getDeviceGroups(groupIdList, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getDeviceGroupsBelongs(final int deviceId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getDeviceGroupsBelongs(deviceId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getDeviceGroupsPermit(final int personGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getDeviceGroupsPermit(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getDeviceGroupsPermittedBy(final int personGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getDeviceGroupsPermittedBy(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Integer getDeviceIdOfFeature(final String featureMd5) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.getDeviceIdOfFeature(featureMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.DeviceBean> getDevices(final List<Integer> idList) {
        try {
            return this.syncCall(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

                public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                    return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<List<DeviceBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<DeviceBean>> nativeCallback) {
                    service.getDevices(idList, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getDevicesOfGroup(final int deviceGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getDevicesOfGroup(deviceGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FaceBean getFace(final int faceId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.FaceBean, FaceBean>(){

                public FaceBean apply(net.gdface.facelog.client.thrift.FaceBean input) {
                    return (FaceBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.FaceBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.FaceBean> nativeCallback) {
                    service.getFace(faceId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getFaceApiParameters(final Token token) {
        try {
            return this.syncCall(new Function<Map<String, String>, Map<String, String>>(){

                public Map<String, String> apply(Map<String, String> input) {
                    return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
                }
            }, new ServiceAsyncCall<Map<String, String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, String>> nativeCallback) {
                    service.getFaceApiParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<FaceBean> getFacesOfFeature(final String featureMd5) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.FaceBean>, List<FaceBean>>(){

                public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.FaceBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback) {
                    service.getFacesOfFeature(featureMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<FaceBean> getFacesOfImage(final String imageMd5) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.FaceBean>, List<FaceBean>>(){

                public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.FaceBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback) {
                    service.getFacesOfImage(imageMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FeatureBean getFeature(final String md5) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback) {
                    service.getFeature(md5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getFeatureBytes(final String md5) {
        try {
            return this.syncCall(new Function<ByteString, byte[]>(){

                public byte[] apply(ByteString input) {
                    return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
                }
            }, new ServiceAsyncCall<ByteString>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<ByteString> nativeCallback) {
                    service.getFeatureBytes(md5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getFeatureBytes(final String md5, final boolean truncation) {
        try {
            return this.syncCall(new Function<ByteString, byte[]>(){

                public byte[] apply(ByteString input) {
                    return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
                }
            }, new ServiceAsyncCall<ByteString>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<ByteString> nativeCallback) {
                    service.getFeatureBytesTruncation(md5, truncation, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<byte[]> getFeatureBytesList(final List<String> md5List, final boolean truncation) {
        try {
            return this.syncCall(new Function<List<ByteString>, List<byte[]>>(){

                public List<byte[]> apply(List<ByteString> input) {
                    return TypeTransformer.getInstance().to(input, ByteString.class, byte[].class);
                }
            }, new ServiceAsyncCall<List<ByteString>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<ByteString>> nativeCallback) {
                    service.getFeatureBytesList(md5List, truncation, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<FeatureBean> getFeatures(final List<String> md5List) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.FeatureBean>, List<FeatureBean>>(){

                public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.FeatureBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.FeatureBean>> nativeCallback) {
                    service.getFeatures(md5List, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getFeaturesByPersonIdAndSdkVersion(final int personId, final String sdkVersion) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.getFeaturesByPersonIdAndSdkVersion(personId, sdkVersion, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getFeaturesOfImage(final String imageMd5) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.getFeaturesOfImage(imageMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getFeaturesOfPerson(final int personId) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.getFeaturesOfPerson(personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getFeaturesPermittedOnDevice(final int deviceId, final boolean ignoreSchedule, final String sdkVersion, final List<String> excludeFeatureIds, final Long timestamp) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.getFeaturesPermittedOnDevice(deviceId, ignoreSchedule, sdkVersion, excludeFeatureIds, timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getGroupIdsByPath(final String tablename, final String path) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getGroupIdsByPath(tablename, path, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PermitBean getGroupPermit(final int deviceId, final int personGroupId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback) {
                    service.getGroupPermit(deviceId, personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PermitBean getGroupPermitOnDeviceGroup(final int deviceGroupId, final int personGroupId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback) {
                    service.getGroupPermitOnDeviceGroup(deviceGroupId, personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PermitBean> getGroupPermits(final int deviceId, final List<Integer> personGroupIdList) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback) {
                    service.getGroupPermits(deviceId, personGroupIdList, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ImageBean getImage(final String imageMD5) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.ImageBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.ImageBean> nativeCallback) {
                    service.getImage(imageMD5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ImageBean getImage(final String primaryKey, final String refType) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.ImageBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.ImageBean> nativeCallback) {
                    service.getImageRef(primaryKey, refType, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getImageBytes(final String imageMD5) {
        try {
            return this.syncCall(new Function<ByteString, byte[]>(){

                public byte[] apply(ByteString input) {
                    return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
                }
            }, new ServiceAsyncCall<ByteString>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<ByteString> nativeCallback) {
                    service.getImageBytes(imageMD5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getImageBytes(final String primaryKey, final String refType) {
        try {
            return this.syncCall(new Function<ByteString, byte[]>(){

                public byte[] apply(ByteString input) {
                    return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
                }
            }, new ServiceAsyncCall<ByteString>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<ByteString> nativeCallback) {
                    service.getImageBytesRef(primaryKey, refType, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getImagesAssociatedByFeature(final String featureMd5) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.getImagesAssociatedByFeature(featureMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogBean> getLogBeansByPersonId(final int personId) {
        try {
            return this.syncCall(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

                public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                    return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
                }
            }, new ServiceAsyncCall<List<LogBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogBean>> nativeCallback) {
                    service.getLogBeansByPersonId(personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogBean> getLogBeansByPersonId(final int personId, final Token token) {
        try {
            return this.syncCall(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

                public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                    return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
                }
            }, new ServiceAsyncCall<List<LogBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogBean>> nativeCallback) {
                    service.getLogBeansByPersonIdSafe(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<MQParam, String> getMessageQueueParameters(final Token token) {
        try {
            return this.syncCall(new Function<Map<net.gdface.facelog.client.thrift.MQParam, String>, Map<MQParam, String>>(){

                public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam, String> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MQParam.class, String.class, MQParam.class, String.class);
                }
            }, new ServiceAsyncCall<Map<net.gdface.facelog.client.thrift.MQParam, String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<net.gdface.facelog.client.thrift.MQParam, String>> nativeCallback) {
                    service.getMessageQueueParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean getPerson(final int personId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.getPerson(personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean getPerson(final int personId, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.getPersonReal(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean getPersonByMobilePhone(final String mobilePhone) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.getPersonByMobilePhone(mobilePhone, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean getPersonByMobilePhone(final String mobilePhone, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.getPersonByMobilePhoneReal(mobilePhone, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean getPersonByPapersNum(final String papersNum) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.getPersonByPapersNum(papersNum, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean getPersonByPapersNum(final String papersNum, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.getPersonByPapersNumSafe(papersNum, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonGroupBean getPersonGroup(final int personGroupId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

                public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                    return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonGroupBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback) {
                    service.getPersonGroup(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonGroupBean> getPersonGroups(final List<Integer> groupIdList) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>, List<PersonGroupBean>>(){

                public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonGroupBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonGroupBean>> nativeCallback) {
                    service.getPersonGroups(groupIdList, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getPersonGroupsBelongs(final int personId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getPersonGroupsBelongs(personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getPersonGroupsPermittedBy(final int deviceGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getPersonGroupsPermittedBy(deviceGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PermitBean getPersonPermit(final int deviceId, final int personId) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback) {
                    service.getPersonPermit(deviceId, personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PermitBean> getPersonPermits(final int deviceId, final List<Integer> personIdList) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback) {
                    service.getPersonPermits(deviceId, personIdList, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonBean> getPersons(final List<Integer> idList) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback) {
                    service.getPersons(idList, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonBean> getPersons(final List<Integer> idList, final Token token) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback) {
                    service.getPersonsReal(idList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getPersonsOfGroup(final int personGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getPersonsOfGroup(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getPersonsPermittedOnDevice(final int deviceId, final boolean ignoreSchedule, final List<Integer> excludePersonIds, final Long timestamp) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getPersonsPermittedOnDevice(deviceId, ignoreSchedule, excludePersonIds, timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getPersonsPermittedOnDeviceByGroup(final int deviceId, final boolean ignoreSchedule, final List<Integer> excludePersonIds, final Long timestamp) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.getPersonsPermittedOnDeviceByGroup(deviceId, ignoreSchedule, excludePersonIds, timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getProperties(final String prefix, final Token token) {
        try {
            return this.syncCall(new Function<Map<String, String>, Map<String, String>>(){

                public Map<String, String> apply(Map<String, String> input) {
                    return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
                }
            }, new ServiceAsyncCall<Map<String, String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, String>> nativeCallback) {
                    service.getProperties(prefix, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getProperty(final String key, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.getProperty(key, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<MQParam, String> getRedisParameters(final Token token) {
        try {
            return this.syncCall(new Function<Map<net.gdface.facelog.client.thrift.MQParam, String>, Map<MQParam, String>>(){

                public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam, String> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MQParam.class, String.class, MQParam.class, String.class);
                }
            }, new ServiceAsyncCall<Map<net.gdface.facelog.client.thrift.MQParam, String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<net.gdface.facelog.client.thrift.MQParam, String>> nativeCallback) {
                    service.getRedisParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getServiceConfig(final Token token) {
        try {
            return this.syncCall(new Function<Map<String, String>, Map<String, String>>(){

                public Map<String, String> apply(Map<String, String> input) {
                    return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
                }
            }, new ServiceAsyncCall<Map<String, String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, String>> nativeCallback) {
                    service.getServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getSubDeviceGroup(final int deviceGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getSubDeviceGroup(deviceGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> getSubPersonGroup(final int personGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.getSubPersonGroup(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public TmpwdTargetInfo getTargetInfo4PwdOnDevice(final String pwd, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.TmpwdTargetInfo, TmpwdTargetInfo>(){

                public TmpwdTargetInfo apply(net.gdface.facelog.client.thrift.TmpwdTargetInfo input) {
                    return (TmpwdTargetInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.TmpwdTargetInfo.class, TmpwdTargetInfo.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.TmpwdTargetInfo>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.TmpwdTargetInfo> nativeCallback) {
                    service.getTargetInfo4PwdOnDevice(pwd, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int initTopGroup(final TopGroupInfo groupInfo, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.initTopGroup((net.gdface.facelog.client.thrift.TopGroupInfo)TypeTransformer.getInstance().to((Object)groupInfo, TopGroupInfo.class, net.gdface.facelog.client.thrift.TopGroupInfo.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isDisable(final int personId) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isDisable(personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isValidAckChannel(final String ackChannel) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidAckChannel(ackChannel, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidCmdSn(final int cmdSn) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidCmdSn(cmdSn, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidDeviceToken(final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidDeviceToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidPassword(final String userId, final String password, final boolean isMd5) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidPassword(userId, password, isMd5, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidPersonToken(final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidPersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidRootToken(final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidToken(final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isValidUserToken(final Token token) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.isValidUserToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String iso8601Time() {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.iso8601Time(nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> listOfParentForDeviceGroup(final int deviceGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.listOfParentForDeviceGroup(deviceGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> listOfParentForPersonGroup(final int personGroupId) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.listOfParentForPersonGroup(personGroupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadAllPerson() {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadAllPerson(nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadAllPerson(final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadAllPersonSafe((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.DeviceBean> loadDeviceByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

                public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                    return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<List<DeviceBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<DeviceBean>> nativeCallback) {
                    service.loadDeviceByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.DeviceBean> loadDeviceByWhere(final String where, final int startRow, final int numRows, final Token token) {
        try {
            return this.syncCall(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

                public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                    return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<List<DeviceBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<DeviceBean>> nativeCallback) {
                    service.loadDeviceByWhereSafe(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadDeviceGroupByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadDeviceGroupByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadDeviceGroupIdByWhere(final String where) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadDeviceGroupIdByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadDeviceGroupIdByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadDeviceGroupIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadDeviceIdByWhere(final String where) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadDeviceIdByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadDeviceIdByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadDeviceIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadDistinctIntegerColumn(final String table, final String column, final String where) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadDistinctIntegerColumn(table, column, where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> loadDistinctStringColumn(final String table, final String column, final String where) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.loadDistinctStringColumn(table, column, where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<ErrorLogBean> loadErrorLogByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.ErrorLogBean>, List<ErrorLogBean>>(){

                public List<ErrorLogBean> apply(List<net.gdface.facelog.client.thrift.ErrorLogBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.ErrorLogBean.class, ErrorLogBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.ErrorLogBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.ErrorLogBean>> nativeCallback) {
                    service.loadErrorLogByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> loadFeatureMd5ByUpdate(final String timestamp) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.loadFeatureMd5ByUpdateTimeStr(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> loadFeatureMd5ByUpdate(final String timestamp, final Token token) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.loadFeatureMd5ByUpdateTimeStrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> loadFeatureMd5ByUpdate(final long timestamp) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.loadFeatureMd5ByUpdate(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> loadFeatureMd5ByUpdate(final long timestamp, final Token token) {
        try {
            return this.syncCall(new Function<List<String>, List<String>>(){

                public List<String> apply(List<String> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<String>> nativeCallback) {
                    service.loadFeatureMd5ByUpdateSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogBean> loadLogByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

                public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                    return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
                }
            }, new ServiceAsyncCall<List<LogBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogBean>> nativeCallback) {
                    service.loadLogByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogBean> loadLogByWhere(final String where, final int startRow, final int numRows, final Token token) {
        try {
            return this.syncCall(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

                public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                    return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
                }
            }, new ServiceAsyncCall<List<LogBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogBean>> nativeCallback) {
                    service.loadLogByWhereSafe(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogLightBean> loadLogLightByVerifyTime(final String timestamp, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

                public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                    return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
                }
            }, new ServiceAsyncCall<List<LogLightBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogLightBean>> nativeCallback) {
                    service.loadLogLightByVerifyTimeTimestr(timestamp, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogLightBean> loadLogLightByVerifyTime(final String timestamp, final int startRow, final int numRows, final Token token) {
        try {
            return this.syncCall(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

                public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                    return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
                }
            }, new ServiceAsyncCall<List<LogLightBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogLightBean>> nativeCallback) {
                    service.loadLogLightByVerifyTimeTimestrSafe(timestamp, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogLightBean> loadLogLightByVerifyTime(final long timestamp, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

                public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                    return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
                }
            }, new ServiceAsyncCall<List<LogLightBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogLightBean>> nativeCallback) {
                    service.loadLogLightByVerifyTime(timestamp, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogLightBean> loadLogLightByVerifyTime(final long timestamp, final int startRow, final int numRows, final Token token) {
        try {
            return this.syncCall(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

                public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                    return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
                }
            }, new ServiceAsyncCall<List<LogLightBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogLightBean>> nativeCallback) {
                    service.loadLogLightByVerifyTimeSafe(timestamp, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogLightBean> loadLogLightByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

                public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                    return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
                }
            }, new ServiceAsyncCall<List<LogLightBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogLightBean>> nativeCallback) {
                    service.loadLogLightByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<net.gdface.facelog.db.LogLightBean> loadLogLightByWhere(final String where, final int startRow, final int numRows, final Token token) {
        try {
            return this.syncCall(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

                public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                    return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
                }
            }, new ServiceAsyncCall<List<LogLightBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<LogLightBean>> nativeCallback) {
                    service.loadLogLightByWhereSafe(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PermitBean> loadPermitByUpdate(final String timestamp) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback) {
                    service.loadPermitByUpdateTimestr(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PermitBean> loadPermitByUpdate(final long timestamp) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback) {
                    service.loadPermitByUpdate(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonBean> loadPersonByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback) {
                    service.loadPersonByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonBean> loadPersonByWhere(final String where, final int startRow, final int numRows, final Token token) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback) {
                    service.loadPersonByWhereReal(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonDataPackage> loadPersonDataPackages(final List<Integer> personIds, final String sdkVersion, final int deviceId) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonDataPackage>, List<PersonDataPackage>>(){

                public List<PersonDataPackage> apply(List<net.gdface.facelog.client.thrift.PersonDataPackage> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonDataPackage.class, PersonDataPackage.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonDataPackage>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonDataPackage>> nativeCallback) {
                    service.loadPersonDataPackages(personIds, sdkVersion, deviceId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonDataPackage> loadPersonDataPackagesInSameGroup(final List<Integer> personIds, final String sdkVersion, final int deviceId) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonDataPackage>, List<PersonDataPackage>>(){

                public List<PersonDataPackage> apply(List<net.gdface.facelog.client.thrift.PersonDataPackage> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonDataPackage.class, PersonDataPackage.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonDataPackage>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonDataPackage>> nativeCallback) {
                    service.loadPersonDataPackagesInSameGroup(personIds, sdkVersion, deviceId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<PersonDataPackage> loadPersonDataPackagesPermittedOnDevice(final int deviceId, final boolean ignoreSchedule, final List<Integer> excludePersonIds, final Long timestamp, final String sdkVersion) {
        try {
            return this.syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonDataPackage>, List<PersonDataPackage>>(){

                public List<PersonDataPackage> apply(List<net.gdface.facelog.client.thrift.PersonDataPackage> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonDataPackage.class, PersonDataPackage.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonDataPackage>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonDataPackage>> nativeCallback) {
                    service.loadPersonDataPackagesPermittedOnDevice(deviceId, ignoreSchedule, excludePersonIds, timestamp, sdkVersion, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonGroupByWhere(final String where, final int startRow, final int numRows) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonGroupByWhere(where, startRow, numRows, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonGroupIdByWhere(final String where) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonGroupIdByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonGroupIdByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonGroupIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonIdByUpdateTime(final String timestamp) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonIdByUpdateTimeTimeStr(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonIdByUpdateTime(final String timestamp, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonIdByUpdateTimeTimeStrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonIdByUpdateTime(final long timestamp) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonIdByUpdateTime(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonIdByUpdateTime(final long timestamp, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonIdByUpdateTimeSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonIdByWhere(final String where) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonIdByWhere(where, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadPersonIdByWhere(final String where, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadPersonIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadUpdatedPersons(final String timestamp) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadUpdatedPersonsTimestr(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadUpdatedPersons(final String timestamp, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadUpdatedPersonsTimestrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadUpdatedPersons(final long timestamp) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadUpdatedPersons(timestamp, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Integer> loadUpdatedPersons(final long timestamp, final Token token) {
        try {
            return this.syncCall(new Function<List<Integer>, List<Integer>>(){

                public List<Integer> apply(List<Integer> input) {
                    return input;
                }
            }, new ServiceAsyncCall<List<Integer>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<List<Integer>> nativeCallback) {
                    service.loadUpdatedPersonsSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public LockWakeupResponse lockWakeup(final net.gdface.facelog.db.DeviceBean deviceBean, final boolean ignoreSchedule, final String sdkVersion) throws ServiceSecurityException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.LockWakeupResponse, LockWakeupResponse>(){

                public LockWakeupResponse apply(net.gdface.facelog.client.thrift.LockWakeupResponse input) {
                    return (LockWakeupResponse)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.LockWakeupResponse.class, LockWakeupResponse.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.LockWakeupResponse>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.LockWakeupResponse> nativeCallback) {
                    service.lockWakeup((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), ignoreSchedule, sdkVersion, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void offline(final Token token) throws ServiceSecurityException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.offline((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Token online(final net.gdface.facelog.db.DeviceBean device) throws ServiceSecurityException {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback) {
                    service.online((DeviceBean)TypeTransformer.getInstance().to((Object)device, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String pathOf(final String tablename, final int groupId) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.pathOf(tablename, groupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public net.gdface.facelog.db.DeviceBean registerDevice(final net.gdface.facelog.db.DeviceBean newDevice) throws ServiceSecurityException {
        try {
            return this.syncCall(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

                public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                    return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<DeviceBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<DeviceBean> nativeCallback) {
                    service.registerDevice((DeviceBean)TypeTransformer.getInstance().to((Object)newDevice, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void releasePersonToken(final Token token) throws ServiceSecurityException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.releasePersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void releaseRootToken(final Token token) throws ServiceSecurityException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.releaseRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void releaseUserToken(final Token token) throws ServiceSecurityException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.releaseUserToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void replaceFeature(final int personId, final String featureMd5, final boolean deleteOldFeatureImage, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.replaceFeature(personId, featureMd5, deleteOldFeatureImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Integer rootGroupOfDevice(final int deviceId) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.rootGroupOfDevice(deviceId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Integer rootGroupOfDeviceGroup(final int groupId) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.rootGroupOfDeviceGroup(groupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Integer rootGroupOfPerson(final int personId) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.rootGroupOfPerson(personId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Integer rootGroupOfPersonGroup(final int groupId) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.rootGroupOfPersonGroup(groupId, nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String runCmd(final List<Integer> target, final boolean group, final String cmdpath, final String jsonArgs, final String ackChannel, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.runCmd(target, group, cmdpath, jsonArgs, ackChannel, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Integer runTask(final String taskQueue, final String cmdpath, final String jsonArgs, final String ackChannel, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.runTask(taskQueue, cmdpath, jsonArgs, ackChannel, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String runTaskSync(final String taskQueue, final String cmdpath, final String jsonArgs, final int timeoutSecs, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.runTaskSync(taskQueue, cmdpath, jsonArgs, timeoutSecs, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public net.gdface.facelog.db.DeviceBean saveDevice(final net.gdface.facelog.db.DeviceBean deviceBean, final Token token) {
        try {
            return this.syncCall(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

                public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                    return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<DeviceBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<DeviceBean> nativeCallback) {
                    service.saveDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DeviceGroupBean saveDeviceGroup(final DeviceGroupBean deviceGroupBean, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

                public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                    return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceGroupBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback) {
                    service.saveDeviceGroup((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroupBean, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PermitBean savePermit(final int deviceGroupId, final int personGroupId, final String column, final String value, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback) {
                    service.savePermitWithColumn(deviceGroupId, personGroupId, column, value, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PermitBean savePermit(final PermitBean permitBean, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback) {
                    service.savePermit((net.gdface.facelog.client.thrift.PermitBean)TypeTransformer.getInstance().to((Object)permitBean, PermitBean.class, net.gdface.facelog.client.thrift.PermitBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final byte[] idPhoto, final boolean exractFeature, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonWithPhotoAndExtractFeature((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), exractFeature, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final byte[] idPhoto, final byte[] feature, final String featureVersion, final byte[] featureImage, final FaceBean faceBean, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonFull((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, (ByteString)TypeTransformer.getInstance().to((Object)featureImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final byte[] idPhoto, final byte[] feature, final String featureVersion, final List<byte[]> photos, final List<FaceBean> faces, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonWithPhotoAndFeatureMultiImage((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, TypeTransformer.getInstance().to(photos, byte[].class, ByteString.class), TypeTransformer.getInstance().to(faces, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final byte[] idPhoto, final byte[] feature, final String featureVersion, final List<FaceBean> faceBeans, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonWithPhotoAndFeatureMultiFaces((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final byte[] idPhoto, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonWithPhoto((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final byte[] idPhoto, final FeatureBean featureBean, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonWithPhotoAndFeature((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FeatureBean)TypeTransformer.getInstance().to((Object)featureBean, FeatureBean.class, net.gdface.facelog.client.thrift.FeatureBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final String idPhotoMd5, final String featureMd5, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePersonWithPhotoAndFeatureSaved((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhotoMd5, featureMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonBean savePerson(final PersonBean personBean, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback) {
                    service.savePerson((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PersonGroupBean savePersonGroup(final PersonGroupBean personGroupBean, final Token token) {
        try {
            return this.syncCall(new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

                public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                    return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonGroupBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback) {
                    service.savePersonGroup((net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroupBean, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int savePersons(final List<byte[]> photos, final List<PersonBean> persons, final Token token) {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.savePersonsWithPhoto(TypeTransformer.getInstance().to(photos, byte[].class, ByteString.class), TypeTransformer.getInstance().to(persons, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void savePersons(final List<PersonBean> persons, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.savePersons(TypeTransformer.getInstance().to(persons, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void saveServiceConfig(final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.saveServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String sdkTaskQueueOf(final String task, final String sdkVersion, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.sdkTaskQueueOf(task, sdkVersion, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setPersonExpiryDate(final int personId, final String expiryDate, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.setPersonExpiryDateTimeStr(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setPersonExpiryDate(final int personId, final long expiryDate, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.setPersonExpiryDate(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setPersonExpiryDate(final List<Integer> personIdList, final long expiryDate, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.setPersonExpiryDateList(personIdList, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setProperties(final Map<String, String> config, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.setProperties(TypeTransformer.getInstance().to(config, String.class, String.class, String.class, String.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setProperty(final String key, final String value, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.setProperty(key, value, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String taskQueueOf(final String task, final Token token) {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.taskQueueOf(task, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void unbindBorder(final int personGroupId, final int deviceGroupId, final Token token) {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.unbindBorder(personGroupId, deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void unregisterDevice(final Token token) throws ServiceSecurityException {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.unregisterDevice((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceSecurityException e) {
            throw (ServiceSecurityException)TypeTransformer.getInstance().to((Object)e, net.gdface.facelog.client.thrift.ServiceSecurityException.class, ServiceSecurityException.class);
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public net.gdface.facelog.db.DeviceBean updateDevice(final net.gdface.facelog.db.DeviceBean deviceBean, final Token token) {
        try {
            return this.syncCall(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

                public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                    return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
                }
            }, new ServiceAsyncCall<DeviceBean>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<DeviceBean> nativeCallback) {
                    service.updateDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String version() {
        try {
            return this.syncCall(new Function<String, String>(){

                public String apply(String input) {
                    return input;
                }
            }, new ServiceAsyncCall<String>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<String> nativeCallback) {
                    service.version(nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> versionInfo() {
        try {
            return this.syncCall(new Function<Map<String, String>, Map<String, String>>(){

                public Map<String, String> apply(Map<String, String> input) {
                    return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
                }
            }, new ServiceAsyncCall<Map<String, String>>(){

                @Override
                public void call(IFaceLogClient service, ServiceMethodCallback<Map<String, String>> nativeCallback) {
                    service.versionInfo(nativeCallback);
                }
            });
        }
        catch (net.gdface.facelog.client.thrift.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static interface ServiceAsyncCall<T> {
        public void call(IFaceLogClient var1, ServiceMethodCallback<T> var2);
    }
}

