/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.LockWakeupResponse;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.MatchEntry;
import net.gdface.facelog.PersonDataPackage;
import net.gdface.facelog.TmpPwdTargetType;
import net.gdface.facelog.TmpwdTargetInfo;
import net.gdface.facelog.Token;
import net.gdface.facelog.TopGroupInfo;
import net.gdface.facelog.client.thrift.DeviceBean;
import net.gdface.facelog.client.thrift.DuplicateRecordException;
import net.gdface.facelog.client.thrift.FuzzyMatchCountExceedLimitException;
import net.gdface.facelog.client.thrift.IFaceLogClient;
import net.gdface.facelog.client.thrift.LogBean;
import net.gdface.facelog.client.thrift.LogLightBean;
import net.gdface.facelog.client.thrift.ServiceRuntimeException;
import net.gdface.facelog.client.thrift.ServiceSecurityException;
import net.gdface.facelog.client.thrift.StringMatchType;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.ErrorLogBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class IFaceLogThriftClientAsync {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public IFaceLogThriftClientAsync(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public IFaceLogThriftClientAsync(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    public IFaceLogThriftClientAsync(HostAndPort hostAndPort) {
        this(ClientFactory.builder().setHostAndPort(hostAndPort));
    }

    public boolean testConnect() {
        return this.factory.testConnect();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClientAsync [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public ListenableFuture<Void> addErrorLog(ErrorLogBean errorLogBean, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addErrorLog((net.gdface.facelog.client.thrift.ErrorLogBean)TypeTransformer.getInstance().to((Object)errorLogBean, ErrorLogBean.class, net.gdface.facelog.client.thrift.ErrorLogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addErrorLog(ErrorLogBean errorLogBean, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addErrorLog(errorLogBean, token), callback);
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, String featureVersion, Integer personId, boolean asIdPhotoIfAbsent, byte[] featurePhoto, FaceBean faceBean, String removed, Token token) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.addFeatureWithImage((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, asIdPhotoIfAbsent, (ByteString)TypeTransformer.getInstance().to((Object)featurePhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), removed, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] feature, String featureVersion, Integer personId, boolean asIdPhotoIfAbsent, byte[] featurePhoto, FaceBean faceBean, String removed, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, featureVersion, personId, asIdPhotoIfAbsent, featurePhoto, faceBean, removed, token), callback);
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, String removed, Token token) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.addFeature((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, TypeTransformer.getInstance().to(faecBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), removed, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, String removed, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, featureVersion, personId, faecBeans, removed, token), callback);
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, String featureVersion, Integer personId, List<byte[]> photos, List<FaceBean> faces, String removed, Token token) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.addFeatureMulti((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, TypeTransformer.getInstance().to(photos, byte[].class, ByteString.class), TypeTransformer.getInstance().to(faces, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), removed, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] feature, String featureVersion, Integer personId, List<byte[]> photos, List<FaceBean> faces, String removed, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, featureVersion, personId, photos, faces, removed, token), callback);
    }

    public ListenableFuture<ImageBean> addImage(byte[] imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token) {
        MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean> nativeCallback = new MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean>(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        nativeCallback.service.addImage((ByteString)TypeTransformer.getInstance().to((Object)imageData, byte[].class, ByteString.class), deviceId, (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addImage(byte[] imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.addImage(imageData, deviceId, faceBean, personId, token), callback);
    }

    public ListenableFuture<Void> addLog(net.gdface.facelog.db.LogBean logBean, byte[] faceImage, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addLogWithFaceImage((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (ByteString)TypeTransformer.getInstance().to((Object)faceImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLog(net.gdface.facelog.db.LogBean logBean, byte[] faceImage, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLog(logBean, faceImage, token), callback);
    }

    public ListenableFuture<Void> addLog(net.gdface.facelog.db.LogBean logBean, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addLog((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLog(net.gdface.facelog.db.LogBean logBean, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLog(logBean, token), callback);
    }

    public ListenableFuture<Void> addLog(net.gdface.facelog.db.LogBean logBean, FaceBean faceBean, byte[] featureImage, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addLogFull((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (ByteString)TypeTransformer.getInstance().to((Object)featureImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLog(net.gdface.facelog.db.LogBean logBean, FaceBean faceBean, byte[] featureImage, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLog(logBean, faceBean, featureImage, token), callback);
    }

    public ListenableFuture<Void> addLogs(List<net.gdface.facelog.db.LogBean> logBeans, List<FaceBean> faceBeans, List<byte[]> featureImages, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addLogsFull(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), TypeTransformer.getInstance().to(featureImages, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLogs(List<net.gdface.facelog.db.LogBean> logBeans, List<FaceBean> faceBeans, List<byte[]> featureImages, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLogs(logBeans, faceBeans, featureImages, token), callback);
    }

    public ListenableFuture<Void> addLogs(List<net.gdface.facelog.db.LogBean> logBeans, List<byte[]> faceImages, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addLogsWithFaceImage(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), TypeTransformer.getInstance().to(faceImages, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLogs(List<net.gdface.facelog.db.LogBean> logBeans, List<byte[]> faceImages, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLogs(logBeans, faceImages, token), callback);
    }

    public ListenableFuture<Void> addLogs(List<net.gdface.facelog.db.LogBean> logBeans, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.addLogs(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLogs(List<net.gdface.facelog.db.LogBean> logBeans, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLogs(logBeans, token), callback);
    }

    public ListenableFuture<String> applyAckChannel(int duration, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.applyAckChannelWithDuration(duration, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void applyAckChannel(int duration, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.applyAckChannel(duration, token), callback);
    }

    public ListenableFuture<String> applyAckChannel(Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.applyAckChannel((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void applyAckChannel(Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.applyAckChannel(token), callback);
    }

    public ListenableFuture<Integer> applyCmdSn(Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.applyCmdSn((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void applyCmdSn(Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.applyCmdSn(token), callback);
    }

    public ListenableFuture<Token> applyPersonToken(int personId, String password, boolean isMd5) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.applyPersonToken(personId, password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyPersonToken(int personId, String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyPersonToken(personId, password, isMd5), callback);
    }

    public ListenableFuture<Token> applyRootToken(String password, boolean isMd5) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.applyRootToken(password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyRootToken(String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyRootToken(password, isMd5), callback);
    }

    public ListenableFuture<Token> applyUserToken(int userid, String password, boolean isMd5) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.applyUserToken(userid, password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyUserToken(int userid, String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyUserToken(userid, password, isMd5), callback);
    }

    public ListenableFuture<Void> bindBorder(int personGroupId, int deviceGroupId, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.bindBorder(personGroupId, deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void bindBorder(int personGroupId, int deviceGroupId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.bindBorder(personGroupId, deviceGroupId, token), callback);
    }

    public ListenableFuture<List<Integer>> childListForDeviceGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.childListForDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void childListForDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.childListForDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> childListForPersonGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.childListForPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void childListForPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.childListForPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<Integer> countDeviceByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countDeviceByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countDeviceByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceByWhere(where), callback);
    }

    public ListenableFuture<Integer> countDeviceByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countDeviceByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countDeviceByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceByWhere(where, token), callback);
    }

    public ListenableFuture<Integer> countDeviceGroupByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countDeviceGroupByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countDeviceGroupByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceGroupByWhere(where), callback);
    }

    public ListenableFuture<Integer> countDeviceGroupByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countDeviceGroupByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countDeviceGroupByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceGroupByWhere(where, token), callback);
    }

    public ListenableFuture<Integer> countErrorLogByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countErrorLogByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countErrorLogByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countErrorLogByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogByWhere(where, token), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(String timestamp) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByVerifyTimeTimestr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByVerifyTime(String timestamp, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(String timestamp, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByVerifyTimeTimestrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByVerifyTime(String timestamp, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp, token), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByVerifyTime(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByVerifyTime(long timestamp, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByVerifyTimeSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByVerifyTime(long timestamp, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp, token), callback);
    }

    public ListenableFuture<Integer> countLogLightByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogLightByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByWhere(where, token), callback);
    }

    public ListenableFuture<Integer> countPersonByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countPersonByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonByWhere(where), callback);
    }

    public ListenableFuture<Integer> countPersonByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countPersonByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonByWhere(where, token), callback);
    }

    public ListenableFuture<Integer> countPersonGroupByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countPersonGroupByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonGroupByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonGroupByWhere(where), callback);
    }

    public ListenableFuture<Integer> countPersonGroupByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countPersonGroupByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonGroupByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonGroupByWhere(where, token), callback);
    }

    public ListenableFuture<Map<String, Integer>> countPersonLog(int personId, Long startDate, Long endDate) {
        MethodCallback<Map<String, Integer>, Map<String, Integer>> nativeCallback = new MethodCallback<Map<String, Integer>, Map<String, Integer>>(new Function<Map<String, Integer>, Map<String, Integer>>(){

            public Map<String, Integer> apply(Map<String, Integer> input) {
                return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
            }
        });
        nativeCallback.service.countPersonLog(personId, startDate, endDate, nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonLog(int personId, Long startDate, Long endDate, FutureCallback<Map<String, Integer>> callback) {
        this.factory.addCallback(this.countPersonLog(personId, startDate, endDate), callback);
    }

    public ListenableFuture<Map<String, Integer>> countPersonLog(int personId, Long startDate, Long endDate, Token token) {
        MethodCallback<Map<String, Integer>, Map<String, Integer>> nativeCallback = new MethodCallback<Map<String, Integer>, Map<String, Integer>>(new Function<Map<String, Integer>, Map<String, Integer>>(){

            public Map<String, Integer> apply(Map<String, Integer> input) {
                return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
            }
        });
        nativeCallback.service.countPersonLogSafe(personId, startDate, endDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonLog(int personId, Long startDate, Long endDate, Token token, FutureCallback<Map<String, Integer>> callback) {
        this.factory.addCallback(this.countPersonLog(personId, startDate, endDate, token), callback);
    }

    public ListenableFuture<Map<String, Integer>> countPersonLog(int personId, String startDate, String endDate) {
        MethodCallback<Map<String, Integer>, Map<String, Integer>> nativeCallback = new MethodCallback<Map<String, Integer>, Map<String, Integer>>(new Function<Map<String, Integer>, Map<String, Integer>>(){

            public Map<String, Integer> apply(Map<String, Integer> input) {
                return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
            }
        });
        nativeCallback.service.countPersonLogTimeStr(personId, startDate, endDate, nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonLog(int personId, String startDate, String endDate, FutureCallback<Map<String, Integer>> callback) {
        this.factory.addCallback(this.countPersonLog(personId, startDate, endDate), callback);
    }

    public ListenableFuture<Map<String, Integer>> countPersonLog(int personId, String startDate, String endDate, Token token) {
        MethodCallback<Map<String, Integer>, Map<String, Integer>> nativeCallback = new MethodCallback<Map<String, Integer>, Map<String, Integer>>(new Function<Map<String, Integer>, Map<String, Integer>>(){

            public Map<String, Integer> apply(Map<String, Integer> input) {
                return TypeTransformer.getInstance().to(input, String.class, Integer.class, String.class, Integer.class);
            }
        });
        nativeCallback.service.countPersonLogTimeStrSafe(personId, startDate, endDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonLog(int personId, String startDate, String endDate, Token token, FutureCallback<Map<String, Integer>> callback) {
        this.factory.addCallback(this.countPersonLog(personId, startDate, endDate, token), callback);
    }

    public ListenableFuture<String> createTempPwd(int targetId, TmpPwdTargetType targetType, int duration, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.createTempPwdWithDuration(targetId, (net.gdface.facelog.client.thrift.TmpPwdTargetType)((Object)TypeTransformer.getInstance().to((Object)targetType, TmpPwdTargetType.class, net.gdface.facelog.client.thrift.TmpPwdTargetType.class)), duration, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void createTempPwd(int targetId, TmpPwdTargetType targetType, int duration, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.createTempPwd(targetId, targetType, duration, token), callback);
    }

    public ListenableFuture<String> createTempPwd(int targetId, TmpPwdTargetType targetType, String expiryDate, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.createTempPwd(targetId, (net.gdface.facelog.client.thrift.TmpPwdTargetType)((Object)TypeTransformer.getInstance().to((Object)targetType, TmpPwdTargetType.class, net.gdface.facelog.client.thrift.TmpPwdTargetType.class)), expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void createTempPwd(int targetId, TmpPwdTargetType targetType, String expiryDate, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.createTempPwd(targetId, targetType, expiryDate, token), callback);
    }

    public ListenableFuture<Integer> deleteAllFeaturesByPersonId(int personId, boolean deleteImage, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteAllFeaturesByPersonId(personId, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteAllFeaturesByPersonId(int personId, boolean deleteImage, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteAllFeaturesByPersonId(personId, deleteImage, token), callback);
    }

    public ListenableFuture<Boolean> deleteDevice(int id, Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.deleteDevice(id, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteDevice(int id, Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.deleteDevice(id, token), callback);
    }

    public ListenableFuture<Boolean> deleteDeviceByMac(String mac, Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.deleteDeviceByMac(mac, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteDeviceByMac(String mac, Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.deleteDeviceByMac(mac, token), callback);
    }

    public ListenableFuture<Integer> deleteDeviceGroup(int deviceGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteDeviceGroup(int deviceGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteDeviceGroup(deviceGroupId, token), callback);
    }

    public ListenableFuture<Integer> deleteErrorLogByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteErrorLogByWhere(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteErrorLogByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteErrorLogByWhere(where, token), callback);
    }

    public ListenableFuture<List<String>> deleteFeature(String featureMd5, boolean deleteImage, Token token) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.deleteFeature(featureMd5, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteFeature(String featureMd5, boolean deleteImage, Token token, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.deleteFeature(featureMd5, deleteImage, token), callback);
    }

    public ListenableFuture<Integer> deleteGroupPermitOnDeviceGroup(int deviceGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteGroupPermitOnDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteGroupPermitOnDeviceGroup(int deviceGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteGroupPermitOnDeviceGroup(deviceGroupId, token), callback);
    }

    public ListenableFuture<Integer> deleteImage(String imageMd5, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteImage(imageMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteImage(String imageMd5, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteImage(imageMd5, token), callback);
    }

    public ListenableFuture<Integer> deleteLogByWhere(String where, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteLogByWhere(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteLogByWhere(String where, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteLogByWhere(where, token), callback);
    }

    public ListenableFuture<Integer> deletePermit(int deviceGroupId, int personGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePermitById(deviceGroupId, personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePermit(int deviceGroupId, int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePermit(deviceGroupId, personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePerson(int personId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePerson(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePerson(int personId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePerson(personId, token), callback);
    }

    public ListenableFuture<Integer> deletePersonByMobilePhone(String mobilePhone, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonByMobilePhone(mobilePhone, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonByMobilePhone(String mobilePhone, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonByMobilePhone(mobilePhone, token), callback);
    }

    public ListenableFuture<Integer> deletePersonByPapersNum(String papersNum, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonByPapersNum(papersNum, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonByPapersNum(String papersNum, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonByPapersNum(papersNum, token), callback);
    }

    public ListenableFuture<Integer> deletePersonGroup(int personGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonGroup(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonGroup(int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonGroup(personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePersonGroupPermit(int personGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonGroupPermit(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonGroupPermit(int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonGroupPermit(personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePersons(List<Integer> personIdList, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersons(personIdList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersons(List<Integer> personIdList, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersons(personIdList, token), callback);
    }

    public ListenableFuture<Integer> deletePersonsByMobilePhone(List<String> mobilePhoneList, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonsByMobilePhone(mobilePhoneList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonsByMobilePhone(List<String> mobilePhoneList, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonsByMobilePhone(mobilePhoneList, token), callback);
    }

    public ListenableFuture<Integer> deletePersonsByPapersNum(List<String> papersNumList, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonsByPapersNum(papersNumList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonsByPapersNum(List<String> papersNumList, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonsByPapersNum(papersNumList, token), callback);
    }

    public ListenableFuture<Void> disablePerson(int personId, Integer moveToGroupId, boolean deletePhoto, boolean deleteFeature, boolean deleteLog, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.disablePerson(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void disablePerson(int personId, Integer moveToGroupId, boolean deletePhoto, boolean deleteFeature, boolean deleteLog, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.disablePerson(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, token), callback);
    }

    public ListenableFuture<Void> disablePerson(List<Integer> personIdList, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.disablePersonList(personIdList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void disablePerson(List<Integer> personIdList, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.disablePerson(personIdList, token), callback);
    }

    public ListenableFuture<Boolean> existsDevice(int id) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsDevice(id, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsDevice(int id, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsDevice(id), callback);
    }

    public ListenableFuture<Boolean> existsFeature(String md5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsFeature(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsFeature(String md5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsFeature(md5), callback);
    }

    public ListenableFuture<Boolean> existsImage(String md5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsImage(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsImage(String md5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsImage(md5), callback);
    }

    public ListenableFuture<Boolean> existsPerson(int persionId) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsPerson(persionId, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsPerson(int persionId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsPerson(persionId), callback);
    }

    public ListenableFuture<Integer> faceRecognizePersonPermitted(byte[] imageData, Float threshold, int group, int deviceId, boolean searchInPermited) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.faceRecognizePersonPermitted((ByteString)TypeTransformer.getInstance().to((Object)imageData, byte[].class, ByteString.class), threshold == null ? null : Double.valueOf(threshold.doubleValue()), group, deviceId, searchInPermited, nativeCallback);
        return nativeCallback.feature;
    }

    public void faceRecognizePersonPermitted(byte[] imageData, Float threshold, int group, int deviceId, boolean searchInPermited, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.faceRecognizePersonPermitted(imageData, threshold, group, deviceId, searchInPermited), callback);
    }

    public ListenableFuture<List<MatchEntry>> fuzzySearch(String tablename, String column, String pattern, gu.sql2java.StringMatchType matchType, int matchFlags, int parentGroupId, int maxMatchCount) {
        MethodCallback<List<MatchEntry>, List<net.gdface.facelog.client.thrift.MatchEntry>> nativeCallback = new MethodCallback<List<MatchEntry>, List<net.gdface.facelog.client.thrift.MatchEntry>>(new Function<List<net.gdface.facelog.client.thrift.MatchEntry>, List<MatchEntry>>(){

            public List<MatchEntry> apply(List<net.gdface.facelog.client.thrift.MatchEntry> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MatchEntry.class, MatchEntry.class);
            }
        });
        nativeCallback.service.fuzzySearch(tablename, column, pattern, (StringMatchType)((Object)TypeTransformer.getInstance().to((Object)matchType, gu.sql2java.StringMatchType.class, StringMatchType.class)), matchFlags, parentGroupId, maxMatchCount, nativeCallback);
        return nativeCallback.feature;
    }

    public void fuzzySearch(String tablename, String column, String pattern, gu.sql2java.StringMatchType matchType, int matchFlags, int parentGroupId, int maxMatchCount, FutureCallback<List<MatchEntry>> callback) {
        this.factory.addCallback(this.fuzzySearch(tablename, column, pattern, matchType, matchFlags, parentGroupId, maxMatchCount), callback);
    }

    public ListenableFuture<List<MatchEntry>> fuzzySearchPerson(String column, String pattern, gu.sql2java.StringMatchType matchType, int matchFlags, int parentGroupId, int maxMatchCount, Token token) {
        MethodCallback<List<MatchEntry>, List<net.gdface.facelog.client.thrift.MatchEntry>> nativeCallback = new MethodCallback<List<MatchEntry>, List<net.gdface.facelog.client.thrift.MatchEntry>>(new Function<List<net.gdface.facelog.client.thrift.MatchEntry>, List<MatchEntry>>(){

            public List<MatchEntry> apply(List<net.gdface.facelog.client.thrift.MatchEntry> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MatchEntry.class, MatchEntry.class);
            }
        });
        nativeCallback.service.fuzzySearchPerson(column, pattern, (StringMatchType)((Object)TypeTransformer.getInstance().to((Object)matchType, gu.sql2java.StringMatchType.class, StringMatchType.class)), matchFlags, parentGroupId, maxMatchCount, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void fuzzySearchPerson(String column, String pattern, gu.sql2java.StringMatchType matchType, int matchFlags, int parentGroupId, int maxMatchCount, Token token, FutureCallback<List<MatchEntry>> callback) {
        this.factory.addCallback(this.fuzzySearchPerson(column, pattern, matchType, matchFlags, parentGroupId, maxMatchCount, token), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> getDevice(int deviceId) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.getDevice(deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDevice(int deviceId, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.getDevice(deviceId), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> getDeviceByMac(String mac) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.getDeviceByMac(mac, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceByMac(String mac, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.getDeviceByMac(mac), callback);
    }

    public ListenableFuture<DeviceGroupBean> getDeviceGroup(int deviceGroupId) {
        MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = new MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean>(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

            public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        nativeCallback.service.getDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroup(int deviceGroupId, FutureCallback<DeviceGroupBean> callback) {
        this.factory.addCallback(this.getDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<DeviceGroupBean>> getDeviceGroups(List<Integer> groupIdList) {
        MethodCallback<List<DeviceGroupBean>, List<net.gdface.facelog.client.thrift.DeviceGroupBean>> nativeCallback = new MethodCallback<List<DeviceGroupBean>, List<net.gdface.facelog.client.thrift.DeviceGroupBean>>(new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>, List<DeviceGroupBean>>(){

            public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        nativeCallback.service.getDeviceGroups(groupIdList, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroups(List<Integer> groupIdList, FutureCallback<List<DeviceGroupBean>> callback) {
        this.factory.addCallback(this.getDeviceGroups(groupIdList), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsBelongs(int deviceId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getDeviceGroupsBelongs(deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroupsBelongs(int deviceId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsBelongs(deviceId), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsPermit(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getDeviceGroupsPermit(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroupsPermit(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsPermit(personGroupId), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsPermittedBy(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getDeviceGroupsPermittedBy(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroupsPermittedBy(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsPermittedBy(personGroupId), callback);
    }

    public ListenableFuture<Integer> getDeviceIdOfFeature(String featureMd5) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.getDeviceIdOfFeature(featureMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceIdOfFeature(String featureMd5, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.getDeviceIdOfFeature(featureMd5), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> getDevices(List<Integer> idList) {
        MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>>(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.getDevices(idList, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDevices(List<Integer> idList, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.getDevices(idList), callback);
    }

    public ListenableFuture<List<Integer>> getDevicesOfGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getDevicesOfGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDevicesOfGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDevicesOfGroup(deviceGroupId), callback);
    }

    public ListenableFuture<FaceBean> getFace(int faceId) {
        MethodCallback<FaceBean, net.gdface.facelog.client.thrift.FaceBean> nativeCallback = new MethodCallback<FaceBean, net.gdface.facelog.client.thrift.FaceBean>(new Function<net.gdface.facelog.client.thrift.FaceBean, FaceBean>(){

            public FaceBean apply(net.gdface.facelog.client.thrift.FaceBean input) {
                return (FaceBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
            }
        });
        nativeCallback.service.getFace(faceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFace(int faceId, FutureCallback<FaceBean> callback) {
        this.factory.addCallback(this.getFace(faceId), callback);
    }

    public ListenableFuture<Map<String, String>> getFaceApiParameters(Token token) {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.getFaceApiParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getFaceApiParameters(Token token, FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.getFaceApiParameters(token), callback);
    }

    public ListenableFuture<List<FaceBean>> getFacesOfFeature(String featureMd5) {
        MethodCallback<List<FaceBean>, List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback = new MethodCallback<List<FaceBean>, List<net.gdface.facelog.client.thrift.FaceBean>>(new Function<List<net.gdface.facelog.client.thrift.FaceBean>, List<FaceBean>>(){

            public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
            }
        });
        nativeCallback.service.getFacesOfFeature(featureMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFacesOfFeature(String featureMd5, FutureCallback<List<FaceBean>> callback) {
        this.factory.addCallback(this.getFacesOfFeature(featureMd5), callback);
    }

    public ListenableFuture<List<FaceBean>> getFacesOfImage(String imageMd5) {
        MethodCallback<List<FaceBean>, List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback = new MethodCallback<List<FaceBean>, List<net.gdface.facelog.client.thrift.FaceBean>>(new Function<List<net.gdface.facelog.client.thrift.FaceBean>, List<FaceBean>>(){

            public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
            }
        });
        nativeCallback.service.getFacesOfImage(imageMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFacesOfImage(String imageMd5, FutureCallback<List<FaceBean>> callback) {
        this.factory.addCallback(this.getFacesOfImage(imageMd5), callback);
    }

    public ListenableFuture<FeatureBean> getFeature(String md5) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.getFeature(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeature(String md5, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.getFeature(md5), callback);
    }

    public ListenableFuture<byte[]> getFeatureBytes(String md5) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getFeatureBytes(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatureBytes(String md5, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getFeatureBytes(md5), callback);
    }

    public ListenableFuture<byte[]> getFeatureBytes(String md5, boolean truncation) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getFeatureBytesTruncation(md5, truncation, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatureBytes(String md5, boolean truncation, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getFeatureBytes(md5, truncation), callback);
    }

    public ListenableFuture<List<byte[]>> getFeatureBytesList(List<String> md5List, boolean truncation) {
        MethodCallback<List<byte[]>, List<ByteString>> nativeCallback = new MethodCallback<List<byte[]>, List<ByteString>>(new Function<List<ByteString>, List<byte[]>>(){

            public List<byte[]> apply(List<ByteString> input) {
                return TypeTransformer.getInstance().to(input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getFeatureBytesList(md5List, truncation, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatureBytesList(List<String> md5List, boolean truncation, FutureCallback<List<byte[]>> callback) {
        this.factory.addCallback(this.getFeatureBytesList(md5List, truncation), callback);
    }

    public ListenableFuture<List<FeatureBean>> getFeatures(List<String> md5List) {
        MethodCallback<List<FeatureBean>, List<net.gdface.facelog.client.thrift.FeatureBean>> nativeCallback = new MethodCallback<List<FeatureBean>, List<net.gdface.facelog.client.thrift.FeatureBean>>(new Function<List<net.gdface.facelog.client.thrift.FeatureBean>, List<FeatureBean>>(){

            public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.getFeatures(md5List, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatures(List<String> md5List, FutureCallback<List<FeatureBean>> callback) {
        this.factory.addCallback(this.getFeatures(md5List), callback);
    }

    public ListenableFuture<List<String>> getFeaturesByPersonIdAndSdkVersion(int personId, String sdkVersion) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.getFeaturesByPersonIdAndSdkVersion(personId, sdkVersion, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesByPersonIdAndSdkVersion(int personId, String sdkVersion, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesByPersonIdAndSdkVersion(personId, sdkVersion), callback);
    }

    public ListenableFuture<List<String>> getFeaturesOfImage(String imageMd5) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.getFeaturesOfImage(imageMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesOfImage(String imageMd5, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesOfImage(imageMd5), callback);
    }

    public ListenableFuture<List<String>> getFeaturesOfPerson(int personId) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.getFeaturesOfPerson(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesOfPerson(int personId, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesOfPerson(personId), callback);
    }

    public ListenableFuture<List<String>> getFeaturesPermittedOnDevice(int deviceId, boolean ignoreSchedule, String sdkVersion, List<String> excludeFeatureIds, Long timestamp) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.getFeaturesPermittedOnDevice(deviceId, ignoreSchedule, sdkVersion, excludeFeatureIds, timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesPermittedOnDevice(int deviceId, boolean ignoreSchedule, String sdkVersion, List<String> excludeFeatureIds, Long timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesPermittedOnDevice(deviceId, ignoreSchedule, sdkVersion, excludeFeatureIds, timestamp), callback);
    }

    public ListenableFuture<List<Integer>> getGroupIdsByPath(String tablename, String path) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getGroupIdsByPath(tablename, path, nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupIdsByPath(String tablename, String path, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getGroupIdsByPath(tablename, path), callback);
    }

    public ListenableFuture<PermitBean> getGroupPermit(int deviceId, int personGroupId) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getGroupPermit(deviceId, personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupPermit(int deviceId, int personGroupId, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.getGroupPermit(deviceId, personGroupId), callback);
    }

    public ListenableFuture<PermitBean> getGroupPermitOnDeviceGroup(int deviceGroupId, int personGroupId) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getGroupPermitOnDeviceGroup(deviceGroupId, personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupPermitOnDeviceGroup(int deviceGroupId, int personGroupId, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.getGroupPermitOnDeviceGroup(deviceGroupId, personGroupId), callback);
    }

    public ListenableFuture<List<PermitBean>> getGroupPermits(int deviceId, List<Integer> personGroupIdList) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getGroupPermits(deviceId, personGroupIdList, nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupPermits(int deviceId, List<Integer> personGroupIdList, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.getGroupPermits(deviceId, personGroupIdList), callback);
    }

    public ListenableFuture<ImageBean> getImage(String imageMD5) {
        MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean> nativeCallback = new MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean>(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        nativeCallback.service.getImage(imageMD5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImage(String imageMD5, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.getImage(imageMD5), callback);
    }

    public ListenableFuture<ImageBean> getImage(String primaryKey, String refType) {
        MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean> nativeCallback = new MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean>(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        nativeCallback.service.getImageRef(primaryKey, refType, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImage(String primaryKey, String refType, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.getImage(primaryKey, refType), callback);
    }

    public ListenableFuture<byte[]> getImageBytes(String imageMD5) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getImageBytes(imageMD5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImageBytes(String imageMD5, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getImageBytes(imageMD5), callback);
    }

    public ListenableFuture<byte[]> getImageBytes(String primaryKey, String refType) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getImageBytesRef(primaryKey, refType, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImageBytes(String primaryKey, String refType, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getImageBytes(primaryKey, refType), callback);
    }

    public ListenableFuture<List<String>> getImagesAssociatedByFeature(String featureMd5) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.getImagesAssociatedByFeature(featureMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImagesAssociatedByFeature(String featureMd5, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getImagesAssociatedByFeature(featureMd5), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> getLogBeansByPersonId(int personId) {
        MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>>(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        nativeCallback.service.getLogBeansByPersonId(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getLogBeansByPersonId(int personId, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.getLogBeansByPersonId(personId), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> getLogBeansByPersonId(int personId, Token token) {
        MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>>(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        nativeCallback.service.getLogBeansByPersonIdSafe(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getLogBeansByPersonId(int personId, Token token, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.getLogBeansByPersonId(personId, token), callback);
    }

    public ListenableFuture<Map<MQParam, String>> getMessageQueueParameters(Token token) {
        MethodCallback<Map<MQParam, String>, Map<net.gdface.facelog.client.thrift.MQParam, String>> nativeCallback = new MethodCallback<Map<MQParam, String>, Map<net.gdface.facelog.client.thrift.MQParam, String>>(new Function<Map<net.gdface.facelog.client.thrift.MQParam, String>, Map<MQParam, String>>(){

            public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam, String> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MQParam.class, String.class, MQParam.class, String.class);
            }
        });
        nativeCallback.service.getMessageQueueParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getMessageQueueParameters(Token token, FutureCallback<Map<MQParam, String>> callback) {
        this.factory.addCallback(this.getMessageQueueParameters(token), callback);
    }

    public ListenableFuture<PersonBean> getPerson(int personId) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPerson(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPerson(int personId, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPerson(personId), callback);
    }

    public ListenableFuture<PersonBean> getPerson(int personId, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonReal(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPerson(int personId, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPerson(personId, token), callback);
    }

    public ListenableFuture<PersonBean> getPersonByMobilePhone(String mobilePhone) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonByMobilePhone(mobilePhone, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonByMobilePhone(String mobilePhone, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPersonByMobilePhone(mobilePhone), callback);
    }

    public ListenableFuture<PersonBean> getPersonByMobilePhone(String mobilePhone, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonByMobilePhoneReal(mobilePhone, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonByMobilePhone(String mobilePhone, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPersonByMobilePhone(mobilePhone, token), callback);
    }

    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonByPapersNum(papersNum, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonByPapersNum(String papersNum, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPersonByPapersNum(papersNum), callback);
    }

    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonByPapersNumSafe(papersNum, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonByPapersNum(String papersNum, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPersonByPapersNum(papersNum, token), callback);
    }

    public ListenableFuture<PersonGroupBean> getPersonGroup(int personGroupId) {
        MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = new MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean>(new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

            public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        nativeCallback.service.getPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroup(int personGroupId, FutureCallback<PersonGroupBean> callback) {
        this.factory.addCallback(this.getPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<List<PersonGroupBean>> getPersonGroups(List<Integer> groupIdList) {
        MethodCallback<List<PersonGroupBean>, List<net.gdface.facelog.client.thrift.PersonGroupBean>> nativeCallback = new MethodCallback<List<PersonGroupBean>, List<net.gdface.facelog.client.thrift.PersonGroupBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>, List<PersonGroupBean>>(){

            public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        nativeCallback.service.getPersonGroups(groupIdList, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroups(List<Integer> groupIdList, FutureCallback<List<PersonGroupBean>> callback) {
        this.factory.addCallback(this.getPersonGroups(groupIdList), callback);
    }

    public ListenableFuture<List<Integer>> getPersonGroupsBelongs(int personId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getPersonGroupsBelongs(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroupsBelongs(int personId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonGroupsBelongs(personId), callback);
    }

    public ListenableFuture<List<Integer>> getPersonGroupsPermittedBy(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getPersonGroupsPermittedBy(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroupsPermittedBy(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonGroupsPermittedBy(deviceGroupId), callback);
    }

    public ListenableFuture<PermitBean> getPersonPermit(int deviceId, int personId) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getPersonPermit(deviceId, personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonPermit(int deviceId, int personId, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.getPersonPermit(deviceId, personId), callback);
    }

    public ListenableFuture<List<PermitBean>> getPersonPermits(int deviceId, List<Integer> personIdList) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getPersonPermits(deviceId, personIdList, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonPermits(int deviceId, List<Integer> personIdList, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.getPersonPermits(deviceId, personIdList), callback);
    }

    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList) {
        MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = new MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersons(idList, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersons(List<Integer> idList, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.getPersons(idList), callback);
    }

    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList, Token token) {
        MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = new MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonsReal(idList, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersons(List<Integer> idList, Token token, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.getPersons(idList, token), callback);
    }

    public ListenableFuture<List<Integer>> getPersonsOfGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getPersonsOfGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonsOfGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonsOfGroup(personGroupId), callback);
    }

    public ListenableFuture<List<Integer>> getPersonsPermittedOnDevice(int deviceId, boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getPersonsPermittedOnDevice(deviceId, ignoreSchedule, excludePersonIds, timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonsPermittedOnDevice(int deviceId, boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonsPermittedOnDevice(deviceId, ignoreSchedule, excludePersonIds, timestamp), callback);
    }

    public ListenableFuture<List<String>> getPersonsPermittedOnDeviceByGroup(int deviceId, boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.getPersonsPermittedOnDeviceByGroup(deviceId, ignoreSchedule, excludePersonIds, timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonsPermittedOnDeviceByGroup(int deviceId, boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getPersonsPermittedOnDeviceByGroup(deviceId, ignoreSchedule, excludePersonIds, timestamp), callback);
    }

    public ListenableFuture<Map<String, String>> getProperties(String prefix, Token token) {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.getProperties(prefix, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getProperties(String prefix, Token token, FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.getProperties(prefix, token), callback);
    }

    public ListenableFuture<String> getProperty(String key, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.getProperty(key, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getProperty(String key, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.getProperty(key, token), callback);
    }

    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token) {
        MethodCallback<Map<MQParam, String>, Map<net.gdface.facelog.client.thrift.MQParam, String>> nativeCallback = new MethodCallback<Map<MQParam, String>, Map<net.gdface.facelog.client.thrift.MQParam, String>>(new Function<Map<net.gdface.facelog.client.thrift.MQParam, String>, Map<MQParam, String>>(){

            public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam, String> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MQParam.class, String.class, MQParam.class, String.class);
            }
        });
        nativeCallback.service.getRedisParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getRedisParameters(Token token, FutureCallback<Map<MQParam, String>> callback) {
        this.factory.addCallback(this.getRedisParameters(token), callback);
    }

    public ListenableFuture<Map<String, String>> getServiceConfig(Token token) {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.getServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getServiceConfig(Token token, FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.getServiceConfig(token), callback);
    }

    public ListenableFuture<List<Integer>> getSubDeviceGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getSubDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getSubDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getSubDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> getSubPersonGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.getSubPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getSubPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getSubPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<TmpwdTargetInfo> getTargetInfo4PwdOnDevice(String pwd, Token token) {
        MethodCallback<TmpwdTargetInfo, net.gdface.facelog.client.thrift.TmpwdTargetInfo> nativeCallback = new MethodCallback<TmpwdTargetInfo, net.gdface.facelog.client.thrift.TmpwdTargetInfo>(new Function<net.gdface.facelog.client.thrift.TmpwdTargetInfo, TmpwdTargetInfo>(){

            public TmpwdTargetInfo apply(net.gdface.facelog.client.thrift.TmpwdTargetInfo input) {
                return (TmpwdTargetInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.TmpwdTargetInfo.class, TmpwdTargetInfo.class);
            }
        });
        nativeCallback.service.getTargetInfo4PwdOnDevice(pwd, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getTargetInfo4PwdOnDevice(String pwd, Token token, FutureCallback<TmpwdTargetInfo> callback) {
        this.factory.addCallback(this.getTargetInfo4PwdOnDevice(pwd, token), callback);
    }

    public ListenableFuture<Integer> initTopGroup(TopGroupInfo groupInfo, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.initTopGroup((net.gdface.facelog.client.thrift.TopGroupInfo)TypeTransformer.getInstance().to((Object)groupInfo, TopGroupInfo.class, net.gdface.facelog.client.thrift.TopGroupInfo.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void initTopGroup(TopGroupInfo groupInfo, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.initTopGroup(groupInfo, token), callback);
    }

    public ListenableFuture<Boolean> isDisable(int personId) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isDisable(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void isDisable(int personId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isDisable(personId), callback);
    }

    public boolean isLocal() {
        return false;
    }

    public ListenableFuture<Boolean> isValidAckChannel(String ackChannel) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidAckChannel(ackChannel, nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidAckChannel(String ackChannel, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidAckChannel(ackChannel), callback);
    }

    public ListenableFuture<Boolean> isValidCmdSn(int cmdSn) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidCmdSn(cmdSn, nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidCmdSn(int cmdSn, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidCmdSn(cmdSn), callback);
    }

    public ListenableFuture<Boolean> isValidDeviceToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidDeviceToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidDeviceToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidDeviceToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidPassword(String userId, String password, boolean isMd5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidPassword(userId, password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidPassword(String userId, String password, boolean isMd5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidPassword(userId, password, isMd5), callback);
    }

    public ListenableFuture<Boolean> isValidPersonToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidPersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidPersonToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidPersonToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidRootToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidRootToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidRootToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidUserToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidUserToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidUserToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidUserToken(token), callback);
    }

    public ListenableFuture<String> iso8601Time() {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.iso8601Time(nativeCallback);
        return nativeCallback.feature;
    }

    public void iso8601Time(FutureCallback<String> callback) {
        this.factory.addCallback(this.iso8601Time(), callback);
    }

    public ListenableFuture<List<Integer>> listOfParentForDeviceGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.listOfParentForDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void listOfParentForDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.listOfParentForDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> listOfParentForPersonGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.listOfParentForPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void listOfParentForPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.listOfParentForPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<List<Integer>> loadAllPerson() {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadAllPerson(nativeCallback);
        return nativeCallback.feature;
    }

    public void loadAllPerson(FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadAllPerson(), callback);
    }

    public ListenableFuture<List<Integer>> loadAllPerson(Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadAllPersonSafe((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadAllPerson(Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadAllPerson(token), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> loadDeviceByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>>(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.loadDeviceByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.loadDeviceByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> loadDeviceByWhere(String where, int startRow, int numRows, Token token) {
        MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>>(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.loadDeviceByWhereSafe(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceByWhere(String where, int startRow, int numRows, Token token, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.loadDeviceByWhere(where, startRow, numRows, token), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadDeviceGroupByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceGroupByWhere(String where, int startRow, int numRows, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadDeviceGroupIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceGroupIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadDeviceGroupIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceGroupIdByWhere(String where, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupIdByWhere(where, token), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadDeviceIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadDeviceIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceIdByWhere(String where, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceIdByWhere(where, token), callback);
    }

    public ListenableFuture<List<Integer>> loadDistinctIntegerColumn(String table, String column, String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadDistinctIntegerColumn(table, column, where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDistinctIntegerColumn(String table, String column, String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDistinctIntegerColumn(table, column, where), callback);
    }

    public ListenableFuture<List<String>> loadDistinctStringColumn(String table, String column, String where) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.loadDistinctStringColumn(table, column, where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDistinctStringColumn(String table, String column, String where, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadDistinctStringColumn(table, column, where), callback);
    }

    public ListenableFuture<List<ErrorLogBean>> loadErrorLogByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<ErrorLogBean>, List<net.gdface.facelog.client.thrift.ErrorLogBean>> nativeCallback = new MethodCallback<List<ErrorLogBean>, List<net.gdface.facelog.client.thrift.ErrorLogBean>>(new Function<List<net.gdface.facelog.client.thrift.ErrorLogBean>, List<ErrorLogBean>>(){

            public List<ErrorLogBean> apply(List<net.gdface.facelog.client.thrift.ErrorLogBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.ErrorLogBean.class, ErrorLogBean.class);
            }
        });
        nativeCallback.service.loadErrorLogByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadErrorLogByWhere(String where, int startRow, int numRows, FutureCallback<List<ErrorLogBean>> callback) {
        this.factory.addCallback(this.loadErrorLogByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(String timestamp) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.loadFeatureMd5ByUpdateTimeStr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadFeatureMd5ByUpdate(String timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(String timestamp, Token token) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.loadFeatureMd5ByUpdateTimeStrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadFeatureMd5ByUpdate(String timestamp, Token token, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp, token), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.loadFeatureMd5ByUpdate(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadFeatureMd5ByUpdate(long timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp, Token token) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return input;
            }
        });
        nativeCallback.service.loadFeatureMd5ByUpdateSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadFeatureMd5ByUpdate(long timestamp, Token token, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp, token), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> loadLogByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>>(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        nativeCallback.service.loadLogByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.loadLogByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> loadLogByWhere(String where, int startRow, int numRows, Token token) {
        MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>>(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        nativeCallback.service.loadLogByWhereSafe(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogByWhere(String where, int startRow, int numRows, Token token, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.loadLogByWhere(where, startRow, numRows, token), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(String timestamp, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByVerifyTimeTimestr(timestamp, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByVerifyTime(String timestamp, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(String timestamp, int startRow, int numRows, Token token) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByVerifyTimeTimestrSafe(timestamp, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByVerifyTime(String timestamp, int startRow, int numRows, Token token, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows, token), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(long timestamp, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByVerifyTime(timestamp, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByVerifyTime(long timestamp, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(long timestamp, int startRow, int numRows, Token token) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByVerifyTimeSafe(timestamp, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByVerifyTime(long timestamp, int startRow, int numRows, Token token, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows, token), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByWhere(String where, int startRow, int numRows, Token token) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByWhereSafe(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByWhere(String where, int startRow, int numRows, Token token, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByWhere(where, startRow, numRows, token), callback);
    }

    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(String timestamp) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.loadPermitByUpdateTimestr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPermitByUpdate(String timestamp, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.loadPermitByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(long timestamp) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.loadPermitByUpdate(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPermitByUpdate(long timestamp, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.loadPermitByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = new MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.loadPersonByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonByWhere(String where, int startRow, int numRows, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.loadPersonByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where, int startRow, int numRows, Token token) {
        MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = new MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.loadPersonByWhereReal(where, startRow, numRows, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonByWhere(String where, int startRow, int numRows, Token token, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.loadPersonByWhere(where, startRow, numRows, token), callback);
    }

    public ListenableFuture<List<PersonDataPackage>> loadPersonDataPackages(List<Integer> personIds, String sdkVersion, int deviceId) {
        MethodCallback<List<PersonDataPackage>, List<net.gdface.facelog.client.thrift.PersonDataPackage>> nativeCallback = new MethodCallback<List<PersonDataPackage>, List<net.gdface.facelog.client.thrift.PersonDataPackage>>(new Function<List<net.gdface.facelog.client.thrift.PersonDataPackage>, List<PersonDataPackage>>(){

            public List<PersonDataPackage> apply(List<net.gdface.facelog.client.thrift.PersonDataPackage> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonDataPackage.class, PersonDataPackage.class);
            }
        });
        nativeCallback.service.loadPersonDataPackages(personIds, sdkVersion, deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonDataPackages(List<Integer> personIds, String sdkVersion, int deviceId, FutureCallback<List<PersonDataPackage>> callback) {
        this.factory.addCallback(this.loadPersonDataPackages(personIds, sdkVersion, deviceId), callback);
    }

    public ListenableFuture<List<PersonDataPackage>> loadPersonDataPackagesInSameGroup(List<Integer> personIds, String sdkVersion, int deviceId) {
        MethodCallback<List<PersonDataPackage>, List<net.gdface.facelog.client.thrift.PersonDataPackage>> nativeCallback = new MethodCallback<List<PersonDataPackage>, List<net.gdface.facelog.client.thrift.PersonDataPackage>>(new Function<List<net.gdface.facelog.client.thrift.PersonDataPackage>, List<PersonDataPackage>>(){

            public List<PersonDataPackage> apply(List<net.gdface.facelog.client.thrift.PersonDataPackage> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonDataPackage.class, PersonDataPackage.class);
            }
        });
        nativeCallback.service.loadPersonDataPackagesInSameGroup(personIds, sdkVersion, deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonDataPackagesInSameGroup(List<Integer> personIds, String sdkVersion, int deviceId, FutureCallback<List<PersonDataPackage>> callback) {
        this.factory.addCallback(this.loadPersonDataPackagesInSameGroup(personIds, sdkVersion, deviceId), callback);
    }

    public ListenableFuture<List<PersonDataPackage>> loadPersonDataPackagesPermittedOnDevice(int deviceId, boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, String sdkVersion) {
        MethodCallback<List<PersonDataPackage>, List<net.gdface.facelog.client.thrift.PersonDataPackage>> nativeCallback = new MethodCallback<List<PersonDataPackage>, List<net.gdface.facelog.client.thrift.PersonDataPackage>>(new Function<List<net.gdface.facelog.client.thrift.PersonDataPackage>, List<PersonDataPackage>>(){

            public List<PersonDataPackage> apply(List<net.gdface.facelog.client.thrift.PersonDataPackage> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonDataPackage.class, PersonDataPackage.class);
            }
        });
        nativeCallback.service.loadPersonDataPackagesPermittedOnDevice(deviceId, ignoreSchedule, excludePersonIds, timestamp, sdkVersion, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonDataPackagesPermittedOnDevice(int deviceId, boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, String sdkVersion, FutureCallback<List<PersonDataPackage>> callback) {
        this.factory.addCallback(this.loadPersonDataPackagesPermittedOnDevice(deviceId, ignoreSchedule, excludePersonIds, timestamp, sdkVersion), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonGroupByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonGroupByWhere(String where, int startRow, int numRows, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonGroupIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonGroupIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonGroupIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonGroupIdByWhere(String where, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupIdByWhere(where, token), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(String timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonIdByUpdateTimeTimeStr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByUpdateTime(String timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(String timestamp, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonIdByUpdateTimeTimeStrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByUpdateTime(String timestamp, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp, token), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonIdByUpdateTime(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByUpdateTime(long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonIdByUpdateTimeSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByUpdateTime(long timestamp, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp, token), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadPersonIdByWhereSafe(where, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByWhere(String where, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByWhere(where, token), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(String timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadUpdatedPersonsTimestr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadUpdatedPersons(String timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(String timestamp, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadUpdatedPersonsTimestrSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadUpdatedPersons(String timestamp, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp, token), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadUpdatedPersons(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadUpdatedPersons(long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp, Token token) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return input;
            }
        });
        nativeCallback.service.loadUpdatedPersonsSafe(timestamp, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void loadUpdatedPersons(long timestamp, Token token, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp, token), callback);
    }

    public ListenableFuture<LockWakeupResponse> lockWakeup(net.gdface.facelog.db.DeviceBean deviceBean, boolean ignoreSchedule, String sdkVersion) {
        MethodCallback<LockWakeupResponse, net.gdface.facelog.client.thrift.LockWakeupResponse> nativeCallback = new MethodCallback<LockWakeupResponse, net.gdface.facelog.client.thrift.LockWakeupResponse>(new Function<net.gdface.facelog.client.thrift.LockWakeupResponse, LockWakeupResponse>(){

            public LockWakeupResponse apply(net.gdface.facelog.client.thrift.LockWakeupResponse input) {
                return (LockWakeupResponse)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.LockWakeupResponse.class, LockWakeupResponse.class);
            }
        });
        nativeCallback.service.lockWakeup((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), ignoreSchedule, sdkVersion, nativeCallback);
        return nativeCallback.feature;
    }

    public void lockWakeup(net.gdface.facelog.db.DeviceBean deviceBean, boolean ignoreSchedule, String sdkVersion, FutureCallback<LockWakeupResponse> callback) {
        this.factory.addCallback(this.lockWakeup(deviceBean, ignoreSchedule, sdkVersion), callback);
    }

    public ListenableFuture<Void> offline(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.offline((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void offline(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.offline(token), callback);
    }

    public ListenableFuture<Token> online(net.gdface.facelog.db.DeviceBean device) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.online((DeviceBean)TypeTransformer.getInstance().to((Object)device, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void online(net.gdface.facelog.db.DeviceBean device, FutureCallback<Token> callback) {
        this.factory.addCallback(this.online(device), callback);
    }

    public ListenableFuture<String> pathOf(String tablename, int groupId) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.pathOf(tablename, groupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void pathOf(String tablename, int groupId, FutureCallback<String> callback) {
        this.factory.addCallback(this.pathOf(tablename, groupId), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> registerDevice(net.gdface.facelog.db.DeviceBean newDevice) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.registerDevice((DeviceBean)TypeTransformer.getInstance().to((Object)newDevice, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void registerDevice(net.gdface.facelog.db.DeviceBean newDevice, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.registerDevice(newDevice), callback);
    }

    public ListenableFuture<Void> releasePersonToken(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.releasePersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void releasePersonToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releasePersonToken(token), callback);
    }

    public ListenableFuture<Void> releaseRootToken(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.releaseRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void releaseRootToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releaseRootToken(token), callback);
    }

    public ListenableFuture<Void> releaseUserToken(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.releaseUserToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void releaseUserToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releaseUserToken(token), callback);
    }

    public ListenableFuture<Void> replaceFeature(int personId, String featureMd5, boolean deleteOldFeatureImage, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.replaceFeature(personId, featureMd5, deleteOldFeatureImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void replaceFeature(int personId, String featureMd5, boolean deleteOldFeatureImage, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.replaceFeature(personId, featureMd5, deleteOldFeatureImage, token), callback);
    }

    public ListenableFuture<Integer> rootGroupOfDevice(int deviceId) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.rootGroupOfDevice(deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void rootGroupOfDevice(int deviceId, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.rootGroupOfDevice(deviceId), callback);
    }

    public ListenableFuture<Integer> rootGroupOfDeviceGroup(int groupId) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.rootGroupOfDeviceGroup(groupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void rootGroupOfDeviceGroup(int groupId, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.rootGroupOfDeviceGroup(groupId), callback);
    }

    public ListenableFuture<Integer> rootGroupOfPerson(int personId) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.rootGroupOfPerson(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void rootGroupOfPerson(int personId, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.rootGroupOfPerson(personId), callback);
    }

    public ListenableFuture<Integer> rootGroupOfPersonGroup(int groupId) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.rootGroupOfPersonGroup(groupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void rootGroupOfPersonGroup(int groupId, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.rootGroupOfPersonGroup(groupId), callback);
    }

    public ListenableFuture<String> runCmd(List<Integer> target, boolean group, String cmdpath, String jsonArgs, String ackChannel, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.runCmd(target, group, cmdpath, jsonArgs, ackChannel, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void runCmd(List<Integer> target, boolean group, String cmdpath, String jsonArgs, String ackChannel, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.runCmd(target, group, cmdpath, jsonArgs, ackChannel, token), callback);
    }

    public ListenableFuture<Integer> runTask(String taskQueue, String cmdpath, String jsonArgs, String ackChannel, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.runTask(taskQueue, cmdpath, jsonArgs, ackChannel, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void runTask(String taskQueue, String cmdpath, String jsonArgs, String ackChannel, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.runTask(taskQueue, cmdpath, jsonArgs, ackChannel, token), callback);
    }

    public ListenableFuture<String> runTaskSync(String taskQueue, String cmdpath, String jsonArgs, int timeoutSecs, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.runTaskSync(taskQueue, cmdpath, jsonArgs, timeoutSecs, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void runTaskSync(String taskQueue, String cmdpath, String jsonArgs, int timeoutSecs, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.runTaskSync(taskQueue, cmdpath, jsonArgs, timeoutSecs, token), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> saveDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.saveDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void saveDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.saveDevice(deviceBean, token), callback);
    }

    public ListenableFuture<DeviceGroupBean> saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token) {
        MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = new MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean>(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

            public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        nativeCallback.service.saveDeviceGroup((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroupBean, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token, FutureCallback<DeviceGroupBean> callback) {
        this.factory.addCallback(this.saveDeviceGroup(deviceGroupBean, token), callback);
    }

    public ListenableFuture<PermitBean> savePermit(int deviceGroupId, int personGroupId, String column, String value, Token token) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.savePermitWithColumn(deviceGroupId, personGroupId, column, value, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePermit(int deviceGroupId, int personGroupId, String column, String value, Token token, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.savePermit(deviceGroupId, personGroupId, column, value, token), callback);
    }

    public ListenableFuture<PermitBean> savePermit(PermitBean permitBean, Token token) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.savePermit((net.gdface.facelog.client.thrift.PermitBean)TypeTransformer.getInstance().to((Object)permitBean, PermitBean.class, net.gdface.facelog.client.thrift.PermitBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePermit(PermitBean permitBean, Token token, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.savePermit(permitBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, boolean exractFeature, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndExtractFeature((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), exractFeature, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, boolean exractFeature, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, exractFeature, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, byte[] featureImage, FaceBean faceBean, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonFull((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, (ByteString)TypeTransformer.getInstance().to((Object)featureImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, byte[] featureImage, FaceBean faceBean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, feature, featureVersion, featureImage, faceBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, List<byte[]> photos, List<FaceBean> faces, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiImage((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, TypeTransformer.getInstance().to(photos, byte[].class, ByteString.class), TypeTransformer.getInstance().to(faces, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, List<byte[]> photos, List<FaceBean> faces, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, feature, featureVersion, photos, faces, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, List<FaceBean> faceBeans, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiFaces((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, List<FaceBean> faceBeans, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, feature, featureVersion, faceBeans, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhoto((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, FeatureBean featureBean, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeature((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FeatureBean)TypeTransformer.getInstance().to((Object)featureBean, FeatureBean.class, net.gdface.facelog.client.thrift.FeatureBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, FeatureBean featureBean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, featureBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeatureSaved((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhotoMd5, featureMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhotoMd5, featureMd5, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePerson((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, token), callback);
    }

    public ListenableFuture<PersonGroupBean> savePersonGroup(PersonGroupBean personGroupBean, Token token) {
        MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = new MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean>(new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

            public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        nativeCallback.service.savePersonGroup((net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroupBean, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePersonGroup(PersonGroupBean personGroupBean, Token token, FutureCallback<PersonGroupBean> callback) {
        this.factory.addCallback(this.savePersonGroup(personGroupBean, token), callback);
    }

    public ListenableFuture<Integer> savePersons(List<byte[]> photos, List<PersonBean> persons, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.savePersonsWithPhoto(TypeTransformer.getInstance().to(photos, byte[].class, ByteString.class), TypeTransformer.getInstance().to(persons, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePersons(List<byte[]> photos, List<PersonBean> persons, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.savePersons(photos, persons, token), callback);
    }

    public ListenableFuture<Void> savePersons(List<PersonBean> persons, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.savePersons(TypeTransformer.getInstance().to(persons, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePersons(List<PersonBean> persons, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.savePersons(persons, token), callback);
    }

    public ListenableFuture<Void> saveServiceConfig(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.saveServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void saveServiceConfig(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.saveServiceConfig(token), callback);
    }

    public ListenableFuture<String> sdkTaskQueueOf(String task, String sdkVersion, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.sdkTaskQueueOf(task, sdkVersion, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void sdkTaskQueueOf(String task, String sdkVersion, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.sdkTaskQueueOf(task, sdkVersion, token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(int personId, String expiryDate, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.setPersonExpiryDateTimeStr(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setPersonExpiryDate(int personId, String expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personId, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(int personId, long expiryDate, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.setPersonExpiryDate(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setPersonExpiryDate(int personId, long expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personId, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(List<Integer> personIdList, long expiryDate, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.setPersonExpiryDateList(personIdList, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setPersonExpiryDate(List<Integer> personIdList, long expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personIdList, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setProperties(Map<String, String> config, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.setProperties(TypeTransformer.getInstance().to(config, String.class, String.class, String.class, String.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setProperties(Map<String, String> config, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setProperties(config, token), callback);
    }

    public ListenableFuture<Void> setProperty(String key, String value, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.setProperty(key, value, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setProperty(String key, String value, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setProperty(key, value, token), callback);
    }

    public ListenableFuture<String> taskQueueOf(String task, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.taskQueueOf(task, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void taskQueueOf(String task, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.taskQueueOf(task, token), callback);
    }

    public ListenableFuture<Void> unbindBorder(int personGroupId, int deviceGroupId, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.unbindBorder(personGroupId, deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void unbindBorder(int personGroupId, int deviceGroupId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.unbindBorder(personGroupId, deviceGroupId, token), callback);
    }

    public ListenableFuture<Void> unregisterDevice(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return input;
            }
        });
        nativeCallback.service.unregisterDevice((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void unregisterDevice(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.unregisterDevice(token), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> updateDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.updateDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void updateDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.updateDevice(deviceBean, token), callback);
    }

    public ListenableFuture<String> version() {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.version(nativeCallback);
        return nativeCallback.feature;
    }

    public void version(FutureCallback<String> callback) {
        this.factory.addCallback(this.version(), callback);
    }

    public ListenableFuture<Map<String, String>> versionInfo() {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.versionInfo(nativeCallback);
        return nativeCallback.feature;
    }

    public void versionInfo(FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.versionInfo(), callback);
    }

    static /* synthetic */ ClientFactory access$000(IFaceLogThriftClientAsync x0) {
        return x0.factory;
    }

    public static class DefaultCallback<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(Throwable t) {
            try {
                throw t;
            }
            catch (DuplicateRecordException e) {
                this.onDuplicateRecordException(e);
            }
            catch (FuzzyMatchCountExceedLimitException e) {
                this.onFuzzyMatchCountExceedLimitException(e);
            }
            catch (ServiceSecurityException e) {
                this.onServiceSecurityException(e);
            }
            catch (ServiceRuntimeException e) {
                this.onServiceRuntimeException(e);
            }
            catch (Throwable e) {
                this.onThrowable(e);
            }
        }

        protected void onDuplicateRecordException(DuplicateRecordException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onFuzzyMatchCountExceedLimitException(FuzzyMatchCountExceedLimitException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onServiceSecurityException(ServiceSecurityException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onServiceRuntimeException(ServiceRuntimeException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onThrowable(Throwable e) {
            e.printStackTrace();
        }
    }

    private class MethodCallback<L, R>
    implements ServiceMethodCallback<R> {
        private final AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                MethodCallback.this.onError(error);
            }
        };
        final IFaceLogClient service = (IFaceLogClient)IFaceLogThriftClientAsync.access$000(IFaceLogThriftClientAsync.this).applyInstance(IFaceLogClient.class, this.closeListener);
        final SettableFuture<L> feature = SettableFuture.create();
        final Function<R, L> transformer;

        MethodCallback(Function<R, L> transformer) {
            this.transformer = transformer;
        }

        public void onSuccess(R result) {
            this.feature.set(this.transformer.apply(result));
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onError(Throwable error) {
            if (error instanceof ThriftException && ((ThriftException)error).kind == ThriftException.Kind.MISSING_RESULT) {
                this.onSuccess(null);
            }
            this.feature.setException(error);
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

