package net.gdface.facelog.thrift;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.DuplicateRecordException;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.ServiceSecurityException;
import net.gdface.facelog.Token;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.LogBean;
import net.gdface.facelog.db.LogLightBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.TypeTransformer;
import net.gdface.thrift.ClientFactory;

import com.facebook.swift.service.RuntimeTApplicationException;
import static com.google.common.base.Preconditions.*;

/**
 * 基于thrift/swift框架生成的client端代码提供{@link IFaceLog}接口的RPC实现(线程安全)<br>
 * 转发所有{@link IFaceLog}接口方法到{@link #delegate()}指定的实例<br>
 * 所有服务端抛出的{@link RuntimeException}异常被封装到{@link ServiceRuntimeException}中抛出<br>
 * Example:<br>
 * <pre>
 *        IFaceLogThriftClient thriftInstance = ClientFactory
 *            .builder()
 *            .setHostAndPort("127.0.0.1",26413)
 *            .build(IFaceLog.class, IFaceLogThriftClient.class);
 * </pre>
 * 计算机生成代码(generated by automated tools ThriftServiceDecoratorGenerator @author guyadong)<br>
 * @author guyadong
 *
 */
public class IFaceLogThriftClient implements IFaceLog {
    private final ClientFactory factory;

    public IFaceLogThriftClient(ClientFactory factory) {
        super();
        this.factory = checkNotNull(factory,"factory is null");
    }

    /**
     * 返回{@link net.gdface.facelog.client.thrift.IFaceLog}实例
     * @return
     */
    protected net.gdface.facelog.client.thrift.IFaceLog delegate() {
        return factory.applyInstance(net.gdface.facelog.client.thrift.IFaceLog.class);
    }
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClient [factory=");
        builder.append(factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }
    @Override
    public FeatureBean addFeature(byte[] feature,
        Integer personId,
        List<FaceBean> faecBeans,
        Token token) 
        throws DuplicateRecordException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.addFeature(feature,
                personId,
                TypeTransformer.getInstance().to(
                    faecBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public FeatureBean addFeature(byte[] feature,
        Integer personId,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token) 
        throws DuplicateRecordException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.addFeatureMulti(feature,
                personId,
                TypeTransformer.getInstance().to(
                    faceInfo,
                    ByteBuffer.class,
                    FaceBean.class,
                    byte[].class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
                deviceId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public ImageBean addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token) 
        throws DuplicateRecordException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.addImage(imageData,
                deviceId,
                TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
                personId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void addLog(LogBean bean,
        Token token) 
        throws DuplicateRecordException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.addLog(TypeTransformer.getInstance().to(
                    bean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void addLogs(List<LogBean> beans,
        Token token) 
        throws DuplicateRecordException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.addLogs(TypeTransformer.getInstance().to(
                    beans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void addPermit(int deviceGroupId,
        int personGroupId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.addPermitById(deviceGroupId,
                personGroupId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void addPermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.addPermit(TypeTransformer.getInstance().to(
                    deviceGroup,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
                TypeTransformer.getInstance().to(
                    personGroup,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public String applyAckChannel(Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.applyAckChannel(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public String applyAckChannel(Token token,
        long duration) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.applyAckChannelWithDuration(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),
                duration);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public long applyCmdSn(Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.applyCmdSn(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Token applyPersonToken(int personId,
        String password,
        boolean isMd5) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.applyPersonToken(personId,
                password,
                isMd5),
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Token applyRootToken(String password,
        boolean isMd5) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.applyRootToken(password,
                isMd5),
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countDeviceByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countDeviceByWhere(where);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countDeviceGroupByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countDeviceGroupByWhere(where);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countLogByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countLogByWhere(where);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countLogLightByVerifyTime(long timestamp) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countLogLightByVerifyTime(timestamp);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countLogLightByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countLogLightByWhere(where);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countPersonByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countPersonByWhere(where);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int countPersonGroupByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.countPersonGroupByWhere(where);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deleteAllFeaturesByPersonId(personId,
                deleteImage,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deleteDeviceGroup(int deviceGroupId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deleteDeviceGroup(deviceGroupId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<String> deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.deleteFeature(featureMd5,
                deleteImage,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deleteImage(String imageMd5,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deleteImage(imageMd5,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deletePermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deletePermit(TypeTransformer.getInstance().to(
                    deviceGroup,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
                TypeTransformer.getInstance().to(
                    personGroup,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deletePerson(int personId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deletePerson(personId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deletePersonByPapersNum(String papersNum,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deletePersonByPapersNum(papersNum,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deletePersonGroup(int personGroupId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deletePersonGroup(personGroupId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deletePersons(List<Integer> personIdList,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deletePersons(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int deletePersonsByPapersNum(List<String> papersNumlist,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.deletePersonsByPapersNum(TypeTransformer.getInstance().to(
                    papersNumlist,
                    String.class,
                    String.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void disablePerson(int personId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.disablePerson(personId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void disablePerson(List<Integer> personIdList,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.disablePersonList(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean existsDevice(int id) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.existsDevice(id);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean existsFeature(String md5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.existsFeature(md5);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean existsImage(String md5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.existsImage(md5);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean existsPerson(int persionId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.existsPerson(persionId);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public DeviceBean getDevice(int deviceId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getDevice(deviceId),
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public DeviceGroupBean getDeviceGroup(int deviceGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getDeviceGroup(deviceGroupId),
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<DeviceGroupBean> getDeviceGroups(List<Integer> groupIdList) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getDeviceGroups(TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class)),
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> getDeviceGroupsBelongs(int deviceId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getDeviceGroupsBelongs(deviceId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Integer getDeviceIdOfFeature(String featureMd5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.getDeviceIdOfFeature(featureMd5);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<DeviceBean> getDevices(List<Integer> idList) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getDevices(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class)),
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> getDevicesOfGroup(int deviceGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getDevicesOfGroup(deviceGroupId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public FeatureBean getFeature(String md5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getFeature(md5),
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<String> getFeatureBeansByPersonId(int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getFeatureBeansByPersonId(personId),
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public byte[] getFeatureBytes(String md5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.getFeatureBytes(md5);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<FeatureBean> getFeatures(List<String> md5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getFeatures(TypeTransformer.getInstance().to(
                    md5,
                    String.class,
                    String.class)),
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<String> getFeaturesOfPerson(int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getFeaturesOfPerson(personId),
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean getGroupPermit(int deviceId,
        int personGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.getGroupPermit(deviceId,
                personGroupId);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Boolean> getGroupPermits(int deviceId,
        List<Integer> personGroupIdList) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getGroupPermits(deviceId,
                TypeTransformer.getInstance().to(
                    personGroupIdList,
                    Integer.class,
                    Integer.class)),
                    Boolean.class,
                    Boolean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public ImageBean getImage(String imageMD5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getImage(imageMD5),
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public byte[] getImageBytes(String imageMD5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.getImageBytes(imageMD5);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<String> getImagesAssociatedByFeature(String featureMd5) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getImagesAssociatedByFeature(featureMd5),
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<LogBean> getLogBeansByPersonId(int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getLogBeansByPersonId(personId),
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean getPerson(int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPerson(personId),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean getPersonByPapersNum(String papersNum) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersonByPapersNum(papersNum),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonGroupBean getPersonGroup(int personGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersonGroup(personGroupId),
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<PersonGroupBean> getPersonGroups(List<Integer> groupIdList) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersonGroups(TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class)),
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> getPersonGroupsBelongs(int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersonGroupsBelongs(personId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean getPersonPermit(int deviceId,
        int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.getPersonPermit(deviceId,
                personId);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Boolean> getPersonPermits(int deviceId,
        List<Integer> personIdList) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersonPermits(deviceId,
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class)),
                    Boolean.class,
                    Boolean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<PersonBean> getPersons(List<Integer> idList) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersons(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> getPersonsOfGroup(int personGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getPersonsOfGroup(personGroupId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public String getProperty(String key,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.getProperty(key,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Map<MQParam, String> getRedisParameters(Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getRedisParameters(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.MQParam.class,
                    String.class,
                    MQParam.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Map<String, String> getServiceConfig(Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getServiceConfig(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    String.class,
                    String.class,
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> getSubDeviceGroup(int deviceGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getSubDeviceGroup(deviceGroupId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> getSubPersonGroup(int personGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.getSubPersonGroup(personGroupId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean isDisable(int personId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.isDisable(personId);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean isLocal(){
        return false;
    }
    @Override
    public boolean isValidAckChannel(String ackChannel) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.isValidAckChannel(ackChannel);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean isValidCmdSn(long cmdSn) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.isValidCmdSn(cmdSn);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public boolean isValidPassword(String userId,
        String password,
        boolean isMd5,
        Token token) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.isValidPassword(userId,
                password,
                isMd5,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> listOfParentForDeviceGroup(int deviceGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.listOfParentForDeviceGroup(deviceGroupId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> listOfParentForPersonGroup(int personGroupId) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.listOfParentForPersonGroup(personGroupId),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadAllPerson() 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadAllPerson(),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<DeviceBean> loadDeviceByWhere(String where,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadDeviceByWhere(where,
                startRow,
                numRows),
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadDeviceGroupByWhere(where,
                startRow,
                numRows),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadDeviceGroupIdByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadDeviceGroupIdByWhere(where),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadDeviceIdByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadDeviceIdByWhere(where),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<String> loadFeatureMd5ByUpdate(long timestamp) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadFeatureMd5ByUpdate(timestamp),
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<LogBean> loadLogByWhere(String where,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadLogByWhere(where,
                startRow,
                numRows),
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<LogLightBean> loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadLogLightByVerifyTime(timestamp,
                startRow,
                numRows),
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<LogLightBean> loadLogLightByWhere(String where,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadLogLightByWhere(where,
                startRow,
                numRows),
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<PermitBean> loadPermitByUpdate(long timestamp) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadPermitByUpdate(timestamp),
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<PersonBean> loadPersonByWhere(String where,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadPersonByWhere(where,
                startRow,
                numRows),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadPersonGroupByWhere(String where,
        int startRow,
        int numRows) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadPersonGroupByWhere(where,
                startRow,
                numRows),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadPersonGroupIdByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadPersonGroupIdByWhere(where),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadPersonIdByUpdateTime(long timestamp) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadPersonIdByUpdateTime(timestamp),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadPersonIdByWhere(String where) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadPersonIdByWhere(where),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public List<Integer> loadUpdatedPersons(long timestamp) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.loadUpdatedPersons(timestamp),
                    Integer.class,
                    Integer.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void offline(Token token) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.offline(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Token online(DeviceBean device) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.online(TypeTransformer.getInstance().to(
                    device,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class)),
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public DeviceBean registerDevice(DeviceBean newDevice) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.registerDevice(TypeTransformer.getInstance().to(
                    newDevice,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class)),
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void releasePersonToken(Token token) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.releasePersonToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void releaseRootToken(Token token) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.releaseRootToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.replaceFeature(personId,
                featureMd5,
                deleteOldFeatureImage,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public DeviceBean saveDevice(DeviceBean deviceBean,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.saveDevice(TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public DeviceGroupBean saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.saveDeviceGroup(TypeTransformer.getInstance().to(
                    deviceGroupBean,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        byte[] featureImage,
        FaceBean featureFaceBean,
        Integer deviceId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonFull(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                idPhoto,
                feature,
                featureImage,
                TypeTransformer.getInstance().to(
                    featureFaceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
                deviceId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        List<FaceBean> faceBeans,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonWithPhotoAndFeatureMultiFaces(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                idPhoto,
                feature,
                TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonWithPhotoAndFeatureMultiImage(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                idPhoto,
                feature,
                TypeTransformer.getInstance().to(
                    faceInfo,
                    ByteBuffer.class,
                    FaceBean.class,
                    byte[].class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
                deviceId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        byte[] idPhoto,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonWithPhoto(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                idPhoto,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Integer deviceId,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonWithPhotoAndFeature(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                idPhoto,
                TypeTransformer.getInstance().to(
                    featureBean,
                    FeatureBean.class,
                    net.gdface.facelog.client.thrift.FeatureBean.class),
                deviceId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        String idPhotoMd5,
        String featureMd5,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonWithPhotoAndFeatureSaved(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                idPhotoMd5,
                featureMd5,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonBean savePerson(PersonBean bean,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePerson(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public PersonGroupBean savePersonGroup(PersonGroupBean personGroupBean,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.savePersonGroup(TypeTransformer.getInstance().to(
                    personGroupBean,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void savePersons(List<PersonBean> beans,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.savePersons(TypeTransformer.getInstance().to(
                    beans,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public int savePersons(Map<ByteBuffer, PersonBean> persons,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.savePersonsWithPhoto(TypeTransformer.getInstance().to(
                    persons,
                    ByteBuffer.class,
                    PersonBean.class,
                    byte[].class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void saveServiceConfig(Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.saveServiceConfig(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void setPersonExpiryDate(int personId,
        long expiryDate,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.setPersonExpiryDate(personId,
                expiryDate,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.setPersonExpiryDateList(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
                expiryDate,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void setProperties(Map<String, String> config,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.setProperties(TypeTransformer.getInstance().to(
                    config,
                    String.class,
                    String.class,
                    String.class,
                    String.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void setProperty(String key,
        String value,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.setProperty(key,
                value,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public void unregisterDevice(int deviceId,
        Token token) 
        throws ServiceSecurityException{
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
             instance.unregisterDevice(deviceId,
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public DeviceBean updateDevice(DeviceBean deviceBean,
        Token token) 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.updateDevice(TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public String version() 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return instance.version();
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
    @Override
    public Map<String, String> versionInfo() 
        {
        net.gdface.facelog.client.thrift.IFaceLog instance = delegate();
        try{
            return TypeTransformer.getInstance().to(
                    instance.versionInfo(),
                    String.class,
                    String.class,
                    String.class,
                    String.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch(RuntimeTApplicationException e){
            return net.gdface.thrift.ThriftUtils.returnNull(e);
        }
        finally{
            factory.releaseInstance(instance);
        }
    }
}