package net.gdface.facelog.thrift;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.LogBean;
import net.gdface.facelog.db.LogLightBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.TypeTransformer;

import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import net.gdface.thrift.ClientFactory;
import static com.google.common.base.Preconditions.*;

/**
 * 基于thrift/swift框架生成的client端代码提供{@link IFaceLog}接口的异步RPC实现(线程安全)<br>
 * 转发所有{@link IFaceLog}接口方法到{@link #delegate()}指定的实例<br>
 * 所有服务端抛出的{@link RuntimeException}异常被封装到{@link ServiceRuntimeException}中抛出<br>
 * Example:<br>
 * <pre>
 *        IFaceLogThriftClientAsync thriftInstance = ClientFactory
 *            .builder()
 *            .setHostAndPort("127.0.0.1",26413)
 *            .build(IFaceLog.class, IFaceLogThriftClientAsync.class);
 * </pre>
 * 计算机生成代码(generated by automated tools ThriftServiceDecoratorGenerator @author guyadong)<br>
 * @author guyadong
 *
 */
public class IFaceLogThriftClientAsync {
    private final ClientFactory factory;

    public IFaceLogThriftClientAsync(ClientFactory factory) {
        super();
        this.factory = checkNotNull(factory,"factory is null");
    }

    /**
     * 返回{@link net.gdface.facelog.client.thrift.IFaceLog.Async}实例
     * @return
     */
    protected net.gdface.facelog.client.thrift.IFaceLog.Async delegate() {
        return factory.applyInstance(net.gdface.facelog.client.thrift.IFaceLog.Async.class);
    }
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClientAsync [factory=");
        builder.append(factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }
    /**
     * 默认的{@link FutureCallback}实现
     * @author guyadong
     *
     * @param <V>
     */
    public static class DefaultCallback<V> implements FutureCallback<V>{
        @Override
        public void onSuccess(V result) {
            // DO NOTHING
        }
        @Override
        public void onFailure(Throwable t) {
            try{
                throw t;
            }
            catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
                onDuplicateRecordException(e);
            }
            catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
                onServiceSecurityException(e);
            }
            catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
                onServiceRuntimeException(e);
            }
            catch(Throwable e){
                onThrowable(e);
            }
        }
        protected void onDuplicateRecordException(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            System.out.println(e.getServiceStackTraceMessage());
        }
        protected void onServiceSecurityException(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            System.out.println(e.getServiceStackTraceMessage());
        }
        protected void onServiceRuntimeException(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            System.out.println(e.getServiceStackTraceMessage());
        }
        protected void onThrowable(Throwable e){
            e.printStackTrace();
        }
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.Integer,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        Integer personId,
        List<FaceBean> faecBeans,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<FeatureBean> future = Futures.transform(
            async.addFeature(feature,
            personId,
            TypeTransformer.getInstance().to(
                    faecBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>(){
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void addFeature(byte[] feature,
        Integer personId,
        List<FaceBean> faecBeans,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,personId,faecBeans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.Integer,java.util.Map,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        Integer personId,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<FeatureBean> future = Futures.transform(
            async.addFeatureMulti(feature,
            personId,
            TypeTransformer.getInstance().to(
                    faceInfo,
                    ByteBuffer.class,
                    FaceBean.class,
                    byte[].class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>(){
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void addFeature(byte[] feature,
        Integer personId,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,personId,faceInfo,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addImage(byte[],java.lang.Integer,net.gdface.facelog.db.FaceBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<ImageBean> addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<ImageBean> future = Futures.transform(
            async.addImage(imageData,
            deviceId,
            TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>(){
                @Override
                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token,
        FutureCallback<ImageBean>callback){
        factory.addCallback(addImage(imageData,deviceId,faceBean,personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLog(net.gdface.facelog.db.LogBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLog(LogBean bean,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.addLog(TypeTransformer.getInstance().to(
                    bean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void addLog(LogBean bean,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLog(bean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLogs(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLogs(List<LogBean> beans,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.addLogs(TypeTransformer.getInstance().to(
                    beans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void addLogs(List<LogBean> beans,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLogs(beans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addPermit(int,int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addPermit(int deviceGroupId,
        int personGroupId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.addPermitById(deviceGroupId,
            personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void addPermit(int deviceGroupId,
        int personGroupId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addPermit(deviceGroupId,personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addPermit(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addPermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.addPermit(TypeTransformer.getInstance().to(
                    deviceGroup,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    personGroup,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void addPermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addPermit(deviceGroup,personGroup,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyAckChannel(net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> applyAckChannel(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<String> future = async.applyAckChannel(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void applyAckChannel(Token token,
        FutureCallback<String>callback){
        factory.addCallback(applyAckChannel(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyAckChannel(net.gdface.facelog.Token,long)}
     */
    public ListenableFuture<String> applyAckChannel(Token token,
        long duration){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<String> future = async.applyAckChannelWithDuration(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),
            duration);
        return factory.wrap(async,future);
    }
    public void applyAckChannel(Token token,
        long duration,
        FutureCallback<String>callback){
        factory.addCallback(applyAckChannel(token,duration), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyCmdSn(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Long> applyCmdSn(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Long> future = async.applyCmdSn(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void applyCmdSn(Token token,
        FutureCallback<Long>callback){
        factory.addCallback(applyCmdSn(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyPersonToken(int,java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyPersonToken(int personId,
        String password,
        boolean isMd5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Token> future = Futures.transform(
            async.applyPersonToken(personId,
            password,
            isMd5),
            new Function<net.gdface.facelog.client.thrift.Token,Token>(){
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void applyPersonToken(int personId,
        String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyPersonToken(personId,password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyRootToken(java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyRootToken(String password,
        boolean isMd5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Token> future = Futures.transform(
            async.applyRootToken(password,
            isMd5),
            new Function<net.gdface.facelog.client.thrift.Token,Token>(){
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void applyRootToken(String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyRootToken(password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countDeviceByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countDeviceByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countDeviceByWhere(where);
        return factory.wrap(async,future);
    }
    public void countDeviceByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countDeviceByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countDeviceGroupByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countDeviceGroupByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countDeviceGroupByWhere(where);
        return factory.wrap(async,future);
    }
    public void countDeviceGroupByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countDeviceGroupByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countLogByWhere(where);
        return factory.wrap(async,future);
    }
    public void countLogByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByVerifyTime(long)}
     */
    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countLogLightByVerifyTime(timestamp);
        return factory.wrap(async,future);
    }
    public void countLogLightByVerifyTime(long timestamp,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByVerifyTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogLightByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countLogLightByWhere(where);
        return factory.wrap(async,future);
    }
    public void countLogLightByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countPersonByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countPersonByWhere(where);
        return factory.wrap(async,future);
    }
    public void countPersonByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countPersonByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonGroupByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countPersonGroupByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.countPersonGroupByWhere(where);
        return factory.wrap(async,future);
    }
    public void countPersonGroupByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countPersonGroupByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteAllFeaturesByPersonId(int,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deleteAllFeaturesByPersonId(personId,
            deleteImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteAllFeaturesByPersonId(personId,deleteImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteDeviceGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteDeviceGroup(int deviceGroupId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deleteDeviceGroup(deviceGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deleteDeviceGroup(int deviceGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteDeviceGroup(deviceGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteFeature(java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<List<String>> deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<String>> future = async.deleteFeature(featureMd5,
            deleteImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token,
        FutureCallback<List<String>>callback){
        factory.addCallback(deleteFeature(featureMd5,deleteImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteImage(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteImage(String imageMd5,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deleteImage(imageMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deleteImage(String imageMd5,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteImage(imageMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePermit(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deletePermit(TypeTransformer.getInstance().to(
                    deviceGroup,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    personGroup,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deletePermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePermit(deviceGroup,personGroup,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePerson(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePerson(int personId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deletePerson(personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deletePerson(int personId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePerson(personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonByPapersNum(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonByPapersNum(String papersNum,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deletePersonByPapersNum(papersNum,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deletePersonByPapersNum(String papersNum,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonByPapersNum(papersNum,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonGroup(int personGroupId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deletePersonGroup(personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deletePersonGroup(int personGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonGroup(personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersons(List<Integer> personIdList,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deletePersons(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deletePersons(List<Integer> personIdList,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersons(personIdList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonsByPapersNum(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonsByPapersNum(List<String> papersNumlist,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.deletePersonsByPapersNum(TypeTransformer.getInstance().to(
                    papersNumlist,
                    String.class,
                    String.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void deletePersonsByPapersNum(List<String> papersNumlist,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonsByPapersNum(papersNumlist,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#disablePerson(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> disablePerson(int personId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.disablePerson(personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void disablePerson(int personId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(disablePerson(personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#disablePerson(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> disablePerson(List<Integer> personIdList,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.disablePersonList(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void disablePerson(List<Integer> personIdList,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(disablePerson(personIdList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsDevice(int)}
     */
    public ListenableFuture<Boolean> existsDevice(int id){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.existsDevice(id);
        return factory.wrap(async,future);
    }
    public void existsDevice(int id,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsDevice(id), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsFeature(java.lang.String)}
     */
    public ListenableFuture<Boolean> existsFeature(String md5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.existsFeature(md5);
        return factory.wrap(async,future);
    }
    public void existsFeature(String md5,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsFeature(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsImage(java.lang.String)}
     */
    public ListenableFuture<Boolean> existsImage(String md5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.existsImage(md5);
        return factory.wrap(async,future);
    }
    public void existsImage(String md5,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsImage(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsPerson(int)}
     */
    public ListenableFuture<Boolean> existsPerson(int persionId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.existsPerson(persionId);
        return factory.wrap(async,future);
    }
    public void existsPerson(int persionId,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsPerson(persionId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevice(int)}
     */
    public ListenableFuture<DeviceBean> getDevice(int deviceId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<DeviceBean> future = Futures.transform(
            async.getDevice(deviceId),
            new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>(){
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getDevice(int deviceId,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(getDevice(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroup(int)}
     */
    public ListenableFuture<DeviceGroupBean> getDeviceGroup(int deviceGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<DeviceGroupBean> future = Futures.transform(
            async.getDeviceGroup(deviceGroupId),
            new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>(){
                @Override
                public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getDeviceGroup(int deviceGroupId,
        FutureCallback<DeviceGroupBean>callback){
        factory.addCallback(getDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroups(java.util.List)}
     */
    public ListenableFuture<List<DeviceGroupBean>> getDeviceGroups(List<Integer> groupIdList){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<DeviceGroupBean>> future = Futures.transform(
            async.getDeviceGroups(TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class)),
            new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>,List<DeviceGroupBean>>(){
                @Override
                public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getDeviceGroups(List<Integer> groupIdList,
        FutureCallback<List<DeviceGroupBean>>callback){
        factory.addCallback(getDeviceGroups(groupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroupsBelongs(int)}
     */
    public ListenableFuture<List<Integer>> getDeviceGroupsBelongs(int deviceId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.getDeviceGroupsBelongs(deviceId);
        return factory.wrap(async,future);
    }
    public void getDeviceGroupsBelongs(int deviceId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDeviceGroupsBelongs(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceIdOfFeature(java.lang.String)}
     */
    public ListenableFuture<Integer> getDeviceIdOfFeature(String featureMd5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.getDeviceIdOfFeature(featureMd5);
        return factory.wrap(async,future);
    }
    public void getDeviceIdOfFeature(String featureMd5,
        FutureCallback<Integer>callback){
        factory.addCallback(getDeviceIdOfFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevices(java.util.List)}
     */
    public ListenableFuture<List<DeviceBean>> getDevices(List<Integer> idList){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<DeviceBean>> future = Futures.transform(
            async.getDevices(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class)),
            new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>(){
                @Override
                public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getDevices(List<Integer> idList,
        FutureCallback<List<DeviceBean>>callback){
        factory.addCallback(getDevices(idList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevicesOfGroup(int)}
     */
    public ListenableFuture<List<Integer>> getDevicesOfGroup(int deviceGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.getDevicesOfGroup(deviceGroupId);
        return factory.wrap(async,future);
    }
    public void getDevicesOfGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDevicesOfGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeature(java.lang.String)}
     */
    public ListenableFuture<FeatureBean> getFeature(String md5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<FeatureBean> future = Futures.transform(
            async.getFeature(md5),
            new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>(){
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getFeature(String md5,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(getFeature(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatureBeansByPersonId(int)}
     */
    public ListenableFuture<List<String>> getFeatureBeansByPersonId(int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<String>> future = async.getFeatureBeansByPersonId(personId);
        return factory.wrap(async,future);
    }
    public void getFeatureBeansByPersonId(int personId,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeatureBeansByPersonId(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatureBytes(java.lang.String)}
     */
    public ListenableFuture<byte[]> getFeatureBytes(String md5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<byte[]> future = async.getFeatureBytes(md5);
        return factory.wrap(async,future);
    }
    public void getFeatureBytes(String md5,
        FutureCallback<byte[]>callback){
        factory.addCallback(getFeatureBytes(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatures(java.util.List)}
     */
    public ListenableFuture<List<FeatureBean>> getFeatures(List<String> md5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<FeatureBean>> future = Futures.transform(
            async.getFeatures(TypeTransformer.getInstance().to(
                    md5,
                    String.class,
                    String.class)),
            new Function<List<net.gdface.facelog.client.thrift.FeatureBean>,List<FeatureBean>>(){
                @Override
                public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getFeatures(List<String> md5,
        FutureCallback<List<FeatureBean>>callback){
        factory.addCallback(getFeatures(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeaturesOfPerson(int)}
     */
    public ListenableFuture<List<String>> getFeaturesOfPerson(int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<String>> future = async.getFeaturesOfPerson(personId);
        return factory.wrap(async,future);
    }
    public void getFeaturesOfPerson(int personId,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeaturesOfPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermit(int,int)}
     */
    public ListenableFuture<Boolean> getGroupPermit(int deviceId,
        int personGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.getGroupPermit(deviceId,
            personGroupId);
        return factory.wrap(async,future);
    }
    public void getGroupPermit(int deviceId,
        int personGroupId,
        FutureCallback<Boolean>callback){
        factory.addCallback(getGroupPermit(deviceId,personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermits(int,java.util.List)}
     */
    public ListenableFuture<List<Boolean>> getGroupPermits(int deviceId,
        List<Integer> personGroupIdList){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Boolean>> future = async.getGroupPermits(deviceId,
            TypeTransformer.getInstance().to(
                    personGroupIdList,
                    Integer.class,
                    Integer.class));
        return factory.wrap(async,future);
    }
    public void getGroupPermits(int deviceId,
        List<Integer> personGroupIdList,
        FutureCallback<List<Boolean>>callback){
        factory.addCallback(getGroupPermits(deviceId,personGroupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImage(java.lang.String)}
     */
    public ListenableFuture<ImageBean> getImage(String imageMD5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<ImageBean> future = Futures.transform(
            async.getImage(imageMD5),
            new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>(){
                @Override
                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getImage(String imageMD5,
        FutureCallback<ImageBean>callback){
        factory.addCallback(getImage(imageMD5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImageBytes(java.lang.String)}
     */
    public ListenableFuture<byte[]> getImageBytes(String imageMD5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<byte[]> future = async.getImageBytes(imageMD5);
        return factory.wrap(async,future);
    }
    public void getImageBytes(String imageMD5,
        FutureCallback<byte[]>callback){
        factory.addCallback(getImageBytes(imageMD5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImagesAssociatedByFeature(java.lang.String)}
     */
    public ListenableFuture<List<String>> getImagesAssociatedByFeature(String featureMd5){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<String>> future = async.getImagesAssociatedByFeature(featureMd5);
        return factory.wrap(async,future);
    }
    public void getImagesAssociatedByFeature(String featureMd5,
        FutureCallback<List<String>>callback){
        factory.addCallback(getImagesAssociatedByFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getLogBeansByPersonId(int)}
     */
    public ListenableFuture<List<LogBean>> getLogBeansByPersonId(int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<LogBean>> future = Futures.transform(
            async.getLogBeansByPersonId(personId),
            new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>(){
                @Override
                public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getLogBeansByPersonId(int personId,
        FutureCallback<List<LogBean>>callback){
        factory.addCallback(getLogBeansByPersonId(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPerson(int)}
     */
    public ListenableFuture<PersonBean> getPerson(int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.getPerson(personId),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getPerson(int personId,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonByPapersNum(java.lang.String)}
     */
    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.getPersonByPapersNum(papersNum),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getPersonByPapersNum(String papersNum,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPersonByPapersNum(papersNum), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroup(int)}
     */
    public ListenableFuture<PersonGroupBean> getPersonGroup(int personGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonGroupBean> future = Futures.transform(
            async.getPersonGroup(personGroupId),
            new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>(){
                @Override
                public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getPersonGroup(int personGroupId,
        FutureCallback<PersonGroupBean>callback){
        factory.addCallback(getPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroups(java.util.List)}
     */
    public ListenableFuture<List<PersonGroupBean>> getPersonGroups(List<Integer> groupIdList){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<PersonGroupBean>> future = Futures.transform(
            async.getPersonGroups(TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class)),
            new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>,List<PersonGroupBean>>(){
                @Override
                public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getPersonGroups(List<Integer> groupIdList,
        FutureCallback<List<PersonGroupBean>>callback){
        factory.addCallback(getPersonGroups(groupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroupsBelongs(int)}
     */
    public ListenableFuture<List<Integer>> getPersonGroupsBelongs(int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.getPersonGroupsBelongs(personId);
        return factory.wrap(async,future);
    }
    public void getPersonGroupsBelongs(int personId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonGroupsBelongs(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonPermit(int,int)}
     */
    public ListenableFuture<Boolean> getPersonPermit(int deviceId,
        int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.getPersonPermit(deviceId,
            personId);
        return factory.wrap(async,future);
    }
    public void getPersonPermit(int deviceId,
        int personId,
        FutureCallback<Boolean>callback){
        factory.addCallback(getPersonPermit(deviceId,personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonPermits(int,java.util.List)}
     */
    public ListenableFuture<List<Boolean>> getPersonPermits(int deviceId,
        List<Integer> personIdList){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Boolean>> future = async.getPersonPermits(deviceId,
            TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class));
        return factory.wrap(async,future);
    }
    public void getPersonPermits(int deviceId,
        List<Integer> personIdList,
        FutureCallback<List<Boolean>>callback){
        factory.addCallback(getPersonPermits(deviceId,personIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersons(java.util.List)}
     */
    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<PersonBean>> future = Futures.transform(
            async.getPersons(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class)),
            new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>(){
                @Override
                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getPersons(List<Integer> idList,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(getPersons(idList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonsOfGroup(int)}
     */
    public ListenableFuture<List<Integer>> getPersonsOfGroup(int personGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.getPersonsOfGroup(personGroupId);
        return factory.wrap(async,future);
    }
    public void getPersonsOfGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonsOfGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getProperty(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> getProperty(String key,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<String> future = async.getProperty(key,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void getProperty(String key,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(getProperty(key,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getRedisParameters(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Map<MQParam, String>> future = Futures.transform(
            async.getRedisParameters(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<Map<net.gdface.facelog.client.thrift.MQParam,String>,Map<MQParam, String>>(){
                @Override
                public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam,String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.MQParam.class,
                    String.class,
                    MQParam.class,
                    String.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void getRedisParameters(Token token,
        FutureCallback<Map<MQParam, String>>callback){
        factory.addCallback(getRedisParameters(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getServiceConfig(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<String, String>> getServiceConfig(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Map<String, String>> future = async.getServiceConfig(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void getServiceConfig(Token token,
        FutureCallback<Map<String, String>>callback){
        factory.addCallback(getServiceConfig(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getSubDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> getSubDeviceGroup(int deviceGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.getSubDeviceGroup(deviceGroupId);
        return factory.wrap(async,future);
    }
    public void getSubDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getSubDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getSubPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> getSubPersonGroup(int personGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.getSubPersonGroup(personGroupId);
        return factory.wrap(async,future);
    }
    public void getSubPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getSubPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isDisable(int)}
     */
    public ListenableFuture<Boolean> isDisable(int personId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.isDisable(personId);
        return factory.wrap(async,future);
    }
    public void isDisable(int personId,
        FutureCallback<Boolean>callback){
        factory.addCallback(isDisable(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isLocal()}
     */
    public boolean isLocal(){
        return false;
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidAckChannel(java.lang.String)}
     */
    public ListenableFuture<Boolean> isValidAckChannel(String ackChannel){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.isValidAckChannel(ackChannel);
        return factory.wrap(async,future);
    }
    public void isValidAckChannel(String ackChannel,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidAckChannel(ackChannel), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidCmdSn(long)}
     */
    public ListenableFuture<Boolean> isValidCmdSn(long cmdSn){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.isValidCmdSn(cmdSn);
        return factory.wrap(async,future);
    }
    public void isValidCmdSn(long cmdSn,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidCmdSn(cmdSn), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidPassword(java.lang.String,java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidPassword(String userId,
        String password,
        boolean isMd5,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Boolean> future = async.isValidPassword(userId,
            password,
            isMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void isValidPassword(String userId,
        String password,
        boolean isMd5,
        Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidPassword(userId,password,isMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#listOfParentForDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> listOfParentForDeviceGroup(int deviceGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.listOfParentForDeviceGroup(deviceGroupId);
        return factory.wrap(async,future);
    }
    public void listOfParentForDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(listOfParentForDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#listOfParentForPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> listOfParentForPersonGroup(int personGroupId){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.listOfParentForPersonGroup(personGroupId);
        return factory.wrap(async,future);
    }
    public void listOfParentForPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(listOfParentForPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadAllPerson()}
     */
    public ListenableFuture<List<Integer>> loadAllPerson(){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadAllPerson();
        return factory.wrap(async,future);
    }
    public void loadAllPerson(FutureCallback<List<Integer>>callback){
        factory.addCallback(loadAllPerson(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<DeviceBean>> loadDeviceByWhere(String where,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<DeviceBean>> future = Futures.transform(
            async.loadDeviceByWhere(where,
            startRow,
            numRows),
            new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>(){
                @Override
                public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void loadDeviceByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<DeviceBean>>callback){
        factory.addCallback(loadDeviceByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceGroupByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<Integer>> loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadDeviceGroupByWhere(where,
            startRow,
            numRows);
        return factory.wrap(async,future);
    }
    public void loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceGroupByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceGroupIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadDeviceGroupIdByWhere(where);
        return factory.wrap(async,future);
    }
    public void loadDeviceGroupIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceGroupIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadDeviceIdByWhere(where);
        return factory.wrap(async,future);
    }
    public void loadDeviceIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadFeatureMd5ByUpdate(long)}
     */
    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<String>> future = async.loadFeatureMd5ByUpdate(timestamp);
        return factory.wrap(async,future);
    }
    public void loadFeatureMd5ByUpdate(long timestamp,
        FutureCallback<List<String>>callback){
        factory.addCallback(loadFeatureMd5ByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogBean>> loadLogByWhere(String where,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<LogBean>> future = Futures.transform(
            async.loadLogByWhere(where,
            startRow,
            numRows),
            new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>(){
                @Override
                public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void loadLogByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<LogBean>>callback){
        factory.addCallback(loadLogByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByVerifyTime(long,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<LogLightBean>> future = Futures.transform(
            async.loadLogLightByVerifyTime(timestamp,
            startRow,
            numRows),
            new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>(){
                @Override
                public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByVerifyTime(timestamp,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByWhere(String where,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<LogLightBean>> future = Futures.transform(
            async.loadLogLightByWhere(where,
            startRow,
            numRows),
            new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>(){
                @Override
                public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void loadLogLightByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPermitByUpdate(long)}
     */
    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(long timestamp){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<PermitBean>> future = Futures.transform(
            async.loadPermitByUpdate(timestamp),
            new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>(){
                @Override
                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void loadPermitByUpdate(long timestamp,
        FutureCallback<List<PermitBean>>callback){
        factory.addCallback(loadPermitByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<PersonBean>> future = Futures.transform(
            async.loadPersonByWhere(where,
            startRow,
            numRows),
            new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>(){
                @Override
                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void loadPersonByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(loadPersonByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonGroupByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<Integer>> loadPersonGroupByWhere(String where,
        int startRow,
        int numRows){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonGroupByWhere(where,
            startRow,
            numRows);
        return factory.wrap(async,future);
    }
    public void loadPersonGroupByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonGroupByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonGroupIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonGroupIdByWhere(where);
        return factory.wrap(async,future);
    }
    public void loadPersonGroupIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonGroupIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByUpdateTime(long)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonIdByUpdateTime(timestamp);
        return factory.wrap(async,future);
    }
    public void loadPersonIdByUpdateTime(long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByUpdateTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonIdByWhere(where);
        return factory.wrap(async,future);
    }
    public void loadPersonIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadUpdatedPersons(long)}
     */
    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<List<Integer>> future = async.loadUpdatedPersons(timestamp);
        return factory.wrap(async,future);
    }
    public void loadUpdatedPersons(long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadUpdatedPersons(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#offline(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> offline(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.offline(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void offline(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(offline(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#online(net.gdface.facelog.db.DeviceBean)}
     */
    public ListenableFuture<Token> online(DeviceBean device){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Token> future = Futures.transform(
            async.online(TypeTransformer.getInstance().to(
                    device,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class)),
            new Function<net.gdface.facelog.client.thrift.Token,Token>(){
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void online(DeviceBean device,
        FutureCallback<Token>callback){
        factory.addCallback(online(device), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#registerDevice(net.gdface.facelog.db.DeviceBean)}
     */
    public ListenableFuture<DeviceBean> registerDevice(DeviceBean newDevice){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<DeviceBean> future = Futures.transform(
            async.registerDevice(TypeTransformer.getInstance().to(
                    newDevice,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class)),
            new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>(){
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void registerDevice(DeviceBean newDevice,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(registerDevice(newDevice), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releasePersonToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releasePersonToken(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.releasePersonToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void releasePersonToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releasePersonToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releaseRootToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releaseRootToken(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.releaseRootToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void releaseRootToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releaseRootToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#replaceFeature(java.lang.Integer,java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.replaceFeature(personId,
            featureMd5,
            deleteOldFeatureImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(replaceFeature(personId,featureMd5,deleteOldFeatureImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveDevice(net.gdface.facelog.db.DeviceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceBean> saveDevice(DeviceBean deviceBean,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<DeviceBean> future = Futures.transform(
            async.saveDevice(TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>(){
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void saveDevice(DeviceBean deviceBean,
        Token token,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(saveDevice(deviceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveDeviceGroup(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceGroupBean> saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<DeviceGroupBean> future = Futures.transform(
            async.saveDeviceGroup(TypeTransformer.getInstance().to(
                    deviceGroupBean,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>(){
                @Override
                public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token,
        FutureCallback<DeviceGroupBean>callback){
        factory.addCallback(saveDeviceGroup(deviceGroupBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],byte[],net.gdface.facelog.db.FaceBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        byte[] featureImage,
        FaceBean featureFaceBean,
        Integer deviceId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePersonFull(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhoto,
            feature,
            featureImage,
            TypeTransformer.getInstance().to(
                    featureFaceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        byte[] featureImage,
        FaceBean featureFaceBean,
        Integer deviceId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,feature,featureImage,featureFaceBean,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        List<FaceBean> faceBeans,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePersonWithPhotoAndFeatureMultiFaces(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhoto,
            feature,
            TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        List<FaceBean> faceBeans,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,feature,faceBeans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.util.Map,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePersonWithPhotoAndFeatureMultiImage(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhoto,
            feature,
            TypeTransformer.getInstance().to(
                    faceInfo,
                    ByteBuffer.class,
                    FaceBean.class,
                    byte[].class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,feature,faceInfo,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePersonWithPhoto(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhoto,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],net.gdface.facelog.db.FeatureBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Integer deviceId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePersonWithPhotoAndFeature(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhoto,
            TypeTransformer.getInstance().to(
                    featureBean,
                    FeatureBean.class,
                    net.gdface.facelog.client.thrift.FeatureBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Integer deviceId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,featureBean,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        String idPhotoMd5,
        String featureMd5,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePersonWithPhotoAndFeatureSaved(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhotoMd5,
            featureMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        String idPhotoMd5,
        String featureMd5,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhotoMd5,featureMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonBean> future = Futures.transform(
            async.savePerson(TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>(){
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePerson(PersonBean bean,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersonGroup(net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonGroupBean> savePersonGroup(PersonGroupBean personGroupBean,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<PersonGroupBean> future = Futures.transform(
            async.savePersonGroup(TypeTransformer.getInstance().to(
                    personGroupBean,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>(){
                @Override
                public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void savePersonGroup(PersonGroupBean personGroupBean,
        Token token,
        FutureCallback<PersonGroupBean>callback){
        factory.addCallback(savePersonGroup(personGroupBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> savePersons(List<PersonBean> beans,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.savePersons(TypeTransformer.getInstance().to(
                    beans,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void savePersons(List<PersonBean> beans,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(savePersons(beans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersons(java.util.Map,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> savePersons(Map<ByteBuffer, PersonBean> persons,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Integer> future = async.savePersonsWithPhoto(TypeTransformer.getInstance().to(
                    persons,
                    ByteBuffer.class,
                    PersonBean.class,
                    byte[].class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void savePersons(Map<ByteBuffer, PersonBean> persons,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(savePersons(persons,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveServiceConfig(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> saveServiceConfig(Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.saveServiceConfig(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void saveServiceConfig(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(saveServiceConfig(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(int,long,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(int personId,
        long expiryDate,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.setPersonExpiryDate(personId,
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void setPersonExpiryDate(int personId,
        long expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personId,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(java.util.List,long,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.setPersonExpiryDateList(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personIdList,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setProperties(java.util.Map,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setProperties(Map<String, String> config,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.setProperties(TypeTransformer.getInstance().to(
                    config,
                    String.class,
                    String.class,
                    String.class,
                    String.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void setProperties(Map<String, String> config,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setProperties(config,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setProperty(java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setProperty(String key,
        String value,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.setProperty(key,
            value,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void setProperty(String key,
        String value,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setProperty(key,value,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#unregisterDevice(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> unregisterDevice(int deviceId,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Void> future = async.unregisterDevice(deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class));
        return factory.wrap(async,future);
    }
    public void unregisterDevice(int deviceId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(unregisterDevice(deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#updateDevice(net.gdface.facelog.db.DeviceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceBean> updateDevice(DeviceBean deviceBean,
        Token token){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<DeviceBean> future = Futures.transform(
            async.updateDevice(TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class)),
            new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>(){
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }
            });
        return factory.wrap(async,future);
    }
    public void updateDevice(DeviceBean deviceBean,
        Token token,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(updateDevice(deviceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#version()}
     */
    public ListenableFuture<String> version(){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<String> future = async.version();
        return factory.wrap(async,future);
    }
    public void version(FutureCallback<String>callback){
        factory.addCallback(version(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#versionInfo()}
     */
    public ListenableFuture<Map<String, String>> versionInfo(){        
        net.gdface.facelog.client.thrift.IFaceLog.Async async = delegate();
        ListenableFuture<Map<String, String>> future = async.versionInfo();
        return factory.wrap(async,future);
    }
    public void versionInfo(FutureCallback<Map<String, String>>callback){
        factory.addCallback(versionInfo(), callback);
    }
}