/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import gu.simplemq.redis.JedisPoolLazy;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.CmdDispatcher;
import net.gdface.facelog.client.CmdManager;
import net.gdface.facelog.client.CommandAdapter;
import net.gdface.facelog.client.CommandAdapterContainer;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.thrift.IFaceLogThriftClient;
import net.gdface.facelog.thrift.IFaceLogThriftClientAsync;

public class ClientExtendTools {
    private IFaceLogThriftClient syncInstance;
    private IFaceLogThriftClientAsync asyncInstance;
    public final Function<Integer, Integer> deviceGroupIdGetter = new Function<Integer, Integer>(){

        public Integer apply(Integer input) {
            try {
                DeviceBean device = ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getDevice(input) : (DeviceBean)ClientExtendTools.this.asyncInstance.getDevice(input).get();
                return null == device ? null : device.getGroupId();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Function<Integer, List<Integer>> personGroupBelonsGetter = new Function<Integer, List<Integer>>(){

        public List<Integer> apply(Integer personId) {
            try {
                return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getPersonGroupsBelongs(personId) : (List)ClientExtendTools.this.asyncInstance.getPersonGroupsBelongs(personId).get();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Long> cmdSnValidator = new Predicate<Long>(){

        public boolean apply(Long input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidCmdSn(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidCmdSn(input).get()).booleanValue());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<String> ackChannelValidator = new Predicate<String>(){

        public boolean apply(String input) {
            try {
                return null == input || input.isEmpty() ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidAckChannel(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidAckChannel(input).get()).booleanValue());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };

    ClientExtendTools(IFaceLogThriftClient syncInstance) {
        this.syncInstance = (IFaceLogThriftClient)Preconditions.checkNotNull((Object)syncInstance, (Object)"syncInstance is null");
        this.asyncInstance = null;
    }

    ClientExtendTools(IFaceLogThriftClientAsync asyncInstance) {
        this.syncInstance = null;
        this.asyncInstance = (IFaceLogThriftClientAsync)Preconditions.checkNotNull((Object)asyncInstance, (Object)"asyncInstance is null");
    }

    public Supplier<Integer> getDeviceGroupIdSupplier(final int deviceId) {
        return new Supplier<Integer>(){

            public Integer get() {
                return (Integer)ClientExtendTools.this.deviceGroupIdGetter.apply((Object)deviceId);
            }
        };
    }

    public Supplier<List<Integer>> getPersonGroupBelonsSupplier(final int personId) {
        return new Supplier<List<Integer>>(){

            public List<Integer> get() {
                return (List)ClientExtendTools.this.personGroupBelonsGetter.apply((Object)personId);
            }
        };
    }

    public CmdManager makeCmdManager(Token token) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token)).getType() == Token.TokenType.PERSON || token.getType() == Token.TokenType.ROOT ? 1 : 0) != 0, (Object)"person or root token required");
            return new CmdManager(JedisPoolLazy.getDefaultInstance(), this.syncInstance != null ? this.syncInstance.getRedisParameters(token) : (Map)this.asyncInstance.getRedisParameters(token).get());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CmdDispatcher makeCmdDispatcher(Token token) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token)).getType() == Token.TokenType.DEVICE ? 1 : 0) != 0, (Object)"device token required");
            int deviceId = token.getId();
            Map pameters = this.syncInstance != null ? this.syncInstance.getRedisParameters(token) : (Map)this.asyncInstance.getRedisParameters(token).get();
            return new CmdDispatcher(deviceId, this.getDeviceGroupIdSupplier(deviceId)).setCmdSnValidator(this.cmdSnValidator).setAckChannelValidator(this.ackChannelValidator).setCmdAdapter((CommandAdapter)new CommandAdapterContainer()).registerChannel((String)pameters.get(MQParam.CMD_CHANNEL));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Supplier<String> getAckChannelSupplier(final Token token, final long duration) {
        return new Supplier<String>(){

            public String get() {
                try {
                    return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.applyAckChannel(token, duration) : (String)ClientExtendTools.this.asyncInstance.applyAckChannel(token, duration).get();
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Supplier<String> getAckChannelSupplier(Token token) {
        return this.getAckChannelSupplier(token, 0L);
    }

    public Supplier<Long> getCmdSnSupplier(final Token token) {
        return new Supplier<Long>(){

            public Long get() {
                try {
                    return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.applyCmdSn(token) : ((Long)ClientExtendTools.this.asyncInstance.applyCmdSn(token).get()).longValue();
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

