/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.thrift.DeviceBean;
import net.gdface.facelog.client.thrift.DuplicateRecordException;
import net.gdface.facelog.client.thrift.IFaceLog;
import net.gdface.facelog.client.thrift.LogBean;
import net.gdface.facelog.client.thrift.LogLightBean;
import net.gdface.facelog.client.thrift.ServiceRuntimeException;
import net.gdface.facelog.client.thrift.ServiceSecurityException;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.TypeTransformer;

public class IFaceLogThriftClientAsync {
    private final ClientFactory factory;

    public IFaceLogThriftClientAsync(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    protected IFaceLog.Async delegate() {
        return (IFaceLog.Async)this.factory.applyInstance(IFaceLog.Async.class);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClientAsync [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, Integer personId, List<FaceBean> faecBeans, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.addFeature(feature, personId, TypeTransformer.getInstance().to(faecBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void addFeature(byte[] feature, Integer personId, List<FaceBean> faecBeans, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, personId, faecBeans, token), callback);
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, Integer personId, Map<ByteBuffer, FaceBean> faceInfo, Integer deviceId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.addFeatureMulti(feature, personId, TypeTransformer.getInstance().to(faceInfo, ByteBuffer.class, FaceBean.class, byte[].class, net.gdface.facelog.client.thrift.FaceBean.class), deviceId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void addFeature(byte[] feature, Integer personId, Map<ByteBuffer, FaceBean> faceInfo, Integer deviceId, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, personId, faceInfo, deviceId, token), callback);
    }

    public ListenableFuture<ImageBean> addImage(byte[] imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.addImage(imageData, deviceId, (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void addImage(byte[] imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.addImage(imageData, deviceId, faceBean, personId, token), callback);
    }

    public ListenableFuture<Void> addLog(net.gdface.facelog.db.LogBean bean, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.addLog((LogBean)TypeTransformer.getInstance().to((Object)bean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void addLog(net.gdface.facelog.db.LogBean bean, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLog(bean, token), callback);
    }

    public ListenableFuture<Void> addLogs(List<net.gdface.facelog.db.LogBean> beans, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.addLogs(TypeTransformer.getInstance().to(beans, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void addLogs(List<net.gdface.facelog.db.LogBean> beans, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLogs(beans, token), callback);
    }

    public ListenableFuture<Void> addPermit(int deviceGroupId, int personGroupId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.addPermitById(deviceGroupId, personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void addPermit(int deviceGroupId, int personGroupId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addPermit(deviceGroupId, personGroupId, token), callback);
    }

    public ListenableFuture<Void> addPermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.addPermit((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroup, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroup, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void addPermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addPermit(deviceGroup, personGroup, token), callback);
    }

    public ListenableFuture<String> applyAckChannel(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<String> future = async.applyAckChannel((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void applyAckChannel(Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.applyAckChannel(token), callback);
    }

    public ListenableFuture<String> applyAckChannel(Token token, long duration) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<String> future = async.applyAckChannelWithDuration((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), duration);
        return this.factory.wrap((Object)async, future);
    }

    public void applyAckChannel(Token token, long duration, FutureCallback<String> callback) {
        this.factory.addCallback(this.applyAckChannel(token, duration), callback);
    }

    public ListenableFuture<Long> applyCmdSn(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Long> future = async.applyCmdSn((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void applyCmdSn(Token token, FutureCallback<Long> callback) {
        this.factory.addCallback(this.applyCmdSn(token), callback);
    }

    public ListenableFuture<Token> applyPersonToken(int personId, String password, boolean isMd5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.applyPersonToken(personId, password, isMd5), (Function)new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void applyPersonToken(int personId, String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyPersonToken(personId, password, isMd5), callback);
    }

    public ListenableFuture<Token> applyRootToken(String password, boolean isMd5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.applyRootToken(password, isMd5), (Function)new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void applyRootToken(String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyRootToken(password, isMd5), callback);
    }

    public ListenableFuture<Integer> countDeviceByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countDeviceByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void countDeviceByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceByWhere(where), callback);
    }

    public ListenableFuture<Integer> countDeviceGroupByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countDeviceGroupByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void countDeviceGroupByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceGroupByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countLogByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void countLogByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countLogLightByVerifyTime(timestamp);
        return this.factory.wrap((Object)async, future);
    }

    public void countLogLightByVerifyTime(long timestamp, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp), callback);
    }

    public ListenableFuture<Integer> countLogLightByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countLogLightByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void countLogLightByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByWhere(where), callback);
    }

    public ListenableFuture<Integer> countPersonByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countPersonByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void countPersonByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonByWhere(where), callback);
    }

    public ListenableFuture<Integer> countPersonGroupByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.countPersonGroupByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void countPersonGroupByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonGroupByWhere(where), callback);
    }

    public ListenableFuture<Integer> deleteAllFeaturesByPersonId(int personId, boolean deleteImage, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deleteAllFeaturesByPersonId(personId, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deleteAllFeaturesByPersonId(int personId, boolean deleteImage, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteAllFeaturesByPersonId(personId, deleteImage, token), callback);
    }

    public ListenableFuture<Integer> deleteDeviceGroup(int deviceGroupId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deleteDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deleteDeviceGroup(int deviceGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteDeviceGroup(deviceGroupId, token), callback);
    }

    public ListenableFuture<List<String>> deleteFeature(String featureMd5, boolean deleteImage, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<String>> future = async.deleteFeature(featureMd5, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deleteFeature(String featureMd5, boolean deleteImage, Token token, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.deleteFeature(featureMd5, deleteImage, token), callback);
    }

    public ListenableFuture<Integer> deleteImage(String imageMd5, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deleteImage(imageMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deleteImage(String imageMd5, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteImage(imageMd5, token), callback);
    }

    public ListenableFuture<Integer> deletePermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deletePermit((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroup, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroup, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deletePermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePermit(deviceGroup, personGroup, token), callback);
    }

    public ListenableFuture<Integer> deletePerson(int personId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deletePerson(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deletePerson(int personId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePerson(personId, token), callback);
    }

    public ListenableFuture<Integer> deletePersonByPapersNum(String papersNum, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deletePersonByPapersNum(papersNum, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deletePersonByPapersNum(String papersNum, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonByPapersNum(papersNum, token), callback);
    }

    public ListenableFuture<Integer> deletePersonGroup(int personGroupId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deletePersonGroup(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deletePersonGroup(int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonGroup(personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePersons(List<Integer> personIdList, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deletePersons(TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deletePersons(List<Integer> personIdList, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersons(personIdList, token), callback);
    }

    public ListenableFuture<Integer> deletePersonsByPapersNum(List<String> papersNumlist, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.deletePersonsByPapersNum(TypeTransformer.getInstance().to(papersNumlist, String.class, String.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void deletePersonsByPapersNum(List<String> papersNumlist, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonsByPapersNum(papersNumlist, token), callback);
    }

    public ListenableFuture<Void> disablePerson(int personId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.disablePerson(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void disablePerson(int personId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.disablePerson(personId, token), callback);
    }

    public ListenableFuture<Void> disablePerson(List<Integer> personIdList, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.disablePersonList(TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void disablePerson(List<Integer> personIdList, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.disablePerson(personIdList, token), callback);
    }

    public ListenableFuture<Boolean> existsDevice(int id) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.existsDevice(id);
        return this.factory.wrap((Object)async, future);
    }

    public void existsDevice(int id, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsDevice(id), callback);
    }

    public ListenableFuture<Boolean> existsFeature(String md5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.existsFeature(md5);
        return this.factory.wrap((Object)async, future);
    }

    public void existsFeature(String md5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsFeature(md5), callback);
    }

    public ListenableFuture<Boolean> existsImage(String md5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.existsImage(md5);
        return this.factory.wrap((Object)async, future);
    }

    public void existsImage(String md5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsImage(md5), callback);
    }

    public ListenableFuture<Boolean> existsPerson(int persionId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.existsPerson(persionId);
        return this.factory.wrap((Object)async, future);
    }

    public void existsPerson(int persionId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsPerson(persionId), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> getDevice(int deviceId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getDevice(deviceId), (Function)new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getDevice(int deviceId, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.getDevice(deviceId), callback);
    }

    public ListenableFuture<DeviceGroupBean> getDeviceGroup(int deviceGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getDeviceGroup(deviceGroupId), (Function)new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

            public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getDeviceGroup(int deviceGroupId, FutureCallback<DeviceGroupBean> callback) {
        this.factory.addCallback(this.getDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<DeviceGroupBean>> getDeviceGroups(List<Integer> groupIdList) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getDeviceGroups(TypeTransformer.getInstance().to(groupIdList, Integer.class, Integer.class)), (Function)new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>, List<DeviceGroupBean>>(){

            public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getDeviceGroups(List<Integer> groupIdList, FutureCallback<List<DeviceGroupBean>> callback) {
        this.factory.addCallback(this.getDeviceGroups(groupIdList), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsBelongs(int deviceId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.getDeviceGroupsBelongs(deviceId);
        return this.factory.wrap((Object)async, future);
    }

    public void getDeviceGroupsBelongs(int deviceId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsBelongs(deviceId), callback);
    }

    public ListenableFuture<Integer> getDeviceIdOfFeature(String featureMd5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.getDeviceIdOfFeature(featureMd5);
        return this.factory.wrap((Object)async, future);
    }

    public void getDeviceIdOfFeature(String featureMd5, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.getDeviceIdOfFeature(featureMd5), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> getDevices(List<Integer> idList) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getDevices(TypeTransformer.getInstance().to(idList, Integer.class, Integer.class)), (Function)new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getDevices(List<Integer> idList, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.getDevices(idList), callback);
    }

    public ListenableFuture<List<Integer>> getDevicesOfGroup(int deviceGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.getDevicesOfGroup(deviceGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void getDevicesOfGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDevicesOfGroup(deviceGroupId), callback);
    }

    public ListenableFuture<FeatureBean> getFeature(String md5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getFeature(md5), (Function)new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getFeature(String md5, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.getFeature(md5), callback);
    }

    public ListenableFuture<List<String>> getFeatureBeansByPersonId(int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<String>> future = async.getFeatureBeansByPersonId(personId);
        return this.factory.wrap((Object)async, future);
    }

    public void getFeatureBeansByPersonId(int personId, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeatureBeansByPersonId(personId), callback);
    }

    public ListenableFuture<byte[]> getFeatureBytes(String md5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<byte[]> future = async.getFeatureBytes(md5);
        return this.factory.wrap((Object)async, future);
    }

    public void getFeatureBytes(String md5, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getFeatureBytes(md5), callback);
    }

    public ListenableFuture<List<FeatureBean>> getFeatures(List<String> md5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getFeatures(TypeTransformer.getInstance().to(md5, String.class, String.class)), (Function)new Function<List<net.gdface.facelog.client.thrift.FeatureBean>, List<FeatureBean>>(){

            public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getFeatures(List<String> md5, FutureCallback<List<FeatureBean>> callback) {
        this.factory.addCallback(this.getFeatures(md5), callback);
    }

    public ListenableFuture<List<String>> getFeaturesOfPerson(int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<String>> future = async.getFeaturesOfPerson(personId);
        return this.factory.wrap((Object)async, future);
    }

    public void getFeaturesOfPerson(int personId, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesOfPerson(personId), callback);
    }

    public ListenableFuture<Boolean> getGroupPermit(int deviceId, int personGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.getGroupPermit(deviceId, personGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void getGroupPermit(int deviceId, int personGroupId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.getGroupPermit(deviceId, personGroupId), callback);
    }

    public ListenableFuture<List<Boolean>> getGroupPermits(int deviceId, List<Integer> personGroupIdList) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Boolean>> future = async.getGroupPermits(deviceId, TypeTransformer.getInstance().to(personGroupIdList, Integer.class, Integer.class));
        return this.factory.wrap((Object)async, future);
    }

    public void getGroupPermits(int deviceId, List<Integer> personGroupIdList, FutureCallback<List<Boolean>> callback) {
        this.factory.addCallback(this.getGroupPermits(deviceId, personGroupIdList), callback);
    }

    public ListenableFuture<ImageBean> getImage(String imageMD5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getImage(imageMD5), (Function)new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getImage(String imageMD5, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.getImage(imageMD5), callback);
    }

    public ListenableFuture<byte[]> getImageBytes(String imageMD5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<byte[]> future = async.getImageBytes(imageMD5);
        return this.factory.wrap((Object)async, future);
    }

    public void getImageBytes(String imageMD5, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getImageBytes(imageMD5), callback);
    }

    public ListenableFuture<List<String>> getImagesAssociatedByFeature(String featureMd5) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<String>> future = async.getImagesAssociatedByFeature(featureMd5);
        return this.factory.wrap((Object)async, future);
    }

    public void getImagesAssociatedByFeature(String featureMd5, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getImagesAssociatedByFeature(featureMd5), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> getLogBeansByPersonId(int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getLogBeansByPersonId(personId), (Function)new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getLogBeansByPersonId(int personId, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.getLogBeansByPersonId(personId), callback);
    }

    public ListenableFuture<PersonBean> getPerson(int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getPerson(personId), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getPerson(int personId, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPerson(personId), callback);
    }

    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getPersonByPapersNum(papersNum), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonByPapersNum(String papersNum, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPersonByPapersNum(papersNum), callback);
    }

    public ListenableFuture<PersonGroupBean> getPersonGroup(int personGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getPersonGroup(personGroupId), (Function)new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

            public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonGroup(int personGroupId, FutureCallback<PersonGroupBean> callback) {
        this.factory.addCallback(this.getPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<List<PersonGroupBean>> getPersonGroups(List<Integer> groupIdList) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getPersonGroups(TypeTransformer.getInstance().to(groupIdList, Integer.class, Integer.class)), (Function)new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>, List<PersonGroupBean>>(){

            public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonGroups(List<Integer> groupIdList, FutureCallback<List<PersonGroupBean>> callback) {
        this.factory.addCallback(this.getPersonGroups(groupIdList), callback);
    }

    public ListenableFuture<List<Integer>> getPersonGroupsBelongs(int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.getPersonGroupsBelongs(personId);
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonGroupsBelongs(int personId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonGroupsBelongs(personId), callback);
    }

    public ListenableFuture<Boolean> getPersonPermit(int deviceId, int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.getPersonPermit(deviceId, personId);
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonPermit(int deviceId, int personId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.getPersonPermit(deviceId, personId), callback);
    }

    public ListenableFuture<List<Boolean>> getPersonPermits(int deviceId, List<Integer> personIdList) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Boolean>> future = async.getPersonPermits(deviceId, TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class));
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonPermits(int deviceId, List<Integer> personIdList, FutureCallback<List<Boolean>> callback) {
        this.factory.addCallback(this.getPersonPermits(deviceId, personIdList), callback);
    }

    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getPersons(TypeTransformer.getInstance().to(idList, Integer.class, Integer.class)), (Function)new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getPersons(List<Integer> idList, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.getPersons(idList), callback);
    }

    public ListenableFuture<List<Integer>> getPersonsOfGroup(int personGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.getPersonsOfGroup(personGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void getPersonsOfGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonsOfGroup(personGroupId), callback);
    }

    public ListenableFuture<String> getProperty(String key, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<String> future = async.getProperty(key, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void getProperty(String key, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.getProperty(key, token), callback);
    }

    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.getRedisParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<Map<net.gdface.facelog.client.thrift.MQParam, String>, Map<MQParam, String>>(){

            public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam, String> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MQParam.class, String.class, MQParam.class, String.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void getRedisParameters(Token token, FutureCallback<Map<MQParam, String>> callback) {
        this.factory.addCallback(this.getRedisParameters(token), callback);
    }

    public ListenableFuture<Map<String, String>> getServiceConfig(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Map<String, String>> future = async.getServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void getServiceConfig(Token token, FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.getServiceConfig(token), callback);
    }

    public ListenableFuture<List<Integer>> getSubDeviceGroup(int deviceGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.getSubDeviceGroup(deviceGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void getSubDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getSubDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> getSubPersonGroup(int personGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.getSubPersonGroup(personGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void getSubPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getSubPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<Boolean> isDisable(int personId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isDisable(personId);
        return this.factory.wrap((Object)async, future);
    }

    public void isDisable(int personId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isDisable(personId), callback);
    }

    public boolean isLocal() {
        return false;
    }

    public ListenableFuture<Boolean> isValidAckChannel(String ackChannel) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isValidAckChannel(ackChannel);
        return this.factory.wrap((Object)async, future);
    }

    public void isValidAckChannel(String ackChannel, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidAckChannel(ackChannel), callback);
    }

    public ListenableFuture<Boolean> isValidCmdSn(long cmdSn) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isValidCmdSn(cmdSn);
        return this.factory.wrap((Object)async, future);
    }

    public void isValidCmdSn(long cmdSn, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidCmdSn(cmdSn), callback);
    }

    public ListenableFuture<Boolean> isValidDeviceToken(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isValidDeviceToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void isValidDeviceToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidDeviceToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidPassword(String userId, String password, boolean isMd5, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isValidPassword(userId, password, isMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void isValidPassword(String userId, String password, boolean isMd5, Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidPassword(userId, password, isMd5, token), callback);
    }

    public ListenableFuture<Boolean> isValidPersonToken(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isValidPersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void isValidPersonToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidPersonToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidRootToken(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Boolean> future = async.isValidRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void isValidRootToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidRootToken(token), callback);
    }

    public ListenableFuture<List<Integer>> listOfParentForDeviceGroup(int deviceGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.listOfParentForDeviceGroup(deviceGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void listOfParentForDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.listOfParentForDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> listOfParentForPersonGroup(int personGroupId) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.listOfParentForPersonGroup(personGroupId);
        return this.factory.wrap((Object)async, future);
    }

    public void listOfParentForPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.listOfParentForPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<List<Integer>> loadAllPerson() {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadAllPerson();
        return this.factory.wrap((Object)async, future);
    }

    public void loadAllPerson(FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadAllPerson(), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> loadDeviceByWhere(String where, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.loadDeviceByWhere(where, startRow, numRows), (Function)new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void loadDeviceByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.loadDeviceByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupByWhere(String where, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadDeviceGroupByWhere(where, startRow, numRows);
        return this.factory.wrap((Object)async, future);
    }

    public void loadDeviceGroupByWhere(String where, int startRow, int numRows, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadDeviceGroupIdByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void loadDeviceGroupIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadDeviceIdByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void loadDeviceIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceIdByWhere(where), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<String>> future = async.loadFeatureMd5ByUpdate(timestamp);
        return this.factory.wrap((Object)async, future);
    }

    public void loadFeatureMd5ByUpdate(long timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> loadLogByWhere(String where, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.loadLogByWhere(where, startRow, numRows), (Function)new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void loadLogByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.loadLogByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(long timestamp, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.loadLogLightByVerifyTime(timestamp, startRow, numRows), (Function)new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void loadLogLightByVerifyTime(long timestamp, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByWhere(String where, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.loadLogLightByWhere(where, startRow, numRows), (Function)new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void loadLogLightByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(long timestamp) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.loadPermitByUpdate(timestamp), (Function)new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void loadPermitByUpdate(long timestamp, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.loadPermitByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.loadPersonByWhere(where, startRow, numRows), (Function)new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void loadPersonByWhere(String where, int startRow, int numRows, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.loadPersonByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupByWhere(String where, int startRow, int numRows) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonGroupByWhere(where, startRow, numRows);
        return this.factory.wrap((Object)async, future);
    }

    public void loadPersonGroupByWhere(String where, int startRow, int numRows, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonGroupIdByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void loadPersonGroupIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonIdByUpdateTime(timestamp);
        return this.factory.wrap((Object)async, future);
    }

    public void loadPersonIdByUpdateTime(long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadPersonIdByWhere(where);
        return this.factory.wrap((Object)async, future);
    }

    public void loadPersonIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<List<Integer>> future = async.loadUpdatedPersons(timestamp);
        return this.factory.wrap((Object)async, future);
    }

    public void loadUpdatedPersons(long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp), callback);
    }

    public ListenableFuture<Void> offline(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.offline((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void offline(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.offline(token), callback);
    }

    public ListenableFuture<Token> online(net.gdface.facelog.db.DeviceBean device) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.online((DeviceBean)TypeTransformer.getInstance().to((Object)device, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class)), (Function)new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void online(net.gdface.facelog.db.DeviceBean device, FutureCallback<Token> callback) {
        this.factory.addCallback(this.online(device), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> registerDevice(net.gdface.facelog.db.DeviceBean newDevice) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.registerDevice((DeviceBean)TypeTransformer.getInstance().to((Object)newDevice, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class)), (Function)new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void registerDevice(net.gdface.facelog.db.DeviceBean newDevice, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.registerDevice(newDevice), callback);
    }

    public ListenableFuture<Void> releasePersonToken(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.releasePersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void releasePersonToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releasePersonToken(token), callback);
    }

    public ListenableFuture<Void> releaseRootToken(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.releaseRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void releaseRootToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releaseRootToken(token), callback);
    }

    public ListenableFuture<Void> replaceFeature(Integer personId, String featureMd5, boolean deleteOldFeatureImage, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.replaceFeature(personId, featureMd5, deleteOldFeatureImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void replaceFeature(Integer personId, String featureMd5, boolean deleteOldFeatureImage, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.replaceFeature(personId, featureMd5, deleteOldFeatureImage, token), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> saveDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.saveDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void saveDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.saveDevice(deviceBean, token), callback);
    }

    public ListenableFuture<DeviceGroupBean> saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.saveDeviceGroup((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroupBean, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

            public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token, FutureCallback<DeviceGroupBean> callback) {
        this.factory.addCallback(this.saveDeviceGroup(deviceGroupBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, byte[] idPhoto, byte[] feature, byte[] featureImage, FaceBean featureFaceBean, Integer deviceId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonFull((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhoto, feature, featureImage, (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)featureFaceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), deviceId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, byte[] idPhoto, byte[] feature, byte[] featureImage, FaceBean featureFaceBean, Integer deviceId, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, idPhoto, feature, featureImage, featureFaceBean, deviceId, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, byte[] idPhoto, byte[] feature, List<FaceBean> faceBeans, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonWithPhotoAndFeatureMultiFaces((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhoto, feature, TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, byte[] idPhoto, byte[] feature, List<FaceBean> faceBeans, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, idPhoto, feature, faceBeans, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, byte[] idPhoto, byte[] feature, Map<ByteBuffer, FaceBean> faceInfo, Integer deviceId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonWithPhotoAndFeatureMultiImage((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhoto, feature, TypeTransformer.getInstance().to(faceInfo, ByteBuffer.class, FaceBean.class, byte[].class, net.gdface.facelog.client.thrift.FaceBean.class), deviceId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, byte[] idPhoto, byte[] feature, Map<ByteBuffer, FaceBean> faceInfo, Integer deviceId, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, idPhoto, feature, faceInfo, deviceId, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, byte[] idPhoto, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonWithPhoto((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhoto, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, byte[] idPhoto, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, idPhoto, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, byte[] idPhoto, FeatureBean featureBean, Integer deviceId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonWithPhotoAndFeature((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhoto, (net.gdface.facelog.client.thrift.FeatureBean)TypeTransformer.getInstance().to((Object)featureBean, FeatureBean.class, net.gdface.facelog.client.thrift.FeatureBean.class), deviceId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, byte[] idPhoto, FeatureBean featureBean, Integer deviceId, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, idPhoto, featureBean, deviceId, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, String idPhotoMd5, String featureMd5, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonWithPhotoAndFeatureSaved((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhotoMd5, featureMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, String idPhotoMd5, String featureMd5, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, idPhotoMd5, featureMd5, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean bean, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePerson((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)bean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePerson(PersonBean bean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(bean, token), callback);
    }

    public ListenableFuture<PersonGroupBean> savePersonGroup(PersonGroupBean personGroupBean, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.savePersonGroup((net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroupBean, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

            public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void savePersonGroup(PersonGroupBean personGroupBean, Token token, FutureCallback<PersonGroupBean> callback) {
        this.factory.addCallback(this.savePersonGroup(personGroupBean, token), callback);
    }

    public ListenableFuture<Void> savePersons(List<PersonBean> beans, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.savePersons(TypeTransformer.getInstance().to(beans, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void savePersons(List<PersonBean> beans, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.savePersons(beans, token), callback);
    }

    public ListenableFuture<Integer> savePersons(Map<ByteBuffer, PersonBean> persons, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Integer> future = async.savePersonsWithPhoto(TypeTransformer.getInstance().to(persons, ByteBuffer.class, PersonBean.class, byte[].class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void savePersons(Map<ByteBuffer, PersonBean> persons, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.savePersons(persons, token), callback);
    }

    public ListenableFuture<Void> saveServiceConfig(Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.saveServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void saveServiceConfig(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.saveServiceConfig(token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(int personId, long expiryDate, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.setPersonExpiryDate(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void setPersonExpiryDate(int personId, long expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personId, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(List<Integer> personIdList, long expiryDate, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.setPersonExpiryDateList(TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void setPersonExpiryDate(List<Integer> personIdList, long expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personIdList, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setProperties(Map<String, String> config, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.setProperties(TypeTransformer.getInstance().to(config, String.class, String.class, String.class, String.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void setProperties(Map<String, String> config, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setProperties(config, token), callback);
    }

    public ListenableFuture<Void> setProperty(String key, String value, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.setProperty(key, value, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void setProperty(String key, String value, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setProperty(key, value, token), callback);
    }

    public ListenableFuture<Void> unregisterDevice(int deviceId, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Void> future = async.unregisterDevice(deviceId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class));
        return this.factory.wrap((Object)async, future);
    }

    public void unregisterDevice(int deviceId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.unregisterDevice(deviceId, token), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> updateDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token) {
        IFaceLog.Async async = this.delegate();
        ListenableFuture future = Futures.transform(async.updateDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class)), (Function)new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        return this.factory.wrap((Object)async, future);
    }

    public void updateDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.updateDevice(deviceBean, token), callback);
    }

    public ListenableFuture<String> version() {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<String> future = async.version();
        return this.factory.wrap((Object)async, future);
    }

    public void version(FutureCallback<String> callback) {
        this.factory.addCallback(this.version(), callback);
    }

    public ListenableFuture<Map<String, String>> versionInfo() {
        IFaceLog.Async async = this.delegate();
        ListenableFuture<Map<String, String>> future = async.versionInfo();
        return this.factory.wrap((Object)async, future);
    }

    public void versionInfo(FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.versionInfo(), callback);
    }

    public static class DefaultCallback<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(Throwable t) {
            try {
                throw t;
            }
            catch (DuplicateRecordException e) {
                this.onDuplicateRecordException(e);
            }
            catch (ServiceSecurityException e) {
                this.onServiceSecurityException(e);
            }
            catch (ServiceRuntimeException e) {
                this.onServiceRuntimeException(e);
            }
            catch (Throwable e) {
                this.onThrowable(e);
            }
        }

        protected void onDuplicateRecordException(DuplicateRecordException e) {
            System.out.println(e.getServiceStackTraceMessage());
        }

        protected void onServiceSecurityException(ServiceSecurityException e) {
            System.out.println(e.getServiceStackTraceMessage());
        }

        protected void onServiceRuntimeException(ServiceRuntimeException e) {
            System.out.println(e.getServiceStackTraceMessage());
        }

        protected void onThrowable(Throwable e) {
            e.printStackTrace();
        }
    }
}

