// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: comparator.java.vm
// ______________________________________________________
package net.gdface.facelog.db;

import java.util.Comparator;


/**
 * Comparator class is used to sort the FeatureBean objects.
 * @author sql2java
 */
public class FeatureComparator implements Comparator<FeatureBean>,Constant
{
    /**
     * Holds the field on which the comparison is performed.
     */
    private int iType;
    /**
     * Value that will contain the information about the order of the sort: normal or reversal.
     */
    private boolean bReverse;

    /**
     * Constructor class for FeatureComparator.
     * <br>
     * Example:
     * <br>
     * <code>Arrays.sort(pArray, new FeatureComparator(Constant.FL_FEATURE_ID_MD5, bReverse));</code>
     *
     * @param iType the field from which you want to sort
     * <br>
     * Possible values are:
     * <ul>
     *   <li>{@link Constant#FL_FEATURE_ID_MD5}
     *   <li>{@link Constant#FL_FEATURE_ID_VERSION}
     *   <li>{@link Constant#FL_FEATURE_ID_PERSON_ID}
     *   <li>{@link Constant#FL_FEATURE_ID_FEATURE}
     *   <li>{@link Constant#FL_FEATURE_ID_UPDATE_TIME}
     * </ul>
     */
    public FeatureComparator(int iType)
    {
        this(iType, false);
    }

    /**
     * Constructor class for FeatureComparator.
     * <br>
     * Example:
     * <br>
     * <code>Arrays.sort(pArray, new FeatureComparator(Constant.FL_FEATURE_ID_MD5, bReverse));</code>
     *
     * @param iType the field from which you want to sort.
     * <br>
     * Possible values are:
     * <ul>
     *   <li>{@link Constant#FL_FEATURE_ID_MD5})
     *   <li>{@link Constant#FL_FEATURE_ID_VERSION})
     *   <li>{@link Constant#FL_FEATURE_ID_PERSON_ID})
     *   <li>{@link Constant#FL_FEATURE_ID_FEATURE})
     *   <li>{@link Constant#FL_FEATURE_ID_UPDATE_TIME})
     * </ul>
     *
     * @param bReverse set this value to true, if you want to reverse the sorting results
     */
    public FeatureComparator(int iType, boolean bReverse)
    {
        this.iType = iType;
        this.bReverse = bReverse;
    }

    @Override
    public int compare(FeatureBean b1, FeatureBean b2)
    {
        int iReturn = 0;
        switch(iType)
        {
            case FL_FEATURE_ID_MD5:
                if (b1.getMd5() == null && b2.getMd5() != null) {
                    iReturn = -1;
                } else if (b1.getMd5() == null && b2.getMd5() == null) {
                    iReturn = 0;
                } else if (b1.getMd5() != null && b2.getMd5() == null) {
                    iReturn = 1;
                } else {
                    iReturn = b1.getMd5().compareTo(b2.getMd5());
                }
                break;
            case FL_FEATURE_ID_VERSION:
                if (b1.getVersion() == null && b2.getVersion() != null) {
                    iReturn = -1;
                } else if (b1.getVersion() == null && b2.getVersion() == null) {
                    iReturn = 0;
                } else if (b1.getVersion() != null && b2.getVersion() == null) {
                    iReturn = 1;
                } else {
                    iReturn = b1.getVersion().compareTo(b2.getVersion());
                }
                break;
            case FL_FEATURE_ID_PERSON_ID:
                if (b1.getPersonId() == null && b2.getPersonId() != null) {
                    iReturn = -1;
                } else if (b1.getPersonId() == null && b2.getPersonId() == null) {
                    iReturn = 0;
                } else if (b1.getPersonId() != null && b2.getPersonId() == null) {
                    iReturn = 1;
                } else {
                    iReturn = b1.getPersonId().compareTo(b2.getPersonId());
                }
                break;
            case FL_FEATURE_ID_FEATURE:
                if (b1.getFeature() == null && b2.getFeature() != null) {
                    iReturn = -1;
                } else if (b1.getFeature() == null && b2.getFeature() == null) {
                    iReturn = 0;
                } else if (b1.getFeature() != null && b2.getFeature() == null) {
                    iReturn = 1;
                } else {
                    iReturn = b1.getFeature().compareTo(b2.getFeature());
                }
                break;
            case FL_FEATURE_ID_UPDATE_TIME:
                if (b1.getUpdateTime() == null && b2.getUpdateTime() != null) {
                    iReturn = -1;
                } else if (b1.getUpdateTime() == null && b2.getUpdateTime() == null) {
                    iReturn = 0;
                } else if (b1.getUpdateTime() != null && b2.getUpdateTime() == null) {
                    iReturn = 1;
                } else {
                    iReturn = b1.getUpdateTime().compareTo(b2.getUpdateTime());
                }
                break;
            default:
                throw new IllegalArgumentException("Type passed for the field is not supported");
        }

        return bReverse ? (-1 * iReturn) : iReturn;
    }}
