// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: bean.java.vm
// ______________________________________________________
package net.gdface.facelog.db;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftField.Requiredness;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
/**
 * PersonGroupBean is a mapping of fl_person_group Table.
 * <br>Meta Data Information (in progress):
 * <ul>
 *    <li>comments: 用户组信息 </li>
 * </ul>
 * @author guyadong
*/
@ThriftStruct
@ApiModel(description="用户组信息")
public final class PersonGroupBean
    implements Serializable,BaseBean<PersonGroupBean>,Comparable<PersonGroupBean>,Constant,Cloneable
{
    private static final long serialVersionUID = 4644637718755569065L;
    /** NULL {@link PersonGroupBean} bean , IMMUTABLE instance */
    public static final PersonGroupBean NULL = new PersonGroupBean().asNULL().asImmutable();
    /** comments:用户组id */
    @ApiModelProperty(value = "用户组id" ,required=true ,dataType="Integer")
    private Integer id;

    /** comments:用户组名 */
    @ApiModelProperty(value = "用户组名" ,required=true ,dataType="String")
    private String name;

    /** comments:是否为叶子节点, 1:叶子节点 0:分支节点,null:两者都可 */
    @ApiModelProperty(value = "是否为叶子节点, 1:叶子节点 0:分支节点,null:两者都可"  ,dataType="Integer")
    private Integer leaf;

    /** comments:上一级用户组id */
    @ApiModelProperty(value = "上一级用户组id"  ,dataType="Integer")
    private Integer parent;

    /** comments:指向设备组id,用于应用层定义管理员/操作员的管理边界,此字段不为null代表此用户组为管理边界,指向的设备组为此用户组的设备管理边界,
  对于属于此组的管理员和操作员都只能管理此组内的用户及对应设备组内的设备 */
    @ApiModelProperty(value = "指向设备组id,用于应用层定义管理员/操作员的管理边界,此字段不为null代表此用户组为管理边界,指向的设备组为此用户组的设备管理边界,\n"
+"  对于属于此组的管理员和操作员都只能管理此组内的用户及对应设备组内的设备"  ,dataType="Integer")
    private Integer rootGroup;

    /** comments:备注 */
    @ApiModelProperty(value = "备注"  ,dataType="String")
    private String remark;

    /** comments:应用项目自定义二进制扩展字段(最大64KB) */
    @ApiModelProperty(value = "应用项目自定义二进制扩展字段(最大64KB)"  ,dataType="ByteBuffer")
    private java.nio.ByteBuffer extBin;

    /** comments:应用项目自定义文本扩展字段(最大64KB) */
    @ApiModelProperty(value = "应用项目自定义文本扩展字段(最大64KB)"  ,dataType="String")
    private String extTxt;

    @ApiModelProperty(value = "create_time"  ,dataType="Date")
    private java.util.Date createTime;

    @ApiModelProperty(value = "update_time"  ,dataType="Date")
    private java.util.Date updateTime;

    /** flag whether {@code this} can be modified */
    private Boolean immutable;
    /** columns modified flag */
    @ApiModelProperty(value="columns modified flag",dataType="int",required=true)
    private int modified;
    /** columns initialized flag */
    @ApiModelProperty(value="columns initialized flag",dataType="int",required=true)
    private int initialized;
    /** new record flag  */
    @ApiModelProperty(value="new record flag",dataType="boolean",required=true)
    private boolean isNew;        
    /** 
     * set immutable status
     * @return {@code this} 
     */
    private PersonGroupBean immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }
    /** 
     * set {@code this} as immutable object
     * @return {@code this} 
     */
    public PersonGroupBean asImmutable() {
        return immutable(Boolean.TRUE);
    }
    /**
     * @return {@code true} if {@code this} is a mutable object  
     */
    public boolean mutable(){
        return !Boolean.TRUE.equals(this.immutable);
    }
    /**
     * @return {@code this}
     * @throws IllegalStateException if {@code this} is a immutable object 
     */
    private PersonGroupBean checkMutable(){
        if(!mutable()){
            throw new IllegalStateException("this is a immutable object");
        }
        return this;
    }
    /**
     * @return return a new mutable copy of this object.
     */
    public PersonGroupBean cloneMutable(){
        return clone().immutable(null);
    }
    @ThriftField(value=1,name="_new",requiredness=Requiredness.REQUIRED)
    @Override
    public boolean isNew()
    {
        return this.isNew;
    }


    @Override
    public void isNew(boolean isNew)
    {
        this.isNew = isNew;
    }
    /**
     * Specifies to the object if it has been set as new.
     *
     * @param isNew the boolean value to be assigned to the isNew field
     */
    @ThriftField()
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }
    /**
     * @return the modified status of columns
     */
    @ThriftField(value=2,requiredness=Requiredness.REQUIRED)
    public int getModified(){
        return modified;
    }

    /**
     * @param modified the modified status bit to be assigned to {@link #modified}
     */
    @ThriftField()
    public void setModified(int modified){
        this.modified = modified;
    }
    /**
     * @return the initialized status of columns
     */
    @ThriftField(value=3,requiredness=Requiredness.REQUIRED)
    public int getInitialized(){
        return initialized;
    }

    /**
     * @param initialized the initialized status bit to be assigned to {@link #initialized}
     */
    @ThriftField()
    public void setInitialized(int initialized){
        this.initialized = initialized;
    }
    protected static final <T extends Comparable<T>>boolean equals(T a, T b) {
        return a == b || (a != null && 0==a.compareTo(b));
    }
    public PersonGroupBean(){
        super();
        reset();
    }
    /**
     * construct a new instance filled with primary keys
     * @param id PK# 1 
     */
    public PersonGroupBean(Integer id){
        this();
        setId(id);
    }
    /**
     * Getter method for {@link #id}.<br>
     * PRIMARY KEY.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.id</li>
     * <li> imported key: fl_permit.person_group_id</li>
     * <li> imported key: fl_person.group_id</li>
     * <li> imported key: fl_person_group.parent</li>
     * <li>comments: 用户组id</li>
     * <li>AUTO_INCREMENT</li>
     * <li>NOT NULL</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of id
     */
    @ThriftField(value=4)
    public Integer getId(){
        return id;
    }
    /**
     * Setter method for {@link #id}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to id
     */
    public void setId(Integer newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_ID_MASK;
        initialized |= FL_PERSON_GROUP_ID_ID_MASK;

        if (Objects.equals(newVal, id)) {
            return;
        }
        id = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "id")
    public void writeId(Integer newVal){
        checkMutable();
        id = newVal;
    }
    /**
     * Setter method for {@link #id}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to id
     */
    public void setId(int newVal)
    {
        setId(new Integer(newVal));
    }
    /**
     * Determines if the id has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkIdModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_ID_MASK);
    }

    /**
     * Determines if the id has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkIdInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_ID_MASK);
    }
    /**
     * Getter method for {@link #name}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.name</li>
     * <li>comments: 用户组名</li>
     * <li>NOT NULL</li>
     * <li>column size: 32</li>
     * <li>JDBC type returned by the driver: Types.VARCHAR</li>
     * </ul>
     *
     * @return the value of name
     */
    @ThriftField(value=5)
    public String getName(){
        return name;
    }
    /**
     * Setter method for {@link #name}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to name
     */
    public void setName(String newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_NAME_MASK;
        initialized |= FL_PERSON_GROUP_ID_NAME_MASK;

        if (Objects.equals(newVal, name)) {
            return;
        }
        name = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "name")
    public void writeName(String newVal){
        checkMutable();
        name = newVal;
    }
    /**
     * Determines if the name has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkNameModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_NAME_MASK);
    }

    /**
     * Determines if the name has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkNameInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_NAME_MASK);
    }
    /**
     * Getter method for {@link #leaf}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.leaf</li>
     * <li>comments: 是否为叶子节点, 1:叶子节点 0:分支节点,null:两者都可</li>
     * <li>column size: 3</li>
     * <li>JDBC type returned by the driver: Types.TINYINT</li>
     * </ul>
     *
     * @return the value of leaf
     */
    @ThriftField(value=6)
    public Integer getLeaf(){
        return leaf;
    }
    /**
     * Setter method for {@link #leaf}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to leaf
     */
    public void setLeaf(Integer newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_LEAF_MASK;
        initialized |= FL_PERSON_GROUP_ID_LEAF_MASK;

        if (Objects.equals(newVal, leaf)) {
            return;
        }
        leaf = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "leaf")
    public void writeLeaf(Integer newVal){
        checkMutable();
        leaf = newVal;
    }
    /**
     * Setter method for {@link #leaf}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to leaf
     */
    public void setLeaf(int newVal)
    {
        setLeaf(new Integer(newVal));
    }
    /**
     * Determines if the leaf has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkLeafModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_LEAF_MASK);
    }

    /**
     * Determines if the leaf has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkLeafInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_LEAF_MASK);
    }
    /**
     * Getter method for {@link #parent}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.parent</li>
     * <li> foreign key: fl_person_group.id</li>
     * <li>comments: 上一级用户组id</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of parent
     */
    @ThriftField(value=7)
    public Integer getParent(){
        return parent;
    }
    /**
     * Setter method for {@link #parent}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to parent
     */
    public void setParent(Integer newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_PARENT_MASK;
        initialized |= FL_PERSON_GROUP_ID_PARENT_MASK;

        if (Objects.equals(newVal, parent)) {
            return;
        }
        parent = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "parent")
    public void writeParent(Integer newVal){
        checkMutable();
        parent = newVal;
    }
    /**
     * Setter method for {@link #parent}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to parent
     */
    public void setParent(int newVal)
    {
        setParent(new Integer(newVal));
    }
    /**
     * Determines if the parent has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkParentModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_PARENT_MASK);
    }

    /**
     * Determines if the parent has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkParentInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_PARENT_MASK);
    }
    /**
     * Getter method for {@link #rootGroup}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.root_group</li>
     * <li>comments: 指向设备组id,用于应用层定义管理员/操作员的管理边界,此字段不为null代表此用户组为管理边界,指向的设备组为此用户组的设备管理边界,
  对于属于此组的管理员和操作员都只能管理此组内的用户及对应设备组内的设备</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of rootGroup
     */
    @ThriftField(value=8)
    public Integer getRootGroup(){
        return rootGroup;
    }
    /**
     * Setter method for {@link #rootGroup}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to rootGroup
     */
    public void setRootGroup(Integer newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_ROOT_GROUP_MASK;
        initialized |= FL_PERSON_GROUP_ID_ROOT_GROUP_MASK;

        if (Objects.equals(newVal, rootGroup)) {
            return;
        }
        rootGroup = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "rootGroup")
    public void writeRootGroup(Integer newVal){
        checkMutable();
        rootGroup = newVal;
    }
    /**
     * Setter method for {@link #rootGroup}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to rootGroup
     */
    public void setRootGroup(int newVal)
    {
        setRootGroup(new Integer(newVal));
    }
    /**
     * Determines if the rootGroup has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkRootGroupModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_ROOT_GROUP_MASK);
    }

    /**
     * Determines if the rootGroup has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkRootGroupInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_ROOT_GROUP_MASK);
    }
    /**
     * Getter method for {@link #remark}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.remark</li>
     * <li>comments: 备注</li>
     * <li>column size: 256</li>
     * <li>JDBC type returned by the driver: Types.VARCHAR</li>
     * </ul>
     *
     * @return the value of remark
     */
    @ThriftField(value=9)
    public String getRemark(){
        return remark;
    }
    /**
     * Setter method for {@link #remark}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to remark
     */
    public void setRemark(String newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_REMARK_MASK;
        initialized |= FL_PERSON_GROUP_ID_REMARK_MASK;

        if (Objects.equals(newVal, remark)) {
            return;
        }
        remark = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "remark")
    public void writeRemark(String newVal){
        checkMutable();
        remark = newVal;
    }
    /**
     * Determines if the remark has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkRemarkModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_REMARK_MASK);
    }

    /**
     * Determines if the remark has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkRemarkInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_REMARK_MASK);
    }
    /**
     * Getter method for {@link #extBin}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.ext_bin</li>
     * <li>comments: 应用项目自定义二进制扩展字段(最大64KB)</li>
     * <li>column size: 65535</li>
     * <li>JDBC type returned by the driver: Types.LONGVARBINARY</li>
     * </ul>
     *
     * @return the value of extBin
     */
    @ThriftField(value=10)
    public java.nio.ByteBuffer getExtBin(){
        return extBin;
    }
    /**
     * Setter method for {@link #extBin}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to extBin
     */
    public void setExtBin(java.nio.ByteBuffer newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_EXT_BIN_MASK;
        initialized |= FL_PERSON_GROUP_ID_EXT_BIN_MASK;

        if (Objects.equals(newVal, extBin)) {
            return;
        }
        extBin = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "extBin")
    public void writeExtBin(java.nio.ByteBuffer newVal){
        checkMutable();
        extBin = newVal;
    }
    /**
     * Determines if the extBin has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkExtBinModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_EXT_BIN_MASK);
    }

    /**
     * Determines if the extBin has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkExtBinInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_EXT_BIN_MASK);
    }
    /**
     * Getter method for {@link #extTxt}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.ext_txt</li>
     * <li>comments: 应用项目自定义文本扩展字段(最大64KB)</li>
     * <li>column size: 65535</li>
     * <li>JDBC type returned by the driver: Types.LONGVARCHAR</li>
     * </ul>
     *
     * @return the value of extTxt
     */
    @ThriftField(value=11)
    public String getExtTxt(){
        return extTxt;
    }
    /**
     * Setter method for {@link #extTxt}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to extTxt
     */
    public void setExtTxt(String newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_EXT_TXT_MASK;
        initialized |= FL_PERSON_GROUP_ID_EXT_TXT_MASK;

        if (Objects.equals(newVal, extTxt)) {
            return;
        }
        extTxt = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "extTxt")
    public void writeExtTxt(String newVal){
        checkMutable();
        extTxt = newVal;
    }
    /**
     * Determines if the extTxt has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkExtTxtModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_EXT_TXT_MASK);
    }

    /**
     * Determines if the extTxt has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkExtTxtInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_EXT_TXT_MASK);
    }
    /**
     * Getter method for {@link #createTime}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.create_time</li>
     * <li>default value: 'CURRENT_TIMESTAMP'</li>
     * <li>NOT NULL</li>
     * <li>column size: 19</li>
     * <li>JDBC type returned by the driver: Types.TIMESTAMP</li>
     * </ul>
     *
     * @return the value of createTime
     */
    public java.util.Date getCreateTime(){
        return createTime;
    }
    /** 
     * use Long to represent date type for thrift:swift support 
     * @see #getCreateTime()
     */
    @ThriftField(name = "createTime",value = 12)
    public Long readCreateTime(){
        return null == createTime ? null:createTime.getTime();
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to createTime
     */
    public void setCreateTime(java.util.Date newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_CREATE_TIME_MASK;
        initialized |= FL_PERSON_GROUP_ID_CREATE_TIME_MASK;

        if (Objects.equals(newVal, createTime)) {
            return;
        }
        createTime = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "createTime")
    public void writeCreateTime(Long newVal){
        checkMutable();
        createTime = null == newVal?null:new java.util.Date(newVal);
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to createTime
     */
    public void setCreateTime(long newVal)
    {
        setCreateTime(new java.util.Date(newVal));
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * @param newVal the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this Date object.
     */
    public void setCreateTime(Long newVal)
    {
        setCreateTime(null == newVal ? null : new java.util.Date(newVal));
    }
    /**
     * Determines if the createTime has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkCreateTimeModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_CREATE_TIME_MASK);
    }

    /**
     * Determines if the createTime has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkCreateTimeInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_CREATE_TIME_MASK);
    }
    /**
     * Getter method for {@link #updateTime}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_person_group.update_time</li>
     * <li>default value: 'CURRENT_TIMESTAMP'</li>
     * <li>NOT NULL</li>
     * <li>column size: 19</li>
     * <li>JDBC type returned by the driver: Types.TIMESTAMP</li>
     * </ul>
     *
     * @return the value of updateTime
     */
    public java.util.Date getUpdateTime(){
        return updateTime;
    }
    /** 
     * use Long to represent date type for thrift:swift support 
     * @see #getUpdateTime()
     */
    @ThriftField(name = "updateTime",value = 13)
    public Long readUpdateTime(){
        return null == updateTime ? null:updateTime.getTime();
    }
    /**
     * Setter method for {@link #updateTime}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to updateTime
     */
    public void setUpdateTime(java.util.Date newVal)
    {
        checkMutable();

        modified |= FL_PERSON_GROUP_ID_UPDATE_TIME_MASK;
        initialized |= FL_PERSON_GROUP_ID_UPDATE_TIME_MASK;

        if (Objects.equals(newVal, updateTime)) {
            return;
        }
        updateTime = newVal;
    }
    /** 
     * setter for thrift:swift support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name = "updateTime")
    public void writeUpdateTime(Long newVal){
        checkMutable();
        updateTime = null == newVal?null:new java.util.Date(newVal);
    }
    /**
     * Setter method for {@link #updateTime}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to updateTime
     */
    public void setUpdateTime(long newVal)
    {
        setUpdateTime(new java.util.Date(newVal));
    }
    /**
     * Setter method for {@link #updateTime}.<br>
     * @param newVal the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this Date object.
     */
    public void setUpdateTime(Long newVal)
    {
        setUpdateTime(null == newVal ? null : new java.util.Date(newVal));
    }
    /**
     * Determines if the updateTime has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkUpdateTimeModified()
    {
        return 0L !=  (modified & FL_PERSON_GROUP_ID_UPDATE_TIME_MASK);
    }

    /**
     * Determines if the updateTime has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkUpdateTimeInitialized()
    {
        return 0L !=  (initialized & FL_PERSON_GROUP_ID_UPDATE_TIME_MASK);
    }
    //////////////////////////////////////
    // referenced bean for FOREIGN KEYS
    //////////////////////////////////////
    /** 
     * The referenced {@link PersonGroupBean} by {@link #parent} . <br>
     * FOREIGN KEY (parent) REFERENCES fl_person_group(id)
     */
    @ApiModelProperty(hidden = true)
    private PersonGroupBean referencedByParent;
    /**
     * Getter method for {@link #referencedByParent}.
     * @return PersonGroupBean
     */
    public PersonGroupBean getReferencedByParent() {
        return this.referencedByParent;
    }
    /**
     * Setter method for {@link #referencedByParent}.
     * @param reference PersonGroupBean
     */
    public void setReferencedByParent(PersonGroupBean reference) {
        this.referencedByParent = reference;
    }

    @Override
    public boolean isModified()
    {
        return 0 != modified;
    }
  
    @Override
    public boolean isModified(int columnID){
        switch ( columnID ){
        case FL_PERSON_GROUP_ID_ID:
            return checkIdModified();
        case FL_PERSON_GROUP_ID_NAME:
            return checkNameModified();
        case FL_PERSON_GROUP_ID_LEAF:
            return checkLeafModified();
        case FL_PERSON_GROUP_ID_PARENT:
            return checkParentModified();
        case FL_PERSON_GROUP_ID_ROOT_GROUP:
            return checkRootGroupModified();
        case FL_PERSON_GROUP_ID_REMARK:
            return checkRemarkModified();
        case FL_PERSON_GROUP_ID_EXT_BIN:
            return checkExtBinModified();
        case FL_PERSON_GROUP_ID_EXT_TXT:
            return checkExtTxtModified();
        case FL_PERSON_GROUP_ID_CREATE_TIME:
            return checkCreateTimeModified();
        case FL_PERSON_GROUP_ID_UPDATE_TIME:
            return checkUpdateTimeModified();
        default:
            return false;
        }        
    }

    @Override
    public boolean isInitialized(int columnID){
        switch(columnID) {
        case FL_PERSON_GROUP_ID_ID:
            return checkIdInitialized();
        case FL_PERSON_GROUP_ID_NAME:
            return checkNameInitialized();
        case FL_PERSON_GROUP_ID_LEAF:
            return checkLeafInitialized();
        case FL_PERSON_GROUP_ID_PARENT:
            return checkParentInitialized();
        case FL_PERSON_GROUP_ID_ROOT_GROUP:
            return checkRootGroupInitialized();
        case FL_PERSON_GROUP_ID_REMARK:
            return checkRemarkInitialized();
        case FL_PERSON_GROUP_ID_EXT_BIN:
            return checkExtBinInitialized();
        case FL_PERSON_GROUP_ID_EXT_TXT:
            return checkExtTxtInitialized();
        case FL_PERSON_GROUP_ID_CREATE_TIME:
            return checkCreateTimeInitialized();
        case FL_PERSON_GROUP_ID_UPDATE_TIME:
            return checkUpdateTimeInitialized();
        default:
            return false;
        }
    }
    
    @Override
    public boolean isModified(String column){        
        return isModified(columnIDOf(column));
    }

    @Override
    public boolean isInitialized(String column){
        return isInitialized(columnIDOf(column));
    }
    
    @Override
    public void resetIsModified()
    {
        checkMutable();
        modified = 0;
    }

    @Override
    public void resetPrimaryKeysModified()
    {
        modified &= (~(FL_PERSON_GROUP_ID_ID_MASK));
    }
    /**
     * Resets columns modification status except primary keys to 'not modified'.
     */
    public void resetModifiedExceptPrimaryKeys()
    {
        modified &= (~(FL_PERSON_GROUP_ID_NAME_MASK |
            FL_PERSON_GROUP_ID_LEAF_MASK |
            FL_PERSON_GROUP_ID_PARENT_MASK |
            FL_PERSON_GROUP_ID_ROOT_GROUP_MASK |
            FL_PERSON_GROUP_ID_REMARK_MASK |
            FL_PERSON_GROUP_ID_EXT_BIN_MASK |
            FL_PERSON_GROUP_ID_EXT_TXT_MASK |
            FL_PERSON_GROUP_ID_CREATE_TIME_MASK |
            FL_PERSON_GROUP_ID_UPDATE_TIME_MASK));
    }
    /**
     * Resets the object initialization status to 'not initialized'.
     */
    private void resetInitialized()
    {
        initialized = 0;
    }
    /** reset all fields to initial value, equal to a new bean */
    public void reset(){
        checkMutable();
        this.id = null;
        this.name = null;
        this.leaf = null;
        this.parent = null;
        this.rootGroup = null;
        this.remark = null;
        this.extBin = null;
        this.extTxt = null;
        /* DEFAULT:'CURRENT_TIMESTAMP'*/
        this.createTime = null;
        /* DEFAULT:'CURRENT_TIMESTAMP'*/
        this.updateTime = null;
        this.isNew = true;
        this.modified = 0;
        this.initialized = 0;
    }
    @Override
    public boolean equals(Object object)
    {
        if (!(object instanceof PersonGroupBean)) {
            return false;
        }

        PersonGroupBean obj = (PersonGroupBean) object;
        return new EqualsBuilder()
            .append(getId(), obj.getId())
            .append(getName(), obj.getName())
            .append(getLeaf(), obj.getLeaf())
            .append(getParent(), obj.getParent())
            .append(getRootGroup(), obj.getRootGroup())
            .append(getRemark(), obj.getRemark())
            .append(getExtBin(), obj.getExtBin())
            .append(getExtTxt(), obj.getExtTxt())
            .append(getCreateTime(), obj.getCreateTime())
            .append(getUpdateTime(), obj.getUpdateTime())
            .isEquals();
    }

    @Override
    public int hashCode()
    {
        return new HashCodeBuilder(-82280557, -700257973)
            .append(getId())
            .toHashCode();
    }

    @Override
    public String toString() {
        return toString(true,false);
    }
    /**
     * cast byte array to HEX string
     * 
     * @param input
     * @return {@code null} if {@code input} is null
     */
    private static final String toHex(byte[] input) {
        if (null == input){
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; i++) {
            sb.append(Character.forDigit((input[i] & 240) >> 4, 16));
            sb.append(Character.forDigit(input[i] & 15, 16));
        }
        return sb.toString();
    }
    protected static final StringBuilder append(StringBuilder buffer,boolean full,byte[] value){
        if(full || null == value){
            buffer.append(toHex(value));
        }else{
            buffer.append(value.length).append(" bytes");
        }
        return buffer;
    }
    private static int stringLimit = 64;
    private static final int MINIMUM_LIMIT = 16;
    protected static final StringBuilder append(StringBuilder buffer,boolean full,String value){
        if(full || null == value || value.length() <= stringLimit){
            buffer.append(value);
        }else{
            buffer.append(value.substring(0,stringLimit - 8)).append(" ...").append(value.substring(stringLimit-4,stringLimit));
        }
        return buffer;
    }
    protected static final <T>StringBuilder append(StringBuilder buffer,boolean full,T value){
        return buffer.append(value);
    }
    public static final void setStringLimit(int limit){
        if(limit < MINIMUM_LIMIT){
            throw new IllegalArgumentException(String.format("INVALID limit %d,minimum value %d",limit,MINIMUM_LIMIT));
        }
        stringLimit = limit;
    }
    @Override
    public String toString(boolean notNull, boolean fullIfStringOrBytes) {
        // only output initialized field
        StringBuilder builder = new StringBuilder(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append("[");
        int count = 0;        
        if(checkIdInitialized()){
            if(!notNull || null != getId()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("id=");
                append(builder,fullIfStringOrBytes,getId());
            }
        }
        if(checkNameInitialized()){
            if(!notNull || null != getName()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("name=");
                append(builder,fullIfStringOrBytes,getName());
            }
        }
        if(checkLeafInitialized()){
            if(!notNull || null != getLeaf()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("leaf=");
                append(builder,fullIfStringOrBytes,getLeaf());
            }
        }
        if(checkParentInitialized()){
            if(!notNull || null != getParent()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("parent=");
                append(builder,fullIfStringOrBytes,getParent());
            }
        }
        if(checkRootGroupInitialized()){
            if(!notNull || null != getRootGroup()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("root_group=");
                append(builder,fullIfStringOrBytes,getRootGroup());
            }
        }
        if(checkRemarkInitialized()){
            if(!notNull || null != getRemark()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("remark=");
                append(builder,fullIfStringOrBytes,getRemark());
            }
        }
        if(checkExtBinInitialized()){
            if(!notNull || null != getExtBin()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("ext_bin=");
                append(builder,fullIfStringOrBytes,getExtBin());
            }
        }
        if(checkExtTxtInitialized()){
            if(!notNull || null != getExtTxt()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("ext_txt=");
                append(builder,fullIfStringOrBytes,getExtTxt());
            }
        }
        if(checkCreateTimeInitialized()){
            if(!notNull || null != getCreateTime()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("create_time=");
                append(builder,fullIfStringOrBytes,getCreateTime());
            }
        }
        if(checkUpdateTimeInitialized()){
            if(!notNull || null != getUpdateTime()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("update_time=");
                append(builder,fullIfStringOrBytes,getUpdateTime());
            }
        }
        builder.append("]");
        return builder.toString();
    }
    @Override
    public int compareTo(PersonGroupBean object){
        return new CompareToBuilder()
            .append(getId(), object.getId())
            .append(getName(), object.getName())
            .append(getLeaf(), object.getLeaf())
            .append(getParent(), object.getParent())
            .append(getRootGroup(), object.getRootGroup())
            .append(getRemark(), object.getRemark())
            .append(getExtBin(), object.getExtBin())
            .append(getExtTxt(), object.getExtTxt())
            .append(getCreateTime(), object.getCreateTime())
            .append(getUpdateTime(), object.getUpdateTime())
            .toComparison();
    }
    @Override
    public PersonGroupBean clone(){
        try {
            return (PersonGroupBean) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
    /**
     * Make {@code this} to a NULL bean<br>
     * set all fields to null, {@link #modified} and {@link #initialized} be set to 0
     * @return {@code this} bean
     * @author guyadong
     */
    public PersonGroupBean asNULL()
    {   
        checkMutable();
        
        setId((Integer)null);
        setName((String)null);
        setLeaf((Integer)null);
        setParent((Integer)null);
        setRootGroup((Integer)null);
        setRemark((String)null);
        setExtBin((java.nio.ByteBuffer)null);
        setExtTxt((String)null);
        setCreateTime((java.util.Date)null);
        setUpdateTime((java.util.Date)null);
        isNew(true);
        resetInitialized();
        resetIsModified();
        return this;
    }
    /**
     * check whether this bean is a NULL bean 
     * @return {@code true} if {@link #initialized} be set to zero
     * @see #asNULL()
     */
    public boolean checkNULL(){
        return 0 == getInitialized();
    }
    /** 
     * @param source source list
     * @return {@code source} replace {@code null} element with null instance({@link #NULL})
     */
    public static final List<PersonGroupBean> replaceNull(List<PersonGroupBean> source){
        if(null != source){
            for(int i = 0,endIndex = source.size();i<endIndex;++i){
                if(null == source.get(i)){
                    source.set(i, NULL);
                }
            }
        }
        return source;
    }
    /** 
     * @param source input list
     * @return replace null instance element with {@code null}
     * @see #checkNULL()
     */
    public static final List<PersonGroupBean> replaceNullInstance(List<PersonGroupBean> source){
        if(null != source){
            for(int i = 0,endIndex = source.size();i<endIndex;++i){
                if(source.get(i).checkNULL()){
                    source.set(i, null);
                }
            }
        }
        return source;
    }
    @Override
    public PersonGroupBean copy(PersonGroupBean bean)
    {
        return copy(bean,new int[]{});
    }
    @Override
    public PersonGroupBean copy(PersonGroupBean bean, int... fieldList)
    {
        if (null == fieldList || 0 == fieldList.length){
            fieldList = new int[]{0,1,2,3,4,5,6,7,8,9};
        }
        for (int i = 0; i < fieldList.length; ++i) {
            if( bean.isInitialized(fieldList[i]) && !Objects.deepEquals(bean.getValue(fieldList[i]), getValue(fieldList[i]))){
                setValue(fieldList[i], bean.getValue(fieldList[i]));
            }
        }
        return this;
    }
        
    @Override
    public PersonGroupBean copy(PersonGroupBean bean, String... fieldList)
    {
        if (null == fieldList || 0 == fieldList.length){
            copy(bean,(int[])null);
        }else{
            int field;
            for (int i = 0; i < fieldList.length; i++) {
                field = columnIDOf(fieldList[i].trim());
                if(bean.isInitialized(field) && !Objects.deepEquals(bean.getValue(field), getValue(field))){
                    setValue(field, bean.getValue(field));
                }
            }
        }
        return this;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T>T getValue(int columnID)
    {
        switch( columnID ){
        case FL_PERSON_GROUP_ID_ID: 
            return (T)getId();        
        case FL_PERSON_GROUP_ID_NAME: 
            return (T)getName();        
        case FL_PERSON_GROUP_ID_LEAF: 
            return (T)getLeaf();        
        case FL_PERSON_GROUP_ID_PARENT: 
            return (T)getParent();        
        case FL_PERSON_GROUP_ID_ROOT_GROUP: 
            return (T)getRootGroup();        
        case FL_PERSON_GROUP_ID_REMARK: 
            return (T)getRemark();        
        case FL_PERSON_GROUP_ID_EXT_BIN: 
            return (T)getExtBin();        
        case FL_PERSON_GROUP_ID_EXT_TXT: 
            return (T)getExtTxt();        
        case FL_PERSON_GROUP_ID_CREATE_TIME: 
            return (T)getCreateTime();        
        case FL_PERSON_GROUP_ID_UPDATE_TIME: 
            return (T)getUpdateTime();        
        default:
            return null;
        }
    }

    @Override
    public <T> void setValue(int columnID,T value)
    {
        switch( columnID ) {
        case FL_PERSON_GROUP_ID_ID:
            setId((Integer)value);
            break;
        case FL_PERSON_GROUP_ID_NAME:
            setName((String)value);
            break;
        case FL_PERSON_GROUP_ID_LEAF:
            setLeaf((Integer)value);
            break;
        case FL_PERSON_GROUP_ID_PARENT:
            setParent((Integer)value);
            break;
        case FL_PERSON_GROUP_ID_ROOT_GROUP:
            setRootGroup((Integer)value);
            break;
        case FL_PERSON_GROUP_ID_REMARK:
            setRemark((String)value);
            break;
        case FL_PERSON_GROUP_ID_EXT_BIN:
            setExtBin((java.nio.ByteBuffer)value);
            break;
        case FL_PERSON_GROUP_ID_EXT_TXT:
            setExtTxt((String)value);
            break;
        case FL_PERSON_GROUP_ID_CREATE_TIME:
            setCreateTime((java.util.Date)value);
            break;
        case FL_PERSON_GROUP_ID_UPDATE_TIME:
            setUpdateTime((java.util.Date)value);
            break;
        default:
            break;
        }
    }
    
    @Override
    public <T> T getValue(String column)
    {
        return getValue(columnIDOf(column));
    }

    @Override
    public <T> void setValue(String column,T value)
    {
        setValue(columnIDOf(column),value);
    }
    
    /**
     * @param column column name
     * @return column id for the given field name or negative if {@code column} is invalid name 
     */
    public static int columnIDOf(String column){
        int index = FL_PERSON_GROUP_FIELDS_LIST.indexOf(column);
        return  index < 0 
            ? FL_PERSON_GROUP_JAVA_FIELDS_LIST.indexOf(column)
            : index;
    }
    
    public static String columnNameOf(int columnId){
        try{
            return FL_PERSON_GROUP_FIELDS_LIST.get(columnId);
        } catch(IndexOutOfBoundsException e){
            return null;
        }
    }
    
    public static Class<?> typeOf(int columnId){
        try{
            return FL_PERSON_GROUP_FIELD_TYPES[columnId];
        } catch(IndexOutOfBoundsException e){
            return null;
        }
    }
    
    public static final Builder builder(){
        return new Builder().reset();
    }
    /** 
     * a builder for PersonGroupBean,the template instance is thread local variable
     * a instance of Builder can be reused.
     */
    public static final class Builder{
        /** PersonGroupBean instance used for template to create new PersonGroupBean instance. */
        static final ThreadLocal<PersonGroupBean> TEMPLATE = new ThreadLocal<PersonGroupBean>(){
            @Override
            protected PersonGroupBean initialValue() {
                return new PersonGroupBean();
            }};
        private Builder() {}
        /** 
         * reset the bean as template 
         * @see PersonGroupBean#reset()
         */
        public Builder reset(){
            TEMPLATE.get().reset();
            return this;
        }
        /** set a bean as template,must not be {@code null} */
        public Builder template(PersonGroupBean bean){
            if(null == bean){
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }
        /** return a clone instance of {@link #TEMPLATE}*/
        public PersonGroupBean build(){
            return TEMPLATE.get().clone();
        }
        /** 
         * fill the field : fl_person_group.id
         * @param id 用户组id
         * @see PersonGroupBean#getId()
         * @see PersonGroupBean#setId(Integer)
         */
        public Builder id(Integer id){
            TEMPLATE.get().setId(id);
            return this;
        }
        /** 
         * fill the field : fl_person_group.name
         * @param name 用户组名
         * @see PersonGroupBean#getName()
         * @see PersonGroupBean#setName(String)
         */
        public Builder name(String name){
            TEMPLATE.get().setName(name);
            return this;
        }
        /** 
         * fill the field : fl_person_group.leaf
         * @param leaf 是否为叶子节点, 1:叶子节点 0:分支节点,null:两者都可
         * @see PersonGroupBean#getLeaf()
         * @see PersonGroupBean#setLeaf(Integer)
         */
        public Builder leaf(Integer leaf){
            TEMPLATE.get().setLeaf(leaf);
            return this;
        }
        /** 
         * fill the field : fl_person_group.parent
         * @param parent 上一级用户组id
         * @see PersonGroupBean#getParent()
         * @see PersonGroupBean#setParent(Integer)
         */
        public Builder parent(Integer parent){
            TEMPLATE.get().setParent(parent);
            return this;
        }
        /** 
         * fill the field : fl_person_group.root_group
         * @param rootGroup 指向设备组id,用于应用层定义管理员/操作员的管理边界,此字段不为null代表此用户组为管理边界,指向的设备组为此用户组的设备管理边界,
  对于属于此组的管理员和操作员都只能管理此组内的用户及对应设备组内的设备
         * @see PersonGroupBean#getRootGroup()
         * @see PersonGroupBean#setRootGroup(Integer)
         */
        public Builder rootGroup(Integer rootGroup){
            TEMPLATE.get().setRootGroup(rootGroup);
            return this;
        }
        /** 
         * fill the field : fl_person_group.remark
         * @param remark 备注
         * @see PersonGroupBean#getRemark()
         * @see PersonGroupBean#setRemark(String)
         */
        public Builder remark(String remark){
            TEMPLATE.get().setRemark(remark);
            return this;
        }
        /** 
         * fill the field : fl_person_group.ext_bin
         * @param extBin 应用项目自定义二进制扩展字段(最大64KB)
         * @see PersonGroupBean#getExtBin()
         * @see PersonGroupBean#setExtBin(java.nio.ByteBuffer)
         */
        public Builder extBin(java.nio.ByteBuffer extBin){
            TEMPLATE.get().setExtBin(extBin);
            return this;
        }
        /** 
         * fill the field : fl_person_group.ext_txt
         * @param extTxt 应用项目自定义文本扩展字段(最大64KB)
         * @see PersonGroupBean#getExtTxt()
         * @see PersonGroupBean#setExtTxt(String)
         */
        public Builder extTxt(String extTxt){
            TEMPLATE.get().setExtTxt(extTxt);
            return this;
        }
        /** 
         * fill the field : fl_person_group.create_time
         * @param createTime 
         * @see PersonGroupBean#getCreateTime()
         * @see PersonGroupBean#setCreateTime(java.util.Date)
         */
        public Builder createTime(java.util.Date createTime){
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
        /** 
         * fill the field : fl_person_group.update_time
         * @param updateTime 
         * @see PersonGroupBean#getUpdateTime()
         * @see PersonGroupBean#setUpdateTime(java.util.Date)
         */
        public Builder updateTime(java.util.Date updateTime){
            TEMPLATE.get().setUpdateTime(updateTime);
            return this;
        }
    }
}
