// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: tablelistener.java.vm
// ______________________________________________________
package net.gdface.facelog.db;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Executor;

import net.gdface.facelog.db.exception.RuntimeDaoException;

/**
 * Listener that is notified of table changes.
 * @author guyadong
 */
public interface TableListener<B>{
    /**
     * This adapter class provides default implementations for the
     * methods declared by the {@link TableListener} interface.<br>
     * 
     * @author guyadong
     */
    public static class Adapter<B> implements TableListener<B>{

        @Override
        public void beforeInsert(B bean)throws RuntimeDaoException {}

        @Override
        public void afterInsert(B bean)throws RuntimeDaoException {}

        @Override
        public void beforeUpdate(B bean)throws RuntimeDaoException {}

        @Override
        public void afterUpdate(B bean)throws RuntimeDaoException {}

        @Override
        public void beforeDelete(B bean)throws RuntimeDaoException {}

        @Override
        public void afterDelete(B bean)throws RuntimeDaoException {}
        
        @Override
        public void done()throws RuntimeDaoException {}
    }
    /**
     * Invoked just before inserting a B record into the database.
     *
     * @param bean the B that is about to be inserted
     * @throws RuntimeDaoException
     */
    public void beforeInsert(B bean)throws RuntimeDaoException;


    /**
     * Invoked just after a B record is inserted in the database.
     *
     * @param bean the B that was just inserted
     * @throws RuntimeDaoException
     */
    public void afterInsert(B bean)throws RuntimeDaoException;


    /**
     * Invoked just before updating a B record in the database.
     *
     * @param bean the B that is about to be updated
     * @throws RuntimeDaoException
     */
    public void beforeUpdate(B bean)throws RuntimeDaoException;


    /**
     * Invoked just after updating a B record in the database.
     *
     * @param bean the B that was just updated
     * @throws RuntimeDaoException
     */
    public void afterUpdate(B bean)throws RuntimeDaoException;


    /**
     * Invoked just before deleting a B record in the database.
     *
     * @param bean the B that is about to be deleted
     * @throws RuntimeDaoException
     */
    public void beforeDelete(B bean)throws RuntimeDaoException;


    /**
     * Invoked just after deleting a B record in the database.
     *
     * @param bean the B that was just deleted
     * @throws RuntimeDaoException
     */
    public void afterDelete(B bean)throws RuntimeDaoException;

    /**
     * Invoked in finally block, just after insert,update,delete.
     *
     * @throws RuntimeDaoException
     */
    public void done()throws RuntimeDaoException;

    /**
     * listener event:<br>
     * {@code INSERT} insert a bean<br>
     * {@code UPDATE} update a bean<br>
     * {@code DELETE} delete a bean<br>
     * {@code UPDATE_BEFORE} before updating a bean<br>
     * @author guyadong
     *
     */
    public static enum Event{        
        /** insert a bean */INSERT,
        /** update a bean */UPDATE,
        /** delete a bean */DELETE,
        /** before updating a bean */UPDATE_BEFORE,;
        /**
         * fire current event by  {@link ListenerContainer}
         * @param container
         * @param bean
         * @throws RuntimeDaoException
         */
        public <B> void fire(ListenerContainer<B> container,B bean)throws RuntimeDaoException {
            if(null == container || null == bean){
                return;
            }
            switch(this){
            case INSERT:
                container.afterInsert(bean);
                break;
            case UPDATE:
                container.afterUpdate(bean);
                break;
            case DELETE:
                container.afterDelete(bean);
                break;
            case UPDATE_BEFORE:
                container.beforeUpdate(bean);
                break;
            default:
                break;
            }
        }
        public <B extends BaseBean<B>> void fire(TableManager<B > manager,B bean)throws RuntimeDaoException {
            if(null == manager || null == bean){
                return;
            }
            manager.fire(this, bean);
        }
    }
    /** 
     * container for multiple listener management
     * @author guyadong 
     */
    public static class ListenerContainer <B> implements TableListener<B> {
        private final Set<TableListener<B>> listeners = new LinkedHashSet<TableListener<B>>(16);
        private static final InheritableThreadLocal<LinkedList<Runnable>> commitTasks = new InheritableThreadLocal<>();
        
        public static final TransactionListener TRANSACTION_LISTENER = new TransactionListener() {

            @Override
            public void beginTransaction() {
                commitTasks.set(new LinkedList<Runnable>());
            }

            @Override
            public void endTransaction(boolean commit) {
                if(commit){
                    if(null == commitTasks.get()){
                        throw new IllegalStateException("'beginTransaction' must be called firstly");
                    }
                    for (Runnable task : commitTasks.get()) {
                        task.run();
                    }
                }
                commitTasks.remove();
            }
        };
        public ListenerContainer() {
        }
    
        private static void runTask(Runnable task){
            if(commitTasks.get() != null){
                commitTasks.get().add(task);
            }else {
                task.run();
            }
        }
        @Override
        public void beforeInsert(B bean)throws RuntimeDaoException{
            synchronized (listeners) {
                for(TableListener<B> listener:listeners){
                    try{
                        listener.beforeInsert(bean);
                    }catch(Exception e){
                        System.out.printf("beforeInsert listener error:%s\n",e.getMessage());
                    }
                }
            }
        }
    
        @Override
        public void afterInsert(final B bean)throws RuntimeDaoException{
            synchronized (listeners) {
                for(final TableListener<B> listener:listeners){
                    runTask(new Runnable() {
                        
                        @Override
                        public void run() {
                            try{
                                listener.afterInsert(bean);
                            }catch(Exception e){
                                System.out.printf("afterInsert listener error:%s\n",e.getMessage());
                            }
                        }
                    });

                }
            }
        }
    
        @Override
        public void beforeUpdate(B bean)throws RuntimeDaoException{
            synchronized (listeners) {
                for(TableListener<B> listener:listeners){
                    try{
                        listener.beforeUpdate(bean);
                    }catch(Exception e){
                        System.out.printf("beforeUpdate listener error:%s\n",e.getMessage());
                    }
                }
            }
        }
    
        @Override
        public void afterUpdate(final B bean)throws RuntimeDaoException{
            synchronized (listeners) {
                for(final TableListener<B> listener:listeners){
                    runTask(new Runnable() {
                        
                        @Override
                        public void run() {
                            try{
                                listener.afterUpdate(bean);
                            }catch(Exception e){
                                System.out.printf("afterUpdate listener error:%s\n",e.getMessage());
                            }
                        }
                    });

                }
            }
        }
    
        @Override
        public void beforeDelete(B bean)throws RuntimeDaoException{
            synchronized (listeners) {
                for(TableListener<B> listener:listeners){
                    try{
                        listener.beforeDelete(bean);
                    }catch(Exception e){
                        System.out.printf("beforeDelete listener error:%s\n",e.getMessage());
                    }
                }
            }
        }
    
        @Override
        public void afterDelete(final B bean)throws RuntimeDaoException{
            synchronized (listeners) {
                for(final TableListener<B> listener:listeners){
                    runTask(new Runnable() {
                        
                        @Override
                        public void run() {
                            try{
                                listener.afterDelete(bean);
                            }catch(Exception e){
                                System.out.printf("afterDelete listener error:%s\n",e.getMessage());
                            }
                        }
                    });

                }
            }
        }

        @Override
        public void done()throws RuntimeDaoException{
            synchronized (listeners) {
                for(TableListener<B> listener:listeners){
                    try{
                        listener.done();
                    }catch(Exception e){
                        System.out.printf("done listener error:%s\n",e.getMessage());
                    }
                }
            }
        }
        /**
         * determine if the container is empty.
         * @return 
         */
        public boolean isEmpty() {
            return listeners.isEmpty();
        }
        /**
         * determine if the {@code listener} be added.
         * @param listener
         * @return {@code true} if {@code listener} exists in container
         */
        public boolean contains(TableListener<B> listener) {
            synchronized (listeners) {
                return listeners.contains(listener);
            }
        }
        /**
         * add {@code listener} into container
         * @return {@code true} if add successfully.
         */
        public boolean add(TableListener<B> listener) {
            synchronized (listeners) {
                return null == listener ? false : listeners.add(listener);
            }
        }
        /**
         * remove {@code listener} from container
         * @param listener instance that will be removed.
         * @return {@code true} if remove successfully.
         */
        public boolean remove(TableListener<B> listener) {
            synchronized (listeners) {
                return null == listener? false : listeners.remove(listener);
            }
        }
        /** remove all listeners in container */
        public void clear() {
            synchronized (listeners) {
                listeners.clear();
            }
        }
    }
    /**
     * decorator of a {@link TableListener}<br>
     * run {@code delegate} in {@link Executor}
     * @author guyadong
     *
     * @param <B>
     */
    public static class DecoratorExecutorListener<B> implements TableListener<B>{
        private final TableListener<B> delegate;
        private static final Executor DIRECT_EXECUTOR= new Executor(){
            @Override
            public void execute(Runnable command) {
                command.run();
            }};
        public DecoratorExecutorListener(TableListener<B> delegate) {
            if(null == delegate){
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }
        /** return a {@link Executor} instance for execute task */
        protected  Executor getExecutor() {
            return DIRECT_EXECUTOR;
        }
        public TableListener<B> delegate(){
            return delegate;
        }
        protected void onException(Exception e){
            e.printStackTrace();
        }
        @Override
        public void beforeInsert(final B bean) throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.beforeDelete(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void afterInsert(final B bean) throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.afterInsert(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void beforeUpdate(final B bean) throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.beforeUpdate(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void afterUpdate(final B bean) throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.afterUpdate(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void beforeDelete(final B bean) throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.beforeDelete(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void afterDelete(final B bean) throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.afterDelete(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void done() throws RuntimeDaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.done();
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }
    }
    public static interface TransactionListener{
        public void beginTransaction();
        public void endTransaction(boolean commit);
    }
}

