// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: base.foreign.key.listener.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm;

import java.util.List;
import net.gdface.facelog.dborm.exception.DaoException;

/**
 * abstract implementation of foreign key listener for DEELTE RULE
 * @author guyadong
 *
 * @param <FB> bean for foreign table 
 * @param <B> bean for self table
 */
public abstract class BaseForeignKeyListener<FB extends BaseBean<FB>,B extends BaseBean<B>> extends TableListener.Adapter<FB>{
    protected BaseForeignKeyListener(){}
    /**
     * Retrieves the imported B beans that reference to FB bean <BR>
     * @param fb foreign table bean
     * @return empty list if not found imported beans
     * @throws DaoException
     */
    protected abstract List<B> getImportedBeans(FB fb) throws DaoException;
    /**
     * do something on foreign table row removed for effected imported beans {@code effectBeans}
     * @param effectBeans effected imported beans
     * @throws DaoException
     */
    protected abstract void onRemove(List<B> effectBeans) throws DaoException;
    protected final InheritableThreadLocal<List<B>> importedBeans = new InheritableThreadLocal<List<B>>();
    @Override
    public void beforeDelete(FB bean) throws DaoException{
        this.importedBeans.set(getImportedBeans(bean));
    }

    @Override
    public void afterDelete(FB bean) throws DaoException{
        List<B> beans = this.importedBeans.get();
        if(null != beans){
            this.onRemove(beans);
        }
    }
    @Override
    public void done() throws DaoException {
        // clear TLS variable
        importedBeans.remove();
    }
}

