// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: tablelistener.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;

import net.gdface.facelog.dborm.exception.DaoException;

/**
 * Listener that is notified of table changes.
 * @author guyadong
 */
public interface TableListener<B>{
    /**
     * This adapter class provides default implementations for the
     * methods declared by the {@link TableListener} interface.<br>
     * 
     * @author guyadong
     */
    public static class Adapter<B> implements TableListener<B>{

        @Override
        public void beforeInsert(B bean)throws DaoException {}

        @Override
        public void afterInsert(B bean)throws DaoException {}

        @Override
        public void beforeUpdate(B bean)throws DaoException {}

        @Override
        public void afterUpdate(B bean)throws DaoException {}

        @Override
        public void beforeDelete(B bean)throws DaoException {}

        @Override
        public void afterDelete(B bean)throws DaoException {}
        
        @Override
        public void done()throws DaoException {}
    }
    /**
     * Invoked just before inserting a B record into the database.
     *
     * @param bean the B that is about to be inserted
     * @throws DaoException
     */
    public void beforeInsert(B bean)throws DaoException;


    /**
     * Invoked just after a B record is inserted in the database.
     *
     * @param bean the B that was just inserted
     * @throws DaoException
     */
    public void afterInsert(B bean)throws DaoException;


    /**
     * Invoked just before updating a B record in the database.
     *
     * @param bean the B that is about to be updated
     * @throws DaoException
     */
    public void beforeUpdate(B bean)throws DaoException;


    /**
     * Invoked just after updating a B record in the database.
     *
     * @param bean the B that was just updated
     * @throws DaoException
     */
    public void afterUpdate(B bean)throws DaoException;


    /**
     * Invoked just before deleting a B record in the database.
     *
     * @param bean the B that is about to be deleted
     * @throws DaoException
     */
    public void beforeDelete(B bean)throws DaoException;


    /**
     * Invoked just after deleting a B record in the database.
     *
     * @param bean the B that was just deleted
     * @throws DaoException
     */
    public void afterDelete(B bean)throws DaoException;

    /**
     * Invoked in finally block, just after insert,update,delete.
     *
     * @throws DaoException
     */
    public void done()throws DaoException;

    /**
     * listener event
     * {@code INSERT} insert a bean<br>
     * {@code UPDATE} update a bean<br>
     * {@code DELETE} delete a bean<br>
     * @author guyadong
     *
     */
    public static enum Event{
        /** insert a bean */
        INSERT,UPDATE,DELETE;
        /**
         * fire current event by  {@link ListenerContainer}
         * @param container
         * @param bean
         * @throws DaoException
         */
        public <B> void fire(ListenerContainer<B> container,B bean)throws DaoException {
            if(null == container || null == bean){
                return;
            }
            switch(this){
            case INSERT:
                container.afterInsert(bean);
                break;
            case UPDATE:
                container.afterUpdate(bean);
                break;
            case DELETE:
                container.afterDelete(bean);
                break;
            default:
                break;
            }
        }
        public <B extends BaseBean<B>> void fire(TableManager<B > manager,B bean)throws DaoException {
            if(null == manager || null == bean){
                return;
            }
            manager.fire(this, bean);
        }
    }
    /** 
     * container for multiple listener management
     * @author guyadong 
     */
    public static class ListenerContainer <B> implements TableListener<B> {
        private final Set<TableListener<B>> listeners = Collections.synchronizedSet(new LinkedHashSet<TableListener<B>>(16));
        public ListenerContainer() {
        }
    
        @Override
        public void beforeInsert(B bean)throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.beforeInsert(bean);
            }
        }
    
        @Override
        public void afterInsert(B bean)throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.afterInsert(bean);
            }
        }
    
        @Override
        public void beforeUpdate(B bean)throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.beforeUpdate(bean);
            }
        }
    
        @Override
        public void afterUpdate(B bean)throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.afterUpdate(bean);
            }
        }
    
        @Override
        public void beforeDelete(B bean)throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.beforeDelete(bean);
            }
        }
    
        @Override
        public void afterDelete(B bean)throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.afterDelete(bean);
            }
        }

        @Override
        public void done()throws DaoException{
            for(TableListener<B> listener:listeners){
                listener.done();
            }
        }
        /**
         * determine if the container is empty.
         * @return 
         */
        public boolean isEmpty() {
            return listeners.isEmpty();
        }
        /**
         * determine if the {@code listener} be added.
         * @param listener
         * @return {@code true} if {@code listener} exists in container
         */
        public boolean contains(TableListener<B> listener) {
            return listeners.contains(listener);
        }
        /**
         * add {@code listener} into container
         * @return {@code true} if add successfully.
         */
        public boolean add(TableListener<B> listener) {
            return null == listener ? false : listeners.add(listener);
        }
        /**
         * remove {@code listener} from container
         * @param listener instance that will be removed.
         * @return {@code true} if remove successfully.
         */
        public boolean remove(TableListener<B> listener) {
            return null == listener? false : listeners.remove(listener);
        }
        /** remove all listeners in container */
        public void clear() {
            listeners.clear();
        }
    }
    /**
     * decorator of a {@link TableListener}<br>
     * run {@code delegate} in {@link Executor}
     * @author guyadong
     *
     * @param <B>
     */
    public static class DecoratorExecutorListener<B> implements TableListener<B>{
        private final TableListener<B> delegate;
        private static final Executor DIRECT_EXECUTOR= new Executor(){
            @Override
            public void execute(Runnable command) {
                command.run();
            }};
        public DecoratorExecutorListener(TableListener<B> delegate) {
            if(null == delegate){
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }
        /** return a {@link Executor} instance for execute task */
        protected  Executor getExecutor() {
            return DIRECT_EXECUTOR;
        }
        public TableListener<B> delegate(){
            return delegate;
        }
        protected void onException(Exception e){
            e.printStackTrace();
        }
        @Override
        public void beforeInsert(final B bean) throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.beforeDelete(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void afterInsert(final B bean) throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.afterInsert(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void beforeUpdate(final B bean) throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.beforeUpdate(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void afterUpdate(final B bean) throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.afterUpdate(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void beforeDelete(final B bean) throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.beforeDelete(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void afterDelete(final B bean) throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.afterDelete(bean);
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }

        @Override
        public void done() throws DaoException {
            getExecutor().execute(new Runnable(){
                @Override
                public void run() {
                    try{
                        delegate.done();
                    }catch(Exception e){
                        onException(e);
                    }
                }});
        }
    }
}

