// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: tablemanager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm;
import java.util.List;
import java.util.LinkedList;
import java.util.Collection;
import java.util.concurrent.Callable;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
/**
 * Interface to handle database calls (save, load, count, etc...) for table.
 * @author guyadong
 */
public interface TableManager<B extends BaseBean<B>> extends Constant {

    public interface Action<B>{
        public abstract class BaseAdapter<B> implements Action<B>{
            @Override
            public B getBean() {return null;}            
        }
        /**
         * do action for {@code bean}
         * @param bean input bean
         * @throws DaoException
         */
        void call(B bean)throws DaoException;
        /**
         * return a B instance
         * @return B bean
         */
        B getBean();
    }
    public abstract static class BaseAdapter<B extends BaseBean<B>> implements TableManager<B>{
        /**
         * return the B bean class
         * @return 
         */
        protected abstract Class<B> beanType();
        //13
        /**
         * Insert the B bean into the database.
         * 
         * @param bean the B bean to be saved
         * @return the inserted bean
         * @throws DaoException
         */
        protected abstract B insert(B bean)throws DaoException;
        //14
        /**
         * Update the B bean record in the database according to the changes.
         *
         * @param bean the B bean to be updated
         * @return the updated bean
         * @throws DaoException
         */
        protected abstract B update(B bean)throws DaoException;
        
        public class ListAction implements Action<B> {
            final List<B> list;
            public ListAction() {
                list=new LinkedList<B>();
            }

            public List<B> getList() {
                return list;
            }

            @Override
            public void call(B bean) {
                list.add(bean);
            }

            @Override
            public B getBean() {
                return null;
            }
        }
        @Override
        public int countAll()throws DaoException{
            return this.countWhere("");
        }

        @Override
        public int countUsingTemplate(B bean)throws DaoException{
            return this.countUsingTemplate(bean, SEARCH_EXACT);
        }

        @Override
        public int deleteAll()throws DaoException{
            return this.deleteByWhere("");
        }


        @Override
        public B[] loadAll()throws DaoException{
            return this.loadUsingTemplate(null, 1, -1, SEARCH_EXACT);
        }

        @Override
        public int loadAll(Action<B> action)throws DaoException{
            return this.loadUsingTemplate(null,null,1,-1, SEARCH_EXACT, action);
        }

        @Override
        public B[] loadAll(int startRow, int numRows)throws DaoException{
            return this.loadUsingTemplate(null, startRow, numRows, SEARCH_EXACT);
        }

        @Override
        public int loadAll(int startRow, int numRows, Action<B> action)throws DaoException{
            return this.loadUsingTemplate(null, null, startRow, numRows, SEARCH_EXACT, action);
        }

        @Override
        public List<B> loadAllAsList()throws DaoException{
            return this.loadUsingTemplateAsList(null,1, -1, SEARCH_EXACT);
        }

        @Override
        public List<B> loadAllAsList(int startRow, int numRows)throws DaoException{
            return this.loadUsingTemplateAsList(null, startRow, numRows, SEARCH_EXACT);
        }

        @Override
        public boolean existsByPrimaryKey(B bean)throws DaoException{
            return null!=loadByPrimaryKey(bean);
        }
        @Override
        public B checkDuplicate(B bean)throws DaoException,ObjectRetrievalException{
            throw new UnsupportedOperationException();
        }
        @Override
        public boolean existsPrimaryKey(Object ...keys)throws DaoException{
            return null!=loadByPrimaryKey(keys);
        }
        
        @Override
        public B[] loadByWhere(String where)throws DaoException{
            return this.loadByWhere(where, (int[])null);
        }

        @Override
        public int loadByWhere(String where, Action<B> action)throws DaoException{
            return this.loadByWhere(where, null, action);
        }

        @Override
        public B[] loadByWhere(String where, int[] fieldList)throws DaoException{
            return this.loadByWhere(where, fieldList, 1, -1);
        }

        @Override
        public int loadByWhere(String where, int[] fieldList, Action<B> action)throws DaoException{
            return this.loadByWhere(where, fieldList, 1, -1, action);
        }

        @SuppressWarnings("unchecked")
        @Override
        public B[] loadByWhere(String where, int[] fieldList, int startRow, int numRows)throws DaoException{
            return this.loadByWhereAsList(where, fieldList, startRow, numRows).toArray((B[])java.lang.reflect.Array.newInstance(beanType(),0));
        }

        @Override
        public int loadByWhere(String where, int[] fieldList, int startRow, int numRows,
                Action<B> action)throws DaoException{
            return this.loadByWhereForAction(where, fieldList, startRow, numRows, action);
        }

        @Override
        public List<B> loadByWhereAsList(String where)throws DaoException{
            return this.loadByWhereAsList(where, null, 1, -1);
        }

        @Override
        public List<B> loadByWhereAsList(String where, int[] fieldList)throws DaoException{
            return this.loadByWhereAsList(where, fieldList, 1, -1);
        }

        @Override
        public List<B> loadByWhereAsList(String where, int[] fieldList, int startRow, int numRows)throws DaoException{
            ListAction action = new ListAction();
            loadByWhereForAction(where, fieldList, startRow, numRows, action);              
            return action.getList();
        }
    
        @Override
        public int loadByWhereForAction(String where, int[] fieldList, int startRow, int numRows,Action<B> action)throws DaoException{
            String sql=createSelectSql(fieldList, where);
            // System.out.println("loadByWhere: " + sql);
            return this.loadBySqlForAction(sql, null, fieldList, startRow, numRows, action);
        }
    
        @Override
        public B[] loadUsingTemplate(B bean)throws DaoException{
            return this.loadUsingTemplate(bean, 1, -1, SEARCH_EXACT);
        }

        @Override
        public int loadUsingTemplate(B bean, Action<B> action)throws DaoException{
            return this.loadUsingTemplate(bean, null, 1, -1, SEARCH_EXACT, action);
        }

        @Override
        public B[] loadUsingTemplate(B bean, int startRow, int numRows)throws DaoException{
            return this.loadUsingTemplate(bean, startRow, numRows, SEARCH_EXACT);
        }

        @Override
        public int loadUsingTemplate(B bean, int startRow, int numRows,
                Action<B> action)throws DaoException{
            return this.loadUsingTemplate(bean, null, startRow, numRows,SEARCH_EXACT, action);
        }

        @SuppressWarnings("unchecked")
        @Override
        public B[] loadUsingTemplate(B bean, int startRow, int numRows, int searchType)throws DaoException{
            return this.loadUsingTemplateAsList(bean, startRow, numRows, searchType).toArray((B[])java.lang.reflect.Array.newInstance(beanType(),0));
        }

        @Override
        public List<B> loadUsingTemplateAsList(B bean)throws DaoException{
            return this.loadUsingTemplateAsList(bean, 1, -1, SEARCH_EXACT);
        }

        @Override
        public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows)throws DaoException{
            return this.loadUsingTemplateAsList(bean, startRow, numRows, SEARCH_EXACT);
        }

        @Override
        public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows, int searchType)throws DaoException{
            ListAction action = new ListAction();
            loadUsingTemplate(bean,null,startRow,numRows,searchType, action);
            return action.getList();
        }
        
        @Override
        public B save(B bean)throws DaoException{
            if(null != bean){
                if (bean.isNew()) {
                    this.insert(bean);
                } else {
                    this.update(bean);
                }
            }
            return bean;
        }
        
        @Override
        public B[] save(B[] beans)throws DaoException{
            if(null != beans){
                for (B bean : beans) 
                {
                    this.save(bean);
                }
            }
            return beans;
        }

        @Override
        public <C extends Collection<B>> C save(C beans)throws DaoException{
            if(null != beans){
                for (B bean : beans) 
                {
                    this.save(bean);
                }
            }
            return beans;
        }
        
        @Override
        public <C extends Collection<B>> C saveAsTransaction(final C beans)throws DaoException{
            return this.runAsTransaction(new Callable<C>(){
                @Override
                public C call() throws Exception {
                    return save(beans);
                }});
        }

        @Override
        public B[] saveAsTransaction(final B[] beans)throws DaoException{
            return this.runAsTransaction(new Callable<B[]>(){
                @Override
                public B[] call() throws Exception {
                    return save(beans);
                }});
        }

        @SuppressWarnings("unchecked")
        @Override
        public B[] loadBySql(String sql, Object[] argList, int[] fieldList)throws DaoException{
            return loadBySqlAsList(sql, argList, fieldList).toArray((B[])java.lang.reflect.Array.newInstance(beanType(),0));
        }

        @Override
        public List<B> loadBySqlAsList(String sql, Object[] argList, int[] fieldList)throws DaoException{
            ListAction action = new ListAction();
            loadBySqlForAction(sql,argList,fieldList,1,-1,action);
            return action.getList();
        }
        
        /**
         * generate SQL query statement 
         * @param fieldList
         * @param where
         * @return
         */
        protected String createSelectSql(int[] fieldList, String where){
            StringBuffer sql = new StringBuffer(128);
            String fullFields = this.getFullFields();
            if(null == fieldList || 0 == fieldList.length) {
                sql.append("SELECT ").append(fullFields);
            } else{
                sql.append("SELECT ");
                String[] names=fullFields.split(",");
                for(int i = 0; i < fieldList.length; ++i){
                    if(i > 0) {
                        sql.append(",");
                    }
                    sql.append(names[fieldList[i]]);
                }      
            }
            sql.append(" FROM " + this.getTableName() + " ");
            if(null!=where){
                sql.append(where);
            }
            return sql.toString();
        }

        @Override
        public int delete(B bean)throws DaoException{
            throw new UnsupportedOperationException();
        }
        
        @Override
        public <T extends BaseBean<T>> T getReferencedBean(B bean, int fkIndex)throws DaoException{
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T setReferencedBean(B bean, T beanToSet, int fkIndex)throws DaoException{
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T[] getImportedBeans(B bean, int ikIndex)throws DaoException{
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> List<T> getImportedBeansAsList(B bean, int ikIndex)throws DaoException{
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T[] setImportedBeans(B bean, T[] importedBeans, int ikIndex)throws DaoException{
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>, C extends Collection<T>> C setImportedBeans(B bean, C importedBeans,
                int ikIndex)throws DaoException{
            throw new UnsupportedOperationException();
        }

        @Override
        public B loadByPrimaryKey(B bean)throws DaoException{
            throw new UnsupportedOperationException();
        }
        @Override
        public B loadByPrimaryKeyChecked(B bean)throws DaoException,ObjectRetrievalException{
            throw new UnsupportedOperationException();
        }
        @Override
        public B loadByPrimaryKey(Object ...keys)throws DaoException{
            throw new UnsupportedOperationException();
        }
        @Override
        public B loadByPrimaryKeyChecked(Object ...keys)throws DaoException,ObjectRetrievalException{
            throw new UnsupportedOperationException();
        }
        @Override
        public int deleteByPrimaryKey(Object ...keys)throws DaoException{
            throw new UnsupportedOperationException();
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public B[] loadByIndex(int keyIndex,Object ...keys)throws DaoException{
            return this.loadByIndexAsList(keyIndex,keys).toArray((B[])java.lang.reflect.Array.newInstance(beanType(),0));
        }
        
        @Override
        public List<B> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException{
            throw new UnsupportedOperationException();
        }
        
        @Override
        public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException{
            throw new UnsupportedOperationException();
        }
        
        @Override
        public B save(B bean,Object ...args)throws DaoException{
            throw new UnsupportedOperationException();
        }
        
        @Override
        public B saveCollection(B bean,Object ...args)throws DaoException{
            throw new UnsupportedOperationException();
        }
        
        @Override
        public B saveAsTransaction(final B bean,final Object ...args)throws DaoException{
            return this.runAsTransaction(new Callable<B>(){
                @Override
                public B call() throws Exception {
                    return save(bean , args );
                }});
        }
        
        @Override
        public B saveCollectionAsTransaction(final B bean,final Object ...args)throws DaoException{
            return this.runAsTransaction(new Callable<B>(){
                @Override
                public B call() throws Exception {
                    return saveCollection(bean , args );
                }});
        }
        
        @Override
        public void runAsTransaction(final Runnable fun)throws DaoException{
            this.runAsTransaction(new Callable<Object>() {
                @Override
                public Object call() throws Exception {
                    fun.run();
                    return null;
                }
            });
        }
    }    

    /**
     * return the all of filed names
     * @return 
     */     
    public String getFields();
    
    /**
     * return all of primary key names
     * @return 
     */     
    public String[] getPrimarykeyNames();

    /**
     * return the table name
     * @return 
     */    
    public String getTableName();
        
    /**
     * return the all of full filed names
     * @return 
     */   
    public String getFullFields();
    
    //43
    /**
     * return true if @{code column}(case insensitive)is primary key,otherwise return false <br>
     * return false if @{code column} is null or empty 
     * @param column
     * @return
     */
    public boolean isPrimaryKey(String column);
    
    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________
    //24
    /**
     * Retrieves the number of rows of the table.
     *
     * @return the number of rows returned
     * @throws DaoException
     */
    public int countAll()throws DaoException;
    
    //27
    /**
     * count the number of elements of a specific bean
     *
     * @param bean the bean to look for ant count
     * @return the number of rows returned
     * @throws DaoException
     */
    public int countUsingTemplate( B bean)throws DaoException;
  
    //20
    /**
     * count the number of elements of a specific bean given the search type
     *
     * @param bean the template to look for
     * @param searchType exact ?  like ? starting like ? ending link ? <br>
     *                {@value Constant#SEARCH_EXACT}   {@link Constant#SEARCH_EXACT} <br>
     *                {@value Constant#SEARCH_LIKE}   {@link Constant#SEARCH_LIKE} <br>
     *                {@value Constant#SEARCH_STARTING_LIKE}   {@link Constant#SEARCH_STARTING_LIKE} <br>
     *                {@value Constant#SEARCH_ENDING_LIKE}   {@link Constant#SEARCH_ENDING_LIKE} <br>  
     * @return the number of rows returned
     * @throws DaoException
     */
    public int countUsingTemplate(B bean, int searchType)throws DaoException;

    //25
    /**
     * Retrieves the number of rows of the table with a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the restriction clause
     * @return the number of rows returned
     * @throws DaoException
     */
    public int countWhere(String where)throws DaoException;

    //10
    /**
     * Deletes all rows from table.
     * @return the number of deleted rows.
     * @throws DaoException
     */
    public int deleteAll()throws DaoException;

    //11
    /**
     * Deletes rows from the table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByWhere(String where)throws DaoException;

    //21
    /**
     * Deletes rows using a template.
     *
     * @param bean the template object(s) to be deleted
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteUsingTemplate(B bean)throws DaoException;

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value<br>
     *      for fl_device table<br>
     *          PK# 1 fl_device.id type Integer<br>
     *      for fl_device_group table<br>
     *          PK# 1 fl_device_group.id type Integer<br>
     *      for fl_face table<br>
     *          PK# 1 fl_face.id type Integer<br>
     *      for fl_feature table<br>
     *          PK# 1 fl_feature.md5 type String<br>
     *      for fl_image table<br>
     *          PK# 1 fl_image.md5 type String<br>
     *      for fl_log table<br>
     *          PK# 1 fl_log.id type Integer<br>
     *      for fl_permit table<br>
     *          PK# 1 fl_permit.device_group_id type Integer,PK# 2 fl_permit.person_group_id type Integer<br>
     *      for fl_person table<br>
     *          PK# 1 fl_person.id type Integer<br>
     *      for fl_person_group table<br>
     *          PK# 1 fl_person_group.id type Integer<br>
     *      for fl_store table<br>
     *          PK# 1 fl_store.md5 type String<br>
     * @return the number of deleted rows
     * @throws DaoException
     */   
    public int deleteByPrimaryKey(Object ...keys)throws DaoException;

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    public int delete(B bean)throws DaoException;


    //////////////////////////////////////
    // LOAD ALL
    //////////////////////////////////////

    //5
    /**
     * Loads all the rows from table.
     *
     * @return an array of B bean
     * @throws DaoException
     */
    public B[] loadAll()throws DaoException;

    //5-1    
    /**
     * Loads each row from table and dealt with action.
     * @param action  Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadAll(Action<B> action)throws DaoException;

    //6
    /**
     * Loads the given number of rows from table, given the start row.
     *
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return an array of B bean
     * @throws DaoException
     */
    public B[] loadAll(int startRow, int numRows)throws DaoException;

    //6-1    
    /**
     *  Loads the given number of rows from table, given the start row and dealt with action.
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action  Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadAll(int startRow, int numRows,Action<B> action)throws DaoException;

    //5-2
    /**
     * Loads all the rows from table.
     *
     * @return a list of B bean
     * @throws DaoException
     */
    public List<B> loadAllAsList()throws DaoException;

    //6-2
    /**
     * Loads the given number of rows from table, given the start row.
     *
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return a list of B bean
     * @throws DaoException
     */
    public List<B> loadAllAsList(int startRow, int numRows)throws DaoException;

    //1.2
    /**
     * Loads a B bean from the table using primary key fields of {@code bean}.
     * @param bean the B bean with primary key fields
     * @return a unique B or {@code null} if not found or bean is null
     * @throws DaoException
     */
    public B loadByPrimaryKey(B bean)throws DaoException;
    
    //1.2.2
    /**
     * see also {@link #loadByPrimaryKey(BaseBean)} 
     * @param bean
     * @return a unique B ,otherwise throw exception
     * @throws ObjectRetrievalException not found
     * @throws DaoException
     */
    public B loadByPrimaryKeyChecked(B bean)throws DaoException,ObjectRetrievalException;
    //1.3
    /**
     * Loads a B bean from the table using primary key fields.
     * when you don't know which is primary key of table,you can use the method.
     * @param keys primary keys value:<br> 
     *      for fl_device table<br>
     *          PK# 1 fl_device.id type Integer<br>
     *      for fl_device_group table<br>
     *          PK# 1 fl_device_group.id type Integer<br>
     *      for fl_face table<br>
     *          PK# 1 fl_face.id type Integer<br>
     *      for fl_feature table<br>
     *          PK# 1 fl_feature.md5 type String<br>
     *      for fl_image table<br>
     *          PK# 1 fl_image.md5 type String<br>
     *      for fl_log table<br>
     *          PK# 1 fl_log.id type Integer<br>
     *      for fl_permit table<br>
     *          PK# 1 fl_permit.device_group_id type Integer,PK# 2 fl_permit.person_group_id type Integer<br>
     *      for fl_person table<br>
     *          PK# 1 fl_person.id type Integer<br>
     *      for fl_person_group table<br>
     *          PK# 1 fl_person_group.id type Integer<br>
     *      for fl_store table<br>
     *          PK# 1 fl_store.md5 type String<br>
     * @return a unique B or {@code null} if not found
     * @throws DaoException
     */
    public B loadByPrimaryKey(Object ...keys)throws DaoException;

    //1.3.2
    /**
     * see also {@link #loadByPrimaryKey(Object...)}
     * @param keys
     * @return a unique B,otherwise throw exception
     * @throws ObjectRetrievalException not found
     * @throws DaoException
     */
    public B loadByPrimaryKeyChecked(Object ...keys)throws DaoException,ObjectRetrievalException;
    
    //1.5
    /**
     * Returns true if this table contains row with primary key fields.
     * @param keys primary keys value
     * @see #loadByPrimaryKey(Object...)
     * @return 
     * @throws DaoException
     */
    public boolean existsPrimaryKey(Object ...keys)throws DaoException;
    
    //1.6
    /**
     * Returns true if this table contains row specified by primary key fields of B.<br>
     * when you don't know which is primary key of table,you can use the method.
     * @param bean the B bean with primary key fields
     * @return 
     * @see #loadByPrimaryKey(BaseBean)
     * @throws DaoException
     */
    public boolean existsByPrimaryKey(B bean)throws DaoException;
    //1.7
    /**
     * Check duplicated row by primary keys,if row exists throw exception
     * @param bean the B bean with primary key fields
     * @return always bean
     * @see #existsByPrimaryKey(BaseBean)
     * @throws ObjectRetrievalException has duplicated record
     * @throws DaoException
     */
    public B checkDuplicate(B bean)throws DaoException,ObjectRetrievalException;
   
    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //7 
    /**
     * Retrieves an array of B given a sql 'where' clause.
     *
     * @param where the sql 'where' clause
     * @return 
     * @throws DaoException
     */
    public B[] loadByWhere(String where)throws DaoException;
    
    //7-1
    /**
     * Retrieves each row of B bean given a sql 'where' clause and dealt with action.
     * @param where the sql 'where' clause
     * @param action  Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadByWhere(String where,Action<B> action)throws DaoException;

    //8
    /**
     * Retrieves an array of B bean given a sql where clause, and a list of fields.
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the sql 'WHERE' clause
     * @param fieldList array of field's ID
     * @return 
     * @throws DaoException
     */
    public B[] loadByWhere(String where, int[] fieldList)throws DaoException;
   
    //8-1 
    /**
     * Retrieves each row of B bean given a sql where clause, and a list of fields,
     * and dealt with action.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * @param where the sql 'WHERE' clause
     * @param fieldList array of field's ID
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadByWhere(String where, int[] fieldList,Action<B> action)throws DaoException;

    //9
    /**
     * Retrieves an array of B bean given a sql where clause and a list of fields, and startRow and numRows.
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the sql 'where' clause
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return 
     * @throws DaoException
     */
    public B[] loadByWhere(String where, int[] fieldList, int startRow, int numRows)throws DaoException;

    //9-1    
    /**
     * Retrieves each row of B bean given a sql where clause and a list of fields, and startRow and numRows,
     * and dealt with action.
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the sql 'where' clause
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadByWhere(String where, int[] fieldList, int startRow, int numRows,Action<B> action)throws DaoException;
    //7
    /**
     * Retrieves a list of B bean given a sql 'where' clause.
     *
     * @param where the sql 'where' clause
     * @return
     * @throws DaoException
     */
    public List<B> loadByWhereAsList(String where)throws DaoException;

    //8
    /**
     * Retrieves a list of B bean given a sql where clause, and a list of fields.
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the sql 'WHERE' clause
     * @param fieldList array of field's ID
     * @return
     * @throws DaoException
     */
    public List<B> loadByWhereAsList(String where, int[] fieldList)throws DaoException;
    
    //9-2
    /**
     * Retrieves a list of B bean given a sql where clause and a list of fields, and startRow and numRows.
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the sql 'where' clause
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return
     * @throws DaoException
     */
    public List<B> loadByWhereAsList(String where, int[] fieldList, int startRow, int numRows)throws DaoException;

    //9-3
    /**
     * Retrieves each row of B bean given a sql where clause and a list of fields, and startRow and numRows,
     * and dealt wity action
     * It is up to you to pass the 'WHERE' in your where clauses.
     *
     * @param where the sql 'where' clause
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadByWhereForAction(String where, int[] fieldList, int startRow, int numRows,Action<B> action)throws DaoException;

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18   
    /**
     * Loads a unique B bean from a template one giving a c
     *
     * @param bean the B bean to look for
     * @return the bean matching the template,or {@code null} if not found or null input argument
     * @throws ObjectRetrievalException more than one row
     * @throws DaoException
     */
    public B loadUniqueUsingTemplate(B bean)throws DaoException;

    //18-1
    /**
     * Loads a unique B bean from a template one giving a c
     *
     * @param bean the B bean to look for
     * @return the bean matching the template
     * @throws ObjectRetrievalException not found or more than one row
     * @throws DaoException
     */
    public B loadUniqueUsingTemplateChecked(B bean)throws DaoException,ObjectRetrievalException;

    //19
    /**
     * Loads an array of B from a template one.
     *
     * @param bean the B bean template to look for
     * @return all the B beans matching the template
     * @throws DaoException
     */
    public B[] loadUsingTemplate(B bean)throws DaoException;
    
    //19-1
    /**
     * Loads each row from a template one and dealt with action.
     *
     * @param bean the B bean template to look for
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadUsingTemplate(B bean,Action<B> action)throws DaoException;

    //20
    /**
     * Loads an array of B bean from a template one, given the start row and number of rows.
     *
     * @param bean the B bean template to look for
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return all the B matching the template
     * @throws DaoException
     */
    public B[] loadUsingTemplate(B bean, int startRow, int numRows)throws DaoException;
    
    //20-1
    /**
     * Loads each row from a template one, given the start row and number of rows and dealt with action.
     *
     * @param bean the B bean template to look for
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadUsingTemplate(B bean, int startRow, int numRows,Action<B> action)throws DaoException;

    //20-5
    /**
     * Loads each row from a template one, given the start row and number of rows and dealt with action.
     *
     * @param bean the B template to look for
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param searchType exact ?  like ? starting like ? ending link ? <br>
     *                {@value Constant#SEARCH_EXACT}   {@link Constant#SEARCH_EXACT} <br>
     *                {@value Constant#SEARCH_LIKE}   {@link Constant#SEARCH_LIKE} <br>
     *                {@value Constant#SEARCH_STARTING_LIKE}   {@link Constant#SEARCH_STARTING_LIKE} <br>
     *                {@value Constant#SEARCH_ENDING_LIKE}   {@link Constant#SEARCH_ENDING_LIKE} <br>  
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadUsingTemplate(B bean, int[] fieldList, int startRow, int numRows,int searchType, Action<B> action)throws DaoException;
    //20-4
    /**
     * Loads a list of B bean from a template one, given the start row and number of rows.
     *
     * @param bean the B bean template to look for
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param searchType exact ?  like ? starting like ? ending link ? <br>
     *                {@value Constant#SEARCH_EXACT}   {@link Constant#SEARCH_EXACT} <br>
     *                {@value Constant#SEARCH_LIKE}   {@link Constant#SEARCH_LIKE} <br>
     *                {@value Constant#SEARCH_STARTING_LIKE}   {@link Constant#SEARCH_STARTING_LIKE} <br>
     *                {@value Constant#SEARCH_ENDING_LIKE}   {@link Constant#SEARCH_ENDING_LIKE} <br>  
     * @return all the B bean matching the template
     * @throws DaoException
     */
    public B[] loadUsingTemplate(B bean, int startRow, int numRows, int searchType)throws DaoException;

    //19-2
    /**
     * Loads a list of B bean from a template one.
     *
     * @param bean the B bean template to look for
     * @return all the B beans matching the template
     * @throws DaoException
     */
    public List<B> loadUsingTemplateAsList(B bean)throws DaoException;

    //20-2
    /**
     * Loads a list of B bean from a template one, given the start row and number of rows.
     *
     * @param bean the B bean template to look for
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return all the B bean matching the template
     * @throws DaoException
     */
    public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows)throws DaoException;

    //20-3
    /**
     * Loads an array of B bean from a template one, given the start row and number of rows.
     *
     * @param bean the B bean template to look for
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param searchType exact ?  like ? starting like ? ending link? <br>
     *                {@value Constant#SEARCH_EXACT}   {@link Constant#SEARCH_EXACT} <br>
     *                {@value Constant#SEARCH_LIKE}   {@link Constant#SEARCH_LIKE} <br>
     *                {@value Constant#SEARCH_STARTING_LIKE}   {@link Constant#SEARCH_STARTING_LIKE} <br>
     *                {@value Constant#SEARCH_ENDING_LIKE}   {@link Constant#SEARCH_ENDING_LIKE} <br>  
     * @return all the B beans matching the template
     * @throws DaoException
     */
    public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows, int searchType)throws DaoException;

    //_____________________________________________________________________
    //
    // USING INDICES
    //_____________________________________________________________________    
    /**
     * Retrieves a array of B bean using the index specified by keyIndex.
     * @param keyIndex valid values:see also {@link #loadByIndexAsList(int,Object ...)}
     * @param keys key values of index
     * @return
     * @throws DaoException
     * @see #loadByIndexAsList(int ,Object ...)
     */
    public B[] loadByIndex(int keyIndex,Object ...keys)throws DaoException;
    
    /**
     * Retrieves a list of B bean using the index specified by keyIndex.
     * @param keyIndex valid values: <br>
     *        for fl_device table<br>
     *        {@link Constant#FL_DEVICE_INDEX_MAC},{@link Constant#FL_DEVICE_INDEX_SERIAL_NO},{@link Constant#FL_DEVICE_INDEX_GROUP_ID}<br>     
     *        for fl_device_group table<br>
     *        {@link Constant#FL_DEVICE_GROUP_INDEX_PARENT}<br>     
     *        for fl_face table<br>
     *        {@link Constant#FL_FACE_INDEX_FEATURE_MD5},{@link Constant#FL_FACE_INDEX_IMAGE_MD5}<br>     
     *        for fl_feature table<br>
     *        {@link Constant#FL_FEATURE_INDEX_PERSON_ID}<br>     
     *        for fl_image table<br>
     *        {@link Constant#FL_IMAGE_INDEX_DEVICE_ID}<br>     
     *        for fl_log table<br>
     *        {@link Constant#FL_LOG_INDEX_COMPARE_FACE},{@link Constant#FL_LOG_INDEX_DEVICE_ID},{@link Constant#FL_LOG_INDEX_PERSON_ID},{@link Constant#FL_LOG_INDEX_VERIFY_FEATURE}<br>     
     *        for fl_person table<br>
     *        {@link Constant#FL_PERSON_INDEX_IMAGE_MD5},{@link Constant#FL_PERSON_INDEX_PAPERS_NUM},{@link Constant#FL_PERSON_INDEX_EXPIRY_DATE},{@link Constant#FL_PERSON_INDEX_GROUP_ID}<br>     
     *        for fl_person_group table<br>
     *        {@link Constant#FL_PERSON_GROUP_INDEX_PARENT}<br>     
     * @param keys key values of index
     * @return a list of B bean
     * @throws DaoException
     */
    public java.util.List<B> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException;
    
    /**
     * Deletes rows using key.
     * @param keyIndex valid values: see also {@link #loadByIndexAsList(int,Object ...)}
     * @param keys key values of index
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException;
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    //35
    /**
     * Registers a unique {@link TableListener} listener.<br>
     * do nothing if {@code TableListener} instance exists
     * @param listener
     * @return 
     */
    public TableListener<B> registerListener(TableListener<B> listener);

    //36
    /**
     * remove listener.
     * @param listener 
     */
    public void unregisterListener(TableListener<B> listener);

    //37
    /**
     * see also {@link TableListener.Event#fire(TableListener.ListenerContainer, Object)}
     * @param event
     * @param bean
     * @throws DaoException
     */
    public void fire(TableListener.Event event, B bean) throws DaoException;
    
    //37-1
    /**
     * see also #fire(TableListener.Event, B)
     * @param event 
     * @param bean
     * @throws IllegalArgumentException invalid event id
     * @throws DaoException
     */
    public void fire(int event, B bean) throws DaoException;
    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________
    //12
    /**
     * Saves the B bean into the database.
     *
     * @param bean the B bean to be saved
     * @return the inserted or updated bean,or null if bean is null
     * @throws DaoException
     */
    public B save(B bean)throws DaoException;

    //15
    /**
     * Saves an array of B bean into the database.
     *
     * @param beans the array of  B bean to be saved
     * @return always beans saved
     * @throws DaoException
     */
    public B[] save(B[] beans)throws DaoException;
    
    //15-2
    /**
     * Saves a collection of B bean into the database.
     *
     * @param beans the B bean table to be saved
     * @return alwarys beans saved
     * @throws DaoException
     */
    public <C extends Collection<B>> C saveAsTransaction(C beans)throws DaoException;
    
    //15-3
    /**
     * Saves an array of B bean into the database as transaction.
     *
     * @param beans the B bean table to be saved
     * @return alwarys beans saved
     * @see #save(BaseBean[])
     * @throws DaoException
     */
    public B[] saveAsTransaction(B[] beans)throws DaoException;

    //15-4
    /**
     * Saves a collection of B bean into the database as transaction.
     *
     * @param beans the B bean table to be saved
     * @return alwarys beans saved
     * @throws DaoException
     */
    public <C extends Collection<B>> C save(C beans)throws DaoException;

    //3.9 SYNC SAVE 
    /**
     * Save the B bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the B bean to be saved
     * @param args referenced beans or imported beans,for each table,each argument's type is different:<br>
            for fl_device table:<br>
                {@code  FlDeviceGroupBean FlImageBean[] FlLogBean[]}<br>
            for fl_device_group table:<br>
                {@code  FlDeviceGroupBean FlDeviceBean[] FlDeviceGroupBean[] FlPermitBean[]}<br>
            for fl_face table:<br>
                {@code  FlFeatureBean FlImageBean FlLogBean[]}<br>
            for fl_feature table:<br>
                {@code  FlPersonBean FlFaceBean[] FlLogBean[]}<br>
            for fl_image table:<br>
                {@code  FlDeviceBean FlFaceBean[] FlPersonBean[]}<br>
            for fl_log table:<br>
                {@code  FlDeviceBean FlFaceBean FlFeatureBean FlPersonBean}<br>
            for fl_permit table:<br>
                {@code  FlDeviceGroupBean FlPersonGroupBean}<br>
            for fl_person table:<br>
                {@code  FlImageBean FlPersonGroupBean FlFeatureBean[] FlLogBean[]}<br>
            for fl_person_group table:<br>
                {@code  FlPersonGroupBean FlPermitBean[] FlPersonBean[] FlPersonGroupBean[]}<br>
     * @return the inserted or updated B bean
      * @throws DaoException
     */
    public B save(B bean,Object ...args)throws DaoException;
    
    //3.10 SYNC SAVE 
    /**
     * Save the B bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the B bean to be saved
     * @param args referenced beans or imported beans,for each table,each argument's type is different:<br>
            for fl_device table:<br>
                {@code  FlDeviceGroupBean Collection<FlImageBean> Collection<FlLogBean>}<br>
            for fl_device_group table:<br>
                {@code  FlDeviceGroupBean Collection<FlDeviceBean> Collection<FlDeviceGroupBean> Collection<FlPermitBean>}<br>
            for fl_face table:<br>
                {@code  FlFeatureBean FlImageBean Collection<FlLogBean>}<br>
            for fl_feature table:<br>
                {@code  FlPersonBean Collection<FlFaceBean> Collection<FlLogBean>}<br>
            for fl_image table:<br>
                {@code  FlDeviceBean Collection<FlFaceBean> Collection<FlPersonBean>}<br>
            for fl_log table:<br>
                {@code  FlDeviceBean FlFaceBean FlFeatureBean FlPersonBean}<br>
            for fl_permit table:<br>
                {@code  FlDeviceGroupBean FlPersonGroupBean}<br>
            for fl_person table:<br>
                {@code  FlImageBean FlPersonGroupBean Collection<FlFeatureBean> Collection<FlLogBean>}<br>
            for fl_person_group table:<br>
                {@code  FlPersonGroupBean Collection<FlPermitBean> Collection<FlPersonBean> Collection<FlPersonGroupBean>}<br>
     * @return the inserted or updated B bean
     * @throws DaoException
     */
    public B saveCollection(B bean,Object ...args)throws DaoException;
    
    //3.11 SYNC SAVE 
    /**
     *  Transaction version for sync save
     * @see #save(BaseBean ,Object ...)
     * @param bean the B bean to be saved
     * @param args referenced beans or imported beans<br>
     * @return the inserted or updated B bean
     * @throws DaoException
     */
    public B saveAsTransaction(B bean,Object ...args)throws DaoException;
    
    //3.12 SYNC SAVE 
    /**
     *  Transaction version for sync save
     * @see #saveCollection(BaseBean ,Object ...)
     * @param bean the B bean to be saved
     * @param args referenced beans or imported beans<br>
     * @return the inserted or updated B bean
     * @throws DaoException
     */
    public B saveCollectionAsTransaction(B bean,Object ...args)throws DaoException;
        
    /**
     * Load all the elements using a SQL statement specifying a list of fields to be retrieved.
     * @param sql the SQL statement for retrieving
     * @param argList the arguments to use fill given prepared statement,may be null
     * @param fieldList table of the field's associated constants
     * @return an array of B bean
     * @throws DaoException
     */
    public B[] loadBySql(String sql, Object[] argList, int[] fieldList)throws DaoException;
    
    /**
     * Load all elements using a SQL statement specifying a list of fields to be retrieved.
     * @param sql the SQL statement for retrieving
     * @param argList the arguments to use fill given prepared statement,may be null
     * @param fieldList table of the field's associated constants
     * @return an list of B bean
     * @throws DaoException
     */
    public List<B> loadBySqlAsList(String sql, Object[] argList, int[] fieldList)throws DaoException;
    
    /**
     * Load each the elements using a SQL statement specifying a list of fields to be retrieved and dealt by action.
     * @param sql the SQL statement for retrieving
     * @param argList the arguments to use fill given prepared statement,may be null
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */
    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<B> action)throws DaoException;
    /**
     * Run {@code Callable<T>} as a transaction.<br>
     * all exceptions but {@code SQLException} threw by {@code Callable<T>} is warpped into {@code RuntimeException}<br>
     * throw {@code NullPointerException} if {@code fun} be {@code null}<br>
     * @param <T>  type of return result
     * @param fun
     * @return
     * @throws DaoException
     */
    public<T> T runAsTransaction(Callable<T> fun)throws DaoException;

    /**
     * Run {@code Runnable} as a transaction.no return
     * @param fun
     * @see #runAsTransaction(Runnable)
     * @throws DaoException
     */
    public void runAsTransaction(Runnable fun)throws DaoException;
    
    /**
     * Retrieves the T object referenced by fkName.<br>
     * @param <T>
     * <ul>
     *     <li> for fl_device:
     *     <li> {@link Constant#FL_DEVICE_FK_GROUP_ID} - FlDeviceGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_device_group:
     *     <li> {@link Constant#FL_DEVICE_GROUP_FK_PARENT} - FlDeviceGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_face:
     *     <li> {@link Constant#FL_FACE_FK_FEATURE_MD5} - FlFeatureBean</li>
     *     <li> {@link Constant#FL_FACE_FK_IMAGE_MD5} - FlImageBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_feature:
     *     <li> {@link Constant#FL_FEATURE_FK_PERSON_ID} - FlPersonBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_image:
     *     <li> {@link Constant#FL_IMAGE_FK_DEVICE_ID} - FlDeviceBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_log:
     *     <li> {@link Constant#FL_LOG_FK_DEVICE_ID} - FlDeviceBean</li>
     *     <li> {@link Constant#FL_LOG_FK_COMPARE_FACE} - FlFaceBean</li>
     *     <li> {@link Constant#FL_LOG_FK_VERIFY_FEATURE} - FlFeatureBean</li>
     *     <li> {@link Constant#FL_LOG_FK_PERSON_ID} - FlPersonBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_permit:
     *     <li> {@link Constant#FL_PERMIT_FK_DEVICE_GROUP_ID} - FlDeviceGroupBean</li>
     *     <li> {@link Constant#FL_PERMIT_FK_PERSON_GROUP_ID} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_person:
     *     <li> {@link Constant#FL_PERSON_FK_IMAGE_MD5} - FlImageBean</li>
     *     <li> {@link Constant#FL_PERSON_FK_GROUP_ID} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_person_group:
     *     <li> {@link Constant#FL_PERSON_GROUP_FK_PARENT} - FlPersonGroupBean</li>
     * </ul>
     * @param bean the B object to use
     * @param fkIndex foreign key name.<br>
     *        for for fl_device table:<br>
     *        {@link Constant#FL_DEVICE_FK_GROUP_ID}<br>
     *        for for fl_device_group table:<br>
     *        {@link Constant#FL_DEVICE_GROUP_FK_PARENT}<br>
     *        for for fl_face table:<br>
     *        {@link Constant#FL_FACE_FK_FEATURE_MD5},{@link Constant#FL_FACE_FK_IMAGE_MD5}<br>
     *        for for fl_feature table:<br>
     *        {@link Constant#FL_FEATURE_FK_PERSON_ID}<br>
     *        for for fl_image table:<br>
     *        {@link Constant#FL_IMAGE_FK_DEVICE_ID}<br>
     *        for for fl_log table:<br>
     *        {@link Constant#FL_LOG_FK_DEVICE_ID},{@link Constant#FL_LOG_FK_COMPARE_FACE},{@link Constant#FL_LOG_FK_VERIFY_FEATURE},{@link Constant#FL_LOG_FK_PERSON_ID}<br>
     *        for for fl_permit table:<br>
     *        {@link Constant#FL_PERMIT_FK_DEVICE_GROUP_ID},{@link Constant#FL_PERMIT_FK_PERSON_GROUP_ID}<br>
     *        for for fl_person table:<br>
     *        {@link Constant#FL_PERSON_FK_IMAGE_MD5},{@link Constant#FL_PERSON_FK_GROUP_ID}<br>
     *        for for fl_person_group table:<br>
     *        {@link Constant#FL_PERSON_GROUP_FK_PARENT}<br>
     * @return the associated T bean or {@code null} if {@code bean}  is {@code null}
     * @throws DaoException
     */
    public <T extends BaseBean<T>> T getReferencedBean(B bean,int fkIndex)throws DaoException;
    
    /**
     * Associates the B object to the T object by fkName field.<br>
     * @param <T> see also {@link #getReferencedBean(BaseBean, int)}
     * @param bean the B object to use
     * @param beanToSet the T object to associate to the B bean
     * @param fkIndex see also {@link #getReferencedBean(BaseBean, int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    public <T extends BaseBean<T>> T setReferencedBean(B bean,T beanToSet,int fkIndex)throws DaoException;
    
    /**
     * Retrieves imported T objects by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> for fl_device table:
     *     <li> {@link Constant#FL_DEVICE_IK_FL_IMAGE_DEVICE_ID} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_DEVICE_IK_FL_LOG_DEVICE_ID} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_device_group table:
     *     <li> {@link Constant#FL_DEVICE_GROUP_IK_FL_DEVICE_GROUP_ID} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_DEVICE_GROUP_IK_FL_DEVICE_GROUP_PARENT} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_DEVICE_GROUP_IK_FL_PERMIT_DEVICE_GROUP_ID} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_face table:
     *     <li> {@link Constant#FL_FACE_IK_FL_LOG_COMPARE_FACE} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_feature table:
     *     <li> {@link Constant#FL_FEATURE_IK_FL_FACE_FEATURE_MD5} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_FEATURE_IK_FL_LOG_VERIFY_FEATURE} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_image table:
     *     <li> {@link Constant#FL_IMAGE_IK_FL_FACE_IMAGE_MD5} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_IMAGE_IK_FL_PERSON_IMAGE_MD5} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_person table:
     *     <li> {@link Constant#FL_PERSON_IK_FL_FEATURE_PERSON_ID} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_PERSON_IK_FL_LOG_PERSON_ID} - FlPersonGroupBean</li>
     * </ul>
     * <ul>
     *     <li> for fl_person_group table:
     *     <li> {@link Constant#FL_PERSON_GROUP_IK_FL_PERMIT_PERSON_GROUP_ID} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_PERSON_GROUP_IK_FL_PERSON_GROUP_ID} - FlPersonGroupBean</li>
     *     <li> {@link Constant#FL_PERSON_GROUP_IK_FL_PERSON_GROUP_PARENT} - FlPersonGroupBean</li>
     * </ul>
     * @param bean the B object to use
     * @param ikIndex foreign key name.<br>
     *        for fl_device table:<br>
     *        {@link Constant#FL_IMAGE_FK_DEVICE_ID},{@link Constant#FL_LOG_FK_DEVICE_ID}<br>
     *        for fl_device_group table:<br>
     *        {@link Constant#FL_DEVICE_FK_GROUP_ID},{@link Constant#FL_DEVICE_GROUP_FK_PARENT},{@link Constant#FL_PERMIT_FK_DEVICE_GROUP_ID}<br>
     *        for fl_face table:<br>
     *        {@link Constant#FL_LOG_FK_COMPARE_FACE}<br>
     *        for fl_feature table:<br>
     *        {@link Constant#FL_FACE_FK_FEATURE_MD5},{@link Constant#FL_LOG_FK_VERIFY_FEATURE}<br>
     *        for fl_image table:<br>
     *        {@link Constant#FL_FACE_FK_IMAGE_MD5},{@link Constant#FL_PERSON_FK_IMAGE_MD5}<br>
     *        for fl_person table:<br>
     *        {@link Constant#FL_FEATURE_FK_PERSON_ID},{@link Constant#FL_LOG_FK_PERSON_ID}<br>
     *        for fl_person_group table:<br>
     *        {@link Constant#FL_PERMIT_FK_PERSON_GROUP_ID},{@link Constant#FL_PERSON_FK_GROUP_ID},{@link Constant#FL_PERSON_GROUP_FK_PARENT}<br>
     * @return the associated T beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public <T extends BaseBean<T>> T[] getImportedBeans(B bean,int ikIndex)throws DaoException;
    
    /**
     * Retrieves imported T objects by ikIndex.<br>
     * @param <T> see also {@link #getImportedBeans(BaseBean, int)}
     * @param bean the B object to use
     * @param ikIndex foreign key name.see also {@link #getImportedBeans(BaseBean, int)}
     * @return the associated T beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public <T extends BaseBean<T>> List<T> getImportedBeansAsList(B bean,int ikIndex)throws DaoException;
    
    /**
     * Set the importedBeans associates to the bean by {@code ikIndex}<br>
     * 
     * @param <T> see also {@link #getImportedBeans(BaseBean, int)}
     * @param bean the bean object to use
     * @param importedBeans the T object to associate to bean
     * @param ikIndex foreign key name.see also {@link #getImportedBeans(BaseBean, int)}
     * @return importedBeans always
     * @throws DaoException
     */
    public <T extends BaseBean<T>> T[] setImportedBeans(B bean,T[] importedBeans,int ikIndex)throws DaoException;
    
    /**
     * Set the importedBeans associates to the bean by fkIndex<br>
     * 
     * @param <T> see also {@link #getImportedBeans(BaseBean, int)}
     * @param bean the bean object to use
     * @param importedBeans the T object to associate to bean
     * @param ikIndex foreign key name. see also {@link #getImportedBeans(BaseBean, int)}
     * @return importedBeans always
     * @throws DaoException
     */
    public <T extends BaseBean<T>,C extends Collection<T>> C setImportedBeans(B bean,C importedBeans,int ikIndex)throws DaoException;
}
