// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: manager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.device;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.Manager;
import net.gdface.facelog.dborm.TableListener;
import net.gdface.facelog.dborm.TableManager;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.DataAccessException;
import net.gdface.facelog.dborm.exception.DataRetrievalException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
import net.gdface.facelog.dborm.image.FlImageBean;
import net.gdface.facelog.dborm.image.FlImageManager;
import net.gdface.facelog.dborm.log.FlLogBean;
import net.gdface.facelog.dborm.log.FlLogManager;

/**
 * Handles database calls (save, load, count, etc...) for the fl_device table.<br>
 * Remarks: 前端设备基本信息<br>
 * @author sql2java
 */
public class FlDeviceManager extends TableManager.BaseAdapter<FlDeviceBean>
{
    /**
     * Tablename.
     */
    public static final String TABLE_NAME="fl_device";

    /**
     * Contains all the primary key fields of the fl_device table.
     */
    public static final String[] PRIMARYKEY_NAMES =
    {
        "id"
    };

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }
    
    @Override
    public String getFields() {
        return FL_DEVICE_FIELDS;
    }
    
    @Override
    public String getFullFields() {
        return FL_DEVICE_FULL_FIELDS;
    }

    @Override
    public String[] getPrimarykeyNames() {
        return PRIMARYKEY_NAMES;
    }

    private static FlDeviceManager singleton = new FlDeviceManager();
    protected FlDeviceManager(){}
    /**
     * Get the FlDeviceManager singleton.
     *
     * @return FlDeviceManager
     */
    public static FlDeviceManager getInstance()
    {
        return singleton;
    }


    /**
     * Creates a new FlDeviceBean instance.
     *
     * @return the new FlDeviceBean
     */
    public FlDeviceBean createBean()
    {
        return new FlDeviceBean();
    }
    
    @Override
    protected Class<FlDeviceBean> beanType(){
        return FlDeviceBean.class;
    }
    
    protected FlImageManager instanceOfFlImageManager(){
        return FlImageManager.getInstance();
    }
    protected FlLogManager instanceOfFlLogManager(){
        return FlLogManager.getInstance();
    }
    protected FlDeviceGroupManager instanceOfFlDeviceGroupManager(){
        return FlDeviceGroupManager.getInstance();
    }
    //////////////////////////////////////
    // PRIMARY KEY METHODS
    //////////////////////////////////////

    //1
    /**
     * Loads a {@link FlDeviceBean} from the fl_device using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlDeviceBean or {@code null} if not found or have null argument
     * @throws DaoException
     */
    public FlDeviceBean loadByPrimaryKey(Integer id) throws DaoException
    {
        try{
            return loadByPrimaryKeyChecked(id);
        }catch(ObjectRetrievalException e){
            // not found
            return null;
        }
    }
    
    //1.1
    /**
     * Loads a {@link FlDeviceBean} from the fl_device using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlDeviceBean
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public FlDeviceBean loadByPrimaryKeyChecked(Integer id) throws DaoException
    {
        if(null == id){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT " + FL_DEVICE_FIELDS + " FROM fl_device WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_DEVICE_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_DEVICE_ID_ID + 1, id); }
            List<FlDeviceBean> pReturn = this.loadByPreparedStatementAsList(ps);
            if (1 == pReturn.size()) {
                return pReturn.get(0);
            } else {
                throw new ObjectRetrievalException();
            }
        }
        catch(ObjectRetrievalException e)
        {
            throw e;
        }
        catch(SQLException e)
        {
            throw new DataRetrievalException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //1.2
    
    @Override
    public FlDeviceBean loadByPrimaryKey(FlDeviceBean bean) throws DaoException
    {
        return bean==null?null:loadByPrimaryKey(bean.getId());
    }
    
    //1.2.2
    
    @Override
    public FlDeviceBean loadByPrimaryKeyChecked(FlDeviceBean bean) throws DaoException
    {
        if(null == bean){
            throw new NullPointerException();
        }
        return loadByPrimaryKeyChecked(bean.getId());
    }
    
    //1.3
    /**
     * Loads a {@link FlDeviceBean} from the fl_device using primary key fields.
     * @param keys primary keys value:<br> 
     * @return a unique {@link FlDeviceBean} or {@code null} if not found
     * @see #loadByPrimaryKey(Integer id)
     */
    @Override
    public FlDeviceBean loadByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_DEVICE_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(null == keys[0]){
            return null;
        }
        return loadByPrimaryKey((Integer)keys[0]);
    }
    //1.3.2

    @Override
    public FlDeviceBean loadByPrimaryKeyChecked(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_DEVICE_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(! (keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        return loadByPrimaryKeyChecked((Integer)keys[0]);
    }
    //1.4
    /**
     * Returns true if this fl_device contains row with primary key fields.
     * @param id Integer - PK# 1
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public boolean existsPrimaryKey(Integer id) throws DaoException
    {
        if(null == id){
            return false;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try{
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_device WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_DEVICE_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_DEVICE_ID_ID + 1, id); }
            return 1 == this.countByPreparedStatement(ps);
        }catch(SQLException e){
            throw new ObjectRetrievalException(e);
        }finally{
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }
    //1.6
    /**
     * Return true if this fl_device contains row with primary key fields.
     * @param bean  
     * @throws DaoException
     * @return false if primary kes has null
     */
    @Override
    public boolean existsByPrimaryKey(FlDeviceBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return false;
        }
        long modified = bean.getModified();
        try{
            bean.resetModifiedExceptPrimaryKeys();
            return 1 == countUsingTemplate(bean);
        }finally{
            bean.setModified(modified);
        }
    }
    //1.7

    @Override
    public FlDeviceBean checkDuplicate(FlDeviceBean bean) throws DaoException{
        if(existsByPrimaryKey(bean)){
            throw new ObjectRetrievalException("Duplicate entry ("+ bean.getId() +") for key 'PRIMARY'");
        }
        return bean;
    }
    //1.4.1
    /**
     * Check duplicated row by primary keys,if row exists throw {@link ObjectRetrievalException}
     * @param id Integer
     * @throws DaoException
     * @see #existsPrimaryKey(Integer id)
     */
    public Integer checkDuplicate(Integer id) throws DaoException
    {
        if(existsPrimaryKey(id)){
            throw new ObjectRetrievalException("Duplicate entry '"+ id +"' for key 'PRIMARY'");
        }
        return id;
    }    
    //2
    /**
     * Delete row according to its primary keys.<br>
     * all keys must not be null
     * 
     * @param id Integer - PK# 1
     * @return the number of deleted rows
     * @throws DaoException
     * @see #delete(FlDeviceBean)
     */
    public int deleteByPrimaryKey(Integer id) throws DaoException
    {
        FlDeviceBean bean=createBean();
        bean.setId(id);
        return this.delete(bean);
    }

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    @Override
    public int delete(FlDeviceBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            // listener callback
            this.listenerContainer.beforeDelete(bean);
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_device WHERE id=?");
            // System.out.println("deleteByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getId() == null) { ps.setNull(FL_DEVICE_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_DEVICE_ID_ID + 1, bean.getId()); }
            int rows=ps.executeUpdate();
            if(rows>0){
                // listener callback
                this.listenerContainer.afterDelete(bean);
            }
            return rows;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value:<br> 
     * @return the number of deleted rows
     * @see #delete(FlDeviceBean)
     */   
    @Override
    public int deleteByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_DEVICE_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        FlDeviceBean bean = createBean();   
        
        if(null != keys[0] && !(keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        bean.setId((Integer)keys[0]);
        return delete(bean);
    }
 
    //////////////////////////////////////
    // IMPORT KEY GENERIC METHOD
    //////////////////////////////////////
    
    private static final Class<?>[] IMPORTED_BEAN_TYPES = new Class<?>[]{FlImageBean.class,FlLogBean.class};

    /**
     * @see #getImportedBeansAsList(FlDeviceBean,int)
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] getImportedBeans(FlDeviceBean bean, int ikIndex) throws DaoException {
        return getImportedBeansAsList(bean, ikIndex).toArray((T[])java.lang.reflect.Array.newInstance(IMPORTED_BEAN_TYPES[ikIndex],0));
    }
    
    /**
     * Retrieves imported T objects by ikIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_DEVICE_IK_FL_IMAGE_DEVICE_ID} - {@link FlImageBean}</li>
     *     <li> {@link Constant#FL_DEVICE_IK_FL_LOG_DEVICE_ID} - {@link FlLogBean}</li>
     * </ul>
     * @param bean the {@link FlDeviceBean} object to use
     * @param ikIndex valid values: {@link Constant#FL_DEVICE_IK_FL_IMAGE_DEVICE_ID},{@link Constant#FL_DEVICE_IK_FL_LOG_DEVICE_ID}
     * @return the associated T beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> List<T> getImportedBeansAsList(FlDeviceBean bean,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_DEVICE_IK_FL_IMAGE_DEVICE_ID:
            return (List<T>)this.getImageBeansByDeviceIdAsList(bean);
        case FL_DEVICE_IK_FL_LOG_DEVICE_ID:
            return (List<T>)this.getLogBeansByDeviceIdAsList(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    
    /**
     * Set the T objects as imported beans of bean object by ikIndex.<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlDeviceBean,int)}
     * @param bean the {@link FlDeviceBean} object to use
     * @param importedBeans the FlLogBean array to associate to the {@link FlDeviceBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlDeviceBean,int)}
     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] setImportedBeans(FlDeviceBean bean,T[] importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_DEVICE_IK_FL_IMAGE_DEVICE_ID:
            return (T[])setImageBeansByDeviceId(bean,(FlImageBean[])importedBeans);
        case FL_DEVICE_IK_FL_LOG_DEVICE_ID:
            return (T[])setLogBeansByDeviceId(bean,(FlLogBean[])importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    /**
     * Set the importedBeans associates to the bean by ikIndex<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlDeviceBean,int)}
     * @param bean the {@link FlDeviceBean} object to use
     * @param importedBeans the T object to associate to the {@link FlDeviceBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlDeviceBean,int)}

     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>,C extends java.util.Collection<T>> C setImportedBeans(FlDeviceBean bean,C importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_DEVICE_IK_FL_IMAGE_DEVICE_ID:
            return (C)setImageBeansByDeviceId(bean,(java.util.Collection<FlImageBean>)importedBeans);
        case FL_DEVICE_IK_FL_LOG_DEVICE_ID:
            return (C)setLogBeansByDeviceId(bean,(java.util.Collection<FlLogBean>)importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
 
    //////////////////////////////////////
    // GET/SET IMPORTED KEY BEAN METHOD
    //////////////////////////////////////
    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlImageBean} object from the fl_image.device_id field.<BR>
     * FK_NAME : fl_image_ibfk_1 
     * @param bean the {@link FlDeviceBean}
     * @return the associated {@link FlImageBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlImageBean[] getImageBeansByDeviceId(FlDeviceBean bean) throws DaoException
    {
        return getImageBeansByDeviceIdAsList(bean).toArray(new FlImageBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlImageBean} object from the fl_image.device_id field.<BR>
     * FK_NAME : fl_image_ibfk_1 
     * @param idOfDevice Integer - PK# 1
     * @return the associated {@link FlImageBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlImageBean[] getImageBeansByDeviceId(Integer idOfDevice) throws DaoException
    {
        FlDeviceBean bean = createBean();
        bean.setId(idOfDevice);
        return getImageBeansByDeviceId(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlImageBean} object from fl_image.device_id field.<BR>
     * FK_NAME:fl_image_ibfk_1
     * @param bean the {@link FlDeviceBean}
     * @return the associated {@link FlImageBean} beans 
     * @throws DaoException
     */
    public List<FlImageBean> getImageBeansByDeviceIdAsList(FlDeviceBean bean) throws DaoException
    {
        return getImageBeansByDeviceIdAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlImageBean} object from fl_image.device_id field.<BR>
     * FK_NAME:fl_image_ibfk_1
     * @param idOfDevice Integer - PK# 1
     * @return the associated {@link FlImageBean} beans 
     * @throws DaoException
     */
    public List<FlImageBean> getImageBeansByDeviceIdAsList(Integer idOfDevice) throws DaoException
    {
         FlDeviceBean bean = createBean();
        bean.setId(idOfDevice);
        return getImageBeansByDeviceIdAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlImageBean} object from fl_image.device_id field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_image_ibfk_1
     * @param bean the {@link FlDeviceBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlImageBean} beans 
     * @throws DaoException
     */
    public List<FlImageBean> getImageBeansByDeviceIdAsList(FlDeviceBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlImageBean>();
        }
        FlImageBean other = new FlImageBean();
        other.setDeviceId(bean.getId());
        return instanceOfFlImageManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlImageBean} object array associate to FlDeviceBean by the fl_image.device_id field.<BR>
     * FK_NAME : fl_image_ibfk_1 
     * @param bean the referenced {@link FlDeviceBean}
     * @param importedBeans imported beans from fl_image
     * @return importedBeans always
     * @throws DaoException
     * @see FlImageManager#setReferencedByDeviceId(FlImageBean, FlDeviceBean)
     */
    public FlImageBean[] setImageBeansByDeviceId(FlDeviceBean bean , FlImageBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlImageBean importBean : importedBeans ){
                instanceOfFlImageManager().setReferencedByDeviceId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlImageBean} object collection associate to FlDeviceBean by the fl_image.device_id field.<BR>
     * FK_NAME:fl_image_ibfk_1
     * @param bean the referenced {@link FlDeviceBean} 
     * @param importedBeans imported beans from fl_image 
     * @return importedBeans always
     * @throws DaoException
     * @see FlImageManager#setReferencedByDeviceId(FlImageBean, FlDeviceBean)
     */
    public <C extends java.util.Collection<FlImageBean>> C setImageBeansByDeviceId(FlDeviceBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlImageBean importBean : importedBeans ){
                instanceOfFlImageManager().setReferencedByDeviceId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from the fl_log.device_id field.<BR>
     * FK_NAME : fl_log_ibfk_2 
     * @param bean the {@link FlDeviceBean}
     * @return the associated {@link FlLogBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlLogBean[] getLogBeansByDeviceId(FlDeviceBean bean) throws DaoException
    {
        return getLogBeansByDeviceIdAsList(bean).toArray(new FlLogBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from the fl_log.device_id field.<BR>
     * FK_NAME : fl_log_ibfk_2 
     * @param idOfDevice Integer - PK# 1
     * @return the associated {@link FlLogBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlLogBean[] getLogBeansByDeviceId(Integer idOfDevice) throws DaoException
    {
        FlDeviceBean bean = createBean();
        bean.setId(idOfDevice);
        return getLogBeansByDeviceId(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.device_id field.<BR>
     * FK_NAME:fl_log_ibfk_2
     * @param bean the {@link FlDeviceBean}
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByDeviceIdAsList(FlDeviceBean bean) throws DaoException
    {
        return getLogBeansByDeviceIdAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.device_id field.<BR>
     * FK_NAME:fl_log_ibfk_2
     * @param idOfDevice Integer - PK# 1
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByDeviceIdAsList(Integer idOfDevice) throws DaoException
    {
         FlDeviceBean bean = createBean();
        bean.setId(idOfDevice);
        return getLogBeansByDeviceIdAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.device_id field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_log_ibfk_2
     * @param bean the {@link FlDeviceBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByDeviceIdAsList(FlDeviceBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlLogBean>();
        }
        FlLogBean other = new FlLogBean();
        other.setDeviceId(bean.getId());
        return instanceOfFlLogManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlLogBean} object array associate to FlDeviceBean by the fl_log.device_id field.<BR>
     * FK_NAME : fl_log_ibfk_2 
     * @param bean the referenced {@link FlDeviceBean}
     * @param importedBeans imported beans from fl_log
     * @return importedBeans always
     * @throws DaoException
     * @see FlLogManager#setReferencedByDeviceId(FlLogBean, FlDeviceBean)
     */
    public FlLogBean[] setLogBeansByDeviceId(FlDeviceBean bean , FlLogBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlLogBean importBean : importedBeans ){
                instanceOfFlLogManager().setReferencedByDeviceId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlLogBean} object collection associate to FlDeviceBean by the fl_log.device_id field.<BR>
     * FK_NAME:fl_log_ibfk_2
     * @param bean the referenced {@link FlDeviceBean} 
     * @param importedBeans imported beans from fl_log 
     * @return importedBeans always
     * @throws DaoException
     * @see FlLogManager#setReferencedByDeviceId(FlLogBean, FlDeviceBean)
     */
    public <C extends java.util.Collection<FlLogBean>> C setLogBeansByDeviceId(FlDeviceBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlLogBean importBean : importedBeans ){
                instanceOfFlLogManager().setReferencedByDeviceId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.5 SYNC SAVE 
    /**
     * Save the FlDeviceBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlDeviceBean} bean to be saved
     * @param refDevicegroupByGroupId the {@link FlDeviceGroupBean} bean referenced by {@link FlDeviceBean} 
     * @param impImageByDeviceId the {@link FlImageBean} beans refer to {@link FlDeviceBean} 
     * @param impLogByDeviceId the {@link FlLogBean} beans refer to {@link FlDeviceBean} 
     * @return the inserted or updated {@link FlDeviceBean} bean
     * @throws DaoException
     */
    public FlDeviceBean save(FlDeviceBean bean
        , FlDeviceGroupBean refDevicegroupByGroupId 
        , FlImageBean[] impImageByDeviceId , FlLogBean[] impLogByDeviceId ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refDevicegroupByGroupId){
            this.setReferencedByGroupId(bean,refDevicegroupByGroupId);
        }
        bean = this.save( bean );
        if(null != impImageByDeviceId){
            this.setImageBeansByDeviceId(bean,impImageByDeviceId);
            instanceOfFlImageManager().save( impImageByDeviceId );
        }
        if(null != impLogByDeviceId){
            this.setLogBeansByDeviceId(bean,impLogByDeviceId);
            instanceOfFlLogManager().save( impLogByDeviceId );
        }
        return bean;
    } 

    //3.6 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlDeviceBean , FlDeviceGroupBean , FlImageBean[] , FlLogBean[] )
     */
    public FlDeviceBean saveAsTransaction(final FlDeviceBean bean
        ,final FlDeviceGroupBean refDevicegroupByGroupId 
        ,final FlImageBean[] impImageByDeviceId ,final FlLogBean[] impLogByDeviceId ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlDeviceBean>(){
            @Override
            public FlDeviceBean call() throws Exception {
                return save(bean , refDevicegroupByGroupId , impImageByDeviceId , impLogByDeviceId );
            }});
    }
    //3.7 SYNC SAVE 
    /**
     * Save the FlDeviceBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlDeviceBean} bean to be saved
     * @param refDevicegroupByGroupId the {@link FlDeviceGroupBean} bean referenced by {@link FlDeviceBean} 
     * @param impImageByDeviceId the {@link FlImageBean} bean refer to {@link FlDeviceBean} 
     * @param impLogByDeviceId the {@link FlLogBean} bean refer to {@link FlDeviceBean} 
     * @return the inserted or updated {@link FlDeviceBean} bean
     * @throws DaoException
     */
    public FlDeviceBean save(FlDeviceBean bean
        , FlDeviceGroupBean refDevicegroupByGroupId 
        , java.util.Collection<FlImageBean> impImageByDeviceId , java.util.Collection<FlLogBean> impLogByDeviceId ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refDevicegroupByGroupId){
            this.setReferencedByGroupId(bean,refDevicegroupByGroupId);
        }
        bean = this.save( bean );
        if(null != impImageByDeviceId){
            this.setImageBeansByDeviceId(bean,impImageByDeviceId);
            instanceOfFlImageManager().save( impImageByDeviceId );
        }
        if(null != impLogByDeviceId){
            this.setLogBeansByDeviceId(bean,impLogByDeviceId);
            instanceOfFlLogManager().save( impLogByDeviceId );
        }
        return bean;
    }

    //3.8 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlDeviceBean , FlDeviceGroupBean , java.util.Collection , java.util.Collection )
     * @throws DaoException
     */
    public FlDeviceBean saveAsTransaction(final FlDeviceBean bean
        ,final FlDeviceGroupBean refDevicegroupByGroupId 
        ,final  java.util.Collection<FlImageBean> impImageByDeviceId ,final  java.util.Collection<FlLogBean> impLogByDeviceId ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlDeviceBean>(){
            @Override
            public FlDeviceBean call() throws Exception {
                return save(bean , refDevicegroupByGroupId , impImageByDeviceId , impLogByDeviceId );
            }});
    }

    private static final int SYNC_SAVE_ARG_LEN = 3;
    private static final int SYNC_SAVE_ARG_0 = 0;
    private static final int SYNC_SAVE_ARG_1 = 1;
    private static final int SYNC_SAVE_ARG_2 = 2;
    //3.9 SYNC SAVE 
    /**
     * Save the FlDeviceBean bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the {@link FlDeviceBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlDeviceBean , FlDeviceGroupBean , FlImageBean[] , FlLogBean[] )}
     * @return the inserted or updated {@link FlDeviceBean} bean
     * @throws DaoException
     */
    @Override
    public FlDeviceBean save(FlDeviceBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 3");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlDeviceGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.1 dynamic argument,expected type:FlDeviceGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlImageBean[])){
            throw new IllegalArgumentException("invalid type for the No.2 dynamic argument,expected type:FlImageBean[]");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof FlLogBean[])){
            throw new IllegalArgumentException("invalid type for the No.3 dynamic argument,expected type:FlLogBean[]");
        }
        return save(bean,
                    (FlDeviceGroupBean)args[SYNC_SAVE_ARG_0],
                    (FlImageBean[])args[SYNC_SAVE_ARG_1],
                    (FlLogBean[])args[SYNC_SAVE_ARG_2]);
    } 

    //3.10 SYNC SAVE 
    /**
     * Save the FlDeviceBean bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the {@link FlDeviceBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlDeviceBean , FlDeviceGroupBean , java.util.Collection , java.util.Collection )}
     * @return the inserted or updated {@link FlDeviceBean} bean
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public FlDeviceBean saveCollection(FlDeviceBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 3");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlDeviceGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:FlDeviceGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:java.util.Collection<FlImageBean>");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.3 argument,expected type:java.util.Collection<FlLogBean>");
        }
        return save(bean,
                    (FlDeviceGroupBean)args[SYNC_SAVE_ARG_0],
                    (java.util.Collection<FlImageBean>)args[SYNC_SAVE_ARG_1],
                    (java.util.Collection<FlLogBean>)args[SYNC_SAVE_ARG_2]);
    } 
    //////////////////////////////////////
    // FOREIGN KEY GENERIC METHOD
    //////////////////////////////////////

    /**
     * Retrieves the bean object referenced by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_DEVICE_FK_GROUP_ID} - {@link FlDeviceGroupBean}</li>
     * </ul>
     * @param bean the {@link FlDeviceBean} object to use
     * @param fkIndex valid values: <br>
     *        {@link Constant#FL_DEVICE_FK_GROUP_ID}
     * @return the associated T bean or {@code null} if {@code bean} or {@code beanToSet} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T getReferencedBean(FlDeviceBean bean,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_DEVICE_FK_GROUP_ID:
            return  (T)this.getReferencedByGroupId(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
    
    /**
     * Associates the {@link FlDeviceBean} object to the bean object by fkIndex field.<br>
     * 
     * @param <T> see also {@link #getReferencedBean(FlDeviceBean,int)}
     * @param bean the {@link FlDeviceBean} object to use
     * @param beanToSet the T object to associate to the {@link FlDeviceBean}
     * @param fkIndex valid values: see also {@link #getReferencedBean(FlDeviceBean,int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T setReferencedBean(FlDeviceBean bean,T beanToSet,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_DEVICE_FK_GROUP_ID:
            return  (T)this.setReferencedByGroupId(bean, (FlDeviceGroupBean)beanToSet);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
     
    //////////////////////////////////////
    // GET/SET FOREIGN KEY BEAN METHOD
    //////////////////////////////////////


    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlDeviceGroupBean} object referenced by {@link FlDeviceBean#getGroupId}() field.<br>
     * FK_NAME : fl_device_ibfk_1
     * @param bean the {@link FlDeviceBean}
     * @return the associated {@link FlDeviceGroupBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlDeviceGroupBean getReferencedByGroupId(FlDeviceBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByGroupId(instanceOfFlDeviceGroupManager().loadByPrimaryKey(bean.getGroupId())); 
        return bean.getReferencedByGroupId();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlDeviceBean} object to the {@link FlDeviceGroupBean} object by {@link FlDeviceBean#getGroupId}() field.
     *
     * @param bean the {@link FlDeviceBean} object to use
     * @param beanToSet the {@link FlDeviceGroupBean} object to associate to the {@link FlDeviceBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlDeviceGroupBean setReferencedByGroupId(FlDeviceBean bean, FlDeviceGroupBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlDeviceGroupManager().save(beanToSet);
            bean.setReferencedByGroupId(beanToSet);
            if( null == beanToSet){
                bean.setGroupId(null);
            }else{
                bean.setGroupId(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //11
    /**
     * Deletes rows from the fl_device table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    @Override
    public int deleteByWhere(String where) throws DaoException
    {
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action = new DeleteBeanAction(); 
            this.loadByWhere(where,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;

        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_device " + where);
            // System.out.println("deleteByWhere: " + sql);
            ps = c.prepareStatement(sql.toString());
            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________

    //13

    @Override
    public FlDeviceBean insert(FlDeviceBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean; 
        }
        if (!bean.isNew()){
            return this.update(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();
            // listener callback
            this.listenerContainer.beforeInsert(bean);
            int dirtyCount = 0;
            sql = new StringBuilder("INSERT into fl_device (");

            if (bean.checkIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("id");
                dirtyCount++;
            }

            if (bean.checkGroupIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("group_id");
                dirtyCount++;
            }

            if (bean.checkNameModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("name");
                dirtyCount++;
            }

            if (bean.checkProductNameModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("product_name");
                dirtyCount++;
            }

            if (bean.checkModelModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("model");
                dirtyCount++;
            }

            if (bean.checkVendorModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("vendor");
                dirtyCount++;
            }

            if (bean.checkManufacturerModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("manufacturer");
                dirtyCount++;
            }

            if (bean.checkMadeDateModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("made_date");
                dirtyCount++;
            }

            if (bean.checkVersionModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("version");
                dirtyCount++;
            }

            if (bean.checkSerialNoModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("serial_no");
                dirtyCount++;
            }

            if (bean.checkMacModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("mac");
                dirtyCount++;
            }

            if (bean.checkRemarkModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("remark");
                dirtyCount++;
            }

            if (bean.checkExtBinModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_bin");
                dirtyCount++;
            }

            if (bean.checkExtTxtModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_txt");
                dirtyCount++;
            }

            if (bean.checkCreateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("create_time");
                dirtyCount++;
            }

            if (bean.checkUpdateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("update_time");
                dirtyCount++;
            }

            sql.append(") values (");
            if(dirtyCount > 0) {
                sql.append("?");
                for(int i = 1; i < dirtyCount; i++) {
                    sql.append(",?");
                }
            }
            sql.append(")");


            // System.out.println("insert : " + sql.toString());

            ps = c.prepareStatement(sql.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);

            this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            ps.executeUpdate();

            if (!bean.checkIdModified())
            {
                PreparedStatement ps2 = null;
                ResultSet rs = null;
                try {
                    ps2 = c.prepareStatement("SELECT last_insert_id()");
                    rs = ps2.executeQuery();
                    if(rs.next()) {
                        bean.setId(Manager.getInteger(rs, 1));
                    } else {
                        this.getManager().log("ATTENTION: Could not retrieve generated key!");
                    }
                } finally {
                    this.getManager().close(ps2, rs);
                }
            }

            bean.isNew(false);
            bean.resetIsModified();
            // listener callback
            this.listenerContainer.afterInsert(bean);
            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //14

    @Override
    public FlDeviceBean update(FlDeviceBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean;
        }
        if (bean.isNew()){
            return this.insert(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();

            // listener callback
            this.listenerContainer.beforeUpdate(bean); 
            sql = new StringBuilder("UPDATE fl_device SET ");
            boolean useComma=false;

            if (bean.checkIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("id=?");
            }

            if (bean.checkGroupIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("group_id=?");
            }

            if (bean.checkNameModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("name=?");
            }

            if (bean.checkProductNameModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("product_name=?");
            }

            if (bean.checkModelModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("model=?");
            }

            if (bean.checkVendorModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("vendor=?");
            }

            if (bean.checkManufacturerModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("manufacturer=?");
            }

            if (bean.checkMadeDateModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("made_date=?");
            }

            if (bean.checkVersionModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("version=?");
            }

            if (bean.checkSerialNoModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("serial_no=?");
            }

            if (bean.checkMacModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("mac=?");
            }

            if (bean.checkRemarkModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("remark=?");
            }

            if (bean.checkExtBinModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_bin=?");
            }

            if (bean.checkExtTxtModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_txt=?");
            }

            if (bean.checkCreateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("create_time=?");
            }

            if (bean.checkUpdateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("update_time=?");
            }
            sql.append(" WHERE ");
            sql.append("id=?");
            // System.out.println("update : " + sql.toString());
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);

            int dirtyCount = this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            if (dirtyCount == 0) {
                // System.out.println("The bean to look is not initialized... do not update.");
                return bean;
            }

            if (bean.getId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            ps.executeUpdate();
            // listener callback
            this.listenerContainer.afterUpdate(bean); 
            bean.resetIsModified();

            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18

    @Override
    public FlDeviceBean loadUniqueUsingTemplate(FlDeviceBean bean) throws DaoException
    {
         List<FlDeviceBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             return null;
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //18-1

    @Override
    public FlDeviceBean loadUniqueUsingTemplateChecked(FlDeviceBean bean) throws DaoException
    {
         List<FlDeviceBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             throw new ObjectRetrievalException("Not found element !!");
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //20-5

    @Override
    public int loadUsingTemplate(FlDeviceBean bean, int[] fieldList, int startRow, int numRows,int searchType, Action<FlDeviceBean> action) throws DaoException
    {
        // System.out.println("loadUsingTemplate startRow:" + startRow + ", numRows:" + numRows + ", searchType:" + searchType);
        StringBuilder sqlWhere = new StringBuilder("");
        String sql=createSelectSql(fieldList,this.fillWhere(sqlWhere, bean, searchType) > 0?" WHERE "+sqlWhere.toString():null);
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }

    //21

    @Override
    public int deleteUsingTemplate(FlDeviceBean bean) throws DaoException
    {
        if(bean.checkIdInitialized() && null != bean.getId()){
            return this.deleteByPrimaryKey(bean.getId());
        }
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action=new DeleteBeanAction(); 
            this.loadUsingTemplate(bean,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("DELETE FROM fl_device ");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... deleting all");
            }
            // System.out.println("deleteUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, SEARCH_EXACT, false);

            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }


    //_____________________________________________________________________
    //
    // USING INDICES
    //_____________________________________________________________________


    /**
     * Retrieves an unique FlDeviceBean using the mac index.
     * 
     * @param mac the mac column's value filter
     * @return an FlDeviceBean,otherwise null if not found or exists null in input arguments
     * @throws DaoException
     */
    public FlDeviceBean loadByIndexMac(String mac) throws DaoException
    {
        try{
            return loadByIndexMacChecked(mac);
        }catch(ObjectRetrievalException e){
            return null;
        }
    }
    /**
     * Retrieves an unique FlDeviceBean using the mac index.
     * 
     * @param mac the mac column's value filter. must not be null
     * @return an FlDeviceBean
     * @throws NullPointerException exists null in input arguments
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    public FlDeviceBean loadByIndexMacChecked(String mac) throws DaoException
    {
        FlDeviceBean bean = new FlDeviceBean();
        if(null == mac){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        
        bean.setMac(mac);
        
        return loadUniqueUsingTemplateChecked(bean);
    }
    /**
     * Retrieves an unique FlDeviceBean for each mac index.
     *
     * @param indexs index array
     * @return an list of FlDeviceBean
     * @throws DaoException
     */
    public java.util.List<FlDeviceBean> loadByIndexMac(String... indexs)throws DaoException
    {
        if(null == indexs){
            return new java.util.ArrayList<FlDeviceBean>();
        }
        java.util.ArrayList<FlDeviceBean> list = new java.util.ArrayList<FlDeviceBean>(indexs.length);
        for(int i = 0 ;i< indexs.length;++i){
            list.add(loadByIndexMac(indexs[i]));
        }
        return list;
    }
    /**
     * Retrieves an unique FlDeviceBean for each mac index.
     *
     * @param indexs index array
     * @return an list of FlDeviceBean
     * @throws DaoException
     */
    public java.util.List<FlDeviceBean> loadByIndexMac(java.util.Collection<String> indexs)throws DaoException
    {
        if(null == indexs ){
            return new java.util.ArrayList<FlDeviceBean>();
        }
        java.util.ArrayList<FlDeviceBean> list = new java.util.ArrayList<FlDeviceBean>(indexs.size());
        if(indexs instanceof java.util.List){
            for(String key: indexs){
                list.add(loadByIndexMac(key));
            }
        }else{
            FlDeviceBean bean;
            for(String key: indexs){
                if(null != (bean = loadByIndexMac(key))){
                    list.add(bean);
                }
            }
        }
        return list;
    }
    /**
     * Deletes rows for each mac index.
     *
     * @param indexs index array
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexMac(String... indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexMac(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows for each mac index.
     *
     * @param indexs index collection
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexMac(java.util.Collection<String> indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexMac(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows using the mac index.
     *
     * @param mac the mac column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexMac(String mac) throws DaoException
    {
        FlDeviceBean bean = this.createBean();
        bean.setMac(mac);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an unique FlDeviceBean using the serial_no index.
     * 
     * @param serialNo the serial_no column's value filter
     * @return an FlDeviceBean,otherwise null if not found or exists null in input arguments
     * @throws DaoException
     */
    public FlDeviceBean loadByIndexSerialNo(String serialNo) throws DaoException
    {
        try{
            return loadByIndexSerialNoChecked(serialNo);
        }catch(ObjectRetrievalException e){
            return null;
        }
    }
    /**
     * Retrieves an unique FlDeviceBean using the serial_no index.
     * 
     * @param serialNo the serial_no column's value filter. must not be null
     * @return an FlDeviceBean
     * @throws NullPointerException exists null in input arguments
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    public FlDeviceBean loadByIndexSerialNoChecked(String serialNo) throws DaoException
    {
        FlDeviceBean bean = new FlDeviceBean();
        if(null == serialNo){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        
        bean.setSerialNo(serialNo);
        
        return loadUniqueUsingTemplateChecked(bean);
    }
    /**
     * Retrieves an unique FlDeviceBean for each serial_no index.
     *
     * @param indexs index array
     * @return an list of FlDeviceBean
     * @throws DaoException
     */
    public java.util.List<FlDeviceBean> loadByIndexSerialNo(String... indexs)throws DaoException
    {
        if(null == indexs){
            return new java.util.ArrayList<FlDeviceBean>();
        }
        java.util.ArrayList<FlDeviceBean> list = new java.util.ArrayList<FlDeviceBean>(indexs.length);
        for(int i = 0 ;i< indexs.length;++i){
            list.add(loadByIndexSerialNo(indexs[i]));
        }
        return list;
    }
    /**
     * Retrieves an unique FlDeviceBean for each serial_no index.
     *
     * @param indexs index array
     * @return an list of FlDeviceBean
     * @throws DaoException
     */
    public java.util.List<FlDeviceBean> loadByIndexSerialNo(java.util.Collection<String> indexs)throws DaoException
    {
        if(null == indexs ){
            return new java.util.ArrayList<FlDeviceBean>();
        }
        java.util.ArrayList<FlDeviceBean> list = new java.util.ArrayList<FlDeviceBean>(indexs.size());
        if(indexs instanceof java.util.List){
            for(String key: indexs){
                list.add(loadByIndexSerialNo(key));
            }
        }else{
            FlDeviceBean bean;
            for(String key: indexs){
                if(null != (bean = loadByIndexSerialNo(key))){
                    list.add(bean);
                }
            }
        }
        return list;
    }
    /**
     * Deletes rows for each serial_no index.
     *
     * @param indexs index array
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexSerialNo(String... indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexSerialNo(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows for each serial_no index.
     *
     * @param indexs index collection
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexSerialNo(java.util.Collection<String> indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexSerialNo(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows using the serial_no index.
     *
     * @param serialNo the serial_no column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexSerialNo(String serialNo) throws DaoException
    {
        FlDeviceBean bean = this.createBean();
        bean.setSerialNo(serialNo);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlDeviceBean using the group_id index.
     *
     * @param groupId the group_id column's value filter.
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public FlDeviceBean[] loadByIndexGroupId(Integer groupId) throws DaoException
    {
        return (FlDeviceBean[])this.loadByIndexGroupIdAsList(groupId).toArray(new FlDeviceBean[0]);
    }
    
    /**
     * Retrieves a list of FlDeviceBean using the group_id index.
     *
     * @param groupId the group_id column's value filter.
     * @return a list of FlDeviceBean
     * @throws DaoException
     */
    public List<FlDeviceBean> loadByIndexGroupIdAsList(Integer groupId) throws DaoException
    {
        FlDeviceBean bean = this.createBean();
        bean.setGroupId(groupId);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the group_id index.
     *
     * @param groupId the group_id column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexGroupId(Integer groupId) throws DaoException
    {
        FlDeviceBean bean = this.createBean();
        bean.setGroupId(groupId);
        return deleteUsingTemplate(bean);
    }
    
    
    /**
     * Retrieves a list of FlDeviceBean using the index specified by keyIndex.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_DEVICE_INDEX_MAC},{@link Constant#FL_DEVICE_INDEX_SERIAL_NO},{@link Constant#FL_DEVICE_INDEX_GROUP_ID}
     * @param keys key values of index
     * @return a list of FlDeviceBean
     * @throws DaoException
     */
    @Override
    public List<FlDeviceBean> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_DEVICE_INDEX_MAC:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'mac' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            FlDeviceBean bean= this.loadByIndexMac((String)keys[0]);
            return null == bean ? new java.util.ArrayList<FlDeviceBean>() : java.util.Arrays.asList(bean);
        }
        case FL_DEVICE_INDEX_SERIAL_NO:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'serial_no' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            FlDeviceBean bean= this.loadByIndexSerialNo((String)keys[0]);
            return null == bean ? new java.util.ArrayList<FlDeviceBean>() : java.util.Arrays.asList(bean);
        }
        case FL_DEVICE_INDEX_GROUP_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'group_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.loadByIndexGroupIdAsList((Integer)keys[0]);        
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }
    }
    
    /**
     * Deletes rows using key.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_DEVICE_INDEX_MAC},{@link Constant#FL_DEVICE_INDEX_SERIAL_NO},{@link Constant#FL_DEVICE_INDEX_GROUP_ID}
     * @param keys key values of index
     * @return the number of deleted objects
     * @throws DaoException
     */
    @Override
    public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_DEVICE_INDEX_MAC:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'mac' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexMac((String)keys[0]);
        }
        case FL_DEVICE_INDEX_SERIAL_NO:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'serial_no' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexSerialNo((String)keys[0]);
        }
        case FL_DEVICE_INDEX_GROUP_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'group_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.deleteByIndexGroupId((Integer)keys[0]);
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }        
    }


    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________

    //25

    @Override
    public int countWhere(String where) throws DaoException
    {
        String sql = new StringBuffer("SELECT COUNT(*) AS MCOUNT FROM fl_person ")
    		    .append(null == where ? "" : where).toString();
        // System.out.println("countWhere: " + sql);
        Connection c = null;
        Statement st = null;
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement();
            rs =  st.executeQuery(sql);
            if (rs.next())
            {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(st, rs);
            this.freeConnection(c);
            sql = null;
        }
        throw new DataAccessException("Error in countWhere where=[" + where + "]");
    }

    //26
    /**
     * Retrieves the number of rows of the table fl_device with a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return the number of rows returned
     * @throws DaoException
     */
    private int countByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(rs);
        }
       throw new DataAccessException("Error in countByPreparedStatement");
    }

    //20
    /**
     * count the number of elements of a specific FlDeviceBean bean given the search type
     *
     * @param bean the FlDeviceBean template to look for
     * @param searchType exact ?  like ? starting like ?
     * @return the number of rows returned
     * @throws DaoException
     */
    @Override
    public int countUsingTemplate(FlDeviceBean bean, int searchType) throws DaoException
    {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_device");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... counting all...");
            }
            // System.out.println("countUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);

            return this.countByPreparedStatement(ps);
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    /**
     * fills the given StringBuilder with the sql where clauses constructed using the bean and the search type
     * @param sqlWhere the StringBuilder that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @return the number of clauses returned
     */
    protected int fillWhere(StringBuilder sqlWhere, FlDeviceBean bean, int searchType)
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == SEARCH_EXACT ? "=" : " like ";
        try
        {
            if (bean.checkIdModified()) {
                dirtyCount ++;
                if (bean.getId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id = ?");
                }
            }
            if (bean.checkGroupIdModified()) {
                dirtyCount ++;
                if (bean.getGroupId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("group_id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("group_id = ?");
                }
            }
            if (bean.checkNameModified()) {
                dirtyCount ++;
                if (bean.getName() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("name IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("name ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkProductNameModified()) {
                dirtyCount ++;
                if (bean.getProductName() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("product_name IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("product_name ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkModelModified()) {
                dirtyCount ++;
                if (bean.getModel() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("model IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("model ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkVendorModified()) {
                dirtyCount ++;
                if (bean.getVendor() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("vendor IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("vendor ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkManufacturerModified()) {
                dirtyCount ++;
                if (bean.getManufacturer() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("manufacturer IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("manufacturer ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkMadeDateModified()) {
                dirtyCount ++;
                if (bean.getMadeDate() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("made_date IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("made_date = ?");
                }
            }
            if (bean.checkVersionModified()) {
                dirtyCount ++;
                if (bean.getVersion() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("version IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("version ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkSerialNoModified()) {
                dirtyCount ++;
                if (bean.getSerialNo() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("serial_no IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("serial_no ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkMacModified()) {
                dirtyCount ++;
                if (bean.getMac() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mac IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mac ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkRemarkModified()) {
                dirtyCount ++;
                if (bean.getRemark() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkExtBinModified()) {
                dirtyCount ++;
                if (bean.getExtBin() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin = ?");
                }
            }
            if (bean.checkExtTxtModified()) {
                dirtyCount ++;
                if (bean.getExtTxt() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkCreateTimeModified()) {
                dirtyCount ++;
                if (bean.getCreateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time = ?");
                }
            }
            if (bean.checkUpdateTimeModified()) {
                dirtyCount ++;
                if (bean.getUpdateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("update_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("update_time = ?");
                }
            }
        }
        finally
        {
            sqlEqualsOperation = null;
        }
        return dirtyCount;
    }

    /**
     * fill the given prepared statement with the bean values and a search type
     * @param ps the PreparedStatement that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @param fillNull wether fill null for null field
     * @return the number of clauses returned
     * @throws DaoException
     */
    protected int fillPreparedStatement(PreparedStatement ps, FlDeviceBean bean, int searchType,boolean fillNull) throws DaoException
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        try
        {
            if (bean.checkIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getId() + "]");
                if (bean.getId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            }
            if (bean.checkGroupIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getGroupId() + "]");
                if (bean.getGroupId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getGroupId()); }
            }
            if (bean.checkNameModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getName() + "]");
                        if (bean.getName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getName()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getName() + "%]");
                        if ( bean.getName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getName() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getName() + "]");
                        if ( bean.getName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getName()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getName() + "%]");
                        if (bean.getName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getName() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkProductNameModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getProductName() + "]");
                        if (bean.getProductName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getProductName()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getProductName() + "%]");
                        if ( bean.getProductName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getProductName() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getProductName() + "]");
                        if ( bean.getProductName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getProductName()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getProductName() + "%]");
                        if (bean.getProductName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getProductName() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkModelModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getModel() + "]");
                        if (bean.getModel() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getModel()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getModel() + "%]");
                        if ( bean.getModel()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getModel() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getModel() + "]");
                        if ( bean.getModel() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getModel()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getModel() + "%]");
                        if (bean.getModel()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getModel() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkVendorModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getVendor() + "]");
                        if (bean.getVendor() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getVendor()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getVendor() + "%]");
                        if ( bean.getVendor()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getVendor() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getVendor() + "]");
                        if ( bean.getVendor() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getVendor()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getVendor() + "%]");
                        if (bean.getVendor()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getVendor() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkManufacturerModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getManufacturer() + "]");
                        if (bean.getManufacturer() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getManufacturer()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getManufacturer() + "%]");
                        if ( bean.getManufacturer()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getManufacturer() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getManufacturer() + "]");
                        if ( bean.getManufacturer() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getManufacturer()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getManufacturer() + "%]");
                        if (bean.getManufacturer()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getManufacturer() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkMadeDateModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getMadeDate() + "]");
                if (bean.getMadeDate() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.DATE);} } else { ps.setDate(++dirtyCount, new java.sql.Date(bean.getMadeDate().getTime())); }
            }
            if (bean.checkVersionModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getVersion() + "]");
                        if (bean.getVersion() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getVersion()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getVersion() + "%]");
                        if ( bean.getVersion()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getVersion() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getVersion() + "]");
                        if ( bean.getVersion() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getVersion()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getVersion() + "%]");
                        if (bean.getVersion()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getVersion() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkSerialNoModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getSerialNo() + "]");
                        if (bean.getSerialNo() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getSerialNo()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getSerialNo() + "%]");
                        if ( bean.getSerialNo()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getSerialNo() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getSerialNo() + "]");
                        if ( bean.getSerialNo() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getSerialNo()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getSerialNo() + "%]");
                        if (bean.getSerialNo()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getSerialNo() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkMacModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getMac() + "]");
                        if (bean.getMac() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getMac()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getMac() + "%]");
                        if ( bean.getMac()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getMac() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getMac() + "]");
                        if ( bean.getMac() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getMac()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getMac() + "%]");
                        if (bean.getMac()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getMac() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkRemarkModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "]");
                        if (bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "%]");
                        if ( bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "]");
                        if ( bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "%]");
                        if (bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkExtBinModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtBin() + "]");
                if (bean.getExtBin() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARBINARY);} } else { Manager.setBytes(Types.LONGVARBINARY,ps, ++dirtyCount, bean.getExtBin()); }
            }
            if (bean.checkExtTxtModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "]");
                        if (bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "%]");
                        if ( bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "]");
                        if ( bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "%]");
                        if (bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkCreateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getCreateTime() + "]");
                if (bean.getCreateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getCreateTime().getTime())); }
            }
            if (bean.checkUpdateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getUpdateTime() + "]");
                if (bean.getUpdateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getUpdateTime().getTime())); }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        return dirtyCount;
    }


    //_____________________________________________________________________
    //
    // DECODE RESULT SET
    //_____________________________________________________________________

    //28
    /**
     * decode a resultset in an array of FlDeviceBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlDeviceBean table
     * @throws DaoException
     */
    public FlDeviceBean[] decodeResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return this.decodeResultSetAsList(rs, fieldList, startRow, numRows).toArray(new FlDeviceBean[0]);
    }

    //28-1
    /**
     * decode a resultset in a list of FlDeviceBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlDeviceBean table
     * @throws DaoException
     */
    public List<FlDeviceBean> decodeResultSetAsList(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        actionOnResultSet(rs, fieldList, numRows, numRows, action);
        return action.getList();
    }
    //28-2
    /** decode a resultset and call action
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action interface obj for do something
     * @return the count dealt by action  
     * @throws DaoException
     * @throws IllegalArgumentException
     */
    public int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, Action<FlDeviceBean> action) throws DaoException{
        try{
            int count = 0;
            if(0!=numRows){
                if( startRow<1 ){
                    throw new IllegalArgumentException("invalid argument:startRow (must >=1)");
                }
                if( null==action || null==rs ){
                    throw new IllegalArgumentException("invalid argument:action OR rs (must not be null)");
                }
                for(;startRow > 1 && rs.next();){
                    --startRow;
                    //skip to last of startRow
                }
                if (fieldList == null) {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }
                }else {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }
                }
            }
            return count;
        }catch(DaoException e){
            throw e;
        }catch(SQLException e){
            throw new DataAccessException(e);
        }
    }

    //29
    /**
     * Transforms a ResultSet iterating on the fl_device on a FlDeviceBean bean.
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlDeviceBean bean
     * @throws DaoException
     */
    public FlDeviceBean decodeRow(ResultSet rs,FlDeviceBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        try
        {
            bean.setId(Manager.getInteger(rs, 1));
            bean.setGroupId(Manager.getInteger(rs, 2));
            bean.setName(rs.getString(3));
            bean.setProductName(rs.getString(4));
            bean.setModel(rs.getString(5));
            bean.setVendor(rs.getString(6));
            bean.setManufacturer(rs.getString(7));
            bean.setMadeDate(rs.getDate(8));
            bean.setVersion(rs.getString(9));
            bean.setSerialNo(rs.getString(10));
            bean.setMac(rs.getString(11));
            bean.setRemark(rs.getString(12));
            bean.setExtBin(Manager.getBytes(rs, 13));
            bean.setExtTxt(rs.getString(14));
            bean.setCreateTime(rs.getTimestamp(15));
            bean.setUpdateTime(rs.getTimestamp(16));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //30
    /**
     * Transforms a ResultSet iterating on the fl_device table on a FlDeviceBean bean according to a list of fields.
     *
     * @param rs the ResultSet to be transformed
     * @param fieldList table of the field's associated constants
     * @return bean resulting FlDeviceBean bean
     * @throws DaoException
     */
    public FlDeviceBean decodeRow(ResultSet rs, int[] fieldList,FlDeviceBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        int pos = 0;
        try
        {
            for(int i = 0; i < fieldList.length; i++)
            {
                switch(fieldList[i])
                {
                    case FL_DEVICE_ID_ID:
                        ++pos;
                        bean.setId(Manager.getInteger(rs, pos));
                        break;
                    case FL_DEVICE_ID_GROUP_ID:
                        ++pos;
                        bean.setGroupId(Manager.getInteger(rs, pos));
                        break;
                    case FL_DEVICE_ID_NAME:
                        ++pos;
                        bean.setName(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_PRODUCT_NAME:
                        ++pos;
                        bean.setProductName(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_MODEL:
                        ++pos;
                        bean.setModel(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_VENDOR:
                        ++pos;
                        bean.setVendor(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_MANUFACTURER:
                        ++pos;
                        bean.setManufacturer(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_MADE_DATE:
                        ++pos;
                        bean.setMadeDate(rs.getDate(pos));
                        break;
                    case FL_DEVICE_ID_VERSION:
                        ++pos;
                        bean.setVersion(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_SERIAL_NO:
                        ++pos;
                        bean.setSerialNo(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_MAC:
                        ++pos;
                        bean.setMac(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_REMARK:
                        ++pos;
                        bean.setRemark(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_EXT_BIN:
                        ++pos;
                        bean.setExtBin(Manager.getBytes(rs, pos));
                        break;
                    case FL_DEVICE_ID_EXT_TXT:
                        ++pos;
                        bean.setExtTxt(rs.getString(pos));
                        break;
                    case FL_DEVICE_ID_CREATE_TIME:
                        ++pos;
                        bean.setCreateTime(rs.getTimestamp(pos));
                        break;
                    case FL_DEVICE_ID_UPDATE_TIME:
                        ++pos;
                        bean.setUpdateTime(rs.getTimestamp(pos));
                        break;
                    default:
                        throw new DaoException("Unknown field id " + fieldList[i]);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //31
    /**
     * Transforms a ResultSet iterating on the fl_device on a FlDeviceBean bean using the names of the columns
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlDeviceBean bean
     * @throws DaoException
     */
    public FlDeviceBean metaDataDecodeRow(ResultSet rs) throws DaoException
    {
        FlDeviceBean bean = this.createBean();
        try
        {
            bean.setId(Manager.getInteger(rs, "id"));
            bean.setGroupId(Manager.getInteger(rs, "group_id"));
            bean.setName(rs.getString("name"));
            bean.setProductName(rs.getString("product_name"));
            bean.setModel(rs.getString("model"));
            bean.setVendor(rs.getString("vendor"));
            bean.setManufacturer(rs.getString("manufacturer"));
            bean.setMadeDate(rs.getDate("made_date"));
            bean.setVersion(rs.getString("version"));
            bean.setSerialNo(rs.getString("serial_no"));
            bean.setMac(rs.getString("mac"));
            bean.setRemark(rs.getString("remark"));
            bean.setExtBin(Manager.getBytes(rs, "ext_bin"));
            bean.setExtTxt(rs.getString("ext_txt"));
            bean.setCreateTime(rs.getTimestamp("create_time"));
            bean.setUpdateTime(rs.getTimestamp("update_time"));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }

        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //////////////////////////////////////
    // PREPARED STATEMENT LOADER
    //////////////////////////////////////

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public FlDeviceBean[] loadByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatement(ps, null);
    }

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public List<FlDeviceBean> loadByPreparedStatementAsList(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, null);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public FlDeviceBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, fieldList).toArray(new FlDeviceBean[0]);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public List<FlDeviceBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList) throws DaoException
    { 
        return loadByPreparedStatementAsList(ps,fieldList,1,-1);
    }

    //34
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public FlDeviceBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return loadByPreparedStatementAsList(ps,fieldList,startRow,numRows).toArray(new FlDeviceBean[0]);
    }

    //34-1
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlDeviceBean
     * @throws DaoException
     */
    public List<FlDeviceBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        loadByPreparedStatement(ps,fieldList,startRow,numRows,action);
        return action.getList();
    }
    //34-2
    /**
     * Loads each element using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows 
     * and dealt by action.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */     
    public int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows,Action<FlDeviceBean> action) throws DaoException
    {
        ResultSet rs =  null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            return this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(rs);
        }
    }
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    private final TableListener.ListenerContainer<FlDeviceBean> listenerContainer = new TableListener.ListenerContainer<FlDeviceBean>();

    //35

    @Override
    public TableListener<FlDeviceBean> registerListener(TableListener<FlDeviceBean> listener)
    {
        this.listenerContainer.add(listener);
        return listener;
    }

    //36
    /**
     * remove listener.
     */
    @Override
    public void unregisterListener(TableListener<FlDeviceBean> listener)
    {
        this.listenerContainer.remove(listener);
    }

    //37

    @Override
    public void fire(TableListener.Event event, FlDeviceBean bean) throws DaoException{
        if(null == event){
            throw new NullPointerException();
        }
        event.fire(listenerContainer, bean);
    }
    
    //37-1

    @Override
    public void fire(int event, FlDeviceBean bean) throws DaoException{
        try{
            fire(TableListener.Event.values()[event],bean);
        }catch(ArrayIndexOutOfBoundsException e){
            throw new IllegalArgumentException("invalid event id " + event);
        }
    }

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlDeviceGroupBean,FlDeviceBean> foreignKeyListenerByGroupId = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlDeviceGroupBean,FlDeviceBean>(){
                @Override
                protected List<FlDeviceBean> getImportedBeans(FlDeviceGroupBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlDeviceBean>emptyList()
                            : instanceOfFlDeviceGroupManager().getDeviceBeansByGroupIdAsList(bean);
                }
                @Override
                protected void onRemove(List<FlDeviceBean> effectBeans) throws DaoException {
                    for(FlDeviceBean bean:effectBeans){
                        bean.setGroupId(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    //37-2
    /**
     * bind foreign key listener to foreign table: <br>
     * DELETE RULE : SET_NULL {@code fl_device(group_id)- fl_device_group(id)} <br>
     */
    public void bindForeignKeyListenerForDeleteRule(){
        instanceOfFlDeviceGroupManager().registerListener(foreignKeyListenerByGroupId);
        
    }
    //37-3
    /**
     * unbind foreign key listener from all of foreign tables <br>
     * @see #bindForeignKeyListenerForDeleteRule()
     */
    public void unbindForeignKeyListenerForDeleteRule(){
        instanceOfFlDeviceGroupManager().unregisterListener(foreignKeyListenerByGroupId);
        
    }
    //_____________________________________________________________________
    //
    // UTILS
    //_____________________________________________________________________

    //40
    /**
     * Retrieves the manager object used to get connections.
     *
     * @return the manager used
     */
    private Manager getManager()
    {
        return Manager.getInstance();
    }

    //41
    /**
     * Frees the connection.
     *
     * @param c the connection to release
     */
    private void freeConnection(Connection c)
    {
        // back to pool
        this.getManager().releaseConnection(c);
    }

    //42
    /**
     * Gets the connection.
     */
    private Connection getConnection() throws DaoException
    {
        try
        {
            return this.getManager().getConnection();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
    }

    //43

    @Override
    public boolean isPrimaryKey(String column){
        for(String c:PRIMARYKEY_NAMES){
            if(c.equalsIgnoreCase(column)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Fill the given prepared statement with the values in argList
     * @param ps the PreparedStatement that will be filled
     * @param argList the arguments to use fill given prepared statement
     * @throws DaoException
     */
    private void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws DaoException{
        try {
            if (!(argList == null || ps == null)) {
                for (int i = 0; i < argList.length; i++) {
                    if (argList[i].getClass().equals(byte[].class)) {
                        ps.setBytes(i + 1, (byte[]) argList[i]);
                    } else {
                        ps.setObject(i + 1, argList[i]);
                    }
                }
            }
        } catch (SQLException e) {
            throw new DaoException(e);
        }
    }
    
    @Override    

    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<FlDeviceBean> action) throws DaoException{
        PreparedStatement ps = null;
        Connection connection = null;
        // logger.debug("sql string:\n" + sql + "\n");
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            fillPrepareStatement(ps, argList);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }
   
    @Override

    public <T>T runAsTransaction(Callable<T> fun) throws DaoException{
        return Manager.getInstance().runAsTransaction(fun);
    }
    
    class DeleteBeanAction extends Action.BaseAdapter<FlDeviceBean>{
        private final AtomicInteger count=new AtomicInteger(0);
        @Override
        public void call(FlDeviceBean bean) throws DaoException {
                FlDeviceManager.this.delete(bean);
                count.incrementAndGet();
        }
        int getCount(){
            return count.get();
        }
    }
    //45
    /**
     * return a primary key list from {@link FlDeviceBean} array
     * @param array
     */
    public List<Integer> toPrimaryKeyList(FlDeviceBean... array){        
        if(null == array){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(array.length);
        for(FlDeviceBean bean:array){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
    //46
    /**
     * return a primary key list from {@link FlDeviceBean} collection
     * @param collection
     */
    public List<Integer> toPrimaryKeyList(java.util.Collection<FlDeviceBean> collection){        
        if(null == collection){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(collection.size());
        for(FlDeviceBean bean:collection){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
}
