// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: manager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.face;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.Manager;
import net.gdface.facelog.dborm.TableListener;
import net.gdface.facelog.dborm.TableManager;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.DataAccessException;
import net.gdface.facelog.dborm.exception.DataRetrievalException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
import net.gdface.facelog.dborm.log.FlLogBean;
import net.gdface.facelog.dborm.log.FlLogManager;
import net.gdface.facelog.dborm.image.FlImageBean;
import net.gdface.facelog.dborm.image.FlImageManager;

/**
 * Handles database calls (save, load, count, etc...) for the fl_face table.<br>
 * Remarks: 人脸检测信息数据表,用于保存检测到的人脸的所有信息(特征数据除外)<br>
 * @author sql2java
 */
public class FlFaceManager extends TableManager.BaseAdapter<FlFaceBean>
{
    /**
     * Tablename.
     */
    public static final String TABLE_NAME="fl_face";

    /**
     * Contains all the primary key fields of the fl_face table.
     */
    public static final String[] PRIMARYKEY_NAMES =
    {
        "id"
    };

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }
    
    @Override
    public String getFields() {
        return FL_FACE_FIELDS;
    }
    
    @Override
    public String getFullFields() {
        return FL_FACE_FULL_FIELDS;
    }

    @Override
    public String[] getPrimarykeyNames() {
        return PRIMARYKEY_NAMES;
    }

    private static FlFaceManager singleton = new FlFaceManager();
    protected FlFaceManager(){}
    /**
     * Get the FlFaceManager singleton.
     *
     * @return FlFaceManager
     */
    public static FlFaceManager getInstance()
    {
        return singleton;
    }


    /**
     * Creates a new FlFaceBean instance.
     *
     * @return the new FlFaceBean
     */
    public FlFaceBean createBean()
    {
        return new FlFaceBean();
    }
    
    @Override
    protected Class<FlFaceBean> beanType(){
        return FlFaceBean.class;
    }
    
    protected FlLogManager instanceOfFlLogManager(){
        return FlLogManager.getInstance();
    }
    protected FlFeatureManager instanceOfFlFeatureManager(){
        return FlFeatureManager.getInstance();
    }
    protected FlImageManager instanceOfFlImageManager(){
        return FlImageManager.getInstance();
    }
    //////////////////////////////////////
    // PRIMARY KEY METHODS
    //////////////////////////////////////

    //1
    /**
     * Loads a {@link FlFaceBean} from the fl_face using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlFaceBean or {@code null} if not found or have null argument
     * @throws DaoException
     */
    public FlFaceBean loadByPrimaryKey(Integer id) throws DaoException
    {
        try{
            return loadByPrimaryKeyChecked(id);
        }catch(ObjectRetrievalException e){
            // not found
            return null;
        }
    }
    
    //1.1
    /**
     * Loads a {@link FlFaceBean} from the fl_face using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlFaceBean
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public FlFaceBean loadByPrimaryKeyChecked(Integer id) throws DaoException
    {
        if(null == id){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT " + FL_FACE_FIELDS + " FROM fl_face WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_FACE_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_FACE_ID_ID + 1, id); }
            List<FlFaceBean> pReturn = this.loadByPreparedStatementAsList(ps);
            if (1 == pReturn.size()) {
                return pReturn.get(0);
            } else {
                throw new ObjectRetrievalException();
            }
        }
        catch(ObjectRetrievalException e)
        {
            throw e;
        }
        catch(SQLException e)
        {
            throw new DataRetrievalException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //1.2
    
    @Override
    public FlFaceBean loadByPrimaryKey(FlFaceBean bean) throws DaoException
    {
        return bean==null?null:loadByPrimaryKey(bean.getId());
    }
    
    //1.2.2
    
    @Override
    public FlFaceBean loadByPrimaryKeyChecked(FlFaceBean bean) throws DaoException
    {
        if(null == bean){
            throw new NullPointerException();
        }
        return loadByPrimaryKeyChecked(bean.getId());
    }
    
    //1.3
    /**
     * Loads a {@link FlFaceBean} from the fl_face using primary key fields.
     * @param keys primary keys value:<br> 
     * @return a unique {@link FlFaceBean} or {@code null} if not found
     * @see #loadByPrimaryKey(Integer id)
     */
    @Override
    public FlFaceBean loadByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_FACE_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(null == keys[0]){
            return null;
        }
        return loadByPrimaryKey((Integer)keys[0]);
    }
    //1.3.2

    @Override
    public FlFaceBean loadByPrimaryKeyChecked(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_FACE_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(! (keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        return loadByPrimaryKeyChecked((Integer)keys[0]);
    }
    //1.4
    /**
     * Returns true if this fl_face contains row with primary key fields.
     * @param id Integer - PK# 1
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public boolean existsPrimaryKey(Integer id) throws DaoException
    {
        if(null == id){
            return false;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try{
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_face WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_FACE_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_FACE_ID_ID + 1, id); }
            return 1 == this.countByPreparedStatement(ps);
        }catch(SQLException e){
            throw new ObjectRetrievalException(e);
        }finally{
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }
    //1.6
    /**
     * Return true if this fl_face contains row with primary key fields.
     * @param bean  
     * @throws DaoException
     * @return false if primary kes has null
     */
    @Override
    public boolean existsByPrimaryKey(FlFaceBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return false;
        }
        long modified = bean.getModified();
        try{
            bean.resetModifiedExceptPrimaryKeys();
            return 1 == countUsingTemplate(bean);
        }finally{
            bean.setModified(modified);
        }
    }
    //1.7

    @Override
    public FlFaceBean checkDuplicate(FlFaceBean bean) throws DaoException{
        if(existsByPrimaryKey(bean)){
            throw new ObjectRetrievalException("Duplicate entry ("+ bean.getId() +") for key 'PRIMARY'");
        }
        return bean;
    }
    //1.4.1
    /**
     * Check duplicated row by primary keys,if row exists throw {@link ObjectRetrievalException}
     * @param id Integer
     * @throws DaoException
     * @see #existsPrimaryKey(Integer id)
     */
    public Integer checkDuplicate(Integer id) throws DaoException
    {
        if(existsPrimaryKey(id)){
            throw new ObjectRetrievalException("Duplicate entry '"+ id +"' for key 'PRIMARY'");
        }
        return id;
    }    
    //2
    /**
     * Delete row according to its primary keys.<br>
     * all keys must not be null
     * 
     * @param id Integer - PK# 1
     * @return the number of deleted rows
     * @throws DaoException
     * @see #delete(FlFaceBean)
     */
    public int deleteByPrimaryKey(Integer id) throws DaoException
    {
        FlFaceBean bean=createBean();
        bean.setId(id);
        return this.delete(bean);
    }

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    @Override
    public int delete(FlFaceBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            // listener callback
            this.listenerContainer.beforeDelete(bean);
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_face WHERE id=?");
            // System.out.println("deleteByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getId() == null) { ps.setNull(FL_FACE_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_FACE_ID_ID + 1, bean.getId()); }
            int rows=ps.executeUpdate();
            if(rows>0){
                // listener callback
                this.listenerContainer.afterDelete(bean);
            }
            return rows;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value:<br> 
     * @return the number of deleted rows
     * @see #delete(FlFaceBean)
     */   
    @Override
    public int deleteByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_FACE_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        FlFaceBean bean = createBean();   
        
        if(null != keys[0] && !(keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        bean.setId((Integer)keys[0]);
        return delete(bean);
    }
 
    //////////////////////////////////////
    // IMPORT KEY GENERIC METHOD
    //////////////////////////////////////
    
    private static final Class<?>[] IMPORTED_BEAN_TYPES = new Class<?>[]{FlLogBean.class};

    /**
     * @see #getImportedBeansAsList(FlFaceBean,int)
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] getImportedBeans(FlFaceBean bean, int ikIndex) throws DaoException {
        return getImportedBeansAsList(bean, ikIndex).toArray((T[])java.lang.reflect.Array.newInstance(IMPORTED_BEAN_TYPES[ikIndex],0));
    }
    
    /**
     * Retrieves imported T objects by ikIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_FACE_IK_FL_LOG_COMPARE_FACE} - {@link FlLogBean}</li>
     * </ul>
     * @param bean the {@link FlFaceBean} object to use
     * @param ikIndex valid values: {@link Constant#FL_FACE_IK_FL_LOG_COMPARE_FACE}
     * @return the associated T beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> List<T> getImportedBeansAsList(FlFaceBean bean,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_FACE_IK_FL_LOG_COMPARE_FACE:
            return (List<T>)this.getLogBeansByCompareFaceAsList(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    
    /**
     * Set the T objects as imported beans of bean object by ikIndex.<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlFaceBean,int)}
     * @param bean the {@link FlFaceBean} object to use
     * @param importedBeans the FlLogBean array to associate to the {@link FlFaceBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlFaceBean,int)}
     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] setImportedBeans(FlFaceBean bean,T[] importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_FACE_IK_FL_LOG_COMPARE_FACE:
            return (T[])setLogBeansByCompareFace(bean,(FlLogBean[])importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    /**
     * Set the importedBeans associates to the bean by ikIndex<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlFaceBean,int)}
     * @param bean the {@link FlFaceBean} object to use
     * @param importedBeans the T object to associate to the {@link FlFaceBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlFaceBean,int)}

     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>,C extends java.util.Collection<T>> C setImportedBeans(FlFaceBean bean,C importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_FACE_IK_FL_LOG_COMPARE_FACE:
            return (C)setLogBeansByCompareFace(bean,(java.util.Collection<FlLogBean>)importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
 
    //////////////////////////////////////
    // GET/SET IMPORTED KEY BEAN METHOD
    //////////////////////////////////////
    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from the fl_log.compare_face field.<BR>
     * FK_NAME : fl_log_ibfk_4 
     * @param bean the {@link FlFaceBean}
     * @return the associated {@link FlLogBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlLogBean[] getLogBeansByCompareFace(FlFaceBean bean) throws DaoException
    {
        return getLogBeansByCompareFaceAsList(bean).toArray(new FlLogBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from the fl_log.compare_face field.<BR>
     * FK_NAME : fl_log_ibfk_4 
     * @param idOfFace Integer - PK# 1
     * @return the associated {@link FlLogBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlLogBean[] getLogBeansByCompareFace(Integer idOfFace) throws DaoException
    {
        FlFaceBean bean = createBean();
        bean.setId(idOfFace);
        return getLogBeansByCompareFace(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.compare_face field.<BR>
     * FK_NAME:fl_log_ibfk_4
     * @param bean the {@link FlFaceBean}
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByCompareFaceAsList(FlFaceBean bean) throws DaoException
    {
        return getLogBeansByCompareFaceAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.compare_face field.<BR>
     * FK_NAME:fl_log_ibfk_4
     * @param idOfFace Integer - PK# 1
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByCompareFaceAsList(Integer idOfFace) throws DaoException
    {
         FlFaceBean bean = createBean();
        bean.setId(idOfFace);
        return getLogBeansByCompareFaceAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.compare_face field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_log_ibfk_4
     * @param bean the {@link FlFaceBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByCompareFaceAsList(FlFaceBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlLogBean>();
        }
        FlLogBean other = new FlLogBean();
        other.setCompareFace(bean.getId());
        return instanceOfFlLogManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlLogBean} object array associate to FlFaceBean by the fl_log.compare_face field.<BR>
     * FK_NAME : fl_log_ibfk_4 
     * @param bean the referenced {@link FlFaceBean}
     * @param importedBeans imported beans from fl_log
     * @return importedBeans always
     * @throws DaoException
     * @see FlLogManager#setReferencedByCompareFace(FlLogBean, FlFaceBean)
     */
    public FlLogBean[] setLogBeansByCompareFace(FlFaceBean bean , FlLogBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlLogBean importBean : importedBeans ){
                instanceOfFlLogManager().setReferencedByCompareFace(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlLogBean} object collection associate to FlFaceBean by the fl_log.compare_face field.<BR>
     * FK_NAME:fl_log_ibfk_4
     * @param bean the referenced {@link FlFaceBean} 
     * @param importedBeans imported beans from fl_log 
     * @return importedBeans always
     * @throws DaoException
     * @see FlLogManager#setReferencedByCompareFace(FlLogBean, FlFaceBean)
     */
    public <C extends java.util.Collection<FlLogBean>> C setLogBeansByCompareFace(FlFaceBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlLogBean importBean : importedBeans ){
                instanceOfFlLogManager().setReferencedByCompareFace(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.5 SYNC SAVE 
    /**
     * Save the FlFaceBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlFaceBean} bean to be saved
     * @param refFeatureByFeatureMd5 the {@link FlFeatureBean} bean referenced by {@link FlFaceBean} 
     * @param refImageByImageMd5 the {@link FlImageBean} bean referenced by {@link FlFaceBean} 
     * @param impLogByCompareFace the {@link FlLogBean} beans refer to {@link FlFaceBean} 
     * @return the inserted or updated {@link FlFaceBean} bean
     * @throws DaoException
     */
    public FlFaceBean save(FlFaceBean bean
        , FlFeatureBean refFeatureByFeatureMd5 , FlImageBean refImageByImageMd5 
        , FlLogBean[] impLogByCompareFace ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refFeatureByFeatureMd5){
            this.setReferencedByFeatureMd5(bean,refFeatureByFeatureMd5);
        }
        if(null != refImageByImageMd5){
            this.setReferencedByImageMd5(bean,refImageByImageMd5);
        }
        bean = this.save( bean );
        if(null != impLogByCompareFace){
            this.setLogBeansByCompareFace(bean,impLogByCompareFace);
            instanceOfFlLogManager().save( impLogByCompareFace );
        }
        return bean;
    } 

    //3.6 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlFaceBean , FlFeatureBean , FlImageBean , FlLogBean[] )
     */
    public FlFaceBean saveAsTransaction(final FlFaceBean bean
        ,final FlFeatureBean refFeatureByFeatureMd5 ,final FlImageBean refImageByImageMd5 
        ,final FlLogBean[] impLogByCompareFace ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlFaceBean>(){
            @Override
            public FlFaceBean call() throws Exception {
                return save(bean , refFeatureByFeatureMd5 , refImageByImageMd5 , impLogByCompareFace );
            }});
    }
    //3.7 SYNC SAVE 
    /**
     * Save the FlFaceBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlFaceBean} bean to be saved
     * @param refFeatureByFeatureMd5 the {@link FlFeatureBean} bean referenced by {@link FlFaceBean} 
     * @param refImageByImageMd5 the {@link FlImageBean} bean referenced by {@link FlFaceBean} 
     * @param impLogByCompareFace the {@link FlLogBean} bean refer to {@link FlFaceBean} 
     * @return the inserted or updated {@link FlFaceBean} bean
     * @throws DaoException
     */
    public FlFaceBean save(FlFaceBean bean
        , FlFeatureBean refFeatureByFeatureMd5 , FlImageBean refImageByImageMd5 
        , java.util.Collection<FlLogBean> impLogByCompareFace ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refFeatureByFeatureMd5){
            this.setReferencedByFeatureMd5(bean,refFeatureByFeatureMd5);
        }
        if(null != refImageByImageMd5){
            this.setReferencedByImageMd5(bean,refImageByImageMd5);
        }
        bean = this.save( bean );
        if(null != impLogByCompareFace){
            this.setLogBeansByCompareFace(bean,impLogByCompareFace);
            instanceOfFlLogManager().save( impLogByCompareFace );
        }
        return bean;
    }

    //3.8 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlFaceBean , FlFeatureBean , FlImageBean , java.util.Collection )
     * @throws DaoException
     */
    public FlFaceBean saveAsTransaction(final FlFaceBean bean
        ,final FlFeatureBean refFeatureByFeatureMd5 ,final FlImageBean refImageByImageMd5 
        ,final  java.util.Collection<FlLogBean> impLogByCompareFace ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlFaceBean>(){
            @Override
            public FlFaceBean call() throws Exception {
                return save(bean , refFeatureByFeatureMd5 , refImageByImageMd5 , impLogByCompareFace );
            }});
    }

    private static final int SYNC_SAVE_ARG_LEN = 3;
    private static final int SYNC_SAVE_ARG_0 = 0;
    private static final int SYNC_SAVE_ARG_1 = 1;
    private static final int SYNC_SAVE_ARG_2 = 2;
    //3.9 SYNC SAVE 
    /**
     * Save the FlFaceBean bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the {@link FlFaceBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlFaceBean , FlFeatureBean , FlImageBean , FlLogBean[] )}
     * @return the inserted or updated {@link FlFaceBean} bean
     * @throws DaoException
     */
    @Override
    public FlFaceBean save(FlFaceBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 3");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlFeatureBean)){
            throw new IllegalArgumentException("invalid type for the No.1 dynamic argument,expected type:FlFeatureBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlImageBean)){
            throw new IllegalArgumentException("invalid type for the No.2 dynamic argument,expected type:FlImageBean");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof FlLogBean[])){
            throw new IllegalArgumentException("invalid type for the No.3 dynamic argument,expected type:FlLogBean[]");
        }
        return save(bean,
                    (FlFeatureBean)args[SYNC_SAVE_ARG_0],
                    (FlImageBean)args[SYNC_SAVE_ARG_1],
                    (FlLogBean[])args[SYNC_SAVE_ARG_2]);
    } 

    //3.10 SYNC SAVE 
    /**
     * Save the FlFaceBean bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the {@link FlFaceBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlFaceBean , FlFeatureBean , FlImageBean , java.util.Collection )}
     * @return the inserted or updated {@link FlFaceBean} bean
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public FlFaceBean saveCollection(FlFaceBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 3");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlFeatureBean)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:FlFeatureBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlImageBean)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:FlImageBean");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.3 argument,expected type:java.util.Collection<FlLogBean>");
        }
        return save(bean,
                    (FlFeatureBean)args[SYNC_SAVE_ARG_0],
                    (FlImageBean)args[SYNC_SAVE_ARG_1],
                    (java.util.Collection<FlLogBean>)args[SYNC_SAVE_ARG_2]);
    } 
    //////////////////////////////////////
    // FOREIGN KEY GENERIC METHOD
    //////////////////////////////////////

    /**
     * Retrieves the bean object referenced by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_FACE_FK_FEATURE_MD5} - {@link FlFeatureBean}</li>
     *     <li> {@link Constant#FL_FACE_FK_IMAGE_MD5} - {@link FlImageBean}</li>
     * </ul>
     * @param bean the {@link FlFaceBean} object to use
     * @param fkIndex valid values: <br>
     *        {@link Constant#FL_FACE_FK_FEATURE_MD5},{@link Constant#FL_FACE_FK_IMAGE_MD5}
     * @return the associated T bean or {@code null} if {@code bean} or {@code beanToSet} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T getReferencedBean(FlFaceBean bean,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_FACE_FK_FEATURE_MD5:
            return  (T)this.getReferencedByFeatureMd5(bean);
        case FL_FACE_FK_IMAGE_MD5:
            return  (T)this.getReferencedByImageMd5(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
    
    /**
     * Associates the {@link FlFaceBean} object to the bean object by fkIndex field.<br>
     * 
     * @param <T> see also {@link #getReferencedBean(FlFaceBean,int)}
     * @param bean the {@link FlFaceBean} object to use
     * @param beanToSet the T object to associate to the {@link FlFaceBean}
     * @param fkIndex valid values: see also {@link #getReferencedBean(FlFaceBean,int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T setReferencedBean(FlFaceBean bean,T beanToSet,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_FACE_FK_FEATURE_MD5:
            return  (T)this.setReferencedByFeatureMd5(bean, (FlFeatureBean)beanToSet);
        case FL_FACE_FK_IMAGE_MD5:
            return  (T)this.setReferencedByImageMd5(bean, (FlImageBean)beanToSet);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
     
    //////////////////////////////////////
    // GET/SET FOREIGN KEY BEAN METHOD
    //////////////////////////////////////


    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlFeatureBean} object referenced by {@link FlFaceBean#getFeatureMd5}() field.<br>
     * FK_NAME : fl_face_ibfk_2
     * @param bean the {@link FlFaceBean}
     * @return the associated {@link FlFeatureBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlFeatureBean getReferencedByFeatureMd5(FlFaceBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByFeatureMd5(instanceOfFlFeatureManager().loadByPrimaryKey(bean.getFeatureMd5())); 
        return bean.getReferencedByFeatureMd5();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlFaceBean} object to the {@link FlFeatureBean} object by {@link FlFaceBean#getFeatureMd5}() field.
     *
     * @param bean the {@link FlFaceBean} object to use
     * @param beanToSet the {@link FlFeatureBean} object to associate to the {@link FlFaceBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlFeatureBean setReferencedByFeatureMd5(FlFaceBean bean, FlFeatureBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlFeatureManager().save(beanToSet);
            bean.setReferencedByFeatureMd5(beanToSet);
            if( null == beanToSet){
                bean.setFeatureMd5(null);
            }else{
                bean.setFeatureMd5(beanToSet.getMd5());
            }
        }
        return beanToSet;
    }

    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlImageBean} object referenced by {@link FlFaceBean#getImageMd5}() field.<br>
     * FK_NAME : fl_face_ibfk_1
     * @param bean the {@link FlFaceBean}
     * @return the associated {@link FlImageBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlImageBean getReferencedByImageMd5(FlFaceBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByImageMd5(instanceOfFlImageManager().loadByPrimaryKey(bean.getImageMd5())); 
        return bean.getReferencedByImageMd5();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlFaceBean} object to the {@link FlImageBean} object by {@link FlFaceBean#getImageMd5}() field.
     *
     * @param bean the {@link FlFaceBean} object to use
     * @param beanToSet the {@link FlImageBean} object to associate to the {@link FlFaceBean} (NOT NULL).
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlImageBean setReferencedByImageMd5(FlFaceBean bean, FlImageBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlImageManager().save(beanToSet);
            bean.setReferencedByImageMd5(beanToSet);
            if( null == beanToSet){
               // foreign key ( image_md5 ) is not nullable , nothing to do
            }else{
                bean.setImageMd5(beanToSet.getMd5());
            }
        }
        return beanToSet;
    }

    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //11
    /**
     * Deletes rows from the fl_face table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    @Override
    public int deleteByWhere(String where) throws DaoException
    {
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action = new DeleteBeanAction(); 
            this.loadByWhere(where,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;

        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_face " + where);
            // System.out.println("deleteByWhere: " + sql);
            ps = c.prepareStatement(sql.toString());
            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________

    //13

    @Override
    public FlFaceBean insert(FlFaceBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean; 
        }
        if (!bean.isNew()){
            return this.update(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();
            // listener callback
            this.listenerContainer.beforeInsert(bean);
            int dirtyCount = 0;
            sql = new StringBuilder("INSERT into fl_face (");

            if (bean.checkIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("id");
                dirtyCount++;
            }

            if (bean.checkImageMd5Modified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("image_md5");
                dirtyCount++;
            }

            if (bean.checkFaceLeftModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("face_left");
                dirtyCount++;
            }

            if (bean.checkFaceTopModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("face_top");
                dirtyCount++;
            }

            if (bean.checkFaceWidthModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("face_width");
                dirtyCount++;
            }

            if (bean.checkFaceHeightModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("face_height");
                dirtyCount++;
            }

            if (bean.checkEyeLeftxModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("eye_leftx");
                dirtyCount++;
            }

            if (bean.checkEyeLeftyModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("eye_lefty");
                dirtyCount++;
            }

            if (bean.checkEyeRightxModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("eye_rightx");
                dirtyCount++;
            }

            if (bean.checkEyeRightyModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("eye_righty");
                dirtyCount++;
            }

            if (bean.checkMouthXModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("mouth_x");
                dirtyCount++;
            }

            if (bean.checkMouthYModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("mouth_y");
                dirtyCount++;
            }

            if (bean.checkNoseXModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("nose_x");
                dirtyCount++;
            }

            if (bean.checkNoseYModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("nose_y");
                dirtyCount++;
            }

            if (bean.checkAngleYawModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("angle_yaw");
                dirtyCount++;
            }

            if (bean.checkAnglePitchModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("angle_pitch");
                dirtyCount++;
            }

            if (bean.checkAngleRollModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("angle_roll");
                dirtyCount++;
            }

            if (bean.checkExtInfoModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_info");
                dirtyCount++;
            }

            if (bean.checkFeatureMd5Modified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("feature_md5");
                dirtyCount++;
            }

            sql.append(") values (");
            if(dirtyCount > 0) {
                sql.append("?");
                for(int i = 1; i < dirtyCount; i++) {
                    sql.append(",?");
                }
            }
            sql.append(")");


            // System.out.println("insert : " + sql.toString());

            ps = c.prepareStatement(sql.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);

            this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            ps.executeUpdate();

            if (!bean.checkIdModified())
            {
                PreparedStatement ps2 = null;
                ResultSet rs = null;
                try {
                    ps2 = c.prepareStatement("SELECT last_insert_id()");
                    rs = ps2.executeQuery();
                    if(rs.next()) {
                        bean.setId(Manager.getInteger(rs, 1));
                    } else {
                        this.getManager().log("ATTENTION: Could not retrieve generated key!");
                    }
                } finally {
                    this.getManager().close(ps2, rs);
                }
            }

            bean.isNew(false);
            bean.resetIsModified();
            // listener callback
            this.listenerContainer.afterInsert(bean);
            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //14

    @Override
    public FlFaceBean update(FlFaceBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean;
        }
        if (bean.isNew()){
            return this.insert(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();

            // listener callback
            this.listenerContainer.beforeUpdate(bean); 
            sql = new StringBuilder("UPDATE fl_face SET ");
            boolean useComma=false;

            if (bean.checkIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("id=?");
            }

            if (bean.checkImageMd5Modified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("image_md5=?");
            }

            if (bean.checkFaceLeftModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("face_left=?");
            }

            if (bean.checkFaceTopModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("face_top=?");
            }

            if (bean.checkFaceWidthModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("face_width=?");
            }

            if (bean.checkFaceHeightModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("face_height=?");
            }

            if (bean.checkEyeLeftxModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("eye_leftx=?");
            }

            if (bean.checkEyeLeftyModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("eye_lefty=?");
            }

            if (bean.checkEyeRightxModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("eye_rightx=?");
            }

            if (bean.checkEyeRightyModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("eye_righty=?");
            }

            if (bean.checkMouthXModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("mouth_x=?");
            }

            if (bean.checkMouthYModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("mouth_y=?");
            }

            if (bean.checkNoseXModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("nose_x=?");
            }

            if (bean.checkNoseYModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("nose_y=?");
            }

            if (bean.checkAngleYawModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("angle_yaw=?");
            }

            if (bean.checkAnglePitchModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("angle_pitch=?");
            }

            if (bean.checkAngleRollModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("angle_roll=?");
            }

            if (bean.checkExtInfoModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_info=?");
            }

            if (bean.checkFeatureMd5Modified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("feature_md5=?");
            }
            sql.append(" WHERE ");
            sql.append("id=?");
            // System.out.println("update : " + sql.toString());
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);

            int dirtyCount = this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            if (dirtyCount == 0) {
                // System.out.println("The bean to look is not initialized... do not update.");
                return bean;
            }

            if (bean.getId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            ps.executeUpdate();
            // listener callback
            this.listenerContainer.afterUpdate(bean); 
            bean.resetIsModified();

            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18

    @Override
    public FlFaceBean loadUniqueUsingTemplate(FlFaceBean bean) throws DaoException
    {
         List<FlFaceBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             return null;
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //18-1

    @Override
    public FlFaceBean loadUniqueUsingTemplateChecked(FlFaceBean bean) throws DaoException
    {
         List<FlFaceBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             throw new ObjectRetrievalException("Not found element !!");
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //20-5

    @Override
    public int loadUsingTemplate(FlFaceBean bean, int[] fieldList, int startRow, int numRows,int searchType, Action<FlFaceBean> action) throws DaoException
    {
        // System.out.println("loadUsingTemplate startRow:" + startRow + ", numRows:" + numRows + ", searchType:" + searchType);
        StringBuilder sqlWhere = new StringBuilder("");
        String sql=createSelectSql(fieldList,this.fillWhere(sqlWhere, bean, searchType) > 0?" WHERE "+sqlWhere.toString():null);
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }

    //21

    @Override
    public int deleteUsingTemplate(FlFaceBean bean) throws DaoException
    {
        if(bean.checkIdInitialized() && null != bean.getId()){
            return this.deleteByPrimaryKey(bean.getId());
        }
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action=new DeleteBeanAction(); 
            this.loadUsingTemplate(bean,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("DELETE FROM fl_face ");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... deleting all");
            }
            // System.out.println("deleteUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, SEARCH_EXACT, false);

            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }


    //_____________________________________________________________________
    //
    // USING INDICES
    //_____________________________________________________________________


    /**
     * Retrieves an array of FlFaceBean using the feature_md5 index.
     *
     * @param featureMd5 the feature_md5 column's value filter.
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public FlFaceBean[] loadByIndexFeatureMd5(String featureMd5) throws DaoException
    {
        return (FlFaceBean[])this.loadByIndexFeatureMd5AsList(featureMd5).toArray(new FlFaceBean[0]);
    }
    
    /**
     * Retrieves a list of FlFaceBean using the feature_md5 index.
     *
     * @param featureMd5 the feature_md5 column's value filter.
     * @return a list of FlFaceBean
     * @throws DaoException
     */
    public List<FlFaceBean> loadByIndexFeatureMd5AsList(String featureMd5) throws DaoException
    {
        FlFaceBean bean = this.createBean();
        bean.setFeatureMd5(featureMd5);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the feature_md5 index.
     *
     * @param featureMd5 the feature_md5 column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexFeatureMd5(String featureMd5) throws DaoException
    {
        FlFaceBean bean = this.createBean();
        bean.setFeatureMd5(featureMd5);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlFaceBean using the image_md5 index.
     *
     * @param imageMd5 the image_md5 column's value filter.
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public FlFaceBean[] loadByIndexImageMd5(String imageMd5) throws DaoException
    {
        return (FlFaceBean[])this.loadByIndexImageMd5AsList(imageMd5).toArray(new FlFaceBean[0]);
    }
    
    /**
     * Retrieves a list of FlFaceBean using the image_md5 index.
     *
     * @param imageMd5 the image_md5 column's value filter.
     * @return a list of FlFaceBean
     * @throws DaoException
     */
    public List<FlFaceBean> loadByIndexImageMd5AsList(String imageMd5) throws DaoException
    {
        FlFaceBean bean = this.createBean();
        bean.setImageMd5(imageMd5);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the image_md5 index.
     *
     * @param imageMd5 the image_md5 column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexImageMd5(String imageMd5) throws DaoException
    {
        FlFaceBean bean = this.createBean();
        bean.setImageMd5(imageMd5);
        return deleteUsingTemplate(bean);
    }
    
    
    /**
     * Retrieves a list of FlFaceBean using the index specified by keyIndex.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_FACE_INDEX_FEATURE_MD5},{@link Constant#FL_FACE_INDEX_IMAGE_MD5}
     * @param keys key values of index
     * @return a list of FlFaceBean
     * @throws DaoException
     */
    @Override
    public List<FlFaceBean> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_FACE_INDEX_FEATURE_MD5:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'feature_md5' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.loadByIndexFeatureMd5AsList((String)keys[0]);        
        }
        case FL_FACE_INDEX_IMAGE_MD5:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'image_md5' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.loadByIndexImageMd5AsList((String)keys[0]);        
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }
    }
    
    /**
     * Deletes rows using key.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_FACE_INDEX_FEATURE_MD5},{@link Constant#FL_FACE_INDEX_IMAGE_MD5}
     * @param keys key values of index
     * @return the number of deleted objects
     * @throws DaoException
     */
    @Override
    public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_FACE_INDEX_FEATURE_MD5:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'feature_md5' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexFeatureMd5((String)keys[0]);
        }
        case FL_FACE_INDEX_IMAGE_MD5:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'image_md5' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexImageMd5((String)keys[0]);
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }        
    }


    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________

    //25

    @Override
    public int countWhere(String where) throws DaoException
    {
        String sql = new StringBuffer("SELECT COUNT(*) AS MCOUNT FROM fl_person ")
    		    .append(null == where ? "" : where).toString();
        // System.out.println("countWhere: " + sql);
        Connection c = null;
        Statement st = null;
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement();
            rs =  st.executeQuery(sql);
            if (rs.next())
            {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(st, rs);
            this.freeConnection(c);
            sql = null;
        }
        throw new DataAccessException("Error in countWhere where=[" + where + "]");
    }

    //26
    /**
     * Retrieves the number of rows of the table fl_face with a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return the number of rows returned
     * @throws DaoException
     */
    private int countByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(rs);
        }
       throw new DataAccessException("Error in countByPreparedStatement");
    }

    //20
    /**
     * count the number of elements of a specific FlFaceBean bean given the search type
     *
     * @param bean the FlFaceBean template to look for
     * @param searchType exact ?  like ? starting like ?
     * @return the number of rows returned
     * @throws DaoException
     */
    @Override
    public int countUsingTemplate(FlFaceBean bean, int searchType) throws DaoException
    {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_face");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... counting all...");
            }
            // System.out.println("countUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);

            return this.countByPreparedStatement(ps);
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    /**
     * fills the given StringBuilder with the sql where clauses constructed using the bean and the search type
     * @param sqlWhere the StringBuilder that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @return the number of clauses returned
     */
    protected int fillWhere(StringBuilder sqlWhere, FlFaceBean bean, int searchType)
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == SEARCH_EXACT ? "=" : " like ";
        try
        {
            if (bean.checkIdModified()) {
                dirtyCount ++;
                if (bean.getId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id = ?");
                }
            }
            if (bean.checkImageMd5Modified()) {
                dirtyCount ++;
                if (bean.getImageMd5() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("image_md5 IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("image_md5 ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkFaceLeftModified()) {
                dirtyCount ++;
                if (bean.getFaceLeft() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_left IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_left = ?");
                }
            }
            if (bean.checkFaceTopModified()) {
                dirtyCount ++;
                if (bean.getFaceTop() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_top IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_top = ?");
                }
            }
            if (bean.checkFaceWidthModified()) {
                dirtyCount ++;
                if (bean.getFaceWidth() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_width IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_width = ?");
                }
            }
            if (bean.checkFaceHeightModified()) {
                dirtyCount ++;
                if (bean.getFaceHeight() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_height IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("face_height = ?");
                }
            }
            if (bean.checkEyeLeftxModified()) {
                dirtyCount ++;
                if (bean.getEyeLeftx() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_leftx IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_leftx = ?");
                }
            }
            if (bean.checkEyeLeftyModified()) {
                dirtyCount ++;
                if (bean.getEyeLefty() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_lefty IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_lefty = ?");
                }
            }
            if (bean.checkEyeRightxModified()) {
                dirtyCount ++;
                if (bean.getEyeRightx() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_rightx IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_rightx = ?");
                }
            }
            if (bean.checkEyeRightyModified()) {
                dirtyCount ++;
                if (bean.getEyeRighty() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_righty IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("eye_righty = ?");
                }
            }
            if (bean.checkMouthXModified()) {
                dirtyCount ++;
                if (bean.getMouthX() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mouth_x IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mouth_x = ?");
                }
            }
            if (bean.checkMouthYModified()) {
                dirtyCount ++;
                if (bean.getMouthY() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mouth_y IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mouth_y = ?");
                }
            }
            if (bean.checkNoseXModified()) {
                dirtyCount ++;
                if (bean.getNoseX() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("nose_x IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("nose_x = ?");
                }
            }
            if (bean.checkNoseYModified()) {
                dirtyCount ++;
                if (bean.getNoseY() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("nose_y IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("nose_y = ?");
                }
            }
            if (bean.checkAngleYawModified()) {
                dirtyCount ++;
                if (bean.getAngleYaw() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("angle_yaw IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("angle_yaw = ?");
                }
            }
            if (bean.checkAnglePitchModified()) {
                dirtyCount ++;
                if (bean.getAnglePitch() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("angle_pitch IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("angle_pitch = ?");
                }
            }
            if (bean.checkAngleRollModified()) {
                dirtyCount ++;
                if (bean.getAngleRoll() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("angle_roll IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("angle_roll = ?");
                }
            }
            if (bean.checkExtInfoModified()) {
                dirtyCount ++;
                if (bean.getExtInfo() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_info IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_info = ?");
                }
            }
            if (bean.checkFeatureMd5Modified()) {
                dirtyCount ++;
                if (bean.getFeatureMd5() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("feature_md5 IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("feature_md5 ").append(sqlEqualsOperation).append("?");
                }
            }
        }
        finally
        {
            sqlEqualsOperation = null;
        }
        return dirtyCount;
    }

    /**
     * fill the given prepared statement with the bean values and a search type
     * @param ps the PreparedStatement that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @param fillNull wether fill null for null field
     * @return the number of clauses returned
     * @throws DaoException
     */
    protected int fillPreparedStatement(PreparedStatement ps, FlFaceBean bean, int searchType,boolean fillNull) throws DaoException
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        try
        {
            if (bean.checkIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getId() + "]");
                if (bean.getId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            }
            if (bean.checkImageMd5Modified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getImageMd5() + "]");
                        if (bean.getImageMd5() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getImageMd5()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getImageMd5() + "%]");
                        if ( bean.getImageMd5()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getImageMd5() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getImageMd5() + "]");
                        if ( bean.getImageMd5() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getImageMd5()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getImageMd5() + "%]");
                        if (bean.getImageMd5()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getImageMd5() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkFaceLeftModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getFaceLeft() + "]");
                if (bean.getFaceLeft() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getFaceLeft()); }
            }
            if (bean.checkFaceTopModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getFaceTop() + "]");
                if (bean.getFaceTop() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getFaceTop()); }
            }
            if (bean.checkFaceWidthModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getFaceWidth() + "]");
                if (bean.getFaceWidth() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getFaceWidth()); }
            }
            if (bean.checkFaceHeightModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getFaceHeight() + "]");
                if (bean.getFaceHeight() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getFaceHeight()); }
            }
            if (bean.checkEyeLeftxModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getEyeLeftx() + "]");
                if (bean.getEyeLeftx() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getEyeLeftx()); }
            }
            if (bean.checkEyeLeftyModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getEyeLefty() + "]");
                if (bean.getEyeLefty() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getEyeLefty()); }
            }
            if (bean.checkEyeRightxModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getEyeRightx() + "]");
                if (bean.getEyeRightx() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getEyeRightx()); }
            }
            if (bean.checkEyeRightyModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getEyeRighty() + "]");
                if (bean.getEyeRighty() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getEyeRighty()); }
            }
            if (bean.checkMouthXModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getMouthX() + "]");
                if (bean.getMouthX() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getMouthX()); }
            }
            if (bean.checkMouthYModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getMouthY() + "]");
                if (bean.getMouthY() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getMouthY()); }
            }
            if (bean.checkNoseXModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getNoseX() + "]");
                if (bean.getNoseX() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getNoseX()); }
            }
            if (bean.checkNoseYModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getNoseY() + "]");
                if (bean.getNoseY() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getNoseY()); }
            }
            if (bean.checkAngleYawModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getAngleYaw() + "]");
                if (bean.getAngleYaw() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getAngleYaw()); }
            }
            if (bean.checkAnglePitchModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getAnglePitch() + "]");
                if (bean.getAnglePitch() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getAnglePitch()); }
            }
            if (bean.checkAngleRollModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getAngleRoll() + "]");
                if (bean.getAngleRoll() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getAngleRoll()); }
            }
            if (bean.checkExtInfoModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtInfo() + "]");
                if (bean.getExtInfo() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARBINARY);} } else { Manager.setBytes(Types.LONGVARBINARY,ps, ++dirtyCount, bean.getExtInfo()); }
            }
            if (bean.checkFeatureMd5Modified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getFeatureMd5() + "]");
                        if (bean.getFeatureMd5() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getFeatureMd5()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getFeatureMd5() + "%]");
                        if ( bean.getFeatureMd5()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getFeatureMd5() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getFeatureMd5() + "]");
                        if ( bean.getFeatureMd5() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getFeatureMd5()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getFeatureMd5() + "%]");
                        if (bean.getFeatureMd5()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getFeatureMd5() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        return dirtyCount;
    }


    //_____________________________________________________________________
    //
    // DECODE RESULT SET
    //_____________________________________________________________________

    //28
    /**
     * decode a resultset in an array of FlFaceBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlFaceBean table
     * @throws DaoException
     */
    public FlFaceBean[] decodeResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return this.decodeResultSetAsList(rs, fieldList, startRow, numRows).toArray(new FlFaceBean[0]);
    }

    //28-1
    /**
     * decode a resultset in a list of FlFaceBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlFaceBean table
     * @throws DaoException
     */
    public List<FlFaceBean> decodeResultSetAsList(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        actionOnResultSet(rs, fieldList, numRows, numRows, action);
        return action.getList();
    }
    //28-2
    /** decode a resultset and call action
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action interface obj for do something
     * @return the count dealt by action  
     * @throws DaoException
     * @throws IllegalArgumentException
     */
    public int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, Action<FlFaceBean> action) throws DaoException{
        try{
            int count = 0;
            if(0!=numRows){
                if( startRow<1 ){
                    throw new IllegalArgumentException("invalid argument:startRow (must >=1)");
                }
                if( null==action || null==rs ){
                    throw new IllegalArgumentException("invalid argument:action OR rs (must not be null)");
                }
                for(;startRow > 1 && rs.next();){
                    --startRow;
                    //skip to last of startRow
                }
                if (fieldList == null) {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }
                }else {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }
                }
            }
            return count;
        }catch(DaoException e){
            throw e;
        }catch(SQLException e){
            throw new DataAccessException(e);
        }
    }

    //29
    /**
     * Transforms a ResultSet iterating on the fl_face on a FlFaceBean bean.
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlFaceBean bean
     * @throws DaoException
     */
    public FlFaceBean decodeRow(ResultSet rs,FlFaceBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        try
        {
            bean.setId(Manager.getInteger(rs, 1));
            bean.setImageMd5(rs.getString(2));
            bean.setFaceLeft(Manager.getInteger(rs, 3));
            bean.setFaceTop(Manager.getInteger(rs, 4));
            bean.setFaceWidth(Manager.getInteger(rs, 5));
            bean.setFaceHeight(Manager.getInteger(rs, 6));
            bean.setEyeLeftx(Manager.getInteger(rs, 7));
            bean.setEyeLefty(Manager.getInteger(rs, 8));
            bean.setEyeRightx(Manager.getInteger(rs, 9));
            bean.setEyeRighty(Manager.getInteger(rs, 10));
            bean.setMouthX(Manager.getInteger(rs, 11));
            bean.setMouthY(Manager.getInteger(rs, 12));
            bean.setNoseX(Manager.getInteger(rs, 13));
            bean.setNoseY(Manager.getInteger(rs, 14));
            bean.setAngleYaw(Manager.getInteger(rs, 15));
            bean.setAnglePitch(Manager.getInteger(rs, 16));
            bean.setAngleRoll(Manager.getInteger(rs, 17));
            bean.setExtInfo(Manager.getBytes(rs, 18));
            bean.setFeatureMd5(rs.getString(19));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //30
    /**
     * Transforms a ResultSet iterating on the fl_face table on a FlFaceBean bean according to a list of fields.
     *
     * @param rs the ResultSet to be transformed
     * @param fieldList table of the field's associated constants
     * @return bean resulting FlFaceBean bean
     * @throws DaoException
     */
    public FlFaceBean decodeRow(ResultSet rs, int[] fieldList,FlFaceBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        int pos = 0;
        try
        {
            for(int i = 0; i < fieldList.length; i++)
            {
                switch(fieldList[i])
                {
                    case FL_FACE_ID_ID:
                        ++pos;
                        bean.setId(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_IMAGE_MD5:
                        ++pos;
                        bean.setImageMd5(rs.getString(pos));
                        break;
                    case FL_FACE_ID_FACE_LEFT:
                        ++pos;
                        bean.setFaceLeft(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_FACE_TOP:
                        ++pos;
                        bean.setFaceTop(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_FACE_WIDTH:
                        ++pos;
                        bean.setFaceWidth(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_FACE_HEIGHT:
                        ++pos;
                        bean.setFaceHeight(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_EYE_LEFTX:
                        ++pos;
                        bean.setEyeLeftx(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_EYE_LEFTY:
                        ++pos;
                        bean.setEyeLefty(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_EYE_RIGHTX:
                        ++pos;
                        bean.setEyeRightx(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_EYE_RIGHTY:
                        ++pos;
                        bean.setEyeRighty(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_MOUTH_X:
                        ++pos;
                        bean.setMouthX(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_MOUTH_Y:
                        ++pos;
                        bean.setMouthY(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_NOSE_X:
                        ++pos;
                        bean.setNoseX(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_NOSE_Y:
                        ++pos;
                        bean.setNoseY(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_ANGLE_YAW:
                        ++pos;
                        bean.setAngleYaw(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_ANGLE_PITCH:
                        ++pos;
                        bean.setAnglePitch(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_ANGLE_ROLL:
                        ++pos;
                        bean.setAngleRoll(Manager.getInteger(rs, pos));
                        break;
                    case FL_FACE_ID_EXT_INFO:
                        ++pos;
                        bean.setExtInfo(Manager.getBytes(rs, pos));
                        break;
                    case FL_FACE_ID_FEATURE_MD5:
                        ++pos;
                        bean.setFeatureMd5(rs.getString(pos));
                        break;
                    default:
                        throw new DaoException("Unknown field id " + fieldList[i]);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //31
    /**
     * Transforms a ResultSet iterating on the fl_face on a FlFaceBean bean using the names of the columns
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlFaceBean bean
     * @throws DaoException
     */
    public FlFaceBean metaDataDecodeRow(ResultSet rs) throws DaoException
    {
        FlFaceBean bean = this.createBean();
        try
        {
            bean.setId(Manager.getInteger(rs, "id"));
            bean.setImageMd5(rs.getString("image_md5"));
            bean.setFaceLeft(Manager.getInteger(rs, "face_left"));
            bean.setFaceTop(Manager.getInteger(rs, "face_top"));
            bean.setFaceWidth(Manager.getInteger(rs, "face_width"));
            bean.setFaceHeight(Manager.getInteger(rs, "face_height"));
            bean.setEyeLeftx(Manager.getInteger(rs, "eye_leftx"));
            bean.setEyeLefty(Manager.getInteger(rs, "eye_lefty"));
            bean.setEyeRightx(Manager.getInteger(rs, "eye_rightx"));
            bean.setEyeRighty(Manager.getInteger(rs, "eye_righty"));
            bean.setMouthX(Manager.getInteger(rs, "mouth_x"));
            bean.setMouthY(Manager.getInteger(rs, "mouth_y"));
            bean.setNoseX(Manager.getInteger(rs, "nose_x"));
            bean.setNoseY(Manager.getInteger(rs, "nose_y"));
            bean.setAngleYaw(Manager.getInteger(rs, "angle_yaw"));
            bean.setAnglePitch(Manager.getInteger(rs, "angle_pitch"));
            bean.setAngleRoll(Manager.getInteger(rs, "angle_roll"));
            bean.setExtInfo(Manager.getBytes(rs, "ext_info"));
            bean.setFeatureMd5(rs.getString("feature_md5"));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }

        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //////////////////////////////////////
    // PREPARED STATEMENT LOADER
    //////////////////////////////////////

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public FlFaceBean[] loadByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatement(ps, null);
    }

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public List<FlFaceBean> loadByPreparedStatementAsList(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, null);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public FlFaceBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, fieldList).toArray(new FlFaceBean[0]);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public List<FlFaceBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList) throws DaoException
    { 
        return loadByPreparedStatementAsList(ps,fieldList,1,-1);
    }

    //34
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public FlFaceBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return loadByPreparedStatementAsList(ps,fieldList,startRow,numRows).toArray(new FlFaceBean[0]);
    }

    //34-1
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlFaceBean
     * @throws DaoException
     */
    public List<FlFaceBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        loadByPreparedStatement(ps,fieldList,startRow,numRows,action);
        return action.getList();
    }
    //34-2
    /**
     * Loads each element using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows 
     * and dealt by action.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */     
    public int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows,Action<FlFaceBean> action) throws DaoException
    {
        ResultSet rs =  null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            return this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(rs);
        }
    }
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    private final TableListener.ListenerContainer<FlFaceBean> listenerContainer = new TableListener.ListenerContainer<FlFaceBean>();

    //35

    @Override
    public TableListener<FlFaceBean> registerListener(TableListener<FlFaceBean> listener)
    {
        this.listenerContainer.add(listener);
        return listener;
    }

    //36
    /**
     * remove listener.
     */
    @Override
    public void unregisterListener(TableListener<FlFaceBean> listener)
    {
        this.listenerContainer.remove(listener);
    }

    //37

    @Override
    public void fire(TableListener.Event event, FlFaceBean bean) throws DaoException{
        if(null == event){
            throw new NullPointerException();
        }
        event.fire(listenerContainer, bean);
    }
    
    //37-1

    @Override
    public void fire(int event, FlFaceBean bean) throws DaoException{
        try{
            fire(TableListener.Event.values()[event],bean);
        }catch(ArrayIndexOutOfBoundsException e){
            throw new IllegalArgumentException("invalid event id " + event);
        }
    }

    /** foreign key listener for DEELTE RULE : CASCADE */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlImageBean,FlFaceBean> foreignKeyListenerByImageMd5 = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlImageBean,FlFaceBean>(){
                @Override
                protected List<FlFaceBean> getImportedBeans(FlImageBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlFaceBean>emptyList()
                            : instanceOfFlImageManager().getFaceBeansByImageMd5AsList(bean);
                }
                @Override
                protected void onRemove(List<FlFaceBean> effectBeans) throws DaoException {
                    for(FlFaceBean bean:effectBeans){
                        Event.DELETE.fire(listenerContainer, bean);
                    }
                }};

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlFeatureBean,FlFaceBean> foreignKeyListenerByFeatureMd5 = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlFeatureBean,FlFaceBean>(){
                @Override
                protected List<FlFaceBean> getImportedBeans(FlFeatureBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlFaceBean>emptyList()
                            : instanceOfFlFeatureManager().getFaceBeansByFeatureMd5AsList(bean);
                }
                @Override
                protected void onRemove(List<FlFaceBean> effectBeans) throws DaoException {
                    for(FlFaceBean bean:effectBeans){
                        bean.setFeatureMd5(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    //37-2
    /**
     * bind foreign key listener to foreign table: <br>
     * DELETE RULE : CASCADE {@code fl_face(image_md5)- fl_image(md5)} <br>
     * DELETE RULE : SET_NULL {@code fl_face(feature_md5)- fl_feature(md5)} <br>
     */
    public void bindForeignKeyListenerForDeleteRule(){
        instanceOfFlImageManager().registerListener(foreignKeyListenerByImageMd5);
        instanceOfFlFeatureManager().registerListener(foreignKeyListenerByFeatureMd5);
        
    }
    //37-3
    /**
     * unbind foreign key listener from all of foreign tables <br>
     * @see #bindForeignKeyListenerForDeleteRule()
     */
    public void unbindForeignKeyListenerForDeleteRule(){
        instanceOfFlImageManager().unregisterListener(foreignKeyListenerByImageMd5);
        instanceOfFlFeatureManager().unregisterListener(foreignKeyListenerByFeatureMd5);
        
    }
    //_____________________________________________________________________
    //
    // UTILS
    //_____________________________________________________________________

    //40
    /**
     * Retrieves the manager object used to get connections.
     *
     * @return the manager used
     */
    private Manager getManager()
    {
        return Manager.getInstance();
    }

    //41
    /**
     * Frees the connection.
     *
     * @param c the connection to release
     */
    private void freeConnection(Connection c)
    {
        // back to pool
        this.getManager().releaseConnection(c);
    }

    //42
    /**
     * Gets the connection.
     */
    private Connection getConnection() throws DaoException
    {
        try
        {
            return this.getManager().getConnection();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
    }

    //43

    @Override
    public boolean isPrimaryKey(String column){
        for(String c:PRIMARYKEY_NAMES){
            if(c.equalsIgnoreCase(column)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Fill the given prepared statement with the values in argList
     * @param ps the PreparedStatement that will be filled
     * @param argList the arguments to use fill given prepared statement
     * @throws DaoException
     */
    private void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws DaoException{
        try {
            if (!(argList == null || ps == null)) {
                for (int i = 0; i < argList.length; i++) {
                    if (argList[i].getClass().equals(byte[].class)) {
                        ps.setBytes(i + 1, (byte[]) argList[i]);
                    } else {
                        ps.setObject(i + 1, argList[i]);
                    }
                }
            }
        } catch (SQLException e) {
            throw new DaoException(e);
        }
    }
    
    @Override    

    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<FlFaceBean> action) throws DaoException{
        PreparedStatement ps = null;
        Connection connection = null;
        // logger.debug("sql string:\n" + sql + "\n");
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            fillPrepareStatement(ps, argList);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }
   
    @Override

    public <T>T runAsTransaction(Callable<T> fun) throws DaoException{
        return Manager.getInstance().runAsTransaction(fun);
    }
    
    class DeleteBeanAction extends Action.BaseAdapter<FlFaceBean>{
        private final AtomicInteger count=new AtomicInteger(0);
        @Override
        public void call(FlFaceBean bean) throws DaoException {
                FlFaceManager.this.delete(bean);
                count.incrementAndGet();
        }
        int getCount(){
            return count.get();
        }
    }
    //45
    /**
     * return a primary key list from {@link FlFaceBean} array
     * @param array
     */
    public List<Integer> toPrimaryKeyList(FlFaceBean... array){        
        if(null == array){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(array.length);
        for(FlFaceBean bean:array){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
    //46
    /**
     * return a primary key list from {@link FlFaceBean} collection
     * @param collection
     */
    public List<Integer> toPrimaryKeyList(java.util.Collection<FlFaceBean> collection){        
        if(null == collection){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(collection.size());
        for(FlFaceBean bean:collection){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
}
