// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: bean.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.log;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.BaseBean;
import net.gdface.facelog.dborm.device.FlDeviceBean;
import net.gdface.facelog.dborm.face.FlFaceBean;
import net.gdface.facelog.dborm.face.FlFeatureBean;
import net.gdface.facelog.dborm.person.FlPersonBean;
import net.gdface.facelog.dborm.CompareToBuilder;
import net.gdface.facelog.dborm.EqualsBuilder;
import net.gdface.facelog.dborm.HashCodeBuilder;
/**
 * FlLogBean is a mapping of fl_log Table.
 * <br>Meta Data Information (in progress):
 * <ul>
 *    <li>comments: 人脸验证日志,记录所有通过验证的人员 </li>
 * </ul>
 * @author guyadong
*/
public  class FlLogBean
    implements Serializable,BaseBean<FlLogBean>,Comparable<FlLogBean>,Constant,Cloneable
{
    private static final long serialVersionUID = 7869683986300606649L;
    /** NULL {@link FlLogBean} bean , IMMUTABLE instance */
    public static final FlLogBean NULL = new FlLogBean().asNULL().asImmutable();
    /** comments:日志id */
    private Integer id;

    /** comments:外键,用户id */
    private Integer personId;

    /** comments:外键,日志来源设备id */
    private Integer deviceId;

    /** comments:外键,用于验证身份的人脸特征数据MD5 id */
    private String verifyFeature;

    /** comments:外键,数据库中相似度最高的人脸 id */
    private Integer compareFace;

    /** comments:验证状态,NULL,0:允许通过,其他:拒绝 */
    private Integer verifyStatus;

    /** comments:验证相似度 */
    private Double similarty;

    /** comments:验证时间(可能由前端设备提供时间) */
    private java.util.Date verifyTime;

    private java.util.Date createTime;

    /** flag whether {@code this} can be modified */
    private Boolean immutable;
    /** columns modified flag */
    private long modified;
    /** columns initialized flag */
    private long initialized;
    private boolean isNew;        
    /** 
     * set immutable status
     * @return {@code this} 
     */
    private FlLogBean immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }
    /** 
     * set {@code this} as immutable object
     * @return {@code this} 
     */
    public FlLogBean asImmutable() {
        return immutable(Boolean.TRUE);
    }
    /**
     * @return {@code true} if {@code this} is a mutable object  
     */
    public boolean mutable(){
        return !Boolean.TRUE.equals(this.immutable);
    }
    /**
     * @return {@code this}
     * @throws IllegalStateException if {@code this} is a immutable object 
     */
    private FlLogBean checkMutable(){
        if(!mutable()){
            throw new IllegalStateException("this is a immutable object");
        }
        return this;
    }
    /**
     * @return return a new mutable copy of this object.
     */
    public FlLogBean cloneMutable(){
        return clone().immutable(null);
    }
    @Override
    public boolean isNew()
    {
        return this.isNew;
    }


    @Override
    public void isNew(boolean isNew)
    {
        this.isNew = isNew;
    }
    /**
     * Specifies to the object if it has been set as new.
     *
     * @param isNew the boolean value to be assigned to the isNew field
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }
    /**
     * @return the modified status of columns
     */
    public long getModified(){
        return modified;
    }

    /**
     * @param modified the modified status bit to be assigned to {@link #modified}
     */
    public void setModified(long modified){
        this.modified = modified;
    }
    /**
     * @return the initialized status of columns
     */
    public long getInitialized(){
        return initialized;
    }

    /**
     * @param initialized the initialized status bit to be assigned to {@link #initialized}
     */
    public void setInitialized(long initialized){
        this.initialized = initialized;
    }
    protected static final <T extends Comparable<T>>boolean equals(T a, T b) {
        return a == b || (a != null && 0==a.compareTo(b));
    }
    public FlLogBean(){
        super();
        reset();
    }
    /**
     * construct a new instance filled with primary keys
     * @param id PK# 1 
     */
    public FlLogBean(Integer id){
        this();
        setId(id);
    }
    /**
     * Getter method for {@link #id}.<br>
     * PRIMARY KEY.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.id</li>
     * <li>comments: 日志id</li>
     * <li>AUTO_INCREMENT</li>
     * <li>NOT NULL</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of id
     */
    public Integer getId(){
        return id;
    }
    /**
     * Setter method for {@link #id}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to id
     */
    public void setId(Integer newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, id)) {
            return;
        }
        id = newVal;

        modified |= FL_LOG_ID_ID_MASK;
        initialized |= FL_LOG_ID_ID_MASK;
    }
    /**
     * Setter method for {@link #id}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to id
     */
    public void setId(int newVal)
    {
        setId(new Integer(newVal));
    }
    /**
     * Determines if the id has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkIdModified()
    {
        return 0L !=  (modified & FL_LOG_ID_ID_MASK);
    }

    /**
     * Determines if the id has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkIdInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_ID_MASK);
    }
    /**
     * Getter method for {@link #personId}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.person_id</li>
     * <li> foreign key: fl_person.id</li>
     * <li>comments: 外键,用户id</li>
     * <li>NOT NULL</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of personId
     */
    public Integer getPersonId(){
        return personId;
    }
    /**
     * Setter method for {@link #personId}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to personId
     */
    public void setPersonId(Integer newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, personId)) {
            return;
        }
        personId = newVal;

        modified |= FL_LOG_ID_PERSON_ID_MASK;
        initialized |= FL_LOG_ID_PERSON_ID_MASK;
    }
    /**
     * Setter method for {@link #personId}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to personId
     */
    public void setPersonId(int newVal)
    {
        setPersonId(new Integer(newVal));
    }
    /**
     * Determines if the personId has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkPersonIdModified()
    {
        return 0L !=  (modified & FL_LOG_ID_PERSON_ID_MASK);
    }

    /**
     * Determines if the personId has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkPersonIdInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_PERSON_ID_MASK);
    }
    /**
     * Getter method for {@link #deviceId}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.device_id</li>
     * <li> foreign key: fl_device.id</li>
     * <li>comments: 外键,日志来源设备id</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of deviceId
     */
    public Integer getDeviceId(){
        return deviceId;
    }
    /**
     * Setter method for {@link #deviceId}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to deviceId
     */
    public void setDeviceId(Integer newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, deviceId)) {
            return;
        }
        deviceId = newVal;

        modified |= FL_LOG_ID_DEVICE_ID_MASK;
        initialized |= FL_LOG_ID_DEVICE_ID_MASK;
    }
    /**
     * Setter method for {@link #deviceId}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to deviceId
     */
    public void setDeviceId(int newVal)
    {
        setDeviceId(new Integer(newVal));
    }
    /**
     * Determines if the deviceId has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkDeviceIdModified()
    {
        return 0L !=  (modified & FL_LOG_ID_DEVICE_ID_MASK);
    }

    /**
     * Determines if the deviceId has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkDeviceIdInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_DEVICE_ID_MASK);
    }
    /**
     * Getter method for {@link #verifyFeature}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.verify_feature</li>
     * <li> foreign key: fl_feature.md5</li>
     * <li>comments: 外键,用于验证身份的人脸特征数据MD5 id</li>
     * <li>column size: 32</li>
     * <li>JDBC type returned by the driver: Types.CHAR</li>
     * </ul>
     *
     * @return the value of verifyFeature
     */
    public String getVerifyFeature(){
        return verifyFeature;
    }
    /**
     * Setter method for {@link #verifyFeature}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to verifyFeature
     */
    public void setVerifyFeature(String newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, verifyFeature)) {
            return;
        }
        verifyFeature = newVal;

        modified |= FL_LOG_ID_VERIFY_FEATURE_MASK;
        initialized |= FL_LOG_ID_VERIFY_FEATURE_MASK;
    }
    /**
     * Determines if the verifyFeature has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkVerifyFeatureModified()
    {
        return 0L !=  (modified & FL_LOG_ID_VERIFY_FEATURE_MASK);
    }

    /**
     * Determines if the verifyFeature has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkVerifyFeatureInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_VERIFY_FEATURE_MASK);
    }
    /**
     * Getter method for {@link #compareFace}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.compare_face</li>
     * <li> foreign key: fl_face.id</li>
     * <li>comments: 外键,数据库中相似度最高的人脸 id</li>
     * <li>column size: 10</li>
     * <li>JDBC type returned by the driver: Types.INTEGER</li>
     * </ul>
     *
     * @return the value of compareFace
     */
    public Integer getCompareFace(){
        return compareFace;
    }
    /**
     * Setter method for {@link #compareFace}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to compareFace
     */
    public void setCompareFace(Integer newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, compareFace)) {
            return;
        }
        compareFace = newVal;

        modified |= FL_LOG_ID_COMPARE_FACE_MASK;
        initialized |= FL_LOG_ID_COMPARE_FACE_MASK;
    }
    /**
     * Setter method for {@link #compareFace}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to compareFace
     */
    public void setCompareFace(int newVal)
    {
        setCompareFace(new Integer(newVal));
    }
    /**
     * Determines if the compareFace has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkCompareFaceModified()
    {
        return 0L !=  (modified & FL_LOG_ID_COMPARE_FACE_MASK);
    }

    /**
     * Determines if the compareFace has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkCompareFaceInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_COMPARE_FACE_MASK);
    }
    /**
     * Getter method for {@link #verifyStatus}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.verify_status</li>
     * <li>comments: 验证状态,NULL,0:允许通过,其他:拒绝</li>
     * <li>column size: 3</li>
     * <li>JDBC type returned by the driver: Types.TINYINT</li>
     * </ul>
     *
     * @return the value of verifyStatus
     */
    public Integer getVerifyStatus(){
        return verifyStatus;
    }
    /**
     * Setter method for {@link #verifyStatus}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to verifyStatus
     */
    public void setVerifyStatus(Integer newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, verifyStatus)) {
            return;
        }
        verifyStatus = newVal;

        modified |= FL_LOG_ID_VERIFY_STATUS_MASK;
        initialized |= FL_LOG_ID_VERIFY_STATUS_MASK;
    }
    /**
     * Setter method for {@link #verifyStatus}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to verifyStatus
     */
    public void setVerifyStatus(int newVal)
    {
        setVerifyStatus(new Integer(newVal));
    }
    /**
     * Determines if the verifyStatus has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkVerifyStatusModified()
    {
        return 0L !=  (modified & FL_LOG_ID_VERIFY_STATUS_MASK);
    }

    /**
     * Determines if the verifyStatus has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkVerifyStatusInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_VERIFY_STATUS_MASK);
    }
    /**
     * Getter method for {@link #similarty}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.similarty</li>
     * <li>comments: 验证相似度</li>
     * <li>column size: 22</li>
     * <li>JDBC type returned by the driver: Types.DOUBLE</li>
     * </ul>
     *
     * @return the value of similarty
     */
    public Double getSimilarty(){
        return similarty;
    }
    /**
     * Setter method for {@link #similarty}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value to be assigned to similarty
     */
    public void setSimilarty(Double newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, similarty)) {
            return;
        }
        similarty = newVal;

        modified |= FL_LOG_ID_SIMILARTY_MASK;
        initialized |= FL_LOG_ID_SIMILARTY_MASK;
    }
    /**
     * Setter method for {@link #similarty}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to similarty
     */
    public void setSimilarty(double newVal)
    {
        setSimilarty(new Double(newVal));
    }
    /**
     * Determines if the similarty has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkSimilartyModified()
    {
        return 0L !=  (modified & FL_LOG_ID_SIMILARTY_MASK);
    }

    /**
     * Determines if the similarty has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkSimilartyInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_SIMILARTY_MASK);
    }
    /**
     * Getter method for {@link #verifyTime}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.verify_time</li>
     * <li>comments: 验证时间(可能由前端设备提供时间)</li>
     * <li>default value: 'CURRENT_TIMESTAMP'</li>
     * <li>NOT NULL</li>
     * <li>column size: 19</li>
     * <li>JDBC type returned by the driver: Types.TIMESTAMP</li>
     * </ul>
     *
     * @return the value of verifyTime
     */
    public java.util.Date getVerifyTime(){
        return verifyTime;
    }
    /**
     * Setter method for {@link #verifyTime}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to verifyTime
     */
    public void setVerifyTime(java.util.Date newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, verifyTime)) {
            return;
        }
        verifyTime = newVal;

        modified |= FL_LOG_ID_VERIFY_TIME_MASK;
        initialized |= FL_LOG_ID_VERIFY_TIME_MASK;
    }
    /**
     * Setter method for {@link #verifyTime}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to verifyTime
     */
    public void setVerifyTime(long newVal)
    {
        setVerifyTime(new java.util.Date(newVal));
    }
    /**
     * Setter method for {@link #verifyTime}.<br>
     * @param newVal the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this Date object.
     */
    public void setVerifyTime(Long newVal)
    {
        setVerifyTime(null == newVal ? null : new java.util.Date(newVal));
    }
    /**
     * Determines if the verifyTime has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkVerifyTimeModified()
    {
        return 0L !=  (modified & FL_LOG_ID_VERIFY_TIME_MASK);
    }

    /**
     * Determines if the verifyTime has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkVerifyTimeInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_VERIFY_TIME_MASK);
    }
    /**
     * Getter method for {@link #createTime}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fl_log.create_time</li>
     * <li>default value: 'CURRENT_TIMESTAMP'</li>
     * <li>NOT NULL</li>
     * <li>column size: 19</li>
     * <li>JDBC type returned by the driver: Types.TIMESTAMP</li>
     * </ul>
     *
     * @return the value of createTime
     */
    public java.util.Date getCreateTime(){
        return createTime;
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to createTime
     */
    public void setCreateTime(java.util.Date newVal)
    {
        checkMutable();
        if (Objects.equals(newVal, createTime)) {
            return;
        }
        createTime = newVal;

        modified |= FL_LOG_ID_CREATE_TIME_MASK;
        initialized |= FL_LOG_ID_CREATE_TIME_MASK;
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to createTime
     */
    public void setCreateTime(long newVal)
    {
        setCreateTime(new java.util.Date(newVal));
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * @param newVal the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this Date object.
     */
    public void setCreateTime(Long newVal)
    {
        setCreateTime(null == newVal ? null : new java.util.Date(newVal));
    }
    /**
     * Determines if the createTime has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkCreateTimeModified()
    {
        return 0L !=  (modified & FL_LOG_ID_CREATE_TIME_MASK);
    }

    /**
     * Determines if the createTime has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkCreateTimeInitialized()
    {
        return 0L !=  (initialized & FL_LOG_ID_CREATE_TIME_MASK);
    }
    //////////////////////////////////////
    // referenced bean for FOREIGN KEYS
    //////////////////////////////////////
    /** 
     * The referenced {@link FlDeviceBean} by {@link #deviceId} . <br>
     * FOREIGN KEY (device_id) REFERENCES fl_device(id)
     */
    private FlDeviceBean referencedByDeviceId;
    /**
     * Getter method for {@link #referencedByDeviceId}.
     * @return FlDeviceBean
     */
    public FlDeviceBean getReferencedByDeviceId() {
        return this.referencedByDeviceId;
    }
    /**
     * Setter method for {@link #referencedByDeviceId}.
     * @param reference FlDeviceBean
     */
    public void setReferencedByDeviceId(FlDeviceBean reference) {
        this.referencedByDeviceId = reference;
    }
    /** 
     * The referenced {@link FlFaceBean} by {@link #compareFace} . <br>
     * FOREIGN KEY (compare_face) REFERENCES fl_face(id)
     */
    private FlFaceBean referencedByCompareFace;
    /**
     * Getter method for {@link #referencedByCompareFace}.
     * @return FlFaceBean
     */
    public FlFaceBean getReferencedByCompareFace() {
        return this.referencedByCompareFace;
    }
    /**
     * Setter method for {@link #referencedByCompareFace}.
     * @param reference FlFaceBean
     */
    public void setReferencedByCompareFace(FlFaceBean reference) {
        this.referencedByCompareFace = reference;
    }
    /** 
     * The referenced {@link FlFeatureBean} by {@link #verifyFeature} . <br>
     * FOREIGN KEY (verify_feature) REFERENCES fl_feature(md5)
     */
    private FlFeatureBean referencedByVerifyFeature;
    /**
     * Getter method for {@link #referencedByVerifyFeature}.
     * @return FlFeatureBean
     */
    public FlFeatureBean getReferencedByVerifyFeature() {
        return this.referencedByVerifyFeature;
    }
    /**
     * Setter method for {@link #referencedByVerifyFeature}.
     * @param reference FlFeatureBean
     */
    public void setReferencedByVerifyFeature(FlFeatureBean reference) {
        this.referencedByVerifyFeature = reference;
    }
    /** 
     * The referenced {@link FlPersonBean} by {@link #personId} . <br>
     * FOREIGN KEY (person_id) REFERENCES fl_person(id)
     */
    private FlPersonBean referencedByPersonId;
    /**
     * Getter method for {@link #referencedByPersonId}.
     * @return FlPersonBean
     */
    public FlPersonBean getReferencedByPersonId() {
        return this.referencedByPersonId;
    }
    /**
     * Setter method for {@link #referencedByPersonId}.
     * @param reference FlPersonBean
     */
    public void setReferencedByPersonId(FlPersonBean reference) {
        this.referencedByPersonId = reference;
    }

    @Override
    public boolean isModified()
    {
        return 0 != modified;
    }
  
    @Override
    public boolean isModified(int columnID){
        switch ( columnID ){
        case FL_LOG_ID_ID:
            return checkIdModified();
        case FL_LOG_ID_PERSON_ID:
            return checkPersonIdModified();
        case FL_LOG_ID_DEVICE_ID:
            return checkDeviceIdModified();
        case FL_LOG_ID_VERIFY_FEATURE:
            return checkVerifyFeatureModified();
        case FL_LOG_ID_COMPARE_FACE:
            return checkCompareFaceModified();
        case FL_LOG_ID_VERIFY_STATUS:
            return checkVerifyStatusModified();
        case FL_LOG_ID_SIMILARTY:
            return checkSimilartyModified();
        case FL_LOG_ID_VERIFY_TIME:
            return checkVerifyTimeModified();
        case FL_LOG_ID_CREATE_TIME:
            return checkCreateTimeModified();
        default:
            return false;
        }        
    }

    @Override
    public boolean isInitialized(int columnID){
        switch(columnID) {
        case FL_LOG_ID_ID:
            return checkIdInitialized();
        case FL_LOG_ID_PERSON_ID:
            return checkPersonIdInitialized();
        case FL_LOG_ID_DEVICE_ID:
            return checkDeviceIdInitialized();
        case FL_LOG_ID_VERIFY_FEATURE:
            return checkVerifyFeatureInitialized();
        case FL_LOG_ID_COMPARE_FACE:
            return checkCompareFaceInitialized();
        case FL_LOG_ID_VERIFY_STATUS:
            return checkVerifyStatusInitialized();
        case FL_LOG_ID_SIMILARTY:
            return checkSimilartyInitialized();
        case FL_LOG_ID_VERIFY_TIME:
            return checkVerifyTimeInitialized();
        case FL_LOG_ID_CREATE_TIME:
            return checkCreateTimeInitialized();
        default:
            return false;
        }
    }
    
    @Override
    public boolean isModified(String column){        
        return isModified(columnIDOf(column));
    }

    @Override
    public boolean isInitialized(String column){
        return isInitialized(columnIDOf(column));
    }
    
    @Override
    public void resetIsModified()
    {
        checkMutable();
        modified = 0L;
    }

    @Override
    public void resetPrimaryKeysModified()
    {
        modified &= (~(FL_LOG_ID_ID_MASK));
    }
    /**
     * Resets columns modification status except primary keys to 'not modified'.
     */
    public void resetModifiedExceptPrimaryKeys()
    {
        modified &= (~(FL_LOG_ID_PERSON_ID_MASK |
            FL_LOG_ID_DEVICE_ID_MASK |
            FL_LOG_ID_VERIFY_FEATURE_MASK |
            FL_LOG_ID_COMPARE_FACE_MASK |
            FL_LOG_ID_VERIFY_STATUS_MASK |
            FL_LOG_ID_SIMILARTY_MASK |
            FL_LOG_ID_VERIFY_TIME_MASK |
            FL_LOG_ID_CREATE_TIME_MASK));
    }
    /**
     * Resets the object initialization status to 'not initialized'.
     */
    private void resetInitialized()
    {
        initialized = 0L;
    }
    /** reset all fields to initial value, equal to a new bean */
    public void reset(){
        checkMutable();
        this.id = null;
        this.personId = null;
        this.deviceId = null;
        this.verifyFeature = null;
        this.compareFace = null;
        this.verifyStatus = null;
        this.similarty = null;
        /* DEFAULT:'CURRENT_TIMESTAMP'*/
        this.verifyTime = null;
        /* DEFAULT:'CURRENT_TIMESTAMP'*/
        this.createTime = null;
        this.isNew = true;
        this.modified = 0L;
        this.initialized = 0L;
    }
    @Override
    public boolean equals(Object object)
    {
        if (!(object instanceof FlLogBean)) {
            return false;
        }

        FlLogBean obj = (FlLogBean) object;
        return new EqualsBuilder()
            .append(getId(), obj.getId())
            .append(getPersonId(), obj.getPersonId())
            .append(getDeviceId(), obj.getDeviceId())
            .append(getVerifyFeature(), obj.getVerifyFeature())
            .append(getCompareFace(), obj.getCompareFace())
            .append(getVerifyStatus(), obj.getVerifyStatus())
            .append(getSimilarty(), obj.getSimilarty())
            .append(getVerifyTime(), obj.getVerifyTime())
            .append(getCreateTime(), obj.getCreateTime())
            .isEquals();
    }

    @Override
    public int hashCode()
    {
        return new HashCodeBuilder(-82280557, -700257973)
            .append(getId())
            .toHashCode();
    }

    @Override
    public String toString() {
        return toString(true,false);
    }
    /**
     * cast byte array to HEX string
     * 
     * @param input
     * @return {@code null} if {@code input} is null
     */
    private static final String toHex(byte[] input) {
        if (null == input){
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; i++) {
            sb.append(Character.forDigit((input[i] & 240) >> 4, 16));
            sb.append(Character.forDigit(input[i] & 15, 16));
        }
        return sb.toString();
    }
    protected static final StringBuilder append(StringBuilder buffer,boolean full,byte[] value){
        if(full || null == value){
            buffer.append(toHex(value));
        }else{
            buffer.append(value.length).append(" bytes");
        }
        return buffer;
    }
    private static int stringLimit = 64;
    private static final int MINIMUM_LIMIT = 16;
    protected static final StringBuilder append(StringBuilder buffer,boolean full,String value){
        if(full || null == value || value.length() <= stringLimit){
            buffer.append(value);
        }else{
            buffer.append(value.substring(0,stringLimit - 8)).append(" ...").append(value.substring(stringLimit-4,stringLimit));
        }
        return buffer;
    }
    protected static final <T>StringBuilder append(StringBuilder buffer,boolean full,T value){
        return buffer.append(value);
    }
    public static final void setStringLimit(int limit){
        if(limit < MINIMUM_LIMIT){
            throw new IllegalArgumentException(String.format("INVALID limit %d,minimum value %d",limit,MINIMUM_LIMIT));
        }
        stringLimit = limit;
    }
    @Override
    public String toString(boolean notNull, boolean fullIfStringOrBytes) {
        // only output initialized field
        StringBuilder builder = new StringBuilder(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append("[");
        int count = 0;        
        if(checkIdInitialized()){
            if(!notNull || null != getId()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("id=");
                append(builder,fullIfStringOrBytes,getId());
            }
        }
        if(checkPersonIdInitialized()){
            if(!notNull || null != getPersonId()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("person_id=");
                append(builder,fullIfStringOrBytes,getPersonId());
            }
        }
        if(checkDeviceIdInitialized()){
            if(!notNull || null != getDeviceId()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("device_id=");
                append(builder,fullIfStringOrBytes,getDeviceId());
            }
        }
        if(checkVerifyFeatureInitialized()){
            if(!notNull || null != getVerifyFeature()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("verify_feature=");
                append(builder,fullIfStringOrBytes,getVerifyFeature());
            }
        }
        if(checkCompareFaceInitialized()){
            if(!notNull || null != getCompareFace()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("compare_face=");
                append(builder,fullIfStringOrBytes,getCompareFace());
            }
        }
        if(checkVerifyStatusInitialized()){
            if(!notNull || null != getVerifyStatus()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("verify_status=");
                append(builder,fullIfStringOrBytes,getVerifyStatus());
            }
        }
        if(checkSimilartyInitialized()){
            if(!notNull || null != getSimilarty()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("similarty=");
                append(builder,fullIfStringOrBytes,getSimilarty());
            }
        }
        if(checkVerifyTimeInitialized()){
            if(!notNull || null != getVerifyTime()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("verify_time=");
                append(builder,fullIfStringOrBytes,getVerifyTime());
            }
        }
        if(checkCreateTimeInitialized()){
            if(!notNull || null != getCreateTime()){
                if(count++ >0){
                    builder.append(",");
                }
                builder.append("create_time=");
                append(builder,fullIfStringOrBytes,getCreateTime());
            }
        }
        builder.append("]");
        return builder.toString();
    }
    @Override
    public int compareTo(FlLogBean object){
        return new CompareToBuilder()
            .append(getId(), object.getId())
            .append(getPersonId(), object.getPersonId())
            .append(getDeviceId(), object.getDeviceId())
            .append(getVerifyFeature(), object.getVerifyFeature())
            .append(getCompareFace(), object.getCompareFace())
            .append(getVerifyStatus(), object.getVerifyStatus())
            .append(getSimilarty(), object.getSimilarty())
            .append(getVerifyTime(), object.getVerifyTime())
            .append(getCreateTime(), object.getCreateTime())
            .toComparison();
    }
    @Override
    public FlLogBean clone(){
        try {
            return (FlLogBean) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
    /**
     * Make {@code this} to a NULL bean<br>
     * set all fields to null, {@link #modified} and {@link #initialized} be set to 0
     * @return {@code this} bean
     * @author guyadong
     */
    public FlLogBean asNULL()
    {   
        checkMutable();
        
        setId((Integer)null);
        setPersonId((Integer)null);
        setDeviceId((Integer)null);
        setVerifyFeature((String)null);
        setCompareFace((Integer)null);
        setVerifyStatus((Integer)null);
        setSimilarty((Double)null);
        setVerifyTime((java.util.Date)null);
        setCreateTime((java.util.Date)null);
        isNew(true);
        resetInitialized();
        resetIsModified();
        return this;
    }
    /**
     * check whether this bean is a NULL bean 
     * @return {@code true} if {@link #initialized} be set to zero
     * @see #asNULL()
     */
    public boolean checkNULL(){
        return 0L == getInitialized();
    }
    /** 
     * @param source source list
     * @return {@code source} replace {@code null} element with null instance({@link #NULL})
     */
    public static final List<FlLogBean> replaceNull(List<FlLogBean> source){
        if(null != source){
            for(int i = 0,endIndex = source.size();i<endIndex;++i){
                if(null == source.get(i)){
                    source.set(i, NULL);
                }
            }
        }
        return source;
    }
    /** 
     * @param source input list
     * @return replace null instance element with {@code null}
     * @see #checkNULL()
     */
    public static final List<FlLogBean> replaceNullInstance(List<FlLogBean> source){
        if(null != source){
            for(int i = 0,endIndex = source.size();i<endIndex;++i){
                if(source.get(i).checkNULL()){
                    source.set(i, null);
                }
            }
        }
        return source;
    }
    @Override
    public FlLogBean copy(FlLogBean bean)
    {
        return copy(bean,new int[]{});
    }
    @Override
    public FlLogBean copy(FlLogBean bean, int... fieldList)
    {
        if (null == fieldList || 0 == fieldList.length){
            for (int i = 0; i < FL_LOG_COLUMN_COUNT; ++i) {
                if( bean.isInitialized(i)){
                    setValue(i, bean.getValue(i));
                }
            }
        }
        else{
            for (int i = 0; i < fieldList.length; ++i) {
                if( bean.isInitialized(fieldList[i])){
                    setValue(fieldList[i], bean.getValue(fieldList[i]));
                }
            }
        }
        return this;
    }
        
    @Override
    public FlLogBean copy(FlLogBean bean, String... fieldList)
    {
        if (null == fieldList || 0 == fieldList.length){
            copy(bean,(int[])null);
        }else{
            int field;
            for (int i = 0; i < fieldList.length; i++) {
                field = columnIDOf(fieldList[i].trim());
                if(bean.isInitialized(field)){
                    setValue(field, bean.getValue(field));
                }
            }
        }
        return this;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T>T getValue(int columnID)
    {
        switch( columnID ){
        case FL_LOG_ID_ID: 
            return (T)getId();        
        case FL_LOG_ID_PERSON_ID: 
            return (T)getPersonId();        
        case FL_LOG_ID_DEVICE_ID: 
            return (T)getDeviceId();        
        case FL_LOG_ID_VERIFY_FEATURE: 
            return (T)getVerifyFeature();        
        case FL_LOG_ID_COMPARE_FACE: 
            return (T)getCompareFace();        
        case FL_LOG_ID_VERIFY_STATUS: 
            return (T)getVerifyStatus();        
        case FL_LOG_ID_SIMILARTY: 
            return (T)getSimilarty();        
        case FL_LOG_ID_VERIFY_TIME: 
            return (T)getVerifyTime();        
        case FL_LOG_ID_CREATE_TIME: 
            return (T)getCreateTime();        
        default:
            return null;
        }
    }

    @Override
    public <T> void setValue(int columnID,T value)
    {
        switch( columnID ) {
        case FL_LOG_ID_ID:
            setId((Integer)value);
            break;
        case FL_LOG_ID_PERSON_ID:
            setPersonId((Integer)value);
            break;
        case FL_LOG_ID_DEVICE_ID:
            setDeviceId((Integer)value);
            break;
        case FL_LOG_ID_VERIFY_FEATURE:
            setVerifyFeature((String)value);
            break;
        case FL_LOG_ID_COMPARE_FACE:
            setCompareFace((Integer)value);
            break;
        case FL_LOG_ID_VERIFY_STATUS:
            setVerifyStatus((Integer)value);
            break;
        case FL_LOG_ID_SIMILARTY:
            setSimilarty((Double)value);
            break;
        case FL_LOG_ID_VERIFY_TIME:
            setVerifyTime((java.util.Date)value);
            break;
        case FL_LOG_ID_CREATE_TIME:
            setCreateTime((java.util.Date)value);
            break;
        default:
            break;
        }
    }
    
    @Override
    public <T> T getValue(String column)
    {
        return getValue(columnIDOf(column));
    }

    @Override
    public <T> void setValue(String column,T value)
    {
        setValue(columnIDOf(column),value);
    }
    
    /**
     * @param column column name
     * @return column id for the given field name or negative if {@code column} is invalid name 
     */
    public static int columnIDOf(String column){
        int index = FL_LOG_FIELDS_LIST.indexOf(column);
        return  index < 0 
            ? FL_LOG_JAVA_FIELDS_LIST.indexOf(column)
            : index;
    }
    
    public static final Builder builder(){
        return new Builder();
    }
    /** 
     * a builder for FlLogBean,the template instance is thread local variable
     * a instance of Builder can be reused.
     */
    public static final class Builder{
        /** FlLogBean instance used for template to create new FlLogBean instance. */
        static final ThreadLocal<FlLogBean> TEMPLATE = new ThreadLocal<FlLogBean>(){
            @Override
            protected FlLogBean initialValue() {
                return new FlLogBean();
            }};
        private Builder() {}
        /** 
         * reset the bean as template 
         * @see FlLogBean#reset()
         */
        public Builder reset(){
            TEMPLATE.get().reset();
            return this;
        }
        /** set a bean as template,must not be {@code null} */
        public Builder template(FlLogBean bean){
            if(null == bean){
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }
        /** return a clone instance of {@link #TEMPLATE}*/
        public FlLogBean build(){
            return TEMPLATE.get().clone();
        }
        /** 
         * fill the field : fl_log.id
         * @param id 日志id
         * @see FlLogBean#getId()
         * @see FlLogBean#setId(Integer)
         */
        public Builder id(Integer id){
            TEMPLATE.get().setId(id);
            return this;
        }
        /** 
         * fill the field : fl_log.person_id
         * @param personId 外键,用户id
         * @see FlLogBean#getPersonId()
         * @see FlLogBean#setPersonId(Integer)
         */
        public Builder personId(Integer personId){
            TEMPLATE.get().setPersonId(personId);
            return this;
        }
        /** 
         * fill the field : fl_log.device_id
         * @param deviceId 外键,日志来源设备id
         * @see FlLogBean#getDeviceId()
         * @see FlLogBean#setDeviceId(Integer)
         */
        public Builder deviceId(Integer deviceId){
            TEMPLATE.get().setDeviceId(deviceId);
            return this;
        }
        /** 
         * fill the field : fl_log.verify_feature
         * @param verifyFeature 外键,用于验证身份的人脸特征数据MD5 id
         * @see FlLogBean#getVerifyFeature()
         * @see FlLogBean#setVerifyFeature(String)
         */
        public Builder verifyFeature(String verifyFeature){
            TEMPLATE.get().setVerifyFeature(verifyFeature);
            return this;
        }
        /** 
         * fill the field : fl_log.compare_face
         * @param compareFace 外键,数据库中相似度最高的人脸 id
         * @see FlLogBean#getCompareFace()
         * @see FlLogBean#setCompareFace(Integer)
         */
        public Builder compareFace(Integer compareFace){
            TEMPLATE.get().setCompareFace(compareFace);
            return this;
        }
        /** 
         * fill the field : fl_log.verify_status
         * @param verifyStatus 验证状态,NULL,0:允许通过,其他:拒绝
         * @see FlLogBean#getVerifyStatus()
         * @see FlLogBean#setVerifyStatus(Integer)
         */
        public Builder verifyStatus(Integer verifyStatus){
            TEMPLATE.get().setVerifyStatus(verifyStatus);
            return this;
        }
        /** 
         * fill the field : fl_log.similarty
         * @param similarty 验证相似度
         * @see FlLogBean#getSimilarty()
         * @see FlLogBean#setSimilarty(Double)
         */
        public Builder similarty(Double similarty){
            TEMPLATE.get().setSimilarty(similarty);
            return this;
        }
        /** 
         * fill the field : fl_log.verify_time
         * @param verifyTime 验证时间(可能由前端设备提供时间)
         * @see FlLogBean#getVerifyTime()
         * @see FlLogBean#setVerifyTime(java.util.Date)
         */
        public Builder verifyTime(java.util.Date verifyTime){
            TEMPLATE.get().setVerifyTime(verifyTime);
            return this;
        }
        /** 
         * fill the field : fl_log.create_time
         * @param createTime 
         * @see FlLogBean#getCreateTime()
         * @see FlLogBean#setCreateTime(java.util.Date)
         */
        public Builder createTime(java.util.Date createTime){
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
    }
}
