// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: manager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.Manager;
import net.gdface.facelog.dborm.TableListener;
import net.gdface.facelog.dborm.TableManager;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.DataAccessException;
import net.gdface.facelog.dborm.exception.DataRetrievalException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
import net.gdface.facelog.dborm.device.FlDeviceBean;
import net.gdface.facelog.dborm.device.FlDeviceManager;
import net.gdface.facelog.dborm.face.FlFaceBean;
import net.gdface.facelog.dborm.face.FlFaceManager;
import net.gdface.facelog.dborm.face.FlFeatureBean;
import net.gdface.facelog.dborm.face.FlFeatureManager;
import net.gdface.facelog.dborm.person.FlPersonBean;
import net.gdface.facelog.dborm.person.FlPersonManager;

/**
 * Handles database calls (save, load, count, etc...) for the fl_log table.<br>
 * Remarks: 人脸验证日志,记录所有通过验证的人员<br>
 * @author sql2java
 */
public class FlLogManager extends TableManager.BaseAdapter<FlLogBean>
{
    /**
     * Tablename.
     */
    public static final String TABLE_NAME="fl_log";

    /**
     * Contains all the primary key fields of the fl_log table.
     */
    public static final String[] PRIMARYKEY_NAMES =
    {
        "id"
    };

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }
    
    @Override
    public String getFields() {
        return FL_LOG_FIELDS;
    }
    
    @Override
    public String getFullFields() {
        return FL_LOG_FULL_FIELDS;
    }

    @Override
    public String[] getPrimarykeyNames() {
        return PRIMARYKEY_NAMES;
    }

    private static FlLogManager singleton = new FlLogManager();
    protected FlLogManager(){}
    /**
     * Get the FlLogManager singleton.
     *
     * @return FlLogManager
     */
    public static FlLogManager getInstance()
    {
        return singleton;
    }


    /**
     * Creates a new FlLogBean instance.
     *
     * @return the new FlLogBean
     */
    public FlLogBean createBean()
    {
        return new FlLogBean();
    }
    
    @Override
    protected Class<FlLogBean> beanType(){
        return FlLogBean.class;
    }
    
    protected FlDeviceManager instanceOfFlDeviceManager(){
        return FlDeviceManager.getInstance();
    }
    protected FlFaceManager instanceOfFlFaceManager(){
        return FlFaceManager.getInstance();
    }
    protected FlFeatureManager instanceOfFlFeatureManager(){
        return FlFeatureManager.getInstance();
    }
    protected FlPersonManager instanceOfFlPersonManager(){
        return FlPersonManager.getInstance();
    }
    //////////////////////////////////////
    // PRIMARY KEY METHODS
    //////////////////////////////////////

    //1
    /**
     * Loads a {@link FlLogBean} from the fl_log using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlLogBean or {@code null} if not found or have null argument
     * @throws DaoException
     */
    public FlLogBean loadByPrimaryKey(Integer id) throws DaoException
    {
        try{
            return loadByPrimaryKeyChecked(id);
        }catch(ObjectRetrievalException e){
            // not found
            return null;
        }
    }
    
    //1.1
    /**
     * Loads a {@link FlLogBean} from the fl_log using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlLogBean
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public FlLogBean loadByPrimaryKeyChecked(Integer id) throws DaoException
    {
        if(null == id){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT " + FL_LOG_FIELDS + " FROM fl_log WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_LOG_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_LOG_ID_ID + 1, id); }
            List<FlLogBean> pReturn = this.loadByPreparedStatementAsList(ps);
            if (1 == pReturn.size()) {
                return pReturn.get(0);
            } else {
                throw new ObjectRetrievalException();
            }
        }
        catch(ObjectRetrievalException e)
        {
            throw e;
        }
        catch(SQLException e)
        {
            throw new DataRetrievalException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //1.2
    
    @Override
    public FlLogBean loadByPrimaryKey(FlLogBean bean) throws DaoException
    {
        return bean==null?null:loadByPrimaryKey(bean.getId());
    }
    
    //1.2.2
    
    @Override
    public FlLogBean loadByPrimaryKeyChecked(FlLogBean bean) throws DaoException
    {
        if(null == bean){
            throw new NullPointerException();
        }
        return loadByPrimaryKeyChecked(bean.getId());
    }
    
    //1.3
    /**
     * Loads a {@link FlLogBean} from the fl_log using primary key fields.
     * @param keys primary keys value:<br> 
     * @return a unique {@link FlLogBean} or {@code null} if not found
     * @see #loadByPrimaryKey(Integer id)
     */
    @Override
    public FlLogBean loadByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_LOG_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(null == keys[0]){
            return null;
        }
        return loadByPrimaryKey((Integer)keys[0]);
    }
    //1.3.2

    @Override
    public FlLogBean loadByPrimaryKeyChecked(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_LOG_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(! (keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        return loadByPrimaryKeyChecked((Integer)keys[0]);
    }
    //1.4
    /**
     * Returns true if this fl_log contains row with primary key fields.
     * @param id Integer - PK# 1
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public boolean existsPrimaryKey(Integer id) throws DaoException
    {
        if(null == id){
            return false;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try{
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_log WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_LOG_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_LOG_ID_ID + 1, id); }
            return 1 == this.countByPreparedStatement(ps);
        }catch(SQLException e){
            throw new ObjectRetrievalException(e);
        }finally{
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }
    //1.6
    /**
     * Return true if this fl_log contains row with primary key fields.
     * @param bean  
     * @throws DaoException
     * @return false if primary kes has null
     */
    @Override
    public boolean existsByPrimaryKey(FlLogBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return false;
        }
        long modified = bean.getModified();
        try{
            bean.resetModifiedExceptPrimaryKeys();
            return 1 == countUsingTemplate(bean);
        }finally{
            bean.setModified(modified);
        }
    }
    //1.7

    @Override
    public FlLogBean checkDuplicate(FlLogBean bean) throws DaoException{
        if(existsByPrimaryKey(bean)){
            throw new ObjectRetrievalException("Duplicate entry ("+ bean.getId() +") for key 'PRIMARY'");
        }
        return bean;
    }
    //1.4.1
    /**
     * Check duplicated row by primary keys,if row exists throw {@link ObjectRetrievalException}
     * @param id Integer
     * @throws DaoException
     * @see #existsPrimaryKey(Integer id)
     */
    public Integer checkDuplicate(Integer id) throws DaoException
    {
        if(existsPrimaryKey(id)){
            throw new ObjectRetrievalException("Duplicate entry '"+ id +"' for key 'PRIMARY'");
        }
        return id;
    }    
    //2
    /**
     * Delete row according to its primary keys.<br>
     * all keys must not be null
     * 
     * @param id Integer - PK# 1
     * @return the number of deleted rows
     * @throws DaoException
     * @see #delete(FlLogBean)
     */
    public int deleteByPrimaryKey(Integer id) throws DaoException
    {
        FlLogBean bean=createBean();
        bean.setId(id);
        return this.delete(bean);
    }

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    @Override
    public int delete(FlLogBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            // listener callback
            this.listenerContainer.beforeDelete(bean);
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_log WHERE id=?");
            // System.out.println("deleteByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getId() == null) { ps.setNull(FL_LOG_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_LOG_ID_ID + 1, bean.getId()); }
            int rows=ps.executeUpdate();
            if(rows>0){
                // listener callback
                this.listenerContainer.afterDelete(bean);
            }
            return rows;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value:<br> 
     * @return the number of deleted rows
     * @see #delete(FlLogBean)
     */   
    @Override
    public int deleteByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_LOG_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        FlLogBean bean = createBean();   
        
        if(null != keys[0] && !(keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        bean.setId((Integer)keys[0]);
        return delete(bean);
    }
 
     //3.5 SYNC SAVE 
    /**
     * Save the FlLogBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlLogBean} bean to be saved
     * @param refDeviceByDeviceId the {@link FlDeviceBean} bean referenced by {@link FlLogBean} 
     * @param refFaceByCompareFace the {@link FlFaceBean} bean referenced by {@link FlLogBean} 
     * @param refFeatureByVerifyFeature the {@link FlFeatureBean} bean referenced by {@link FlLogBean} 
     * @param refPersonByPersonId the {@link FlPersonBean} bean referenced by {@link FlLogBean} 
         * @return the inserted or updated {@link FlLogBean} bean
     * @throws DaoException
     */
    public FlLogBean save(FlLogBean bean
        , FlDeviceBean refDeviceByDeviceId , FlFaceBean refFaceByCompareFace , FlFeatureBean refFeatureByVerifyFeature , FlPersonBean refPersonByPersonId 
        ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refDeviceByDeviceId){
            this.setReferencedByDeviceId(bean,refDeviceByDeviceId);
        }
        if(null != refFaceByCompareFace){
            this.setReferencedByCompareFace(bean,refFaceByCompareFace);
        }
        if(null != refFeatureByVerifyFeature){
            this.setReferencedByVerifyFeature(bean,refFeatureByVerifyFeature);
        }
        if(null != refPersonByPersonId){
            this.setReferencedByPersonId(bean,refPersonByPersonId);
        }
        bean = this.save( bean );
        return bean;
    } 

    //3.6 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlLogBean , FlDeviceBean , FlFaceBean , FlFeatureBean , FlPersonBean )
     */
    public FlLogBean saveAsTransaction(final FlLogBean bean
        ,final FlDeviceBean refDeviceByDeviceId ,final FlFaceBean refFaceByCompareFace ,final FlFeatureBean refFeatureByVerifyFeature ,final FlPersonBean refPersonByPersonId 
        ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlLogBean>(){
            @Override
            public FlLogBean call() throws Exception {
                return save(bean , refDeviceByDeviceId , refFaceByCompareFace , refFeatureByVerifyFeature , refPersonByPersonId );
            }});
    }

    private static final int SYNC_SAVE_ARG_LEN = 4;
    private static final int SYNC_SAVE_ARG_0 = 0;
    private static final int SYNC_SAVE_ARG_1 = 1;
    private static final int SYNC_SAVE_ARG_2 = 2;
    private static final int SYNC_SAVE_ARG_3 = 3;
    //3.9 SYNC SAVE 
    /**
     * Save the FlLogBean bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the {@link FlLogBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlLogBean , FlDeviceBean , FlFaceBean , FlFeatureBean , FlPersonBean )}
     * @return the inserted or updated {@link FlLogBean} bean
     * @throws DaoException
     */
    @Override
    public FlLogBean save(FlLogBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 4");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlDeviceBean)){
            throw new IllegalArgumentException("invalid type for the No.1 dynamic argument,expected type:FlDeviceBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlFaceBean)){
            throw new IllegalArgumentException("invalid type for the No.2 dynamic argument,expected type:FlFaceBean");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof FlFeatureBean)){
            throw new IllegalArgumentException("invalid type for the No.3 dynamic argument,expected type:FlFeatureBean");
        }
        if( null != args[SYNC_SAVE_ARG_3] && !(args[SYNC_SAVE_ARG_3] instanceof FlPersonBean)){
            throw new IllegalArgumentException("invalid type for the No.4 dynamic argument,expected type:FlPersonBean");
        }
        return save(bean,
                    (FlDeviceBean)args[SYNC_SAVE_ARG_0],
                    (FlFaceBean)args[SYNC_SAVE_ARG_1],
                    (FlFeatureBean)args[SYNC_SAVE_ARG_2],
                    (FlPersonBean)args[SYNC_SAVE_ARG_3]);
    } 

    //3.10 SYNC SAVE 
    /**
     * Save the FlLogBean bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the {@link FlLogBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlLogBean , FlDeviceBean , FlFaceBean , FlFeatureBean , FlPersonBean )}
     * @return the inserted or updated {@link FlLogBean} bean
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public FlLogBean saveCollection(FlLogBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 4");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlDeviceBean)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:FlDeviceBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlFaceBean)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:FlFaceBean");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof FlFeatureBean)){
            throw new IllegalArgumentException("invalid type for the No.3 argument,expected type:FlFeatureBean");
        }
        if( null != args[SYNC_SAVE_ARG_3] && !(args[SYNC_SAVE_ARG_3] instanceof FlPersonBean)){
            throw new IllegalArgumentException("invalid type for the No.4 argument,expected type:FlPersonBean");
        }
        return save(bean,
                    (FlDeviceBean)args[SYNC_SAVE_ARG_0],
                    (FlFaceBean)args[SYNC_SAVE_ARG_1],
                    (FlFeatureBean)args[SYNC_SAVE_ARG_2],
                    (FlPersonBean)args[SYNC_SAVE_ARG_3]);
    } 
    //////////////////////////////////////
    // FOREIGN KEY GENERIC METHOD
    //////////////////////////////////////

    /**
     * Retrieves the bean object referenced by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_LOG_FK_DEVICE_ID} - {@link FlDeviceBean}</li>
     *     <li> {@link Constant#FL_LOG_FK_COMPARE_FACE} - {@link FlFaceBean}</li>
     *     <li> {@link Constant#FL_LOG_FK_VERIFY_FEATURE} - {@link FlFeatureBean}</li>
     *     <li> {@link Constant#FL_LOG_FK_PERSON_ID} - {@link FlPersonBean}</li>
     * </ul>
     * @param bean the {@link FlLogBean} object to use
     * @param fkIndex valid values: <br>
     *        {@link Constant#FL_LOG_FK_DEVICE_ID},{@link Constant#FL_LOG_FK_COMPARE_FACE},{@link Constant#FL_LOG_FK_VERIFY_FEATURE},{@link Constant#FL_LOG_FK_PERSON_ID}
     * @return the associated T bean or {@code null} if {@code bean} or {@code beanToSet} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T getReferencedBean(FlLogBean bean,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_LOG_FK_DEVICE_ID:
            return  (T)this.getReferencedByDeviceId(bean);
        case FL_LOG_FK_COMPARE_FACE:
            return  (T)this.getReferencedByCompareFace(bean);
        case FL_LOG_FK_VERIFY_FEATURE:
            return  (T)this.getReferencedByVerifyFeature(bean);
        case FL_LOG_FK_PERSON_ID:
            return  (T)this.getReferencedByPersonId(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
    
    /**
     * Associates the {@link FlLogBean} object to the bean object by fkIndex field.<br>
     * 
     * @param <T> see also {@link #getReferencedBean(FlLogBean,int)}
     * @param bean the {@link FlLogBean} object to use
     * @param beanToSet the T object to associate to the {@link FlLogBean}
     * @param fkIndex valid values: see also {@link #getReferencedBean(FlLogBean,int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T setReferencedBean(FlLogBean bean,T beanToSet,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_LOG_FK_DEVICE_ID:
            return  (T)this.setReferencedByDeviceId(bean, (FlDeviceBean)beanToSet);
        case FL_LOG_FK_COMPARE_FACE:
            return  (T)this.setReferencedByCompareFace(bean, (FlFaceBean)beanToSet);
        case FL_LOG_FK_VERIFY_FEATURE:
            return  (T)this.setReferencedByVerifyFeature(bean, (FlFeatureBean)beanToSet);
        case FL_LOG_FK_PERSON_ID:
            return  (T)this.setReferencedByPersonId(bean, (FlPersonBean)beanToSet);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
     
    //////////////////////////////////////
    // GET/SET FOREIGN KEY BEAN METHOD
    //////////////////////////////////////


    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlDeviceBean} object referenced by {@link FlLogBean#getDeviceId}() field.<br>
     * FK_NAME : fl_log_ibfk_2
     * @param bean the {@link FlLogBean}
     * @return the associated {@link FlDeviceBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlDeviceBean getReferencedByDeviceId(FlLogBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByDeviceId(instanceOfFlDeviceManager().loadByPrimaryKey(bean.getDeviceId())); 
        return bean.getReferencedByDeviceId();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlLogBean} object to the {@link FlDeviceBean} object by {@link FlLogBean#getDeviceId}() field.
     *
     * @param bean the {@link FlLogBean} object to use
     * @param beanToSet the {@link FlDeviceBean} object to associate to the {@link FlLogBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlDeviceBean setReferencedByDeviceId(FlLogBean bean, FlDeviceBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlDeviceManager().save(beanToSet);
            bean.setReferencedByDeviceId(beanToSet);
            if( null == beanToSet){
                bean.setDeviceId(null);
            }else{
                bean.setDeviceId(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlFaceBean} object referenced by {@link FlLogBean#getCompareFace}() field.<br>
     * FK_NAME : fl_log_ibfk_4
     * @param bean the {@link FlLogBean}
     * @return the associated {@link FlFaceBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlFaceBean getReferencedByCompareFace(FlLogBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByCompareFace(instanceOfFlFaceManager().loadByPrimaryKey(bean.getCompareFace())); 
        return bean.getReferencedByCompareFace();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlLogBean} object to the {@link FlFaceBean} object by {@link FlLogBean#getCompareFace}() field.
     *
     * @param bean the {@link FlLogBean} object to use
     * @param beanToSet the {@link FlFaceBean} object to associate to the {@link FlLogBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlFaceBean setReferencedByCompareFace(FlLogBean bean, FlFaceBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlFaceManager().save(beanToSet);
            bean.setReferencedByCompareFace(beanToSet);
            if( null == beanToSet){
                bean.setCompareFace(null);
            }else{
                bean.setCompareFace(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlFeatureBean} object referenced by {@link FlLogBean#getVerifyFeature}() field.<br>
     * FK_NAME : fl_log_ibfk_3
     * @param bean the {@link FlLogBean}
     * @return the associated {@link FlFeatureBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlFeatureBean getReferencedByVerifyFeature(FlLogBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByVerifyFeature(instanceOfFlFeatureManager().loadByPrimaryKey(bean.getVerifyFeature())); 
        return bean.getReferencedByVerifyFeature();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlLogBean} object to the {@link FlFeatureBean} object by {@link FlLogBean#getVerifyFeature}() field.
     *
     * @param bean the {@link FlLogBean} object to use
     * @param beanToSet the {@link FlFeatureBean} object to associate to the {@link FlLogBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlFeatureBean setReferencedByVerifyFeature(FlLogBean bean, FlFeatureBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlFeatureManager().save(beanToSet);
            bean.setReferencedByVerifyFeature(beanToSet);
            if( null == beanToSet){
                bean.setVerifyFeature(null);
            }else{
                bean.setVerifyFeature(beanToSet.getMd5());
            }
        }
        return beanToSet;
    }

    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlPersonBean} object referenced by {@link FlLogBean#getPersonId}() field.<br>
     * FK_NAME : fl_log_ibfk_1
     * @param bean the {@link FlLogBean}
     * @return the associated {@link FlPersonBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonBean getReferencedByPersonId(FlLogBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByPersonId(instanceOfFlPersonManager().loadByPrimaryKey(bean.getPersonId())); 
        return bean.getReferencedByPersonId();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlLogBean} object to the {@link FlPersonBean} object by {@link FlLogBean#getPersonId}() field.
     *
     * @param bean the {@link FlLogBean} object to use
     * @param beanToSet the {@link FlPersonBean} object to associate to the {@link FlLogBean} (NOT NULL).
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlPersonBean setReferencedByPersonId(FlLogBean bean, FlPersonBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlPersonManager().save(beanToSet);
            bean.setReferencedByPersonId(beanToSet);
            if( null == beanToSet){
               // foreign key ( person_id ) is not nullable , nothing to do
            }else{
                bean.setPersonId(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //11
    /**
     * Deletes rows from the fl_log table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    @Override
    public int deleteByWhere(String where) throws DaoException
    {
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action = new DeleteBeanAction(); 
            this.loadByWhere(where,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;

        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_log " + where);
            // System.out.println("deleteByWhere: " + sql);
            ps = c.prepareStatement(sql.toString());
            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________

    //13

    @Override
    public FlLogBean insert(FlLogBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean; 
        }
        if (!bean.isNew()){
            return this.update(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();
            // listener callback
            this.listenerContainer.beforeInsert(bean);
            int dirtyCount = 0;
            sql = new StringBuilder("INSERT into fl_log (");

            if (bean.checkIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("id");
                dirtyCount++;
            }

            if (bean.checkPersonIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("person_id");
                dirtyCount++;
            }

            if (bean.checkDeviceIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("device_id");
                dirtyCount++;
            }

            if (bean.checkVerifyFeatureModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("verify_feature");
                dirtyCount++;
            }

            if (bean.checkCompareFaceModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("compare_face");
                dirtyCount++;
            }

            if (bean.checkVerifyStatusModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("verify_status");
                dirtyCount++;
            }

            if (bean.checkSimilartyModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("similarty");
                dirtyCount++;
            }

            if (bean.checkVerifyTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("verify_time");
                dirtyCount++;
            }

            if (bean.checkCreateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("create_time");
                dirtyCount++;
            }

            sql.append(") values (");
            if(dirtyCount > 0) {
                sql.append("?");
                for(int i = 1; i < dirtyCount; i++) {
                    sql.append(",?");
                }
            }
            sql.append(")");


            // System.out.println("insert : " + sql.toString());

            ps = c.prepareStatement(sql.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);

            this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            ps.executeUpdate();

            if (!bean.checkIdModified())
            {
                PreparedStatement ps2 = null;
                ResultSet rs = null;
                try {
                    ps2 = c.prepareStatement("SELECT last_insert_id()");
                    rs = ps2.executeQuery();
                    if(rs.next()) {
                        bean.setId(Manager.getInteger(rs, 1));
                    } else {
                        this.getManager().log("ATTENTION: Could not retrieve generated key!");
                    }
                } finally {
                    this.getManager().close(ps2, rs);
                }
            }

            bean.isNew(false);
            bean.resetIsModified();
            // listener callback
            this.listenerContainer.afterInsert(bean);
            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //14

    @Override
    public FlLogBean update(FlLogBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean;
        }
        if (bean.isNew()){
            return this.insert(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();

            // listener callback
            this.listenerContainer.beforeUpdate(bean); 
            sql = new StringBuilder("UPDATE fl_log SET ");
            boolean useComma=false;

            if (bean.checkIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("id=?");
            }

            if (bean.checkPersonIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("person_id=?");
            }

            if (bean.checkDeviceIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("device_id=?");
            }

            if (bean.checkVerifyFeatureModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("verify_feature=?");
            }

            if (bean.checkCompareFaceModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("compare_face=?");
            }

            if (bean.checkVerifyStatusModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("verify_status=?");
            }

            if (bean.checkSimilartyModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("similarty=?");
            }

            if (bean.checkVerifyTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("verify_time=?");
            }

            if (bean.checkCreateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("create_time=?");
            }
            sql.append(" WHERE ");
            sql.append("id=?");
            // System.out.println("update : " + sql.toString());
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);

            int dirtyCount = this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            if (dirtyCount == 0) {
                // System.out.println("The bean to look is not initialized... do not update.");
                return bean;
            }

            if (bean.getId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            ps.executeUpdate();
            // listener callback
            this.listenerContainer.afterUpdate(bean); 
            bean.resetIsModified();

            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18

    @Override
    public FlLogBean loadUniqueUsingTemplate(FlLogBean bean) throws DaoException
    {
         List<FlLogBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             return null;
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //18-1

    @Override
    public FlLogBean loadUniqueUsingTemplateChecked(FlLogBean bean) throws DaoException
    {
         List<FlLogBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             throw new ObjectRetrievalException("Not found element !!");
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //20-5

    @Override
    public int loadUsingTemplate(FlLogBean bean, int[] fieldList, int startRow, int numRows,int searchType, Action<FlLogBean> action) throws DaoException
    {
        // System.out.println("loadUsingTemplate startRow:" + startRow + ", numRows:" + numRows + ", searchType:" + searchType);
        StringBuilder sqlWhere = new StringBuilder("");
        String sql=createSelectSql(fieldList,this.fillWhere(sqlWhere, bean, searchType) > 0?" WHERE "+sqlWhere.toString():null);
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }

    //21

    @Override
    public int deleteUsingTemplate(FlLogBean bean) throws DaoException
    {
        if(bean.checkIdInitialized() && null != bean.getId()){
            return this.deleteByPrimaryKey(bean.getId());
        }
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action=new DeleteBeanAction(); 
            this.loadUsingTemplate(bean,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("DELETE FROM fl_log ");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... deleting all");
            }
            // System.out.println("deleteUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, SEARCH_EXACT, false);

            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }


    //_____________________________________________________________________
    //
    // USING INDICES
    //_____________________________________________________________________


    /**
     * Retrieves an array of FlLogBean using the compare_face index.
     *
     * @param compareFace the compare_face column's value filter.
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByIndexCompareFace(Integer compareFace) throws DaoException
    {
        return (FlLogBean[])this.loadByIndexCompareFaceAsList(compareFace).toArray(new FlLogBean[0]);
    }
    
    /**
     * Retrieves a list of FlLogBean using the compare_face index.
     *
     * @param compareFace the compare_face column's value filter.
     * @return a list of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByIndexCompareFaceAsList(Integer compareFace) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setCompareFace(compareFace);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the compare_face index.
     *
     * @param compareFace the compare_face column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexCompareFace(Integer compareFace) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setCompareFace(compareFace);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlLogBean using the device_id index.
     *
     * @param deviceId the device_id column's value filter.
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByIndexDeviceId(Integer deviceId) throws DaoException
    {
        return (FlLogBean[])this.loadByIndexDeviceIdAsList(deviceId).toArray(new FlLogBean[0]);
    }
    
    /**
     * Retrieves a list of FlLogBean using the device_id index.
     *
     * @param deviceId the device_id column's value filter.
     * @return a list of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByIndexDeviceIdAsList(Integer deviceId) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setDeviceId(deviceId);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the device_id index.
     *
     * @param deviceId the device_id column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexDeviceId(Integer deviceId) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setDeviceId(deviceId);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlLogBean using the person_id index.
     *
     * @param personId the person_id column's value filter.
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByIndexPersonId(Integer personId) throws DaoException
    {
        return (FlLogBean[])this.loadByIndexPersonIdAsList(personId).toArray(new FlLogBean[0]);
    }
    
    /**
     * Retrieves a list of FlLogBean using the person_id index.
     *
     * @param personId the person_id column's value filter.
     * @return a list of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByIndexPersonIdAsList(Integer personId) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setPersonId(personId);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the person_id index.
     *
     * @param personId the person_id column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexPersonId(Integer personId) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setPersonId(personId);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlLogBean using the verify_feature index.
     *
     * @param verifyFeature the verify_feature column's value filter.
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByIndexVerifyFeature(String verifyFeature) throws DaoException
    {
        return (FlLogBean[])this.loadByIndexVerifyFeatureAsList(verifyFeature).toArray(new FlLogBean[0]);
    }
    
    /**
     * Retrieves a list of FlLogBean using the verify_feature index.
     *
     * @param verifyFeature the verify_feature column's value filter.
     * @return a list of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByIndexVerifyFeatureAsList(String verifyFeature) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setVerifyFeature(verifyFeature);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the verify_feature index.
     *
     * @param verifyFeature the verify_feature column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexVerifyFeature(String verifyFeature) throws DaoException
    {
        FlLogBean bean = this.createBean();
        bean.setVerifyFeature(verifyFeature);
        return deleteUsingTemplate(bean);
    }
    
    
    /**
     * Retrieves a list of FlLogBean using the index specified by keyIndex.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_LOG_INDEX_COMPARE_FACE},{@link Constant#FL_LOG_INDEX_DEVICE_ID},{@link Constant#FL_LOG_INDEX_PERSON_ID},{@link Constant#FL_LOG_INDEX_VERIFY_FEATURE}
     * @param keys key values of index
     * @return a list of FlLogBean
     * @throws DaoException
     */
    @Override
    public List<FlLogBean> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_LOG_INDEX_COMPARE_FACE:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'compare_face' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.loadByIndexCompareFaceAsList((Integer)keys[0]);        
        }
        case FL_LOG_INDEX_DEVICE_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'device_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.loadByIndexDeviceIdAsList((Integer)keys[0]);        
        }
        case FL_LOG_INDEX_PERSON_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'person_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.loadByIndexPersonIdAsList((Integer)keys[0]);        
        }
        case FL_LOG_INDEX_VERIFY_FEATURE:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'verify_feature' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.loadByIndexVerifyFeatureAsList((String)keys[0]);        
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }
    }
    
    /**
     * Deletes rows using key.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_LOG_INDEX_COMPARE_FACE},{@link Constant#FL_LOG_INDEX_DEVICE_ID},{@link Constant#FL_LOG_INDEX_PERSON_ID},{@link Constant#FL_LOG_INDEX_VERIFY_FEATURE}
     * @param keys key values of index
     * @return the number of deleted objects
     * @throws DaoException
     */
    @Override
    public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_LOG_INDEX_COMPARE_FACE:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'compare_face' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.deleteByIndexCompareFace((Integer)keys[0]);
        }
        case FL_LOG_INDEX_DEVICE_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'device_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.deleteByIndexDeviceId((Integer)keys[0]);
        }
        case FL_LOG_INDEX_PERSON_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'person_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.deleteByIndexPersonId((Integer)keys[0]);
        }
        case FL_LOG_INDEX_VERIFY_FEATURE:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'verify_feature' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexVerifyFeature((String)keys[0]);
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }        
    }


    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________

    //25

    @Override
    public int countWhere(String where) throws DaoException
    {
        String sql = new StringBuffer("SELECT COUNT(*) AS MCOUNT FROM fl_person ")
    		    .append(null == where ? "" : where).toString();
        // System.out.println("countWhere: " + sql);
        Connection c = null;
        Statement st = null;
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement();
            rs =  st.executeQuery(sql);
            if (rs.next())
            {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(st, rs);
            this.freeConnection(c);
            sql = null;
        }
        throw new DataAccessException("Error in countWhere where=[" + where + "]");
    }

    //26
    /**
     * Retrieves the number of rows of the table fl_log with a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return the number of rows returned
     * @throws DaoException
     */
    private int countByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(rs);
        }
       throw new DataAccessException("Error in countByPreparedStatement");
    }

    //20
    /**
     * count the number of elements of a specific FlLogBean bean given the search type
     *
     * @param bean the FlLogBean template to look for
     * @param searchType exact ?  like ? starting like ?
     * @return the number of rows returned
     * @throws DaoException
     */
    @Override
    public int countUsingTemplate(FlLogBean bean, int searchType) throws DaoException
    {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_log");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... counting all...");
            }
            // System.out.println("countUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);

            return this.countByPreparedStatement(ps);
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    /**
     * fills the given StringBuilder with the sql where clauses constructed using the bean and the search type
     * @param sqlWhere the StringBuilder that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @return the number of clauses returned
     */
    protected int fillWhere(StringBuilder sqlWhere, FlLogBean bean, int searchType)
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == SEARCH_EXACT ? "=" : " like ";
        try
        {
            if (bean.checkIdModified()) {
                dirtyCount ++;
                if (bean.getId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id = ?");
                }
            }
            if (bean.checkPersonIdModified()) {
                dirtyCount ++;
                if (bean.getPersonId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("person_id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("person_id = ?");
                }
            }
            if (bean.checkDeviceIdModified()) {
                dirtyCount ++;
                if (bean.getDeviceId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("device_id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("device_id = ?");
                }
            }
            if (bean.checkVerifyFeatureModified()) {
                dirtyCount ++;
                if (bean.getVerifyFeature() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("verify_feature IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("verify_feature ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkCompareFaceModified()) {
                dirtyCount ++;
                if (bean.getCompareFace() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("compare_face IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("compare_face = ?");
                }
            }
            if (bean.checkVerifyStatusModified()) {
                dirtyCount ++;
                if (bean.getVerifyStatus() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("verify_status IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("verify_status = ?");
                }
            }
            if (bean.checkSimilartyModified()) {
                dirtyCount ++;
                if (bean.getSimilarty() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("similarty IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("similarty = ?");
                }
            }
            if (bean.checkVerifyTimeModified()) {
                dirtyCount ++;
                if (bean.getVerifyTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("verify_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("verify_time = ?");
                }
            }
            if (bean.checkCreateTimeModified()) {
                dirtyCount ++;
                if (bean.getCreateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time = ?");
                }
            }
        }
        finally
        {
            sqlEqualsOperation = null;
        }
        return dirtyCount;
    }

    /**
     * fill the given prepared statement with the bean values and a search type
     * @param ps the PreparedStatement that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @param fillNull wether fill null for null field
     * @return the number of clauses returned
     * @throws DaoException
     */
    protected int fillPreparedStatement(PreparedStatement ps, FlLogBean bean, int searchType,boolean fillNull) throws DaoException
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        try
        {
            if (bean.checkIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getId() + "]");
                if (bean.getId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            }
            if (bean.checkPersonIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getPersonId() + "]");
                if (bean.getPersonId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getPersonId()); }
            }
            if (bean.checkDeviceIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getDeviceId() + "]");
                if (bean.getDeviceId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getDeviceId()); }
            }
            if (bean.checkVerifyFeatureModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getVerifyFeature() + "]");
                        if (bean.getVerifyFeature() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getVerifyFeature()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getVerifyFeature() + "%]");
                        if ( bean.getVerifyFeature()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getVerifyFeature() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getVerifyFeature() + "]");
                        if ( bean.getVerifyFeature() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getVerifyFeature()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getVerifyFeature() + "%]");
                        if (bean.getVerifyFeature()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getVerifyFeature() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkCompareFaceModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getCompareFace() + "]");
                if (bean.getCompareFace() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getCompareFace()); }
            }
            if (bean.checkVerifyStatusModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getVerifyStatus() + "]");
                if (bean.getVerifyStatus() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TINYINT);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getVerifyStatus()); }
            }
            if (bean.checkSimilartyModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getSimilarty() + "]");
                if (bean.getSimilarty() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.DOUBLE);} } else { Manager.setDouble(ps, ++dirtyCount, bean.getSimilarty()); }
            }
            if (bean.checkVerifyTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getVerifyTime() + "]");
                if (bean.getVerifyTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getVerifyTime().getTime())); }
            }
            if (bean.checkCreateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getCreateTime() + "]");
                if (bean.getCreateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getCreateTime().getTime())); }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        return dirtyCount;
    }


    //_____________________________________________________________________
    //
    // DECODE RESULT SET
    //_____________________________________________________________________

    //28
    /**
     * decode a resultset in an array of FlLogBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlLogBean table
     * @throws DaoException
     */
    public FlLogBean[] decodeResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return this.decodeResultSetAsList(rs, fieldList, startRow, numRows).toArray(new FlLogBean[0]);
    }

    //28-1
    /**
     * decode a resultset in a list of FlLogBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlLogBean table
     * @throws DaoException
     */
    public List<FlLogBean> decodeResultSetAsList(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        actionOnResultSet(rs, fieldList, numRows, numRows, action);
        return action.getList();
    }
    //28-2
    /** decode a resultset and call action
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action interface obj for do something
     * @return the count dealt by action  
     * @throws DaoException
     * @throws IllegalArgumentException
     */
    public int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, Action<FlLogBean> action) throws DaoException{
        try{
            int count = 0;
            if(0!=numRows){
                if( startRow<1 ){
                    throw new IllegalArgumentException("invalid argument:startRow (must >=1)");
                }
                if( null==action || null==rs ){
                    throw new IllegalArgumentException("invalid argument:action OR rs (must not be null)");
                }
                for(;startRow > 1 && rs.next();){
                    --startRow;
                    //skip to last of startRow
                }
                if (fieldList == null) {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }
                }else {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }
                }
            }
            return count;
        }catch(DaoException e){
            throw e;
        }catch(SQLException e){
            throw new DataAccessException(e);
        }
    }

    //29
    /**
     * Transforms a ResultSet iterating on the fl_log on a FlLogBean bean.
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlLogBean bean
     * @throws DaoException
     */
    public FlLogBean decodeRow(ResultSet rs,FlLogBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        try
        {
            bean.setId(Manager.getInteger(rs, 1));
            bean.setPersonId(Manager.getInteger(rs, 2));
            bean.setDeviceId(Manager.getInteger(rs, 3));
            bean.setVerifyFeature(rs.getString(4));
            bean.setCompareFace(Manager.getInteger(rs, 5));
            bean.setVerifyStatus(Manager.getInteger(rs, 6));
            bean.setSimilarty(Manager.getDouble(rs, 7));
            bean.setVerifyTime(rs.getTimestamp(8));
            bean.setCreateTime(rs.getTimestamp(9));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //30
    /**
     * Transforms a ResultSet iterating on the fl_log table on a FlLogBean bean according to a list of fields.
     *
     * @param rs the ResultSet to be transformed
     * @param fieldList table of the field's associated constants
     * @return bean resulting FlLogBean bean
     * @throws DaoException
     */
    public FlLogBean decodeRow(ResultSet rs, int[] fieldList,FlLogBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        int pos = 0;
        try
        {
            for(int i = 0; i < fieldList.length; i++)
            {
                switch(fieldList[i])
                {
                    case FL_LOG_ID_ID:
                        ++pos;
                        bean.setId(Manager.getInteger(rs, pos));
                        break;
                    case FL_LOG_ID_PERSON_ID:
                        ++pos;
                        bean.setPersonId(Manager.getInteger(rs, pos));
                        break;
                    case FL_LOG_ID_DEVICE_ID:
                        ++pos;
                        bean.setDeviceId(Manager.getInteger(rs, pos));
                        break;
                    case FL_LOG_ID_VERIFY_FEATURE:
                        ++pos;
                        bean.setVerifyFeature(rs.getString(pos));
                        break;
                    case FL_LOG_ID_COMPARE_FACE:
                        ++pos;
                        bean.setCompareFace(Manager.getInteger(rs, pos));
                        break;
                    case FL_LOG_ID_VERIFY_STATUS:
                        ++pos;
                        bean.setVerifyStatus(Manager.getInteger(rs, pos));
                        break;
                    case FL_LOG_ID_SIMILARTY:
                        ++pos;
                        bean.setSimilarty(Manager.getDouble(rs, pos));
                        break;
                    case FL_LOG_ID_VERIFY_TIME:
                        ++pos;
                        bean.setVerifyTime(rs.getTimestamp(pos));
                        break;
                    case FL_LOG_ID_CREATE_TIME:
                        ++pos;
                        bean.setCreateTime(rs.getTimestamp(pos));
                        break;
                    default:
                        throw new DaoException("Unknown field id " + fieldList[i]);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //31
    /**
     * Transforms a ResultSet iterating on the fl_log on a FlLogBean bean using the names of the columns
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlLogBean bean
     * @throws DaoException
     */
    public FlLogBean metaDataDecodeRow(ResultSet rs) throws DaoException
    {
        FlLogBean bean = this.createBean();
        try
        {
            bean.setId(Manager.getInteger(rs, "id"));
            bean.setPersonId(Manager.getInteger(rs, "person_id"));
            bean.setDeviceId(Manager.getInteger(rs, "device_id"));
            bean.setVerifyFeature(rs.getString("verify_feature"));
            bean.setCompareFace(Manager.getInteger(rs, "compare_face"));
            bean.setVerifyStatus(Manager.getInteger(rs, "verify_status"));
            bean.setSimilarty(Manager.getDouble(rs, "similarty"));
            bean.setVerifyTime(rs.getTimestamp("verify_time"));
            bean.setCreateTime(rs.getTimestamp("create_time"));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }

        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //////////////////////////////////////
    // PREPARED STATEMENT LOADER
    //////////////////////////////////////

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatement(ps, null);
    }

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByPreparedStatementAsList(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, null);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, fieldList).toArray(new FlLogBean[0]);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList) throws DaoException
    { 
        return loadByPreparedStatementAsList(ps,fieldList,1,-1);
    }

    //34
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public FlLogBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return loadByPreparedStatementAsList(ps,fieldList,startRow,numRows).toArray(new FlLogBean[0]);
    }

    //34-1
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlLogBean
     * @throws DaoException
     */
    public List<FlLogBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        loadByPreparedStatement(ps,fieldList,startRow,numRows,action);
        return action.getList();
    }
    //34-2
    /**
     * Loads each element using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows 
     * and dealt by action.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */     
    public int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows,Action<FlLogBean> action) throws DaoException
    {
        ResultSet rs =  null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            return this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(rs);
        }
    }
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    private final TableListener.ListenerContainer<FlLogBean> listenerContainer = new TableListener.ListenerContainer<FlLogBean>();

    //35

    @Override
    public TableListener<FlLogBean> registerListener(TableListener<FlLogBean> listener)
    {
        this.listenerContainer.add(listener);
        return listener;
    }

    //36
    /**
     * remove listener.
     */
    @Override
    public void unregisterListener(TableListener<FlLogBean> listener)
    {
        this.listenerContainer.remove(listener);
    }

    //37

    @Override
    public void fire(TableListener.Event event, FlLogBean bean) throws DaoException{
        if(null == event){
            throw new NullPointerException();
        }
        event.fire(listenerContainer, bean);
    }
    
    //37-1

    @Override
    public void fire(int event, FlLogBean bean) throws DaoException{
        try{
            fire(TableListener.Event.values()[event],bean);
        }catch(ArrayIndexOutOfBoundsException e){
            throw new IllegalArgumentException("invalid event id " + event);
        }
    }

    /** foreign key listener for DEELTE RULE : CASCADE */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonBean,FlLogBean> foreignKeyListenerByPersonId = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonBean,FlLogBean>(){
                @Override
                protected List<FlLogBean> getImportedBeans(FlPersonBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlLogBean>emptyList()
                            : instanceOfFlPersonManager().getLogBeansByPersonIdAsList(bean);
                }
                @Override
                protected void onRemove(List<FlLogBean> effectBeans) throws DaoException {
                    for(FlLogBean bean:effectBeans){
                        Event.DELETE.fire(listenerContainer, bean);
                    }
                }};

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlDeviceBean,FlLogBean> foreignKeyListenerByDeviceId = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlDeviceBean,FlLogBean>(){
                @Override
                protected List<FlLogBean> getImportedBeans(FlDeviceBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlLogBean>emptyList()
                            : instanceOfFlDeviceManager().getLogBeansByDeviceIdAsList(bean);
                }
                @Override
                protected void onRemove(List<FlLogBean> effectBeans) throws DaoException {
                    for(FlLogBean bean:effectBeans){
                        bean.setDeviceId(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlFeatureBean,FlLogBean> foreignKeyListenerByVerifyFeature = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlFeatureBean,FlLogBean>(){
                @Override
                protected List<FlLogBean> getImportedBeans(FlFeatureBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlLogBean>emptyList()
                            : instanceOfFlFeatureManager().getLogBeansByVerifyFeatureAsList(bean);
                }
                @Override
                protected void onRemove(List<FlLogBean> effectBeans) throws DaoException {
                    for(FlLogBean bean:effectBeans){
                        bean.setVerifyFeature(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlFaceBean,FlLogBean> foreignKeyListenerByCompareFace = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlFaceBean,FlLogBean>(){
                @Override
                protected List<FlLogBean> getImportedBeans(FlFaceBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlLogBean>emptyList()
                            : instanceOfFlFaceManager().getLogBeansByCompareFaceAsList(bean);
                }
                @Override
                protected void onRemove(List<FlLogBean> effectBeans) throws DaoException {
                    for(FlLogBean bean:effectBeans){
                        bean.setCompareFace(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    //37-2
    /**
     * bind foreign key listener to foreign table: <br>
     * DELETE RULE : CASCADE {@code fl_log(person_id)- fl_person(id)} <br>
     * DELETE RULE : SET_NULL {@code fl_log(device_id)- fl_device(id)} <br>
     * DELETE RULE : SET_NULL {@code fl_log(verify_feature)- fl_feature(md5)} <br>
     * DELETE RULE : SET_NULL {@code fl_log(compare_face)- fl_face(id)} <br>
     */
    public void bindForeignKeyListenerForDeleteRule(){
        instanceOfFlPersonManager().registerListener(foreignKeyListenerByPersonId);
        instanceOfFlDeviceManager().registerListener(foreignKeyListenerByDeviceId);
        instanceOfFlFeatureManager().registerListener(foreignKeyListenerByVerifyFeature);
        instanceOfFlFaceManager().registerListener(foreignKeyListenerByCompareFace);
        
    }
    //37-3
    /**
     * unbind foreign key listener from all of foreign tables <br>
     * @see #bindForeignKeyListenerForDeleteRule()
     */
    public void unbindForeignKeyListenerForDeleteRule(){
        instanceOfFlPersonManager().unregisterListener(foreignKeyListenerByPersonId);
        instanceOfFlDeviceManager().unregisterListener(foreignKeyListenerByDeviceId);
        instanceOfFlFeatureManager().unregisterListener(foreignKeyListenerByVerifyFeature);
        instanceOfFlFaceManager().unregisterListener(foreignKeyListenerByCompareFace);
        
    }
    //_____________________________________________________________________
    //
    // UTILS
    //_____________________________________________________________________

    //40
    /**
     * Retrieves the manager object used to get connections.
     *
     * @return the manager used
     */
    private Manager getManager()
    {
        return Manager.getInstance();
    }

    //41
    /**
     * Frees the connection.
     *
     * @param c the connection to release
     */
    private void freeConnection(Connection c)
    {
        // back to pool
        this.getManager().releaseConnection(c);
    }

    //42
    /**
     * Gets the connection.
     */
    private Connection getConnection() throws DaoException
    {
        try
        {
            return this.getManager().getConnection();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
    }

    //43

    @Override
    public boolean isPrimaryKey(String column){
        for(String c:PRIMARYKEY_NAMES){
            if(c.equalsIgnoreCase(column)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Fill the given prepared statement with the values in argList
     * @param ps the PreparedStatement that will be filled
     * @param argList the arguments to use fill given prepared statement
     * @throws DaoException
     */
    private void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws DaoException{
        try {
            if (!(argList == null || ps == null)) {
                for (int i = 0; i < argList.length; i++) {
                    if (argList[i].getClass().equals(byte[].class)) {
                        ps.setBytes(i + 1, (byte[]) argList[i]);
                    } else {
                        ps.setObject(i + 1, argList[i]);
                    }
                }
            }
        } catch (SQLException e) {
            throw new DaoException(e);
        }
    }
    
    @Override    

    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<FlLogBean> action) throws DaoException{
        PreparedStatement ps = null;
        Connection connection = null;
        // logger.debug("sql string:\n" + sql + "\n");
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            fillPrepareStatement(ps, argList);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }
   
    @Override

    public <T>T runAsTransaction(Callable<T> fun) throws DaoException{
        return Manager.getInstance().runAsTransaction(fun);
    }
    
    class DeleteBeanAction extends Action.BaseAdapter<FlLogBean>{
        private final AtomicInteger count=new AtomicInteger(0);
        @Override
        public void call(FlLogBean bean) throws DaoException {
                FlLogManager.this.delete(bean);
                count.incrementAndGet();
        }
        int getCount(){
            return count.get();
        }
    }
    //45
    /**
     * return a primary key list from {@link FlLogBean} array
     * @param array
     */
    public List<Integer> toPrimaryKeyList(FlLogBean... array){        
        if(null == array){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(array.length);
        for(FlLogBean bean:array){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
    //46
    /**
     * return a primary key list from {@link FlLogBean} collection
     * @param collection
     */
    public List<Integer> toPrimaryKeyList(java.util.Collection<FlLogBean> collection){        
        if(null == collection){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(collection.size());
        for(FlLogBean bean:collection){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
}
