// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: manager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.permit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.Manager;
import net.gdface.facelog.dborm.TableListener;
import net.gdface.facelog.dborm.TableManager;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.DataAccessException;
import net.gdface.facelog.dborm.exception.DataRetrievalException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
import net.gdface.facelog.dborm.device.FlDeviceGroupBean;
import net.gdface.facelog.dborm.device.FlDeviceGroupManager;
import net.gdface.facelog.dborm.person.FlPersonGroupBean;
import net.gdface.facelog.dborm.person.FlPersonGroupManager;

/**
 * Handles database calls (save, load, count, etc...) for the fl_permit table.<br>
 * Remarks: 通行权限关联表<br>
 * @author sql2java
 */
public class FlPermitManager extends TableManager.BaseAdapter<FlPermitBean>
{
    /**
     * Tablename.
     */
    public static final String TABLE_NAME="fl_permit";

    /**
     * Contains all the primary key fields of the fl_permit table.
     */
    public static final String[] PRIMARYKEY_NAMES =
    {
        "device_group_id"
        ,"person_group_id"
    };

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }
    
    @Override
    public String getFields() {
        return FL_PERMIT_FIELDS;
    }
    
    @Override
    public String getFullFields() {
        return FL_PERMIT_FULL_FIELDS;
    }

    @Override
    public String[] getPrimarykeyNames() {
        return PRIMARYKEY_NAMES;
    }

    private static FlPermitManager singleton = new FlPermitManager();
    protected FlPermitManager(){}
    /**
     * Get the FlPermitManager singleton.
     *
     * @return FlPermitManager
     */
    public static FlPermitManager getInstance()
    {
        return singleton;
    }


    /**
     * Creates a new FlPermitBean instance.
     *
     * @return the new FlPermitBean
     */
    public FlPermitBean createBean()
    {
        return new FlPermitBean();
    }
    
    @Override
    protected Class<FlPermitBean> beanType(){
        return FlPermitBean.class;
    }
    
    protected FlDeviceGroupManager instanceOfFlDeviceGroupManager(){
        return FlDeviceGroupManager.getInstance();
    }
    protected FlPersonGroupManager instanceOfFlPersonGroupManager(){
        return FlPersonGroupManager.getInstance();
    }
    //////////////////////////////////////
    // PRIMARY KEY METHODS
    //////////////////////////////////////

    //1
    /**
     * Loads a {@link FlPermitBean} from the fl_permit using primary key fields.
     *
     * @param deviceGroupId Integer - PK# 1
     * @param personGroupId Integer - PK# 2
     * @return a unique FlPermitBean or {@code null} if not found or have null argument
     * @throws DaoException
     */
    public FlPermitBean loadByPrimaryKey(Integer deviceGroupId,Integer personGroupId) throws DaoException
    {
        try{
            return loadByPrimaryKeyChecked(deviceGroupId,personGroupId);
        }catch(ObjectRetrievalException e){
            // not found
            return null;
        }
    }
    
    //1.1
    /**
     * Loads a {@link FlPermitBean} from the fl_permit using primary key fields.
     *
     * @param deviceGroupId Integer - PK# 1
     * @param personGroupId Integer - PK# 2
     * @return a unique FlPermitBean
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public FlPermitBean loadByPrimaryKeyChecked(Integer deviceGroupId,Integer personGroupId) throws DaoException
    {
        if(null == deviceGroupId || null == personGroupId){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT " + FL_PERMIT_FIELDS + " FROM fl_permit WHERE device_group_id=? and person_group_id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (deviceGroupId == null) { ps.setNull(FL_PERMIT_ID_DEVICE_GROUP_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERMIT_ID_DEVICE_GROUP_ID + 1, deviceGroupId); }
            if (personGroupId == null) { ps.setNull(FL_PERMIT_ID_PERSON_GROUP_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERMIT_ID_PERSON_GROUP_ID + 1, personGroupId); }
            List<FlPermitBean> pReturn = this.loadByPreparedStatementAsList(ps);
            if (1 == pReturn.size()) {
                return pReturn.get(0);
            } else {
                throw new ObjectRetrievalException();
            }
        }
        catch(ObjectRetrievalException e)
        {
            throw e;
        }
        catch(SQLException e)
        {
            throw new DataRetrievalException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //1.2
    
    @Override
    public FlPermitBean loadByPrimaryKey(FlPermitBean bean) throws DaoException
    {
        return bean==null?null:loadByPrimaryKey(bean.getDeviceGroupId(),bean.getPersonGroupId());
    }
    
    //1.2.2
    
    @Override
    public FlPermitBean loadByPrimaryKeyChecked(FlPermitBean bean) throws DaoException
    {
        if(null == bean){
            throw new NullPointerException();
        }
        return loadByPrimaryKeyChecked(bean.getDeviceGroupId(),bean.getPersonGroupId());
    }
    
    //1.3
    /**
     * Loads a {@link FlPermitBean} from the fl_permit using primary key fields.
     * @param keys primary keys value:<br> 
     * @return a unique {@link FlPermitBean} or {@code null} if not found
     * @see #loadByPrimaryKey(Integer deviceGroupId,Integer personGroupId)
     */
    @Override
    public FlPermitBean loadByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERMIT_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(null == keys[0]){
            return null;
        }
        if(null == keys[1]){
            return null;
        }
        return loadByPrimaryKey((Integer)keys[0],(Integer)keys[1]);
    }
    //1.3.2

    @Override
    public FlPermitBean loadByPrimaryKeyChecked(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERMIT_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(! (keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        if(! (keys[1] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:Integer");
        }
        return loadByPrimaryKeyChecked((Integer)keys[0],(Integer)keys[1]);
    }
    //1.4
    /**
     * Returns true if this fl_permit contains row with primary key fields.
     * @param deviceGroupId Integer - PK# 1
     * @param personGroupId Integer - PK# 2
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public boolean existsPrimaryKey(Integer deviceGroupId,Integer personGroupId) throws DaoException
    {
        if(null == deviceGroupId || null == personGroupId){
            return false;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try{
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_permit WHERE device_group_id=? and person_group_id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (deviceGroupId == null) { ps.setNull(FL_PERMIT_ID_DEVICE_GROUP_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERMIT_ID_DEVICE_GROUP_ID + 1, deviceGroupId); }
            if (personGroupId == null) { ps.setNull(FL_PERMIT_ID_PERSON_GROUP_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERMIT_ID_PERSON_GROUP_ID + 1, personGroupId); }
            return 1 == this.countByPreparedStatement(ps);
        }catch(SQLException e){
            throw new ObjectRetrievalException(e);
        }finally{
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }
    //1.6
    /**
     * Return true if this fl_permit contains row with primary key fields.
     * @param bean  
     * @throws DaoException
     * @return false if primary kes has null
     */
    @Override
    public boolean existsByPrimaryKey(FlPermitBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getDeviceGroupId() || null == bean.getPersonGroupId()){
            return false;
        }
        long modified = bean.getModified();
        try{
            bean.resetModifiedExceptPrimaryKeys();
            return 1 == countUsingTemplate(bean);
        }finally{
            bean.setModified(modified);
        }
    }
    //1.7

    @Override
    public FlPermitBean checkDuplicate(FlPermitBean bean) throws DaoException{
        if(existsByPrimaryKey(bean)){
            throw new ObjectRetrievalException("Duplicate entry ("+ bean.getDeviceGroupId() + " " +bean.getPersonGroupId() +") for key 'PRIMARY'");
        }
        return bean;
    }
    //2
    /**
     * Delete row according to its primary keys.<br>
     * all keys must not be null
     * 
     * @param deviceGroupId Integer - PK# 1
     * @param personGroupId Integer - PK# 2
     * @return the number of deleted rows
     * @throws DaoException
     * @see #delete(FlPermitBean)
     */
    public int deleteByPrimaryKey(Integer deviceGroupId,Integer personGroupId) throws DaoException
    {
        FlPermitBean bean=createBean();
        bean.setDeviceGroupId(deviceGroupId);
        bean.setPersonGroupId(personGroupId);
        return this.delete(bean);
    }

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    @Override
    public int delete(FlPermitBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getDeviceGroupId() || null == bean.getPersonGroupId()){
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            // listener callback
            this.listenerContainer.beforeDelete(bean);
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_permit WHERE device_group_id=? and person_group_id=?");
            // System.out.println("deleteByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getDeviceGroupId() == null) { ps.setNull(FL_PERMIT_ID_DEVICE_GROUP_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERMIT_ID_DEVICE_GROUP_ID + 1, bean.getDeviceGroupId()); }
            if (bean.getPersonGroupId() == null) { ps.setNull(FL_PERMIT_ID_PERSON_GROUP_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERMIT_ID_PERSON_GROUP_ID + 1, bean.getPersonGroupId()); }
            int rows=ps.executeUpdate();
            if(rows>0){
                // listener callback
                this.listenerContainer.afterDelete(bean);
            }
            return rows;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value:<br> 
     * @return the number of deleted rows
     * @see #delete(FlPermitBean)
     */   
    @Override
    public int deleteByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERMIT_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        FlPermitBean bean = createBean();   
        
        if(null != keys[0] && !(keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:$pk.getJavaType()");
        }
        bean.setDeviceGroupId((Integer)keys[0]);
        if(null != keys[1] && !(keys[1] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:$pk.getJavaType()");
        }
        bean.setPersonGroupId((Integer)keys[1]);
        return delete(bean);
    }
 
     //3.5 SYNC SAVE 
    /**
     * Save the FlPermitBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlPermitBean} bean to be saved
     * @param refDevicegroupByDeviceGroupId the {@link FlDeviceGroupBean} bean referenced by {@link FlPermitBean} 
     * @param refPersongroupByPersonGroupId the {@link FlPersonGroupBean} bean referenced by {@link FlPermitBean} 
         * @return the inserted or updated {@link FlPermitBean} bean
     * @throws DaoException
     */
    public FlPermitBean save(FlPermitBean bean
        , FlDeviceGroupBean refDevicegroupByDeviceGroupId , FlPersonGroupBean refPersongroupByPersonGroupId 
        ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refDevicegroupByDeviceGroupId){
            this.setReferencedByDeviceGroupId(bean,refDevicegroupByDeviceGroupId);
        }
        if(null != refPersongroupByPersonGroupId){
            this.setReferencedByPersonGroupId(bean,refPersongroupByPersonGroupId);
        }
        bean = this.save( bean );
        return bean;
    } 

    //3.6 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlPermitBean , FlDeviceGroupBean , FlPersonGroupBean )
     */
    public FlPermitBean saveAsTransaction(final FlPermitBean bean
        ,final FlDeviceGroupBean refDevicegroupByDeviceGroupId ,final FlPersonGroupBean refPersongroupByPersonGroupId 
        ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlPermitBean>(){
            @Override
            public FlPermitBean call() throws Exception {
                return save(bean , refDevicegroupByDeviceGroupId , refPersongroupByPersonGroupId );
            }});
    }

    private static final int SYNC_SAVE_ARG_LEN = 2;
    private static final int SYNC_SAVE_ARG_0 = 0;
    private static final int SYNC_SAVE_ARG_1 = 1;
    //3.9 SYNC SAVE 
    /**
     * Save the FlPermitBean bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the {@link FlPermitBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlPermitBean , FlDeviceGroupBean , FlPersonGroupBean )}
     * @return the inserted or updated {@link FlPermitBean} bean
     * @throws DaoException
     */
    @Override
    public FlPermitBean save(FlPermitBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 2");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlDeviceGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.1 dynamic argument,expected type:FlDeviceGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlPersonGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.2 dynamic argument,expected type:FlPersonGroupBean");
        }
        return save(bean,
                    (FlDeviceGroupBean)args[SYNC_SAVE_ARG_0],
                    (FlPersonGroupBean)args[SYNC_SAVE_ARG_1]);
    } 

    //3.10 SYNC SAVE 
    /**
     * Save the FlPermitBean bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the {@link FlPermitBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlPermitBean , FlDeviceGroupBean , FlPersonGroupBean )}
     * @return the inserted or updated {@link FlPermitBean} bean
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public FlPermitBean saveCollection(FlPermitBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 2");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlDeviceGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:FlDeviceGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlPersonGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:FlPersonGroupBean");
        }
        return save(bean,
                    (FlDeviceGroupBean)args[SYNC_SAVE_ARG_0],
                    (FlPersonGroupBean)args[SYNC_SAVE_ARG_1]);
    } 
    //////////////////////////////////////
    // FOREIGN KEY GENERIC METHOD
    //////////////////////////////////////

    /**
     * Retrieves the bean object referenced by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_PERMIT_FK_DEVICE_GROUP_ID} - {@link FlDeviceGroupBean}</li>
     *     <li> {@link Constant#FL_PERMIT_FK_PERSON_GROUP_ID} - {@link FlPersonGroupBean}</li>
     * </ul>
     * @param bean the {@link FlPermitBean} object to use
     * @param fkIndex valid values: <br>
     *        {@link Constant#FL_PERMIT_FK_DEVICE_GROUP_ID},{@link Constant#FL_PERMIT_FK_PERSON_GROUP_ID}
     * @return the associated T bean or {@code null} if {@code bean} or {@code beanToSet} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T getReferencedBean(FlPermitBean bean,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_PERMIT_FK_DEVICE_GROUP_ID:
            return  (T)this.getReferencedByDeviceGroupId(bean);
        case FL_PERMIT_FK_PERSON_GROUP_ID:
            return  (T)this.getReferencedByPersonGroupId(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
    
    /**
     * Associates the {@link FlPermitBean} object to the bean object by fkIndex field.<br>
     * 
     * @param <T> see also {@link #getReferencedBean(FlPermitBean,int)}
     * @param bean the {@link FlPermitBean} object to use
     * @param beanToSet the T object to associate to the {@link FlPermitBean}
     * @param fkIndex valid values: see also {@link #getReferencedBean(FlPermitBean,int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T setReferencedBean(FlPermitBean bean,T beanToSet,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_PERMIT_FK_DEVICE_GROUP_ID:
            return  (T)this.setReferencedByDeviceGroupId(bean, (FlDeviceGroupBean)beanToSet);
        case FL_PERMIT_FK_PERSON_GROUP_ID:
            return  (T)this.setReferencedByPersonGroupId(bean, (FlPersonGroupBean)beanToSet);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
     
    //////////////////////////////////////
    // GET/SET FOREIGN KEY BEAN METHOD
    //////////////////////////////////////


    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlDeviceGroupBean} object referenced by {@link FlPermitBean#getDeviceGroupId}() field.<br>
     * FK_NAME : fl_permit_ibfk_1
     * @param bean the {@link FlPermitBean}
     * @return the associated {@link FlDeviceGroupBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlDeviceGroupBean getReferencedByDeviceGroupId(FlPermitBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByDeviceGroupId(instanceOfFlDeviceGroupManager().loadByPrimaryKey(bean.getDeviceGroupId())); 
        return bean.getReferencedByDeviceGroupId();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlPermitBean} object to the {@link FlDeviceGroupBean} object by {@link FlPermitBean#getDeviceGroupId}() field.
     *
     * @param bean the {@link FlPermitBean} object to use
     * @param beanToSet the {@link FlDeviceGroupBean} object to associate to the {@link FlPermitBean} (NOT NULL).
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlDeviceGroupBean setReferencedByDeviceGroupId(FlPermitBean bean, FlDeviceGroupBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlDeviceGroupManager().save(beanToSet);
            bean.setReferencedByDeviceGroupId(beanToSet);
            if( null == beanToSet){
               // foreign key ( device_group_id ) is not nullable , nothing to do
            }else{
                bean.setDeviceGroupId(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlPersonGroupBean} object referenced by {@link FlPermitBean#getPersonGroupId}() field.<br>
     * FK_NAME : fl_permit_ibfk_2
     * @param bean the {@link FlPermitBean}
     * @return the associated {@link FlPersonGroupBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonGroupBean getReferencedByPersonGroupId(FlPermitBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByPersonGroupId(instanceOfFlPersonGroupManager().loadByPrimaryKey(bean.getPersonGroupId())); 
        return bean.getReferencedByPersonGroupId();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlPermitBean} object to the {@link FlPersonGroupBean} object by {@link FlPermitBean#getPersonGroupId}() field.
     *
     * @param bean the {@link FlPermitBean} object to use
     * @param beanToSet the {@link FlPersonGroupBean} object to associate to the {@link FlPermitBean} (NOT NULL).
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlPersonGroupBean setReferencedByPersonGroupId(FlPermitBean bean, FlPersonGroupBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlPersonGroupManager().save(beanToSet);
            bean.setReferencedByPersonGroupId(beanToSet);
            if( null == beanToSet){
               // foreign key ( person_group_id ) is not nullable , nothing to do
            }else{
                bean.setPersonGroupId(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //11
    /**
     * Deletes rows from the fl_permit table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    @Override
    public int deleteByWhere(String where) throws DaoException
    {
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action = new DeleteBeanAction(); 
            this.loadByWhere(where,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;

        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_permit " + where);
            // System.out.println("deleteByWhere: " + sql);
            ps = c.prepareStatement(sql.toString());
            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________

    //13

    @Override
    public FlPermitBean insert(FlPermitBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean; 
        }
        if (!bean.isNew()){
            return this.update(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();
            // listener callback
            this.listenerContainer.beforeInsert(bean);
            int dirtyCount = 0;
            sql = new StringBuilder("INSERT into fl_permit (");

            if (bean.checkDeviceGroupIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("device_group_id");
                dirtyCount++;
            }

            if (bean.checkPersonGroupIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("person_group_id");
                dirtyCount++;
            }

            if (bean.checkRemarkModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("remark");
                dirtyCount++;
            }

            if (bean.checkExtBinModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_bin");
                dirtyCount++;
            }

            if (bean.checkExtTxtModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_txt");
                dirtyCount++;
            }

            if (bean.checkCreateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("create_time");
                dirtyCount++;
            }

            sql.append(") values (");
            if(dirtyCount > 0) {
                sql.append("?");
                for(int i = 1; i < dirtyCount; i++) {
                    sql.append(",?");
                }
            }
            sql.append(")");


            // System.out.println("insert : " + sql.toString());

            ps = c.prepareStatement(sql.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);

            this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            ps.executeUpdate();

            bean.isNew(false);
            bean.resetIsModified();
            // listener callback
            this.listenerContainer.afterInsert(bean);
            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //14

    @Override
    public FlPermitBean update(FlPermitBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean;
        }
        if (bean.isNew()){
            return this.insert(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();

            // listener callback
            this.listenerContainer.beforeUpdate(bean); 
            sql = new StringBuilder("UPDATE fl_permit SET ");
            boolean useComma=false;

            if (bean.checkDeviceGroupIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("device_group_id=?");
            }

            if (bean.checkPersonGroupIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("person_group_id=?");
            }

            if (bean.checkRemarkModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("remark=?");
            }

            if (bean.checkExtBinModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_bin=?");
            }

            if (bean.checkExtTxtModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_txt=?");
            }

            if (bean.checkCreateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("create_time=?");
            }
            sql.append(" WHERE ");
            sql.append("device_group_id=? AND person_group_id=?");
            // System.out.println("update : " + sql.toString());
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);

            int dirtyCount = this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            if (dirtyCount == 0) {
                // System.out.println("The bean to look is not initialized... do not update.");
                return bean;
            }

            if (bean.getDeviceGroupId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getDeviceGroupId()); }
            if (bean.getPersonGroupId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getPersonGroupId()); }
            ps.executeUpdate();
            // listener callback
            this.listenerContainer.afterUpdate(bean); 
            bean.resetIsModified();

            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18

    @Override
    public FlPermitBean loadUniqueUsingTemplate(FlPermitBean bean) throws DaoException
    {
         List<FlPermitBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             return null;
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //18-1

    @Override
    public FlPermitBean loadUniqueUsingTemplateChecked(FlPermitBean bean) throws DaoException
    {
         List<FlPermitBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             throw new ObjectRetrievalException("Not found element !!");
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //20-5

    @Override
    public int loadUsingTemplate(FlPermitBean bean, int[] fieldList, int startRow, int numRows,int searchType, Action<FlPermitBean> action) throws DaoException
    {
        // System.out.println("loadUsingTemplate startRow:" + startRow + ", numRows:" + numRows + ", searchType:" + searchType);
        StringBuilder sqlWhere = new StringBuilder("");
        String sql=createSelectSql(fieldList,this.fillWhere(sqlWhere, bean, searchType) > 0?" WHERE "+sqlWhere.toString():null);
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }

    //21

    @Override
    public int deleteUsingTemplate(FlPermitBean bean) throws DaoException
    {
        if(bean.checkDeviceGroupIdInitialized() && null != bean.getDeviceGroupId() && bean.checkPersonGroupIdInitialized() && null != bean.getPersonGroupId()){
            return this.deleteByPrimaryKey(bean.getDeviceGroupId(), bean.getPersonGroupId());
        }
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action=new DeleteBeanAction(); 
            this.loadUsingTemplate(bean,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("DELETE FROM fl_permit ");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... deleting all");
            }
            // System.out.println("deleteUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, SEARCH_EXACT, false);

            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________

    //25

    @Override
    public int countWhere(String where) throws DaoException
    {
        String sql = new StringBuffer("SELECT COUNT(*) AS MCOUNT FROM fl_person ")
    		    .append(null == where ? "" : where).toString();
        // System.out.println("countWhere: " + sql);
        Connection c = null;
        Statement st = null;
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement();
            rs =  st.executeQuery(sql);
            if (rs.next())
            {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(st, rs);
            this.freeConnection(c);
            sql = null;
        }
        throw new DataAccessException("Error in countWhere where=[" + where + "]");
    }

    //26
    /**
     * Retrieves the number of rows of the table fl_permit with a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return the number of rows returned
     * @throws DaoException
     */
    private int countByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(rs);
        }
       throw new DataAccessException("Error in countByPreparedStatement");
    }

    //20
    /**
     * count the number of elements of a specific FlPermitBean bean given the search type
     *
     * @param bean the FlPermitBean template to look for
     * @param searchType exact ?  like ? starting like ?
     * @return the number of rows returned
     * @throws DaoException
     */
    @Override
    public int countUsingTemplate(FlPermitBean bean, int searchType) throws DaoException
    {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_permit");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... counting all...");
            }
            // System.out.println("countUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);

            return this.countByPreparedStatement(ps);
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    /**
     * fills the given StringBuilder with the sql where clauses constructed using the bean and the search type
     * @param sqlWhere the StringBuilder that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @return the number of clauses returned
     */
    protected int fillWhere(StringBuilder sqlWhere, FlPermitBean bean, int searchType)
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == SEARCH_EXACT ? "=" : " like ";
        try
        {
            if (bean.checkDeviceGroupIdModified()) {
                dirtyCount ++;
                if (bean.getDeviceGroupId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("device_group_id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("device_group_id = ?");
                }
            }
            if (bean.checkPersonGroupIdModified()) {
                dirtyCount ++;
                if (bean.getPersonGroupId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("person_group_id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("person_group_id = ?");
                }
            }
            if (bean.checkRemarkModified()) {
                dirtyCount ++;
                if (bean.getRemark() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkExtBinModified()) {
                dirtyCount ++;
                if (bean.getExtBin() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin = ?");
                }
            }
            if (bean.checkExtTxtModified()) {
                dirtyCount ++;
                if (bean.getExtTxt() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkCreateTimeModified()) {
                dirtyCount ++;
                if (bean.getCreateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time = ?");
                }
            }
        }
        finally
        {
            sqlEqualsOperation = null;
        }
        return dirtyCount;
    }

    /**
     * fill the given prepared statement with the bean values and a search type
     * @param ps the PreparedStatement that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @param fillNull wether fill null for null field
     * @return the number of clauses returned
     * @throws DaoException
     */
    protected int fillPreparedStatement(PreparedStatement ps, FlPermitBean bean, int searchType,boolean fillNull) throws DaoException
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        try
        {
            if (bean.checkDeviceGroupIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getDeviceGroupId() + "]");
                if (bean.getDeviceGroupId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getDeviceGroupId()); }
            }
            if (bean.checkPersonGroupIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getPersonGroupId() + "]");
                if (bean.getPersonGroupId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getPersonGroupId()); }
            }
            if (bean.checkRemarkModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "]");
                        if (bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "%]");
                        if ( bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "]");
                        if ( bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "%]");
                        if (bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkExtBinModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtBin() + "]");
                if (bean.getExtBin() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARBINARY);} } else { Manager.setBytes(Types.LONGVARBINARY,ps, ++dirtyCount, bean.getExtBin()); }
            }
            if (bean.checkExtTxtModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "]");
                        if (bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "%]");
                        if ( bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "]");
                        if ( bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "%]");
                        if (bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkCreateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getCreateTime() + "]");
                if (bean.getCreateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getCreateTime().getTime())); }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        return dirtyCount;
    }


    //_____________________________________________________________________
    //
    // DECODE RESULT SET
    //_____________________________________________________________________

    //28
    /**
     * decode a resultset in an array of FlPermitBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlPermitBean table
     * @throws DaoException
     */
    public FlPermitBean[] decodeResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return this.decodeResultSetAsList(rs, fieldList, startRow, numRows).toArray(new FlPermitBean[0]);
    }

    //28-1
    /**
     * decode a resultset in a list of FlPermitBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlPermitBean table
     * @throws DaoException
     */
    public List<FlPermitBean> decodeResultSetAsList(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        actionOnResultSet(rs, fieldList, numRows, numRows, action);
        return action.getList();
    }
    //28-2
    /** decode a resultset and call action
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action interface obj for do something
     * @return the count dealt by action  
     * @throws DaoException
     * @throws IllegalArgumentException
     */
    public int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, Action<FlPermitBean> action) throws DaoException{
        try{
            int count = 0;
            if(0!=numRows){
                if( startRow<1 ){
                    throw new IllegalArgumentException("invalid argument:startRow (must >=1)");
                }
                if( null==action || null==rs ){
                    throw new IllegalArgumentException("invalid argument:action OR rs (must not be null)");
                }
                for(;startRow > 1 && rs.next();){
                    --startRow;
                    //skip to last of startRow
                }
                if (fieldList == null) {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }
                }else {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }
                }
            }
            return count;
        }catch(DaoException e){
            throw e;
        }catch(SQLException e){
            throw new DataAccessException(e);
        }
    }

    //29
    /**
     * Transforms a ResultSet iterating on the fl_permit on a FlPermitBean bean.
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlPermitBean bean
     * @throws DaoException
     */
    public FlPermitBean decodeRow(ResultSet rs,FlPermitBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        try
        {
            bean.setDeviceGroupId(Manager.getInteger(rs, 1));
            bean.setPersonGroupId(Manager.getInteger(rs, 2));
            bean.setRemark(rs.getString(3));
            bean.setExtBin(Manager.getBytes(rs, 4));
            bean.setExtTxt(rs.getString(5));
            bean.setCreateTime(rs.getTimestamp(6));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //30
    /**
     * Transforms a ResultSet iterating on the fl_permit table on a FlPermitBean bean according to a list of fields.
     *
     * @param rs the ResultSet to be transformed
     * @param fieldList table of the field's associated constants
     * @return bean resulting FlPermitBean bean
     * @throws DaoException
     */
    public FlPermitBean decodeRow(ResultSet rs, int[] fieldList,FlPermitBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        int pos = 0;
        try
        {
            for(int i = 0; i < fieldList.length; i++)
            {
                switch(fieldList[i])
                {
                    case FL_PERMIT_ID_DEVICE_GROUP_ID:
                        ++pos;
                        bean.setDeviceGroupId(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERMIT_ID_PERSON_GROUP_ID:
                        ++pos;
                        bean.setPersonGroupId(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERMIT_ID_REMARK:
                        ++pos;
                        bean.setRemark(rs.getString(pos));
                        break;
                    case FL_PERMIT_ID_EXT_BIN:
                        ++pos;
                        bean.setExtBin(Manager.getBytes(rs, pos));
                        break;
                    case FL_PERMIT_ID_EXT_TXT:
                        ++pos;
                        bean.setExtTxt(rs.getString(pos));
                        break;
                    case FL_PERMIT_ID_CREATE_TIME:
                        ++pos;
                        bean.setCreateTime(rs.getTimestamp(pos));
                        break;
                    default:
                        throw new DaoException("Unknown field id " + fieldList[i]);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //31
    /**
     * Transforms a ResultSet iterating on the fl_permit on a FlPermitBean bean using the names of the columns
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlPermitBean bean
     * @throws DaoException
     */
    public FlPermitBean metaDataDecodeRow(ResultSet rs) throws DaoException
    {
        FlPermitBean bean = this.createBean();
        try
        {
            bean.setDeviceGroupId(Manager.getInteger(rs, "device_group_id"));
            bean.setPersonGroupId(Manager.getInteger(rs, "person_group_id"));
            bean.setRemark(rs.getString("remark"));
            bean.setExtBin(Manager.getBytes(rs, "ext_bin"));
            bean.setExtTxt(rs.getString("ext_txt"));
            bean.setCreateTime(rs.getTimestamp("create_time"));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }

        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //////////////////////////////////////
    // PREPARED STATEMENT LOADER
    //////////////////////////////////////

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlPermitBean
     * @throws DaoException
     */
    public FlPermitBean[] loadByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatement(ps, null);
    }

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlPermitBean
     * @throws DaoException
     */
    public List<FlPermitBean> loadByPreparedStatementAsList(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, null);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlPermitBean
     * @throws DaoException
     */
    public FlPermitBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, fieldList).toArray(new FlPermitBean[0]);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlPermitBean
     * @throws DaoException
     */
    public List<FlPermitBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList) throws DaoException
    { 
        return loadByPreparedStatementAsList(ps,fieldList,1,-1);
    }

    //34
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlPermitBean
     * @throws DaoException
     */
    public FlPermitBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return loadByPreparedStatementAsList(ps,fieldList,startRow,numRows).toArray(new FlPermitBean[0]);
    }

    //34-1
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlPermitBean
     * @throws DaoException
     */
    public List<FlPermitBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        loadByPreparedStatement(ps,fieldList,startRow,numRows,action);
        return action.getList();
    }
    //34-2
    /**
     * Loads each element using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows 
     * and dealt by action.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */     
    public int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows,Action<FlPermitBean> action) throws DaoException
    {
        ResultSet rs =  null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            return this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(rs);
        }
    }
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    private final TableListener.ListenerContainer<FlPermitBean> listenerContainer = new TableListener.ListenerContainer<FlPermitBean>();

    //35

    @Override
    public TableListener<FlPermitBean> registerListener(TableListener<FlPermitBean> listener)
    {
        this.listenerContainer.add(listener);
        return listener;
    }

    //36
    /**
     * remove listener.
     */
    @Override
    public void unregisterListener(TableListener<FlPermitBean> listener)
    {
        this.listenerContainer.remove(listener);
    }

    //37

    @Override
    public void fire(TableListener.Event event, FlPermitBean bean) throws DaoException{
        if(null == event){
            throw new NullPointerException();
        }
        event.fire(listenerContainer, bean);
    }
    
    //37-1

    @Override
    public void fire(int event, FlPermitBean bean) throws DaoException{
        try{
            fire(TableListener.Event.values()[event],bean);
        }catch(ArrayIndexOutOfBoundsException e){
            throw new IllegalArgumentException("invalid event id " + event);
        }
    }

    /** foreign key listener for DEELTE RULE : CASCADE */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlDeviceGroupBean,FlPermitBean> foreignKeyListenerByDeviceGroupId = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlDeviceGroupBean,FlPermitBean>(){
                @Override
                protected List<FlPermitBean> getImportedBeans(FlDeviceGroupBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlPermitBean>emptyList()
                            : instanceOfFlDeviceGroupManager().getPermitBeansByDeviceGroupIdAsList(bean);
                }
                @Override
                protected void onRemove(List<FlPermitBean> effectBeans) throws DaoException {
                    for(FlPermitBean bean:effectBeans){
                        Event.DELETE.fire(listenerContainer, bean);
                    }
                }};

    /** foreign key listener for DEELTE RULE : CASCADE */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonGroupBean,FlPermitBean> foreignKeyListenerByPersonGroupId = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonGroupBean,FlPermitBean>(){
                @Override
                protected List<FlPermitBean> getImportedBeans(FlPersonGroupBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlPermitBean>emptyList()
                            : instanceOfFlPersonGroupManager().getPermitBeansByPersonGroupIdAsList(bean);
                }
                @Override
                protected void onRemove(List<FlPermitBean> effectBeans) throws DaoException {
                    for(FlPermitBean bean:effectBeans){
                        Event.DELETE.fire(listenerContainer, bean);
                    }
                }};

    //37-2
    /**
     * bind foreign key listener to foreign table: <br>
     * DELETE RULE : CASCADE {@code fl_permit(device_group_id)- fl_device_group(id)} <br>
     * DELETE RULE : CASCADE {@code fl_permit(person_group_id)- fl_person_group(id)} <br>
     */
    public void bindForeignKeyListenerForDeleteRule(){
        instanceOfFlDeviceGroupManager().registerListener(foreignKeyListenerByDeviceGroupId);
        instanceOfFlPersonGroupManager().registerListener(foreignKeyListenerByPersonGroupId);
        
    }
    //37-3
    /**
     * unbind foreign key listener from all of foreign tables <br>
     * @see #bindForeignKeyListenerForDeleteRule()
     */
    public void unbindForeignKeyListenerForDeleteRule(){
        instanceOfFlDeviceGroupManager().unregisterListener(foreignKeyListenerByDeviceGroupId);
        instanceOfFlPersonGroupManager().unregisterListener(foreignKeyListenerByPersonGroupId);
        
    }
    //_____________________________________________________________________
    //
    // UTILS
    //_____________________________________________________________________

    //40
    /**
     * Retrieves the manager object used to get connections.
     *
     * @return the manager used
     */
    private Manager getManager()
    {
        return Manager.getInstance();
    }

    //41
    /**
     * Frees the connection.
     *
     * @param c the connection to release
     */
    private void freeConnection(Connection c)
    {
        // back to pool
        this.getManager().releaseConnection(c);
    }

    //42
    /**
     * Gets the connection.
     */
    private Connection getConnection() throws DaoException
    {
        try
        {
            return this.getManager().getConnection();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
    }

    //43

    @Override
    public boolean isPrimaryKey(String column){
        for(String c:PRIMARYKEY_NAMES){
            if(c.equalsIgnoreCase(column)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Fill the given prepared statement with the values in argList
     * @param ps the PreparedStatement that will be filled
     * @param argList the arguments to use fill given prepared statement
     * @throws DaoException
     */
    private void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws DaoException{
        try {
            if (!(argList == null || ps == null)) {
                for (int i = 0; i < argList.length; i++) {
                    if (argList[i].getClass().equals(byte[].class)) {
                        ps.setBytes(i + 1, (byte[]) argList[i]);
                    } else {
                        ps.setObject(i + 1, argList[i]);
                    }
                }
            }
        } catch (SQLException e) {
            throw new DaoException(e);
        }
    }
    
    @Override    

    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<FlPermitBean> action) throws DaoException{
        PreparedStatement ps = null;
        Connection connection = null;
        // logger.debug("sql string:\n" + sql + "\n");
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            fillPrepareStatement(ps, argList);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }
   
    @Override

    public <T>T runAsTransaction(Callable<T> fun) throws DaoException{
        return Manager.getInstance().runAsTransaction(fun);
    }
    
    class DeleteBeanAction extends Action.BaseAdapter<FlPermitBean>{
        private final AtomicInteger count=new AtomicInteger(0);
        @Override
        public void call(FlPermitBean bean) throws DaoException {
                FlPermitManager.this.delete(bean);
                count.incrementAndGet();
        }
        int getCount(){
            return count.get();
        }
    }
}
