// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: manager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.person;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.Manager;
import net.gdface.facelog.dborm.TableListener;
import net.gdface.facelog.dborm.TableManager;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.DataAccessException;
import net.gdface.facelog.dborm.exception.DataRetrievalException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
import net.gdface.facelog.dborm.permit.FlPermitBean;
import net.gdface.facelog.dborm.permit.FlPermitManager;
import net.gdface.facelog.dborm.device.FlDeviceGroupBean;
import net.gdface.facelog.dborm.device.FlDeviceGroupManager;

/**
 * Handles database calls (save, load, count, etc...) for the fl_person_group table.<br>
 * Remarks: 用户组信息<br>
 * @author sql2java
 */
public class FlPersonGroupManager extends TableManager.BaseAdapter<FlPersonGroupBean>
{
    /**
     * Tablename.
     */
    public static final String TABLE_NAME="fl_person_group";

    /**
     * Contains all the primary key fields of the fl_person_group table.
     */
    public static final String[] PRIMARYKEY_NAMES =
    {
        "id"
    };

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }
    
    @Override
    public String getFields() {
        return FL_PERSON_GROUP_FIELDS;
    }
    
    @Override
    public String getFullFields() {
        return FL_PERSON_GROUP_FULL_FIELDS;
    }

    @Override
    public String[] getPrimarykeyNames() {
        return PRIMARYKEY_NAMES;
    }

    private static FlPersonGroupManager singleton = new FlPersonGroupManager();
    protected FlPersonGroupManager(){}
    /**
     * Get the FlPersonGroupManager singleton.
     *
     * @return FlPersonGroupManager
     */
    public static FlPersonGroupManager getInstance()
    {
        return singleton;
    }


    /**
     * Creates a new FlPersonGroupBean instance.
     *
     * @return the new FlPersonGroupBean
     */
    public FlPersonGroupBean createBean()
    {
        return new FlPersonGroupBean();
    }
    
    @Override
    protected Class<FlPersonGroupBean> beanType(){
        return FlPersonGroupBean.class;
    }
    
    protected FlPermitManager instanceOfFlPermitManager(){
        return FlPermitManager.getInstance();
    }
    protected FlPersonManager instanceOfFlPersonManager(){
        return FlPersonManager.getInstance();
    }
    protected FlDeviceGroupManager instanceOfFlDeviceGroupManager(){
        return FlDeviceGroupManager.getInstance();
    }
    protected FlPersonGroupManager instanceOfFlPersonGroupManager(){
        return this;
    }
    //////////////////////////////////////
    // PRIMARY KEY METHODS
    //////////////////////////////////////

    //1
    /**
     * Loads a {@link FlPersonGroupBean} from the fl_person_group using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlPersonGroupBean or {@code null} if not found or have null argument
     * @throws DaoException
     */
    public FlPersonGroupBean loadByPrimaryKey(Integer id) throws DaoException
    {
        try{
            return loadByPrimaryKeyChecked(id);
        }catch(ObjectRetrievalException e){
            // not found
            return null;
        }
    }
    
    //1.1
    /**
     * Loads a {@link FlPersonGroupBean} from the fl_person_group using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlPersonGroupBean
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public FlPersonGroupBean loadByPrimaryKeyChecked(Integer id) throws DaoException
    {
        if(null == id){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT " + FL_PERSON_GROUP_FIELDS + " FROM fl_person_group WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_PERSON_GROUP_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERSON_GROUP_ID_ID + 1, id); }
            List<FlPersonGroupBean> pReturn = this.loadByPreparedStatementAsList(ps);
            if (1 == pReturn.size()) {
                return pReturn.get(0);
            } else {
                throw new ObjectRetrievalException();
            }
        }
        catch(ObjectRetrievalException e)
        {
            throw e;
        }
        catch(SQLException e)
        {
            throw new DataRetrievalException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //1.2
    
    @Override
    public FlPersonGroupBean loadByPrimaryKey(FlPersonGroupBean bean) throws DaoException
    {
        return bean==null?null:loadByPrimaryKey(bean.getId());
    }
    
    //1.2.2
    
    @Override
    public FlPersonGroupBean loadByPrimaryKeyChecked(FlPersonGroupBean bean) throws DaoException
    {
        if(null == bean){
            throw new NullPointerException();
        }
        return loadByPrimaryKeyChecked(bean.getId());
    }
    
    //1.3
    /**
     * Loads a {@link FlPersonGroupBean} from the fl_person_group using primary key fields.
     * @param keys primary keys value:<br> 
     * @return a unique {@link FlPersonGroupBean} or {@code null} if not found
     * @see #loadByPrimaryKey(Integer id)
     */
    @Override
    public FlPersonGroupBean loadByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERSON_GROUP_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(null == keys[0]){
            return null;
        }
        return loadByPrimaryKey((Integer)keys[0]);
    }
    //1.3.2

    @Override
    public FlPersonGroupBean loadByPrimaryKeyChecked(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERSON_GROUP_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(! (keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        return loadByPrimaryKeyChecked((Integer)keys[0]);
    }
    //1.4
    /**
     * Returns true if this fl_person_group contains row with primary key fields.
     * @param id Integer - PK# 1
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public boolean existsPrimaryKey(Integer id) throws DaoException
    {
        if(null == id){
            return false;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try{
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_person_group WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_PERSON_GROUP_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERSON_GROUP_ID_ID + 1, id); }
            return 1 == this.countByPreparedStatement(ps);
        }catch(SQLException e){
            throw new ObjectRetrievalException(e);
        }finally{
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }
    //1.6
    /**
     * Return true if this fl_person_group contains row with primary key fields.
     * @param bean  
     * @throws DaoException
     * @return false if primary kes has null
     */
    @Override
    public boolean existsByPrimaryKey(FlPersonGroupBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return false;
        }
        long modified = bean.getModified();
        try{
            bean.resetModifiedExceptPrimaryKeys();
            return 1 == countUsingTemplate(bean);
        }finally{
            bean.setModified(modified);
        }
    }
    //1.7

    @Override
    public FlPersonGroupBean checkDuplicate(FlPersonGroupBean bean) throws DaoException{
        if(existsByPrimaryKey(bean)){
            throw new ObjectRetrievalException("Duplicate entry ("+ bean.getId() +") for key 'PRIMARY'");
        }
        return bean;
    }
    //1.4.1
    /**
     * Check duplicated row by primary keys,if row exists throw {@link ObjectRetrievalException}
     * @param id Integer
     * @throws DaoException
     * @see #existsPrimaryKey(Integer id)
     */
    public Integer checkDuplicate(Integer id) throws DaoException
    {
        if(existsPrimaryKey(id)){
            throw new ObjectRetrievalException("Duplicate entry '"+ id +"' for key 'PRIMARY'");
        }
        return id;
    }    
    //2
    /**
     * Delete row according to its primary keys.<br>
     * all keys must not be null
     * 
     * @param id Integer - PK# 1
     * @return the number of deleted rows
     * @throws DaoException
     * @see #delete(FlPersonGroupBean)
     */
    public int deleteByPrimaryKey(Integer id) throws DaoException
    {
        FlPersonGroupBean bean=createBean();
        bean.setId(id);
        return this.delete(bean);
    }

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    @Override
    public int delete(FlPersonGroupBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            // listener callback
            this.listenerContainer.beforeDelete(bean);
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_person_group WHERE id=?");
            // System.out.println("deleteByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getId() == null) { ps.setNull(FL_PERSON_GROUP_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERSON_GROUP_ID_ID + 1, bean.getId()); }
            int rows=ps.executeUpdate();
            if(rows>0){
                // listener callback
                this.listenerContainer.afterDelete(bean);
            }
            return rows;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value:<br> 
     * @return the number of deleted rows
     * @see #delete(FlPersonGroupBean)
     */   
    @Override
    public int deleteByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERSON_GROUP_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        FlPersonGroupBean bean = createBean();   
        
        if(null != keys[0] && !(keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        bean.setId((Integer)keys[0]);
        return delete(bean);
    }
 
    //////////////////////////////////////
    // IMPORT KEY GENERIC METHOD
    //////////////////////////////////////
    
    private static final Class<?>[] IMPORTED_BEAN_TYPES = new Class<?>[]{FlPermitBean.class,FlPersonBean.class,FlPersonGroupBean.class};

    /**
     * @see #getImportedBeansAsList(FlPersonGroupBean,int)
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] getImportedBeans(FlPersonGroupBean bean, int ikIndex) throws DaoException {
        return getImportedBeansAsList(bean, ikIndex).toArray((T[])java.lang.reflect.Array.newInstance(IMPORTED_BEAN_TYPES[ikIndex],0));
    }
    
    /**
     * Retrieves imported T objects by ikIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_PERSON_GROUP_IK_FL_PERMIT_PERSON_GROUP_ID} - {@link FlPermitBean}</li>
     *     <li> {@link Constant#FL_PERSON_GROUP_IK_FL_PERSON_GROUP_ID} - {@link FlPersonBean}</li>
     *     <li> {@link Constant#FL_PERSON_GROUP_IK_FL_PERSON_GROUP_PARENT} - {@link FlPersonGroupBean}</li>
     * </ul>
     * @param bean the {@link FlPersonGroupBean} object to use
     * @param ikIndex valid values: {@link Constant#FL_PERSON_GROUP_IK_FL_PERMIT_PERSON_GROUP_ID},{@link Constant#FL_PERSON_GROUP_IK_FL_PERSON_GROUP_ID},{@link Constant#FL_PERSON_GROUP_IK_FL_PERSON_GROUP_PARENT}
     * @return the associated T beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> List<T> getImportedBeansAsList(FlPersonGroupBean bean,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_PERSON_GROUP_IK_FL_PERMIT_PERSON_GROUP_ID:
            return (List<T>)this.getPermitBeansByPersonGroupIdAsList(bean);
        case FL_PERSON_GROUP_IK_FL_PERSON_GROUP_ID:
            return (List<T>)this.getPersonBeansByGroupIdAsList(bean);
        case FL_PERSON_GROUP_IK_FL_PERSON_GROUP_PARENT:
            return (List<T>)this.getPersonGroupBeansByParentAsList(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    
    /**
     * Set the T objects as imported beans of bean object by ikIndex.<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlPersonGroupBean,int)}
     * @param bean the {@link FlPersonGroupBean} object to use
     * @param importedBeans the FlPersonGroupBean array to associate to the {@link FlPersonGroupBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlPersonGroupBean,int)}
     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] setImportedBeans(FlPersonGroupBean bean,T[] importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_PERSON_GROUP_IK_FL_PERMIT_PERSON_GROUP_ID:
            return (T[])setPermitBeansByPersonGroupId(bean,(FlPermitBean[])importedBeans);
        case FL_PERSON_GROUP_IK_FL_PERSON_GROUP_ID:
            return (T[])setPersonBeansByGroupId(bean,(FlPersonBean[])importedBeans);
        case FL_PERSON_GROUP_IK_FL_PERSON_GROUP_PARENT:
            return (T[])setPersonGroupBeansByParent(bean,(FlPersonGroupBean[])importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    /**
     * Set the importedBeans associates to the bean by ikIndex<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlPersonGroupBean,int)}
     * @param bean the {@link FlPersonGroupBean} object to use
     * @param importedBeans the T object to associate to the {@link FlPersonGroupBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlPersonGroupBean,int)}

     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>,C extends java.util.Collection<T>> C setImportedBeans(FlPersonGroupBean bean,C importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_PERSON_GROUP_IK_FL_PERMIT_PERSON_GROUP_ID:
            return (C)setPermitBeansByPersonGroupId(bean,(java.util.Collection<FlPermitBean>)importedBeans);
        case FL_PERSON_GROUP_IK_FL_PERSON_GROUP_ID:
            return (C)setPersonBeansByGroupId(bean,(java.util.Collection<FlPersonBean>)importedBeans);
        case FL_PERSON_GROUP_IK_FL_PERSON_GROUP_PARENT:
            return (C)setPersonGroupBeansByParent(bean,(java.util.Collection<FlPersonGroupBean>)importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
 
    //////////////////////////////////////
    // GET/SET IMPORTED KEY BEAN METHOD
    //////////////////////////////////////
    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlPermitBean} object from the fl_permit.person_group_id field.<BR>
     * FK_NAME : fl_permit_ibfk_2 
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPermitBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPermitBean[] getPermitBeansByPersonGroupId(FlPersonGroupBean bean) throws DaoException
    {
        return getPermitBeansByPersonGroupIdAsList(bean).toArray(new FlPermitBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPermitBean} object from the fl_permit.person_group_id field.<BR>
     * FK_NAME : fl_permit_ibfk_2 
     * @param idOfPersonGroup Integer - PK# 1
     * @return the associated {@link FlPermitBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPermitBean[] getPermitBeansByPersonGroupId(Integer idOfPersonGroup) throws DaoException
    {
        FlPersonGroupBean bean = createBean();
        bean.setId(idOfPersonGroup);
        return getPermitBeansByPersonGroupId(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPermitBean} object from fl_permit.person_group_id field.<BR>
     * FK_NAME:fl_permit_ibfk_2
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPermitBean} beans 
     * @throws DaoException
     */
    public List<FlPermitBean> getPermitBeansByPersonGroupIdAsList(FlPersonGroupBean bean) throws DaoException
    {
        return getPermitBeansByPersonGroupIdAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPermitBean} object from fl_permit.person_group_id field.<BR>
     * FK_NAME:fl_permit_ibfk_2
     * @param idOfPersonGroup Integer - PK# 1
     * @return the associated {@link FlPermitBean} beans 
     * @throws DaoException
     */
    public List<FlPermitBean> getPermitBeansByPersonGroupIdAsList(Integer idOfPersonGroup) throws DaoException
    {
         FlPersonGroupBean bean = createBean();
        bean.setId(idOfPersonGroup);
        return getPermitBeansByPersonGroupIdAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlPermitBean} object from fl_permit.person_group_id field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_permit_ibfk_2
     * @param bean the {@link FlPersonGroupBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlPermitBean} beans 
     * @throws DaoException
     */
    public List<FlPermitBean> getPermitBeansByPersonGroupIdAsList(FlPersonGroupBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlPermitBean>();
        }
        FlPermitBean other = new FlPermitBean();
        other.setPersonGroupId(bean.getId());
        return instanceOfFlPermitManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlPermitBean} object array associate to FlPersonGroupBean by the fl_permit.person_group_id field.<BR>
     * FK_NAME : fl_permit_ibfk_2 
     * @param bean the referenced {@link FlPersonGroupBean}
     * @param importedBeans imported beans from fl_permit
     * @return importedBeans always
     * @throws DaoException
     * @see FlPermitManager#setReferencedByPersonGroupId(FlPermitBean, FlPersonGroupBean)
     */
    public FlPermitBean[] setPermitBeansByPersonGroupId(FlPersonGroupBean bean , FlPermitBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlPermitBean importBean : importedBeans ){
                instanceOfFlPermitManager().setReferencedByPersonGroupId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlPermitBean} object collection associate to FlPersonGroupBean by the fl_permit.person_group_id field.<BR>
     * FK_NAME:fl_permit_ibfk_2
     * @param bean the referenced {@link FlPersonGroupBean} 
     * @param importedBeans imported beans from fl_permit 
     * @return importedBeans always
     * @throws DaoException
     * @see FlPermitManager#setReferencedByPersonGroupId(FlPermitBean, FlPersonGroupBean)
     */
    public <C extends java.util.Collection<FlPermitBean>> C setPermitBeansByPersonGroupId(FlPersonGroupBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlPermitBean importBean : importedBeans ){
                instanceOfFlPermitManager().setReferencedByPersonGroupId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonBean} object from the fl_person.group_id field.<BR>
     * FK_NAME : fl_person_ibfk_1 
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPersonBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonBean[] getPersonBeansByGroupId(FlPersonGroupBean bean) throws DaoException
    {
        return getPersonBeansByGroupIdAsList(bean).toArray(new FlPersonBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonBean} object from the fl_person.group_id field.<BR>
     * FK_NAME : fl_person_ibfk_1 
     * @param idOfPersonGroup Integer - PK# 1
     * @return the associated {@link FlPersonBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonBean[] getPersonBeansByGroupId(Integer idOfPersonGroup) throws DaoException
    {
        FlPersonGroupBean bean = createBean();
        bean.setId(idOfPersonGroup);
        return getPersonBeansByGroupId(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonBean} object from fl_person.group_id field.<BR>
     * FK_NAME:fl_person_ibfk_1
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPersonBean} beans 
     * @throws DaoException
     */
    public List<FlPersonBean> getPersonBeansByGroupIdAsList(FlPersonGroupBean bean) throws DaoException
    {
        return getPersonBeansByGroupIdAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonBean} object from fl_person.group_id field.<BR>
     * FK_NAME:fl_person_ibfk_1
     * @param idOfPersonGroup Integer - PK# 1
     * @return the associated {@link FlPersonBean} beans 
     * @throws DaoException
     */
    public List<FlPersonBean> getPersonBeansByGroupIdAsList(Integer idOfPersonGroup) throws DaoException
    {
         FlPersonGroupBean bean = createBean();
        bean.setId(idOfPersonGroup);
        return getPersonBeansByGroupIdAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonBean} object from fl_person.group_id field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_person_ibfk_1
     * @param bean the {@link FlPersonGroupBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlPersonBean} beans 
     * @throws DaoException
     */
    public List<FlPersonBean> getPersonBeansByGroupIdAsList(FlPersonGroupBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlPersonBean>();
        }
        FlPersonBean other = new FlPersonBean();
        other.setGroupId(bean.getId());
        return instanceOfFlPersonManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlPersonBean} object array associate to FlPersonGroupBean by the fl_person.group_id field.<BR>
     * FK_NAME : fl_person_ibfk_1 
     * @param bean the referenced {@link FlPersonGroupBean}
     * @param importedBeans imported beans from fl_person
     * @return importedBeans always
     * @throws DaoException
     * @see FlPersonManager#setReferencedByGroupId(FlPersonBean, FlPersonGroupBean)
     */
    public FlPersonBean[] setPersonBeansByGroupId(FlPersonGroupBean bean , FlPersonBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlPersonBean importBean : importedBeans ){
                instanceOfFlPersonManager().setReferencedByGroupId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlPersonBean} object collection associate to FlPersonGroupBean by the fl_person.group_id field.<BR>
     * FK_NAME:fl_person_ibfk_1
     * @param bean the referenced {@link FlPersonGroupBean} 
     * @param importedBeans imported beans from fl_person 
     * @return importedBeans always
     * @throws DaoException
     * @see FlPersonManager#setReferencedByGroupId(FlPersonBean, FlPersonGroupBean)
     */
    public <C extends java.util.Collection<FlPersonBean>> C setPersonBeansByGroupId(FlPersonGroupBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlPersonBean importBean : importedBeans ){
                instanceOfFlPersonManager().setReferencedByGroupId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonGroupBean} object from the fl_person_group.parent field.<BR>
     * FK_NAME : fl_person_group_ibfk_1 
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPersonGroupBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonGroupBean[] getPersonGroupBeansByParent(FlPersonGroupBean bean) throws DaoException
    {
        return getPersonGroupBeansByParentAsList(bean).toArray(new FlPersonGroupBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonGroupBean} object from the fl_person_group.parent field.<BR>
     * FK_NAME : fl_person_group_ibfk_1 
     * @param idOfPersonGroup Integer - PK# 1
     * @return the associated {@link FlPersonGroupBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonGroupBean[] getPersonGroupBeansByParent(Integer idOfPersonGroup) throws DaoException
    {
        FlPersonGroupBean bean = createBean();
        bean.setId(idOfPersonGroup);
        return getPersonGroupBeansByParent(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonGroupBean} object from fl_person_group.parent field.<BR>
     * FK_NAME:fl_person_group_ibfk_1
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPersonGroupBean} beans 
     * @throws DaoException
     */
    public List<FlPersonGroupBean> getPersonGroupBeansByParentAsList(FlPersonGroupBean bean) throws DaoException
    {
        return getPersonGroupBeansByParentAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonGroupBean} object from fl_person_group.parent field.<BR>
     * FK_NAME:fl_person_group_ibfk_1
     * @param idOfPersonGroup Integer - PK# 1
     * @return the associated {@link FlPersonGroupBean} beans 
     * @throws DaoException
     */
    public List<FlPersonGroupBean> getPersonGroupBeansByParentAsList(Integer idOfPersonGroup) throws DaoException
    {
         FlPersonGroupBean bean = createBean();
        bean.setId(idOfPersonGroup);
        return getPersonGroupBeansByParentAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlPersonGroupBean} object from fl_person_group.parent field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_person_group_ibfk_1
     * @param bean the {@link FlPersonGroupBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlPersonGroupBean} beans 
     * @throws DaoException
     */
    public List<FlPersonGroupBean> getPersonGroupBeansByParentAsList(FlPersonGroupBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlPersonGroupBean>();
        }
        FlPersonGroupBean other = new FlPersonGroupBean();
        other.setParent(bean.getId());
        return instanceOfFlPersonGroupManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlPersonGroupBean} object array associate to FlPersonGroupBean by the fl_person_group.parent field.<BR>
     * FK_NAME : fl_person_group_ibfk_1 
     * @param bean the referenced {@link FlPersonGroupBean}
     * @param importedBeans imported beans from fl_person_group
     * @return importedBeans always
     * @throws DaoException
     * @see FlPersonGroupManager#setReferencedByParent(FlPersonGroupBean, FlPersonGroupBean)
     */
    public FlPersonGroupBean[] setPersonGroupBeansByParent(FlPersonGroupBean bean , FlPersonGroupBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlPersonGroupBean importBean : importedBeans ){
                instanceOfFlPersonGroupManager().setReferencedByParent(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlPersonGroupBean} object collection associate to FlPersonGroupBean by the fl_person_group.parent field.<BR>
     * FK_NAME:fl_person_group_ibfk_1
     * @param bean the referenced {@link FlPersonGroupBean} 
     * @param importedBeans imported beans from fl_person_group 
     * @return importedBeans always
     * @throws DaoException
     * @see FlPersonGroupManager#setReferencedByParent(FlPersonGroupBean, FlPersonGroupBean)
     */
    public <C extends java.util.Collection<FlPersonGroupBean>> C setPersonGroupBeansByParent(FlPersonGroupBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlPersonGroupBean importBean : importedBeans ){
                instanceOfFlPersonGroupManager().setReferencedByParent(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.5 SYNC SAVE 
    /**
     * Save the FlPersonGroupBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlPersonGroupBean} bean to be saved
     * @param refPersongroupByParent the {@link FlPersonGroupBean} bean referenced by {@link FlPersonGroupBean} 
     * @param impPermitByPersonGroupId the {@link FlPermitBean} beans refer to {@link FlPersonGroupBean} 
     * @param impPersonByGroupId the {@link FlPersonBean} beans refer to {@link FlPersonGroupBean} 
     * @param impPersongroupByParent the {@link FlPersonGroupBean} beans refer to {@link FlPersonGroupBean} 
     * @return the inserted or updated {@link FlPersonGroupBean} bean
     * @throws DaoException
     */
    public FlPersonGroupBean save(FlPersonGroupBean bean
        , FlPersonGroupBean refPersongroupByParent 
        , FlPermitBean[] impPermitByPersonGroupId , FlPersonBean[] impPersonByGroupId , FlPersonGroupBean[] impPersongroupByParent ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refPersongroupByParent){
            this.setReferencedByParent(bean,refPersongroupByParent);
        }
        bean = this.save( bean );
        if(null != impPermitByPersonGroupId){
            this.setPermitBeansByPersonGroupId(bean,impPermitByPersonGroupId);
            instanceOfFlPermitManager().save( impPermitByPersonGroupId );
        }
        if(null != impPersonByGroupId){
            this.setPersonBeansByGroupId(bean,impPersonByGroupId);
            instanceOfFlPersonManager().save( impPersonByGroupId );
        }
        if(null != impPersongroupByParent){
            this.setPersonGroupBeansByParent(bean,impPersongroupByParent);
            instanceOfFlPersonGroupManager().save( impPersongroupByParent );
        }
        return bean;
    } 

    //3.6 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlPersonGroupBean , FlPersonGroupBean , FlPermitBean[] , FlPersonBean[] , FlPersonGroupBean[] )
     */
    public FlPersonGroupBean saveAsTransaction(final FlPersonGroupBean bean
        ,final FlPersonGroupBean refPersongroupByParent 
        ,final FlPermitBean[] impPermitByPersonGroupId ,final FlPersonBean[] impPersonByGroupId ,final FlPersonGroupBean[] impPersongroupByParent ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlPersonGroupBean>(){
            @Override
            public FlPersonGroupBean call() throws Exception {
                return save(bean , refPersongroupByParent , impPermitByPersonGroupId , impPersonByGroupId , impPersongroupByParent );
            }});
    }
    //3.7 SYNC SAVE 
    /**
     * Save the FlPersonGroupBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlPersonGroupBean} bean to be saved
     * @param refPersongroupByParent the {@link FlPersonGroupBean} bean referenced by {@link FlPersonGroupBean} 
     * @param impPermitByPersonGroupId the {@link FlPermitBean} bean refer to {@link FlPersonGroupBean} 
     * @param impPersonByGroupId the {@link FlPersonBean} bean refer to {@link FlPersonGroupBean} 
     * @param impPersongroupByParent the {@link FlPersonGroupBean} bean refer to {@link FlPersonGroupBean} 
     * @return the inserted or updated {@link FlPersonGroupBean} bean
     * @throws DaoException
     */
    public FlPersonGroupBean save(FlPersonGroupBean bean
        , FlPersonGroupBean refPersongroupByParent 
        , java.util.Collection<FlPermitBean> impPermitByPersonGroupId , java.util.Collection<FlPersonBean> impPersonByGroupId , java.util.Collection<FlPersonGroupBean> impPersongroupByParent ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refPersongroupByParent){
            this.setReferencedByParent(bean,refPersongroupByParent);
        }
        bean = this.save( bean );
        if(null != impPermitByPersonGroupId){
            this.setPermitBeansByPersonGroupId(bean,impPermitByPersonGroupId);
            instanceOfFlPermitManager().save( impPermitByPersonGroupId );
        }
        if(null != impPersonByGroupId){
            this.setPersonBeansByGroupId(bean,impPersonByGroupId);
            instanceOfFlPersonManager().save( impPersonByGroupId );
        }
        if(null != impPersongroupByParent){
            this.setPersonGroupBeansByParent(bean,impPersongroupByParent);
            instanceOfFlPersonGroupManager().save( impPersongroupByParent );
        }
        return bean;
    }

    //3.8 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlPersonGroupBean , FlPersonGroupBean , java.util.Collection , java.util.Collection , java.util.Collection )
     * @throws DaoException
     */
    public FlPersonGroupBean saveAsTransaction(final FlPersonGroupBean bean
        ,final FlPersonGroupBean refPersongroupByParent 
        ,final  java.util.Collection<FlPermitBean> impPermitByPersonGroupId ,final  java.util.Collection<FlPersonBean> impPersonByGroupId ,final  java.util.Collection<FlPersonGroupBean> impPersongroupByParent ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlPersonGroupBean>(){
            @Override
            public FlPersonGroupBean call() throws Exception {
                return save(bean , refPersongroupByParent , impPermitByPersonGroupId , impPersonByGroupId , impPersongroupByParent );
            }});
    }

    private static final int SYNC_SAVE_ARG_LEN = 4;
    private static final int SYNC_SAVE_ARG_0 = 0;
    private static final int SYNC_SAVE_ARG_1 = 1;
    private static final int SYNC_SAVE_ARG_2 = 2;
    private static final int SYNC_SAVE_ARG_3 = 3;
    //3.9 SYNC SAVE 
    /**
     * Save the FlPersonGroupBean bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the {@link FlPersonGroupBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlPersonGroupBean , FlPersonGroupBean , FlPermitBean[] , FlPersonBean[] , FlPersonGroupBean[] )}
     * @return the inserted or updated {@link FlPersonGroupBean} bean
     * @throws DaoException
     */
    @Override
    public FlPersonGroupBean save(FlPersonGroupBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 4");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlPersonGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.1 dynamic argument,expected type:FlPersonGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlPermitBean[])){
            throw new IllegalArgumentException("invalid type for the No.2 dynamic argument,expected type:FlPermitBean[]");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof FlPersonBean[])){
            throw new IllegalArgumentException("invalid type for the No.3 dynamic argument,expected type:FlPersonBean[]");
        }
        if( null != args[SYNC_SAVE_ARG_3] && !(args[SYNC_SAVE_ARG_3] instanceof FlPersonGroupBean[])){
            throw new IllegalArgumentException("invalid type for the No.4 dynamic argument,expected type:FlPersonGroupBean[]");
        }
        return save(bean,
                    (FlPersonGroupBean)args[SYNC_SAVE_ARG_0],
                    (FlPermitBean[])args[SYNC_SAVE_ARG_1],
                    (FlPersonBean[])args[SYNC_SAVE_ARG_2],
                    (FlPersonGroupBean[])args[SYNC_SAVE_ARG_3]);
    } 

    //3.10 SYNC SAVE 
    /**
     * Save the FlPersonGroupBean bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the {@link FlPersonGroupBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlPersonGroupBean , FlPersonGroupBean , java.util.Collection , java.util.Collection , java.util.Collection )}
     * @return the inserted or updated {@link FlPersonGroupBean} bean
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public FlPersonGroupBean saveCollection(FlPersonGroupBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 4");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlPersonGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:FlPersonGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:java.util.Collection<FlPermitBean>");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.3 argument,expected type:java.util.Collection<FlPersonBean>");
        }
        if( null != args[SYNC_SAVE_ARG_3] && !(args[SYNC_SAVE_ARG_3] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.4 argument,expected type:java.util.Collection<FlPersonGroupBean>");
        }
        return save(bean,
                    (FlPersonGroupBean)args[SYNC_SAVE_ARG_0],
                    (java.util.Collection<FlPermitBean>)args[SYNC_SAVE_ARG_1],
                    (java.util.Collection<FlPersonBean>)args[SYNC_SAVE_ARG_2],
                    (java.util.Collection<FlPersonGroupBean>)args[SYNC_SAVE_ARG_3]);
    } 
    //////////////////////////////////////
    // FOREIGN KEY GENERIC METHOD
    //////////////////////////////////////

    /**
     * Retrieves the bean object referenced by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_PERSON_GROUP_FK_PARENT} - {@link FlPersonGroupBean}</li>
     * </ul>
     * @param bean the {@link FlPersonGroupBean} object to use
     * @param fkIndex valid values: <br>
     *        {@link Constant#FL_PERSON_GROUP_FK_PARENT}
     * @return the associated T bean or {@code null} if {@code bean} or {@code beanToSet} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T getReferencedBean(FlPersonGroupBean bean,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_PERSON_GROUP_FK_PARENT:
            return  (T)this.getReferencedByParent(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
    
    /**
     * Associates the {@link FlPersonGroupBean} object to the bean object by fkIndex field.<br>
     * 
     * @param <T> see also {@link #getReferencedBean(FlPersonGroupBean,int)}
     * @param bean the {@link FlPersonGroupBean} object to use
     * @param beanToSet the T object to associate to the {@link FlPersonGroupBean}
     * @param fkIndex valid values: see also {@link #getReferencedBean(FlPersonGroupBean,int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T setReferencedBean(FlPersonGroupBean bean,T beanToSet,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_PERSON_GROUP_FK_PARENT:
            return  (T)this.setReferencedByParent(bean, (FlPersonGroupBean)beanToSet);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
     
    //////////////////////////////////////
    // GET/SET FOREIGN KEY BEAN METHOD
    //////////////////////////////////////


    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlPersonGroupBean} object referenced by {@link FlPersonGroupBean#getParent}() field.<br>
     * FK_NAME : fl_person_group_ibfk_1
     * @param bean the {@link FlPersonGroupBean}
     * @return the associated {@link FlPersonGroupBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonGroupBean getReferencedByParent(FlPersonGroupBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByParent(instanceOfFlPersonGroupManager().loadByPrimaryKey(bean.getParent())); 
        return bean.getReferencedByParent();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlPersonGroupBean} object to the {@link FlPersonGroupBean} object by {@link FlPersonGroupBean#getParent}() field.
     *
     * @param bean the {@link FlPersonGroupBean} object to use
     * @param beanToSet the {@link FlPersonGroupBean} object to associate to the {@link FlPersonGroupBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlPersonGroupBean setReferencedByParent(FlPersonGroupBean bean, FlPersonGroupBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlPersonGroupManager().save(beanToSet);
            bean.setReferencedByParent(beanToSet);
            if( null == beanToSet){
                bean.setParent(null);
            }else{
                bean.setParent(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //11
    /**
     * Deletes rows from the fl_person_group table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    @Override
    public int deleteByWhere(String where) throws DaoException
    {
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action = new DeleteBeanAction(); 
            this.loadByWhere(where,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;

        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_person_group " + where);
            // System.out.println("deleteByWhere: " + sql);
            ps = c.prepareStatement(sql.toString());
            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________

    //13

    @Override
    public FlPersonGroupBean insert(FlPersonGroupBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean; 
        }
        if (!bean.isNew()){
            return this.update(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();
            // listener callback
            this.listenerContainer.beforeInsert(bean);
            int dirtyCount = 0;
            sql = new StringBuilder("INSERT into fl_person_group (");

            if (bean.checkIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("id");
                dirtyCount++;
            }

            if (bean.checkNameModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("name");
                dirtyCount++;
            }

            if (bean.checkLeafModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("leaf");
                dirtyCount++;
            }

            if (bean.checkParentModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("parent");
                dirtyCount++;
            }

            if (bean.checkRootGroupModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("root_group");
                dirtyCount++;
            }

            if (bean.checkRemarkModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("remark");
                dirtyCount++;
            }

            if (bean.checkExtBinModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_bin");
                dirtyCount++;
            }

            if (bean.checkExtTxtModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_txt");
                dirtyCount++;
            }

            if (bean.checkCreateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("create_time");
                dirtyCount++;
            }

            if (bean.checkUpdateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("update_time");
                dirtyCount++;
            }

            sql.append(") values (");
            if(dirtyCount > 0) {
                sql.append("?");
                for(int i = 1; i < dirtyCount; i++) {
                    sql.append(",?");
                }
            }
            sql.append(")");


            // System.out.println("insert : " + sql.toString());

            ps = c.prepareStatement(sql.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);

            this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            ps.executeUpdate();

            if (!bean.checkIdModified())
            {
                PreparedStatement ps2 = null;
                ResultSet rs = null;
                try {
                    ps2 = c.prepareStatement("SELECT last_insert_id()");
                    rs = ps2.executeQuery();
                    if(rs.next()) {
                        bean.setId(Manager.getInteger(rs, 1));
                    } else {
                        this.getManager().log("ATTENTION: Could not retrieve generated key!");
                    }
                } finally {
                    this.getManager().close(ps2, rs);
                }
            }

            bean.isNew(false);
            bean.resetIsModified();
            // listener callback
            this.listenerContainer.afterInsert(bean);
            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //14

    @Override
    public FlPersonGroupBean update(FlPersonGroupBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean;
        }
        if (bean.isNew()){
            return this.insert(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();

            // listener callback
            this.listenerContainer.beforeUpdate(bean); 
            sql = new StringBuilder("UPDATE fl_person_group SET ");
            boolean useComma=false;

            if (bean.checkIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("id=?");
            }

            if (bean.checkNameModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("name=?");
            }

            if (bean.checkLeafModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("leaf=?");
            }

            if (bean.checkParentModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("parent=?");
            }

            if (bean.checkRootGroupModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("root_group=?");
            }

            if (bean.checkRemarkModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("remark=?");
            }

            if (bean.checkExtBinModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_bin=?");
            }

            if (bean.checkExtTxtModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_txt=?");
            }

            if (bean.checkCreateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("create_time=?");
            }

            if (bean.checkUpdateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("update_time=?");
            }
            sql.append(" WHERE ");
            sql.append("id=?");
            // System.out.println("update : " + sql.toString());
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);

            int dirtyCount = this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            if (dirtyCount == 0) {
                // System.out.println("The bean to look is not initialized... do not update.");
                return bean;
            }

            if (bean.getId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            ps.executeUpdate();
            // listener callback
            this.listenerContainer.afterUpdate(bean); 
            bean.resetIsModified();

            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18

    @Override
    public FlPersonGroupBean loadUniqueUsingTemplate(FlPersonGroupBean bean) throws DaoException
    {
         List<FlPersonGroupBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             return null;
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //18-1

    @Override
    public FlPersonGroupBean loadUniqueUsingTemplateChecked(FlPersonGroupBean bean) throws DaoException
    {
         List<FlPersonGroupBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             throw new ObjectRetrievalException("Not found element !!");
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //20-5

    @Override
    public int loadUsingTemplate(FlPersonGroupBean bean, int[] fieldList, int startRow, int numRows,int searchType, Action<FlPersonGroupBean> action) throws DaoException
    {
        // System.out.println("loadUsingTemplate startRow:" + startRow + ", numRows:" + numRows + ", searchType:" + searchType);
        StringBuilder sqlWhere = new StringBuilder("");
        String sql=createSelectSql(fieldList,this.fillWhere(sqlWhere, bean, searchType) > 0?" WHERE "+sqlWhere.toString():null);
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }

    //21

    @Override
    public int deleteUsingTemplate(FlPersonGroupBean bean) throws DaoException
    {
        if(bean.checkIdInitialized() && null != bean.getId()){
            return this.deleteByPrimaryKey(bean.getId());
        }
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action=new DeleteBeanAction(); 
            this.loadUsingTemplate(bean,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("DELETE FROM fl_person_group ");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... deleting all");
            }
            // System.out.println("deleteUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, SEARCH_EXACT, false);

            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }


    //_____________________________________________________________________
    //
    // USING INDICES
    //_____________________________________________________________________


    /**
     * Retrieves an array of FlPersonGroupBean using the parent index.
     *
     * @param parent the parent column's value filter.
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public FlPersonGroupBean[] loadByIndexParent(Integer parent) throws DaoException
    {
        return (FlPersonGroupBean[])this.loadByIndexParentAsList(parent).toArray(new FlPersonGroupBean[0]);
    }
    
    /**
     * Retrieves a list of FlPersonGroupBean using the parent index.
     *
     * @param parent the parent column's value filter.
     * @return a list of FlPersonGroupBean
     * @throws DaoException
     */
    public List<FlPersonGroupBean> loadByIndexParentAsList(Integer parent) throws DaoException
    {
        FlPersonGroupBean bean = this.createBean();
        bean.setParent(parent);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the parent index.
     *
     * @param parent the parent column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexParent(Integer parent) throws DaoException
    {
        FlPersonGroupBean bean = this.createBean();
        bean.setParent(parent);
        return deleteUsingTemplate(bean);
    }
    
    
    /**
     * Retrieves a list of FlPersonGroupBean using the index specified by keyIndex.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_PERSON_GROUP_INDEX_PARENT}
     * @param keys key values of index
     * @return a list of FlPersonGroupBean
     * @throws DaoException
     */
    @Override
    public List<FlPersonGroupBean> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_PERSON_GROUP_INDEX_PARENT:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'parent' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.loadByIndexParentAsList((Integer)keys[0]);        
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }
    }
    
    /**
     * Deletes rows using key.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_PERSON_GROUP_INDEX_PARENT}
     * @param keys key values of index
     * @return the number of deleted objects
     * @throws DaoException
     */
    @Override
    public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_PERSON_GROUP_INDEX_PARENT:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'parent' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.deleteByIndexParent((Integer)keys[0]);
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }        
    }

    //_____________________________________________________________________
    //
    // MANY TO MANY: LOAD OTHER BEAN VIA JUNCTION TABLE
    //_____________________________________________________________________
    //22 MANY TO MANY
    /**
     * @see #loadViaPermitAsList(FlDeviceGroupBean,int,int)
     */
    public List<FlPersonGroupBean> loadViaPermitAsList(FlDeviceGroupBean bean) throws DaoException
    {
         return this.loadViaPermitAsList(bean, 1, -1);
    }

    //23 MANY TO MANY
    /**
     * Retrieves an list of FlPersonGroupBean using the junction table FlPermit, given a FlDeviceGroupBean, 
     * specifying the start row and the number of rows.
     *
     * @param bean the FlDeviceGroupBean bean to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return a list of FlPersonGroupBean
     * @throws DaoException
     */
    public List<FlPersonGroupBean> loadViaPermitAsList(FlDeviceGroupBean bean, int startRow, int numRows) throws DaoException
    {
        if(null == bean || null == bean.getId()){
            return java.util.Arrays.<FlPersonGroupBean>asList();
        }
        Connection c = null;
        PreparedStatement ps = null;
        String sql = " SELECT " + FL_PERSON_GROUP_FULL_FIELDS
                        + " FROM fl_permit, fl_person_group"
                        + " WHERE "
                        + "     fl_permit.device_group_id=?"
                        + " AND fl_permit.person_group_id=fl_person_group.id";
        try
        {
            c = this.getConnection();
            ps = c.prepareStatement(sql,
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getId() == null) { ps.setNull(1, Types.INTEGER); } else { Manager.setInteger(ps, 1, bean.getId()); }
            return loadByPreparedStatementAsList(ps, null, startRow, numRows);
        }
        catch (SQLException e)
        {
            throw new DaoException(e.getMessage(), e);
        }
        finally
        {
           this.getManager().close(ps);
           this.freeConnection(c);
           sql = null;
        }
    }
    //23.2 MANY TO MANY
    /**
     * add junction between {@link FlPersonGroupBean} and {@link FlDeviceGroupBean} if junction not exists
     * @param bean
     * @param linked
     * @throws DaoException
     */
    public void addJunction(FlPersonGroupBean bean,FlDeviceGroupBean linked) throws DaoException{
        if(null == bean || null == bean.getId()){
            return ;
        }
        if(null == linked || null ==bean.getId()){
            return ;
        }
        if(!instanceOfFlPermitManager().existsPrimaryKey(linked.getId(),bean.getId())){
            FlPermitBean junction = new FlPermitBean();
            junction.setDeviceGroupId(linked.getId());
            junction.setPersonGroupId(bean.getId());
            instanceOfFlPermitManager().save(junction);
        }
    }
    //23.3 MANY TO MANY
    /**
     * remove junction between {@link FlPersonGroupBean} and {@link FlDeviceGroupBean}
     * @param bean
     * @param linked
     * @throws DaoException
     */
    public int deleteJunction(FlPersonGroupBean bean,FlDeviceGroupBean linked) throws DaoException{
        if(null == bean || null == bean.getId()){
            return 0;
        }
        if(null == linked || null ==bean.getId()){
            return 0;
        }
        return instanceOfFlPermitManager().deleteByPrimaryKey(linked.getId(),bean.getId());
    }
    //23.4 MANY TO MANY
    /** @see #addJunction(FlPersonGroupBean,FlDeviceGroupBean) */
    public void addJunction(FlPersonGroupBean bean,FlDeviceGroupBean... linkedBeans) throws DaoException{
        if(null != linkedBeans){
            for(FlDeviceGroupBean linked:linkedBeans){
                addJunction(bean,linked);
            }
        }
    }
    //23.5 MANY TO MANY
    /** @see #addJunction(FlPersonGroupBean,FlDeviceGroupBean) */
    public void addJunction(FlPersonGroupBean bean,java.util.Collection<FlDeviceGroupBean> linkedBeans) throws DaoException{
        if(null != linkedBeans){
            for(FlDeviceGroupBean linked:linkedBeans){
                addJunction(bean,linked);
            }
        }
    }
    //23.6 MANY TO MANY
    /** @see #deleteJunction(FlPersonGroupBean,FlDeviceGroupBean) */
    public int deleteJunction(FlPersonGroupBean bean,FlDeviceGroupBean... linkedBeans) throws DaoException{
        int count = 0;
        if(null != linkedBeans){
            for(FlDeviceGroupBean linked:linkedBeans){
                count += deleteJunction(bean,linked);
            }
        }
        return count;
    }
    //23.7 MANY TO MANY
    /** @see #deleteJunction(FlPersonGroupBean,FlDeviceGroupBean) */
    public int deleteJunction(FlPersonGroupBean bean,java.util.Collection<FlDeviceGroupBean> linkedBeans) throws DaoException{
        int count = 0;
        if(null != linkedBeans){
            for(FlDeviceGroupBean linked:linkedBeans){
                count += deleteJunction(bean,linked);
            }
        }
        return count;
    }

    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________

    //25

    @Override
    public int countWhere(String where) throws DaoException
    {
        String sql = new StringBuffer("SELECT COUNT(*) AS MCOUNT FROM fl_person ")
    		    .append(null == where ? "" : where).toString();
        // System.out.println("countWhere: " + sql);
        Connection c = null;
        Statement st = null;
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement();
            rs =  st.executeQuery(sql);
            if (rs.next())
            {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(st, rs);
            this.freeConnection(c);
            sql = null;
        }
        throw new DataAccessException("Error in countWhere where=[" + where + "]");
    }

    //26
    /**
     * Retrieves the number of rows of the table fl_person_group with a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return the number of rows returned
     * @throws DaoException
     */
    private int countByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(rs);
        }
       throw new DataAccessException("Error in countByPreparedStatement");
    }

    //20
    /**
     * count the number of elements of a specific FlPersonGroupBean bean given the search type
     *
     * @param bean the FlPersonGroupBean template to look for
     * @param searchType exact ?  like ? starting like ?
     * @return the number of rows returned
     * @throws DaoException
     */
    @Override
    public int countUsingTemplate(FlPersonGroupBean bean, int searchType) throws DaoException
    {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_person_group");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... counting all...");
            }
            // System.out.println("countUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);

            return this.countByPreparedStatement(ps);
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    /**
     * fills the given StringBuilder with the sql where clauses constructed using the bean and the search type
     * @param sqlWhere the StringBuilder that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @return the number of clauses returned
     */
    protected int fillWhere(StringBuilder sqlWhere, FlPersonGroupBean bean, int searchType)
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == SEARCH_EXACT ? "=" : " like ";
        try
        {
            if (bean.checkIdModified()) {
                dirtyCount ++;
                if (bean.getId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id = ?");
                }
            }
            if (bean.checkNameModified()) {
                dirtyCount ++;
                if (bean.getName() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("name IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("name ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkLeafModified()) {
                dirtyCount ++;
                if (bean.getLeaf() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("leaf IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("leaf = ?");
                }
            }
            if (bean.checkParentModified()) {
                dirtyCount ++;
                if (bean.getParent() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("parent IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("parent = ?");
                }
            }
            if (bean.checkRootGroupModified()) {
                dirtyCount ++;
                if (bean.getRootGroup() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("root_group IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("root_group = ?");
                }
            }
            if (bean.checkRemarkModified()) {
                dirtyCount ++;
                if (bean.getRemark() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkExtBinModified()) {
                dirtyCount ++;
                if (bean.getExtBin() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin = ?");
                }
            }
            if (bean.checkExtTxtModified()) {
                dirtyCount ++;
                if (bean.getExtTxt() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkCreateTimeModified()) {
                dirtyCount ++;
                if (bean.getCreateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time = ?");
                }
            }
            if (bean.checkUpdateTimeModified()) {
                dirtyCount ++;
                if (bean.getUpdateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("update_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("update_time = ?");
                }
            }
        }
        finally
        {
            sqlEqualsOperation = null;
        }
        return dirtyCount;
    }

    /**
     * fill the given prepared statement with the bean values and a search type
     * @param ps the PreparedStatement that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @param fillNull wether fill null for null field
     * @return the number of clauses returned
     * @throws DaoException
     */
    protected int fillPreparedStatement(PreparedStatement ps, FlPersonGroupBean bean, int searchType,boolean fillNull) throws DaoException
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        try
        {
            if (bean.checkIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getId() + "]");
                if (bean.getId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            }
            if (bean.checkNameModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getName() + "]");
                        if (bean.getName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getName()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getName() + "%]");
                        if ( bean.getName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getName() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getName() + "]");
                        if ( bean.getName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getName()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getName() + "%]");
                        if (bean.getName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getName() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkLeafModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getLeaf() + "]");
                if (bean.getLeaf() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TINYINT);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getLeaf()); }
            }
            if (bean.checkParentModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getParent() + "]");
                if (bean.getParent() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getParent()); }
            }
            if (bean.checkRootGroupModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getRootGroup() + "]");
                if (bean.getRootGroup() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getRootGroup()); }
            }
            if (bean.checkRemarkModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "]");
                        if (bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "%]");
                        if ( bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "]");
                        if ( bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "%]");
                        if (bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkExtBinModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtBin() + "]");
                if (bean.getExtBin() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARBINARY);} } else { Manager.setBytes(Types.LONGVARBINARY,ps, ++dirtyCount, bean.getExtBin()); }
            }
            if (bean.checkExtTxtModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "]");
                        if (bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "%]");
                        if ( bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "]");
                        if ( bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "%]");
                        if (bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkCreateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getCreateTime() + "]");
                if (bean.getCreateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getCreateTime().getTime())); }
            }
            if (bean.checkUpdateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getUpdateTime() + "]");
                if (bean.getUpdateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getUpdateTime().getTime())); }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        return dirtyCount;
    }


    //_____________________________________________________________________
    //
    // DECODE RESULT SET
    //_____________________________________________________________________

    //28
    /**
     * decode a resultset in an array of FlPersonGroupBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlPersonGroupBean table
     * @throws DaoException
     */
    public FlPersonGroupBean[] decodeResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return this.decodeResultSetAsList(rs, fieldList, startRow, numRows).toArray(new FlPersonGroupBean[0]);
    }

    //28-1
    /**
     * decode a resultset in a list of FlPersonGroupBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlPersonGroupBean table
     * @throws DaoException
     */
    public List<FlPersonGroupBean> decodeResultSetAsList(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        actionOnResultSet(rs, fieldList, numRows, numRows, action);
        return action.getList();
    }
    //28-2
    /** decode a resultset and call action
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action interface obj for do something
     * @return the count dealt by action  
     * @throws DaoException
     * @throws IllegalArgumentException
     */
    public int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, Action<FlPersonGroupBean> action) throws DaoException{
        try{
            int count = 0;
            if(0!=numRows){
                if( startRow<1 ){
                    throw new IllegalArgumentException("invalid argument:startRow (must >=1)");
                }
                if( null==action || null==rs ){
                    throw new IllegalArgumentException("invalid argument:action OR rs (must not be null)");
                }
                for(;startRow > 1 && rs.next();){
                    --startRow;
                    //skip to last of startRow
                }
                if (fieldList == null) {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }
                }else {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }
                }
            }
            return count;
        }catch(DaoException e){
            throw e;
        }catch(SQLException e){
            throw new DataAccessException(e);
        }
    }

    //29
    /**
     * Transforms a ResultSet iterating on the fl_person_group on a FlPersonGroupBean bean.
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlPersonGroupBean bean
     * @throws DaoException
     */
    public FlPersonGroupBean decodeRow(ResultSet rs,FlPersonGroupBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        try
        {
            bean.setId(Manager.getInteger(rs, 1));
            bean.setName(rs.getString(2));
            bean.setLeaf(Manager.getInteger(rs, 3));
            bean.setParent(Manager.getInteger(rs, 4));
            bean.setRootGroup(Manager.getInteger(rs, 5));
            bean.setRemark(rs.getString(6));
            bean.setExtBin(Manager.getBytes(rs, 7));
            bean.setExtTxt(rs.getString(8));
            bean.setCreateTime(rs.getTimestamp(9));
            bean.setUpdateTime(rs.getTimestamp(10));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //30
    /**
     * Transforms a ResultSet iterating on the fl_person_group table on a FlPersonGroupBean bean according to a list of fields.
     *
     * @param rs the ResultSet to be transformed
     * @param fieldList table of the field's associated constants
     * @return bean resulting FlPersonGroupBean bean
     * @throws DaoException
     */
    public FlPersonGroupBean decodeRow(ResultSet rs, int[] fieldList,FlPersonGroupBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        int pos = 0;
        try
        {
            for(int i = 0; i < fieldList.length; i++)
            {
                switch(fieldList[i])
                {
                    case FL_PERSON_GROUP_ID_ID:
                        ++pos;
                        bean.setId(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_GROUP_ID_NAME:
                        ++pos;
                        bean.setName(rs.getString(pos));
                        break;
                    case FL_PERSON_GROUP_ID_LEAF:
                        ++pos;
                        bean.setLeaf(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_GROUP_ID_PARENT:
                        ++pos;
                        bean.setParent(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_GROUP_ID_ROOT_GROUP:
                        ++pos;
                        bean.setRootGroup(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_GROUP_ID_REMARK:
                        ++pos;
                        bean.setRemark(rs.getString(pos));
                        break;
                    case FL_PERSON_GROUP_ID_EXT_BIN:
                        ++pos;
                        bean.setExtBin(Manager.getBytes(rs, pos));
                        break;
                    case FL_PERSON_GROUP_ID_EXT_TXT:
                        ++pos;
                        bean.setExtTxt(rs.getString(pos));
                        break;
                    case FL_PERSON_GROUP_ID_CREATE_TIME:
                        ++pos;
                        bean.setCreateTime(rs.getTimestamp(pos));
                        break;
                    case FL_PERSON_GROUP_ID_UPDATE_TIME:
                        ++pos;
                        bean.setUpdateTime(rs.getTimestamp(pos));
                        break;
                    default:
                        throw new DaoException("Unknown field id " + fieldList[i]);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //31
    /**
     * Transforms a ResultSet iterating on the fl_person_group on a FlPersonGroupBean bean using the names of the columns
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlPersonGroupBean bean
     * @throws DaoException
     */
    public FlPersonGroupBean metaDataDecodeRow(ResultSet rs) throws DaoException
    {
        FlPersonGroupBean bean = this.createBean();
        try
        {
            bean.setId(Manager.getInteger(rs, "id"));
            bean.setName(rs.getString("name"));
            bean.setLeaf(Manager.getInteger(rs, "leaf"));
            bean.setParent(Manager.getInteger(rs, "parent"));
            bean.setRootGroup(Manager.getInteger(rs, "root_group"));
            bean.setRemark(rs.getString("remark"));
            bean.setExtBin(Manager.getBytes(rs, "ext_bin"));
            bean.setExtTxt(rs.getString("ext_txt"));
            bean.setCreateTime(rs.getTimestamp("create_time"));
            bean.setUpdateTime(rs.getTimestamp("update_time"));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }

        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //////////////////////////////////////
    // PREPARED STATEMENT LOADER
    //////////////////////////////////////

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public FlPersonGroupBean[] loadByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatement(ps, null);
    }

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public List<FlPersonGroupBean> loadByPreparedStatementAsList(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, null);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public FlPersonGroupBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, fieldList).toArray(new FlPersonGroupBean[0]);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public List<FlPersonGroupBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList) throws DaoException
    { 
        return loadByPreparedStatementAsList(ps,fieldList,1,-1);
    }

    //34
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public FlPersonGroupBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return loadByPreparedStatementAsList(ps,fieldList,startRow,numRows).toArray(new FlPersonGroupBean[0]);
    }

    //34-1
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonGroupBean
     * @throws DaoException
     */
    public List<FlPersonGroupBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        loadByPreparedStatement(ps,fieldList,startRow,numRows,action);
        return action.getList();
    }
    //34-2
    /**
     * Loads each element using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows 
     * and dealt by action.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */     
    public int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows,Action<FlPersonGroupBean> action) throws DaoException
    {
        ResultSet rs =  null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            return this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(rs);
        }
    }
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    private final TableListener.ListenerContainer<FlPersonGroupBean> listenerContainer = new TableListener.ListenerContainer<FlPersonGroupBean>();

    //35

    @Override
    public TableListener<FlPersonGroupBean> registerListener(TableListener<FlPersonGroupBean> listener)
    {
        this.listenerContainer.add(listener);
        return listener;
    }

    //36
    /**
     * remove listener.
     */
    @Override
    public void unregisterListener(TableListener<FlPersonGroupBean> listener)
    {
        this.listenerContainer.remove(listener);
    }

    //37

    @Override
    public void fire(TableListener.Event event, FlPersonGroupBean bean) throws DaoException{
        if(null == event){
            throw new NullPointerException();
        }
        event.fire(listenerContainer, bean);
    }
    
    //37-1

    @Override
    public void fire(int event, FlPersonGroupBean bean) throws DaoException{
        try{
            fire(TableListener.Event.values()[event],bean);
        }catch(ArrayIndexOutOfBoundsException e){
            throw new IllegalArgumentException("invalid event id " + event);
        }
    }

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonGroupBean,FlPersonGroupBean> foreignKeyListenerByParent = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonGroupBean,FlPersonGroupBean>(){
                @Override
                protected List<FlPersonGroupBean> getImportedBeans(FlPersonGroupBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlPersonGroupBean>emptyList()
                            : instanceOfFlPersonGroupManager().getPersonGroupBeansByParentAsList(bean);
                }
                @Override
                protected void onRemove(List<FlPersonGroupBean> effectBeans) throws DaoException {
                    for(FlPersonGroupBean bean:effectBeans){
                        bean.setParent(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    //37-2
    /**
     * bind foreign key listener to foreign table: <br>
     * DELETE RULE : SET_NULL {@code fl_person_group(parent)- fl_person_group(id)} <br>
     */
    public void bindForeignKeyListenerForDeleteRule(){
        instanceOfFlPersonGroupManager().registerListener(foreignKeyListenerByParent);
        
    }
    //37-3
    /**
     * unbind foreign key listener from all of foreign tables <br>
     * @see #bindForeignKeyListenerForDeleteRule()
     */
    public void unbindForeignKeyListenerForDeleteRule(){
        instanceOfFlPersonGroupManager().unregisterListener(foreignKeyListenerByParent);
        
    }
    //_____________________________________________________________________
    //
    // UTILS
    //_____________________________________________________________________

    //40
    /**
     * Retrieves the manager object used to get connections.
     *
     * @return the manager used
     */
    private Manager getManager()
    {
        return Manager.getInstance();
    }

    //41
    /**
     * Frees the connection.
     *
     * @param c the connection to release
     */
    private void freeConnection(Connection c)
    {
        // back to pool
        this.getManager().releaseConnection(c);
    }

    //42
    /**
     * Gets the connection.
     */
    private Connection getConnection() throws DaoException
    {
        try
        {
            return this.getManager().getConnection();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
    }

    //43

    @Override
    public boolean isPrimaryKey(String column){
        for(String c:PRIMARYKEY_NAMES){
            if(c.equalsIgnoreCase(column)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Fill the given prepared statement with the values in argList
     * @param ps the PreparedStatement that will be filled
     * @param argList the arguments to use fill given prepared statement
     * @throws DaoException
     */
    private void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws DaoException{
        try {
            if (!(argList == null || ps == null)) {
                for (int i = 0; i < argList.length; i++) {
                    if (argList[i].getClass().equals(byte[].class)) {
                        ps.setBytes(i + 1, (byte[]) argList[i]);
                    } else {
                        ps.setObject(i + 1, argList[i]);
                    }
                }
            }
        } catch (SQLException e) {
            throw new DaoException(e);
        }
    }
    
    @Override    

    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<FlPersonGroupBean> action) throws DaoException{
        PreparedStatement ps = null;
        Connection connection = null;
        // logger.debug("sql string:\n" + sql + "\n");
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            fillPrepareStatement(ps, argList);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }
   
    @Override

    public <T>T runAsTransaction(Callable<T> fun) throws DaoException{
        return Manager.getInstance().runAsTransaction(fun);
    }
    
    class DeleteBeanAction extends Action.BaseAdapter<FlPersonGroupBean>{
        private final AtomicInteger count=new AtomicInteger(0);
        @Override
        public void call(FlPersonGroupBean bean) throws DaoException {
                FlPersonGroupManager.this.delete(bean);
                count.incrementAndGet();
        }
        int getCount(){
            return count.get();
        }
    }
    //45
    /**
     * return a primary key list from {@link FlPersonGroupBean} array
     * @param array
     */
    public List<Integer> toPrimaryKeyList(FlPersonGroupBean... array){        
        if(null == array){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(array.length);
        for(FlPersonGroupBean bean:array){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
    //46
    /**
     * return a primary key list from {@link FlPersonGroupBean} collection
     * @param collection
     */
    public List<Integer> toPrimaryKeyList(java.util.Collection<FlPersonGroupBean> collection){        
        if(null == collection){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(collection.size());
        for(FlPersonGroupBean bean:collection){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }

    //_____________________________________________________________________
    //
    // SELF-REFERENCE
    //_____________________________________________________________________
    //47
    /**
     * return bean list ( include {@code bean}) by the self-reference field : {@code fl_person_group(parent) }<br>
     * first element is top bean
     * @param id PK# 1 
     * @return  empty list if input primary key is {@code null}<br>
     *         first element equal last if self-reference field is cycle
     * @throws DaoException
     */
    public java.util.List<FlPersonGroupBean> listOfParent(Integer id) throws DaoException{
        java.util.List<FlPersonGroupBean> list = new java.util.ArrayList<FlPersonGroupBean>();
        for(FlPersonGroupBean parent = loadByPrimaryKey(id)
                ; null != parent
                ; parent = loadByPrimaryKey(parent.getParent())){
            list.add(parent);
            if(    (parent.getId().equals(parent.getParent()))
                || (list.size() > 1 && parent.getId().equals(id))){
                // cycle reference
                break;
            }
        }
        java.util.Collections.reverse(list);
        return list;

    }
    //48
    /**
     * see also {@link #listOfParent(Integer)}
     */
    public java.util.List<FlPersonGroupBean> listOfParent(FlPersonGroupBean bean) throws DaoException{
        return null == bean
                ? java.util.Collections.<FlPersonGroupBean>emptyList()
                : listOfParent(bean.getId());
    }
    //49
    /**
     * get level count on the self-reference field : {@code fl_person_group(parent) }
     * @param id PK# 1 
     * @return  0 if input primary key is {@code null}<br>
     *         -1 if self-reference field is cycle
     * @throws DaoException
     */
    public int levelOfParent(Integer id) throws DaoException{
        int count = 0 ;
        for(FlPersonGroupBean parent = loadByPrimaryKey(id)
           ; null != parent
           ; ++count,parent = loadByPrimaryKey(parent.getParent())){
            if(    (parent.getId().equals(parent.getParent()))
                || (count > 0 && parent.getId().equals(id))){
                // cycle reference
                return -1;
            }
        }
        return count;

    }
    //50
    /**
     * see also {@link #levelOfParent(Integer)}
     */
    public int levelOfParent(FlPersonGroupBean bean) throws DaoException{
        return null == bean
                ? 0
                : levelOfParent(bean.getId());
    }
    //51
    /**
     * test whether the self-reference field is cycle : {@code fl_person_group(parent) }
     * @param id PK# 1 
     * @throws DaoException
     * @see #levelOfParent(FlPersonGroupBean)
     */
    public boolean isCycleOnParent(Integer id) throws DaoException{
        return levelOfParent(id) < 0;
    }
    //52
    /**
     * test whether the self-reference field is cycle : {@code fl_person_group(parent) }
     * @param bean
     * @throws DaoException
     * @see #levelOfParent(FlPersonGroupBean)
     */
    public boolean isCycleOnParent(FlPersonGroupBean bean) throws DaoException{
        return levelOfParent(bean) < 0;
    }
    //53
    /**
     * return top bean that with {@code null} self-reference field  : {@code fl_person_group(parent) }
     * @param id PK# 1 
     * @return top bean
     * @throws NullPointerException if input primary key is {@code null}
     * @throws IllegalStateException if self-reference field is cycle
     * @throws DaoException
     */
    public FlPersonGroupBean topOfParent(Integer id) throws DaoException{
        if(null == id){
            throw new NullPointerException();
        }
        FlPersonGroupBean parent = loadByPrimaryKey(id);
        int count = 0 ;
        for(;null != parent && null != parent.getParent();){
            if(    (parent.getId().equals(parent.getParent()))
                || (++count > 1 && parent.getId().equals(id))){
                // cycle reference
                throw new IllegalStateException("cycle on field: " + "parent");
            }
            parent = loadByPrimaryKeyChecked(parent.getParent());
        }
        return parent;
    }
    //54
    /**
     * see also {@link #topOfParent(Integer)}
     */
    public FlPersonGroupBean topOfParent(FlPersonGroupBean bean) throws DaoException{
        if(null == bean){
            throw new NullPointerException();
        }
        return topOfParent(bean.getId());
    }
    //55
    /**
     * Ensures the self-reference field is not cycle : {@code fl_person_group(parent) }
     * @param id PK# 1
     * @return always {@code id}
     * @throws IllegalStateException if self-reference field is cycle 
     * @throws DaoException
     * @see #isCycleOnParent(Integer)
     */
    public Integer checkCycleOfParent(Integer id) throws DaoException{
        if(isCycleOnParent(id)){
            throw new IllegalStateException("cycle on field: " + "parent");
        }
        return id;
    }
    //56
    /**
     * Ensures the self-reference field is not cycle : {@code fl_person_group(parent) }<br>
     * @param bean
     * @return always {@code bean}
     * @throws IllegalStateException if self-reference field is cycle
     * @throws DaoException
     * @see #isCycleOnParent(FlPersonGroupBean)
     */
    public FlPersonGroupBean checkCycleOfParent(FlPersonGroupBean bean) throws DaoException{
        if(isCycleOnParent(bean)){
            throw new IllegalStateException("cycle on field: " + "parent");
        }
        return bean;
    }
}
