// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java-2-6-7 (custom branch) 
// modified by guyadong from
// sql2java original version https://sourceforge.net/projects/sql2java/ 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: manager.java.vm
// ______________________________________________________
package net.gdface.facelog.dborm.person;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

import net.gdface.facelog.dborm.Constant;
import net.gdface.facelog.dborm.Manager;
import net.gdface.facelog.dborm.TableListener;
import net.gdface.facelog.dborm.TableManager;
import net.gdface.facelog.dborm.exception.DaoException;
import net.gdface.facelog.dborm.exception.DataAccessException;
import net.gdface.facelog.dborm.exception.DataRetrievalException;
import net.gdface.facelog.dborm.exception.ObjectRetrievalException;
import net.gdface.facelog.dborm.face.FlFeatureBean;
import net.gdface.facelog.dborm.face.FlFeatureManager;
import net.gdface.facelog.dborm.log.FlLogBean;
import net.gdface.facelog.dborm.log.FlLogManager;
import net.gdface.facelog.dborm.image.FlImageBean;
import net.gdface.facelog.dborm.image.FlImageManager;

/**
 * Handles database calls (save, load, count, etc...) for the fl_person table.<br>
 * Remarks: 人员基本描述信息<br>
 * @author sql2java
 */
public class FlPersonManager extends TableManager.BaseAdapter<FlPersonBean>
{
    /**
     * Tablename.
     */
    public static final String TABLE_NAME="fl_person";

    /**
     * Contains all the primary key fields of the fl_person table.
     */
    public static final String[] PRIMARYKEY_NAMES =
    {
        "id"
    };

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }
    
    @Override
    public String getFields() {
        return FL_PERSON_FIELDS;
    }
    
    @Override
    public String getFullFields() {
        return FL_PERSON_FULL_FIELDS;
    }

    @Override
    public String[] getPrimarykeyNames() {
        return PRIMARYKEY_NAMES;
    }

    private static FlPersonManager singleton = new FlPersonManager();
    protected FlPersonManager(){}
    /**
     * Get the FlPersonManager singleton.
     *
     * @return FlPersonManager
     */
    public static FlPersonManager getInstance()
    {
        return singleton;
    }


    /**
     * Creates a new FlPersonBean instance.
     *
     * @return the new FlPersonBean
     */
    public FlPersonBean createBean()
    {
        return new FlPersonBean();
    }
    
    @Override
    protected Class<FlPersonBean> beanType(){
        return FlPersonBean.class;
    }
    
    protected FlFeatureManager instanceOfFlFeatureManager(){
        return FlFeatureManager.getInstance();
    }
    protected FlLogManager instanceOfFlLogManager(){
        return FlLogManager.getInstance();
    }
    protected FlImageManager instanceOfFlImageManager(){
        return FlImageManager.getInstance();
    }
    protected FlPersonGroupManager instanceOfFlPersonGroupManager(){
        return FlPersonGroupManager.getInstance();
    }
    //////////////////////////////////////
    // PRIMARY KEY METHODS
    //////////////////////////////////////

    //1
    /**
     * Loads a {@link FlPersonBean} from the fl_person using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlPersonBean or {@code null} if not found or have null argument
     * @throws DaoException
     */
    public FlPersonBean loadByPrimaryKey(Integer id) throws DaoException
    {
        try{
            return loadByPrimaryKeyChecked(id);
        }catch(ObjectRetrievalException e){
            // not found
            return null;
        }
    }
    
    //1.1
    /**
     * Loads a {@link FlPersonBean} from the fl_person using primary key fields.
     *
     * @param id Integer - PK# 1
     * @return a unique FlPersonBean
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public FlPersonBean loadByPrimaryKeyChecked(Integer id) throws DaoException
    {
        if(null == id){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT " + FL_PERSON_FIELDS + " FROM fl_person WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_PERSON_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERSON_ID_ID + 1, id); }
            List<FlPersonBean> pReturn = this.loadByPreparedStatementAsList(ps);
            if (1 == pReturn.size()) {
                return pReturn.get(0);
            } else {
                throw new ObjectRetrievalException();
            }
        }
        catch(ObjectRetrievalException e)
        {
            throw e;
        }
        catch(SQLException e)
        {
            throw new DataRetrievalException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //1.2
    
    @Override
    public FlPersonBean loadByPrimaryKey(FlPersonBean bean) throws DaoException
    {
        return bean==null?null:loadByPrimaryKey(bean.getId());
    }
    
    //1.2.2
    
    @Override
    public FlPersonBean loadByPrimaryKeyChecked(FlPersonBean bean) throws DaoException
    {
        if(null == bean){
            throw new NullPointerException();
        }
        return loadByPrimaryKeyChecked(bean.getId());
    }
    
    //1.3
    /**
     * Loads a {@link FlPersonBean} from the fl_person using primary key fields.
     * @param keys primary keys value:<br> 
     * @return a unique {@link FlPersonBean} or {@code null} if not found
     * @see #loadByPrimaryKey(Integer id)
     */
    @Override
    public FlPersonBean loadByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERSON_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(null == keys[0]){
            return null;
        }
        return loadByPrimaryKey((Integer)keys[0]);
    }
    //1.3.2

    @Override
    public FlPersonBean loadByPrimaryKeyChecked(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERSON_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        
        if(! (keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        return loadByPrimaryKeyChecked((Integer)keys[0]);
    }
    //1.4
    /**
     * Returns true if this fl_person contains row with primary key fields.
     * @param id Integer - PK# 1
     * @throws DaoException
     */
    @SuppressWarnings("unused")
    public boolean existsPrimaryKey(Integer id) throws DaoException
    {
        if(null == id){
            return false;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try{
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_person WHERE id=?");
            // System.out.println("loadByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (id == null) { ps.setNull(FL_PERSON_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERSON_ID_ID + 1, id); }
            return 1 == this.countByPreparedStatement(ps);
        }catch(SQLException e){
            throw new ObjectRetrievalException(e);
        }finally{
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }
    //1.6
    /**
     * Return true if this fl_person contains row with primary key fields.
     * @param bean  
     * @throws DaoException
     * @return false if primary kes has null
     */
    @Override
    public boolean existsByPrimaryKey(FlPersonBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return false;
        }
        long modified = bean.getModified();
        try{
            bean.resetModifiedExceptPrimaryKeys();
            return 1 == countUsingTemplate(bean);
        }finally{
            bean.setModified(modified);
        }
    }
    //1.7

    @Override
    public FlPersonBean checkDuplicate(FlPersonBean bean) throws DaoException{
        if(existsByPrimaryKey(bean)){
            throw new ObjectRetrievalException("Duplicate entry ("+ bean.getId() +") for key 'PRIMARY'");
        }
        return bean;
    }
    //1.4.1
    /**
     * Check duplicated row by primary keys,if row exists throw {@link ObjectRetrievalException}
     * @param id Integer
     * @throws DaoException
     * @see #existsPrimaryKey(Integer id)
     */
    public Integer checkDuplicate(Integer id) throws DaoException
    {
        if(existsPrimaryKey(id)){
            throw new ObjectRetrievalException("Duplicate entry '"+ id +"' for key 'PRIMARY'");
        }
        return id;
    }    
    //2
    /**
     * Delete row according to its primary keys.<br>
     * all keys must not be null
     * 
     * @param id Integer - PK# 1
     * @return the number of deleted rows
     * @throws DaoException
     * @see #delete(FlPersonBean)
     */
    public int deleteByPrimaryKey(Integer id) throws DaoException
    {
        FlPersonBean bean=createBean();
        bean.setId(id);
        return this.delete(bean);
    }

    //2.2
    /**
     * Delete row according to primary keys of bean.<br>
     * 
     * @param bean will be deleted ,all keys must not be null
     * @return the number of deleted rows,0 returned if bean is null
     * @throws DaoException
     */
    @Override
    public int delete(FlPersonBean bean) throws DaoException
    {
        if(null == bean  || null == bean.getId()){
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try
        {
            // listener callback
            this.listenerContainer.beforeDelete(bean);
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_person WHERE id=?");
            // System.out.println("deleteByPrimaryKey: " + sql);
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            if (bean.getId() == null) { ps.setNull(FL_PERSON_ID_ID + 1, Types.INTEGER); } else { Manager.setInteger(ps, FL_PERSON_ID_ID + 1, bean.getId()); }
            int rows=ps.executeUpdate();
            if(rows>0){
                // listener callback
                this.listenerContainer.afterDelete(bean);
            }
            return rows;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //2.1
    /**
     * Delete row according to its primary keys.
     *
     * @param keys primary keys value:<br> 
     * @return the number of deleted rows
     * @see #delete(FlPersonBean)
     */   
    @Override
    public int deleteByPrimaryKey(Object ...keys) throws DaoException{
        if(null == keys){
            throw new NullPointerException();
        }
        if(keys.length != FL_PERSON_PK_COUNT){
            throw new IllegalArgumentException("argument number mismatch with primary key number");
        }
        FlPersonBean bean = createBean();   
        
        if(null != keys[0] && !(keys[0] instanceof Integer)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
        }
        bean.setId((Integer)keys[0]);
        return delete(bean);
    }
 
    //////////////////////////////////////
    // IMPORT KEY GENERIC METHOD
    //////////////////////////////////////
    
    private static final Class<?>[] IMPORTED_BEAN_TYPES = new Class<?>[]{FlFeatureBean.class,FlLogBean.class};

    /**
     * @see #getImportedBeansAsList(FlPersonBean,int)
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] getImportedBeans(FlPersonBean bean, int ikIndex) throws DaoException {
        return getImportedBeansAsList(bean, ikIndex).toArray((T[])java.lang.reflect.Array.newInstance(IMPORTED_BEAN_TYPES[ikIndex],0));
    }
    
    /**
     * Retrieves imported T objects by ikIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_PERSON_IK_FL_FEATURE_PERSON_ID} - {@link FlFeatureBean}</li>
     *     <li> {@link Constant#FL_PERSON_IK_FL_LOG_PERSON_ID} - {@link FlLogBean}</li>
     * </ul>
     * @param bean the {@link FlPersonBean} object to use
     * @param ikIndex valid values: {@link Constant#FL_PERSON_IK_FL_FEATURE_PERSON_ID},{@link Constant#FL_PERSON_IK_FL_LOG_PERSON_ID}
     * @return the associated T beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> List<T> getImportedBeansAsList(FlPersonBean bean,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_PERSON_IK_FL_FEATURE_PERSON_ID:
            return (List<T>)this.getFeatureBeansByPersonIdAsList(bean);
        case FL_PERSON_IK_FL_LOG_PERSON_ID:
            return (List<T>)this.getLogBeansByPersonIdAsList(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    
    /**
     * Set the T objects as imported beans of bean object by ikIndex.<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlPersonBean,int)}
     * @param bean the {@link FlPersonBean} object to use
     * @param importedBeans the FlLogBean array to associate to the {@link FlPersonBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlPersonBean,int)}
     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T[] setImportedBeans(FlPersonBean bean,T[] importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_PERSON_IK_FL_FEATURE_PERSON_ID:
            return (T[])setFeatureBeansByPersonId(bean,(FlFeatureBean[])importedBeans);
        case FL_PERSON_IK_FL_LOG_PERSON_ID:
            return (T[])setLogBeansByPersonId(bean,(FlLogBean[])importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
    /**
     * Set the importedBeans associates to the bean by ikIndex<br>
     * @param <T> see also {@link #getImportedBeansAsList(FlPersonBean,int)}
     * @param bean the {@link FlPersonBean} object to use
     * @param importedBeans the T object to associate to the {@link FlPersonBean}
     * @param ikIndex valid values: see also {@link #getImportedBeansAsList(FlPersonBean,int)}

     * @return importedBeans always
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>,C extends java.util.Collection<T>> C setImportedBeans(FlPersonBean bean,C importedBeans,int ikIndex)throws DaoException{
        switch(ikIndex){
        case FL_PERSON_IK_FL_FEATURE_PERSON_ID:
            return (C)setFeatureBeansByPersonId(bean,(java.util.Collection<FlFeatureBean>)importedBeans);
        case FL_PERSON_IK_FL_LOG_PERSON_ID:
            return (C)setLogBeansByPersonId(bean,(java.util.Collection<FlLogBean>)importedBeans);
        default:
            throw new IllegalArgumentException(String.format("invalid ikIndex %d", ikIndex));
        }
    }
 
    //////////////////////////////////////
    // GET/SET IMPORTED KEY BEAN METHOD
    //////////////////////////////////////
    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlFeatureBean} object from the fl_feature.person_id field.<BR>
     * FK_NAME : fl_feature_ibfk_1 
     * @param bean the {@link FlPersonBean}
     * @return the associated {@link FlFeatureBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlFeatureBean[] getFeatureBeansByPersonId(FlPersonBean bean) throws DaoException
    {
        return getFeatureBeansByPersonIdAsList(bean).toArray(new FlFeatureBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlFeatureBean} object from the fl_feature.person_id field.<BR>
     * FK_NAME : fl_feature_ibfk_1 
     * @param idOfPerson Integer - PK# 1
     * @return the associated {@link FlFeatureBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlFeatureBean[] getFeatureBeansByPersonId(Integer idOfPerson) throws DaoException
    {
        FlPersonBean bean = createBean();
        bean.setId(idOfPerson);
        return getFeatureBeansByPersonId(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlFeatureBean} object from fl_feature.person_id field.<BR>
     * FK_NAME:fl_feature_ibfk_1
     * @param bean the {@link FlPersonBean}
     * @return the associated {@link FlFeatureBean} beans 
     * @throws DaoException
     */
    public List<FlFeatureBean> getFeatureBeansByPersonIdAsList(FlPersonBean bean) throws DaoException
    {
        return getFeatureBeansByPersonIdAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlFeatureBean} object from fl_feature.person_id field.<BR>
     * FK_NAME:fl_feature_ibfk_1
     * @param idOfPerson Integer - PK# 1
     * @return the associated {@link FlFeatureBean} beans 
     * @throws DaoException
     */
    public List<FlFeatureBean> getFeatureBeansByPersonIdAsList(Integer idOfPerson) throws DaoException
    {
         FlPersonBean bean = createBean();
        bean.setId(idOfPerson);
        return getFeatureBeansByPersonIdAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlFeatureBean} object from fl_feature.person_id field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_feature_ibfk_1
     * @param bean the {@link FlPersonBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlFeatureBean} beans 
     * @throws DaoException
     */
    public List<FlFeatureBean> getFeatureBeansByPersonIdAsList(FlPersonBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlFeatureBean>();
        }
        FlFeatureBean other = new FlFeatureBean();
        other.setPersonId(bean.getId());
        return instanceOfFlFeatureManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlFeatureBean} object array associate to FlPersonBean by the fl_feature.person_id field.<BR>
     * FK_NAME : fl_feature_ibfk_1 
     * @param bean the referenced {@link FlPersonBean}
     * @param importedBeans imported beans from fl_feature
     * @return importedBeans always
     * @throws DaoException
     * @see FlFeatureManager#setReferencedByPersonId(FlFeatureBean, FlPersonBean)
     */
    public FlFeatureBean[] setFeatureBeansByPersonId(FlPersonBean bean , FlFeatureBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlFeatureBean importBean : importedBeans ){
                instanceOfFlFeatureManager().setReferencedByPersonId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlFeatureBean} object collection associate to FlPersonBean by the fl_feature.person_id field.<BR>
     * FK_NAME:fl_feature_ibfk_1
     * @param bean the referenced {@link FlPersonBean} 
     * @param importedBeans imported beans from fl_feature 
     * @return importedBeans always
     * @throws DaoException
     * @see FlFeatureManager#setReferencedByPersonId(FlFeatureBean, FlPersonBean)
     */
    public <C extends java.util.Collection<FlFeatureBean>> C setFeatureBeansByPersonId(FlPersonBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlFeatureBean importBean : importedBeans ){
                instanceOfFlFeatureManager().setReferencedByPersonId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.1 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from the fl_log.person_id field.<BR>
     * FK_NAME : fl_log_ibfk_1 
     * @param bean the {@link FlPersonBean}
     * @return the associated {@link FlLogBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlLogBean[] getLogBeansByPersonId(FlPersonBean bean) throws DaoException
    {
        return getLogBeansByPersonIdAsList(bean).toArray(new FlLogBean[0]);
    }
    //3.1.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from the fl_log.person_id field.<BR>
     * FK_NAME : fl_log_ibfk_1 
     * @param idOfPerson Integer - PK# 1
     * @return the associated {@link FlLogBean} beans or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlLogBean[] getLogBeansByPersonId(Integer idOfPerson) throws DaoException
    {
        FlPersonBean bean = createBean();
        bean.setId(idOfPerson);
        return getLogBeansByPersonId(bean);
    }
    //3.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.person_id field.<BR>
     * FK_NAME:fl_log_ibfk_1
     * @param bean the {@link FlPersonBean}
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByPersonIdAsList(FlPersonBean bean) throws DaoException
    {
        return getLogBeansByPersonIdAsList(bean,1,-1);
    }
    //3.2.2 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.person_id field.<BR>
     * FK_NAME:fl_log_ibfk_1
     * @param idOfPerson Integer - PK# 1
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByPersonIdAsList(Integer idOfPerson) throws DaoException
    {
         FlPersonBean bean = createBean();
        bean.setId(idOfPerson);
        return getLogBeansByPersonIdAsList(bean);
    }
    //3.2.4 GET IMPORTED
    /**
     * Retrieves the {@link FlLogBean} object from fl_log.person_id field, 
     * given the start row and number of rows.<BR>
     * FK_NAME:fl_log_ibfk_1
     * @param bean the {@link FlPersonBean}
     * @param startRow the start row to be used (first row = 1, last row=-1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the associated {@link FlLogBean} beans 
     * @throws DaoException
     */
    public List<FlLogBean> getLogBeansByPersonIdAsList(FlPersonBean bean,int startRow, int numRows) throws DaoException
    {
        if(null == bean){
            return new java.util.ArrayList<FlLogBean>();
        }
        FlLogBean other = new FlLogBean();
        other.setPersonId(bean.getId());
        return instanceOfFlLogManager().loadUsingTemplateAsList(other,startRow,numRows);
    }
    //3.3 SET IMPORTED
    /**
     * set  the {@link FlLogBean} object array associate to FlPersonBean by the fl_log.person_id field.<BR>
     * FK_NAME : fl_log_ibfk_1 
     * @param bean the referenced {@link FlPersonBean}
     * @param importedBeans imported beans from fl_log
     * @return importedBeans always
     * @throws DaoException
     * @see FlLogManager#setReferencedByPersonId(FlLogBean, FlPersonBean)
     */
    public FlLogBean[] setLogBeansByPersonId(FlPersonBean bean , FlLogBean[] importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlLogBean importBean : importedBeans ){
                instanceOfFlLogManager().setReferencedByPersonId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.4 SET IMPORTED
    /**
     * set  the {@link FlLogBean} object collection associate to FlPersonBean by the fl_log.person_id field.<BR>
     * FK_NAME:fl_log_ibfk_1
     * @param bean the referenced {@link FlPersonBean} 
     * @param importedBeans imported beans from fl_log 
     * @return importedBeans always
     * @throws DaoException
     * @see FlLogManager#setReferencedByPersonId(FlLogBean, FlPersonBean)
     */
    public <C extends java.util.Collection<FlLogBean>> C setLogBeansByPersonId(FlPersonBean bean , C importedBeans) throws DaoException
    {
        if(null != importedBeans){
            for( FlLogBean importBean : importedBeans ){
                instanceOfFlLogManager().setReferencedByPersonId(importBean , bean);
            }
        }
        return importedBeans;
    }

    //3.5 SYNC SAVE 
    /**
     * Save the FlPersonBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlPersonBean} bean to be saved
     * @param refImageByImageMd5 the {@link FlImageBean} bean referenced by {@link FlPersonBean} 
     * @param refPersongroupByGroupId the {@link FlPersonGroupBean} bean referenced by {@link FlPersonBean} 
     * @param impFeatureByPersonId the {@link FlFeatureBean} beans refer to {@link FlPersonBean} 
     * @param impLogByPersonId the {@link FlLogBean} beans refer to {@link FlPersonBean} 
     * @return the inserted or updated {@link FlPersonBean} bean
     * @throws DaoException
     */
    public FlPersonBean save(FlPersonBean bean
        , FlImageBean refImageByImageMd5 , FlPersonGroupBean refPersongroupByGroupId 
        , FlFeatureBean[] impFeatureByPersonId , FlLogBean[] impLogByPersonId ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refImageByImageMd5){
            this.setReferencedByImageMd5(bean,refImageByImageMd5);
        }
        if(null != refPersongroupByGroupId){
            this.setReferencedByGroupId(bean,refPersongroupByGroupId);
        }
        bean = this.save( bean );
        if(null != impFeatureByPersonId){
            this.setFeatureBeansByPersonId(bean,impFeatureByPersonId);
            instanceOfFlFeatureManager().save( impFeatureByPersonId );
        }
        if(null != impLogByPersonId){
            this.setLogBeansByPersonId(bean,impLogByPersonId);
            instanceOfFlLogManager().save( impLogByPersonId );
        }
        return bean;
    } 

    //3.6 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlPersonBean , FlImageBean , FlPersonGroupBean , FlFeatureBean[] , FlLogBean[] )
     */
    public FlPersonBean saveAsTransaction(final FlPersonBean bean
        ,final FlImageBean refImageByImageMd5 ,final FlPersonGroupBean refPersongroupByGroupId 
        ,final FlFeatureBean[] impFeatureByPersonId ,final FlLogBean[] impLogByPersonId ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlPersonBean>(){
            @Override
            public FlPersonBean call() throws Exception {
                return save(bean , refImageByImageMd5 , refPersongroupByGroupId , impFeatureByPersonId , impLogByPersonId );
            }});
    }
    //3.7 SYNC SAVE 
    /**
     * Save the FlPersonBean bean and referenced beans and imported beans into the database.
     *
     * @param bean the {@link FlPersonBean} bean to be saved
     * @param refImageByImageMd5 the {@link FlImageBean} bean referenced by {@link FlPersonBean} 
     * @param refPersongroupByGroupId the {@link FlPersonGroupBean} bean referenced by {@link FlPersonBean} 
     * @param impFeatureByPersonId the {@link FlFeatureBean} bean refer to {@link FlPersonBean} 
     * @param impLogByPersonId the {@link FlLogBean} bean refer to {@link FlPersonBean} 
     * @return the inserted or updated {@link FlPersonBean} bean
     * @throws DaoException
     */
    public FlPersonBean save(FlPersonBean bean
        , FlImageBean refImageByImageMd5 , FlPersonGroupBean refPersongroupByGroupId 
        , java.util.Collection<FlFeatureBean> impFeatureByPersonId , java.util.Collection<FlLogBean> impLogByPersonId ) throws DaoException
    {
        if(null == bean) {
            return null;
        }
        if(null != refImageByImageMd5){
            this.setReferencedByImageMd5(bean,refImageByImageMd5);
        }
        if(null != refPersongroupByGroupId){
            this.setReferencedByGroupId(bean,refPersongroupByGroupId);
        }
        bean = this.save( bean );
        if(null != impFeatureByPersonId){
            this.setFeatureBeansByPersonId(bean,impFeatureByPersonId);
            instanceOfFlFeatureManager().save( impFeatureByPersonId );
        }
        if(null != impLogByPersonId){
            this.setLogBeansByPersonId(bean,impLogByPersonId);
            instanceOfFlLogManager().save( impLogByPersonId );
        }
        return bean;
    }

    //3.8 SYNC SAVE AS TRANSACTION
    /**
     * Transaction version for sync save
     * @see #save(FlPersonBean , FlImageBean , FlPersonGroupBean , java.util.Collection , java.util.Collection )
     * @throws DaoException
     */
    public FlPersonBean saveAsTransaction(final FlPersonBean bean
        ,final FlImageBean refImageByImageMd5 ,final FlPersonGroupBean refPersongroupByGroupId 
        ,final  java.util.Collection<FlFeatureBean> impFeatureByPersonId ,final  java.util.Collection<FlLogBean> impLogByPersonId ) throws DaoException
    {
        return this.runAsTransaction(new Callable<FlPersonBean>(){
            @Override
            public FlPersonBean call() throws Exception {
                return save(bean , refImageByImageMd5 , refPersongroupByGroupId , impFeatureByPersonId , impLogByPersonId );
            }});
    }

    private static final int SYNC_SAVE_ARG_LEN = 4;
    private static final int SYNC_SAVE_ARG_0 = 0;
    private static final int SYNC_SAVE_ARG_1 = 1;
    private static final int SYNC_SAVE_ARG_2 = 2;
    private static final int SYNC_SAVE_ARG_3 = 3;
    //3.9 SYNC SAVE 
    /**
     * Save the FlPersonBean bean and referenced beans and imported beans (array) into the database.
     *
     * @param bean the {@link FlPersonBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlPersonBean , FlImageBean , FlPersonGroupBean , FlFeatureBean[] , FlLogBean[] )}
     * @return the inserted or updated {@link FlPersonBean} bean
     * @throws DaoException
     */
    @Override
    public FlPersonBean save(FlPersonBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 4");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlImageBean)){
            throw new IllegalArgumentException("invalid type for the No.1 dynamic argument,expected type:FlImageBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlPersonGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.2 dynamic argument,expected type:FlPersonGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof FlFeatureBean[])){
            throw new IllegalArgumentException("invalid type for the No.3 dynamic argument,expected type:FlFeatureBean[]");
        }
        if( null != args[SYNC_SAVE_ARG_3] && !(args[SYNC_SAVE_ARG_3] instanceof FlLogBean[])){
            throw new IllegalArgumentException("invalid type for the No.4 dynamic argument,expected type:FlLogBean[]");
        }
        return save(bean,
                    (FlImageBean)args[SYNC_SAVE_ARG_0],
                    (FlPersonGroupBean)args[SYNC_SAVE_ARG_1],
                    (FlFeatureBean[])args[SYNC_SAVE_ARG_2],
                    (FlLogBean[])args[SYNC_SAVE_ARG_3]);
    } 

    //3.10 SYNC SAVE 
    /**
     * Save the FlPersonBean bean and referenced beans and imported beans (collection) into the database.
     *
     * @param bean the {@link FlPersonBean} bean to be saved
     * @param inputs referenced beans or imported beans<br>
     *      see also {@link #save(FlPersonBean , FlImageBean , FlPersonGroupBean , java.util.Collection , java.util.Collection )}
     * @return the inserted or updated {@link FlPersonBean} bean
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public FlPersonBean saveCollection(FlPersonBean bean,Object ...inputs) throws DaoException
    {
        if(null == inputs){
            return save(bean);
        }
        if(inputs.length > SYNC_SAVE_ARG_LEN){
            throw new IllegalArgumentException("too many dynamic arguments,max dynamic arguments number: 4");
        }
        Object[] args = new Object[SYNC_SAVE_ARG_LEN];
        System.arraycopy(inputs, 0, args, 0, inputs.length);
        if( null != args[SYNC_SAVE_ARG_0] && !(args[SYNC_SAVE_ARG_0] instanceof FlImageBean)){
            throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:FlImageBean");
        }
        if( null != args[SYNC_SAVE_ARG_1] && !(args[SYNC_SAVE_ARG_1] instanceof FlPersonGroupBean)){
            throw new IllegalArgumentException("invalid type for the No.2 argument,expected type:FlPersonGroupBean");
        }
        if( null != args[SYNC_SAVE_ARG_2] && !(args[SYNC_SAVE_ARG_2] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.3 argument,expected type:java.util.Collection<FlFeatureBean>");
        }
        if( null != args[SYNC_SAVE_ARG_3] && !(args[SYNC_SAVE_ARG_3] instanceof java.util.Collection)){
            throw new IllegalArgumentException("invalid type for the No.4 argument,expected type:java.util.Collection<FlLogBean>");
        }
        return save(bean,
                    (FlImageBean)args[SYNC_SAVE_ARG_0],
                    (FlPersonGroupBean)args[SYNC_SAVE_ARG_1],
                    (java.util.Collection<FlFeatureBean>)args[SYNC_SAVE_ARG_2],
                    (java.util.Collection<FlLogBean>)args[SYNC_SAVE_ARG_3]);
    } 
    //////////////////////////////////////
    // FOREIGN KEY GENERIC METHOD
    //////////////////////////////////////

    /**
     * Retrieves the bean object referenced by fkIndex.<br>
     * @param <T>
     * <ul>
     *     <li> {@link Constant#FL_PERSON_FK_IMAGE_MD5} - {@link FlImageBean}</li>
     *     <li> {@link Constant#FL_PERSON_FK_GROUP_ID} - {@link FlPersonGroupBean}</li>
     * </ul>
     * @param bean the {@link FlPersonBean} object to use
     * @param fkIndex valid values: <br>
     *        {@link Constant#FL_PERSON_FK_IMAGE_MD5},{@link Constant#FL_PERSON_FK_GROUP_ID}
     * @return the associated T bean or {@code null} if {@code bean} or {@code beanToSet} is {@code null}
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T getReferencedBean(FlPersonBean bean,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_PERSON_FK_IMAGE_MD5:
            return  (T)this.getReferencedByImageMd5(bean);
        case FL_PERSON_FK_GROUP_ID:
            return  (T)this.getReferencedByGroupId(bean);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
    
    /**
     * Associates the {@link FlPersonBean} object to the bean object by fkIndex field.<br>
     * 
     * @param <T> see also {@link #getReferencedBean(FlPersonBean,int)}
     * @param bean the {@link FlPersonBean} object to use
     * @param beanToSet the T object to associate to the {@link FlPersonBean}
     * @param fkIndex valid values: see also {@link #getReferencedBean(FlPersonBean,int)}
     * @return always beanToSet saved
     * @throws DaoException
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends net.gdface.facelog.dborm.BaseBean<T>> T setReferencedBean(FlPersonBean bean,T beanToSet,int fkIndex)throws DaoException{
        switch(fkIndex){
        case FL_PERSON_FK_IMAGE_MD5:
            return  (T)this.setReferencedByImageMd5(bean, (FlImageBean)beanToSet);
        case FL_PERSON_FK_GROUP_ID:
            return  (T)this.setReferencedByGroupId(bean, (FlPersonGroupBean)beanToSet);
        default:
            throw new IllegalArgumentException(String.format("invalid fkIndex %d", fkIndex));
        }
    }
     
    //////////////////////////////////////
    // GET/SET FOREIGN KEY BEAN METHOD
    //////////////////////////////////////


    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlImageBean} object referenced by {@link FlPersonBean#getImageMd5}() field.<br>
     * FK_NAME : fl_person_ibfk_2
     * @param bean the {@link FlPersonBean}
     * @return the associated {@link FlImageBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlImageBean getReferencedByImageMd5(FlPersonBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByImageMd5(instanceOfFlImageManager().loadByPrimaryKey(bean.getImageMd5())); 
        return bean.getReferencedByImageMd5();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlPersonBean} object to the {@link FlImageBean} object by {@link FlPersonBean#getImageMd5}() field.
     *
     * @param bean the {@link FlPersonBean} object to use
     * @param beanToSet the {@link FlImageBean} object to associate to the {@link FlPersonBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlImageBean setReferencedByImageMd5(FlPersonBean bean, FlImageBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlImageManager().save(beanToSet);
            bean.setReferencedByImageMd5(beanToSet);
            if( null == beanToSet){
                bean.setImageMd5(null);
            }else{
                bean.setImageMd5(beanToSet.getMd5());
            }
        }
        return beanToSet;
    }

    //5.1 GET REFERENCED VALUE
    /**
     * Retrieves the {@link FlPersonGroupBean} object referenced by {@link FlPersonBean#getGroupId}() field.<br>
     * FK_NAME : fl_person_ibfk_1
     * @param bean the {@link FlPersonBean}
     * @return the associated {@link FlPersonGroupBean} bean or {@code null} if {@code bean} is {@code null}
     * @throws DaoException
     */
    public FlPersonGroupBean getReferencedByGroupId(FlPersonBean bean) throws DaoException
    {
        if(null == bean){
            return null;
        }
        bean.setReferencedByGroupId(instanceOfFlPersonGroupManager().loadByPrimaryKey(bean.getGroupId())); 
        return bean.getReferencedByGroupId();
    }

    //5.2 SET REFERENCED 
    /**
     * Associates the {@link FlPersonBean} object to the {@link FlPersonGroupBean} object by {@link FlPersonBean#getGroupId}() field.
     *
     * @param bean the {@link FlPersonBean} object to use
     * @param beanToSet the {@link FlPersonGroupBean} object to associate to the {@link FlPersonBean} .
     * @return always beanToSet saved
     * @throws DaoException
     */
    public FlPersonGroupBean setReferencedByGroupId(FlPersonBean bean, FlPersonGroupBean beanToSet) throws DaoException
    {
        if(null != bean){
            instanceOfFlPersonGroupManager().save(beanToSet);
            bean.setReferencedByGroupId(beanToSet);
            if( null == beanToSet){
                bean.setGroupId(null);
            }else{
                bean.setGroupId(beanToSet.getId());
            }
        }
        return beanToSet;
    }

    //////////////////////////////////////
    // SQL 'WHERE' METHOD
    //////////////////////////////////////
    //11
    /**
     * Deletes rows from the fl_person table using a 'where' clause.
     * It is up to you to pass the 'WHERE' in your where clauses.
     * <br>Attention, if 'WHERE' is omitted it will delete all records.
     *
     * @param where the sql 'where' clause
     * @return the number of deleted rows
     * @throws DaoException
     */
    @Override
    public int deleteByWhere(String where) throws DaoException
    {
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action = new DeleteBeanAction(); 
            this.loadByWhere(where,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;

        try
        {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM fl_person " + where);
            // System.out.println("deleteByWhere: " + sql);
            ps = c.prepareStatement(sql.toString());
            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // SAVE
    //_____________________________________________________________________

    //13

    @Override
    public FlPersonBean insert(FlPersonBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean; 
        }
        if (!bean.isNew()){
            return this.update(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();
            // listener callback
            this.listenerContainer.beforeInsert(bean);
            int dirtyCount = 0;
            sql = new StringBuilder("INSERT into fl_person (");

            if (bean.checkIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("id");
                dirtyCount++;
            }

            if (bean.checkGroupIdModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("group_id");
                dirtyCount++;
            }

            if (bean.checkNameModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("name");
                dirtyCount++;
            }

            if (bean.checkSexModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("sex");
                dirtyCount++;
            }

            if (bean.checkRankModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("rank");
                dirtyCount++;
            }

            if (bean.checkPasswordModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("password");
                dirtyCount++;
            }

            if (bean.checkBirthdateModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("birthdate");
                dirtyCount++;
            }

            if (bean.checkMobilePhoneModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("mobile_phone");
                dirtyCount++;
            }

            if (bean.checkPapersTypeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("papers_type");
                dirtyCount++;
            }

            if (bean.checkPapersNumModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("papers_num");
                dirtyCount++;
            }

            if (bean.checkImageMd5Modified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("image_md5");
                dirtyCount++;
            }

            if (bean.checkExpiryDateModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("expiry_date");
                dirtyCount++;
            }

            if (bean.checkRemarkModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("remark");
                dirtyCount++;
            }

            if (bean.checkExtBinModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_bin");
                dirtyCount++;
            }

            if (bean.checkExtTxtModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("ext_txt");
                dirtyCount++;
            }

            if (bean.checkCreateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("create_time");
                dirtyCount++;
            }

            if (bean.checkUpdateTimeModified()) {
                if (dirtyCount>0) {
                    sql.append(",");
                }
                sql.append("update_time");
                dirtyCount++;
            }

            sql.append(") values (");
            if(dirtyCount > 0) {
                sql.append("?");
                for(int i = 1; i < dirtyCount; i++) {
                    sql.append(",?");
                }
            }
            sql.append(")");


            // System.out.println("insert : " + sql.toString());

            ps = c.prepareStatement(sql.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);

            this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            ps.executeUpdate();

            if (!bean.checkIdModified())
            {
                PreparedStatement ps2 = null;
                ResultSet rs = null;
                try {
                    ps2 = c.prepareStatement("SELECT last_insert_id()");
                    rs = ps2.executeQuery();
                    if(rs.next()) {
                        bean.setId(Manager.getInteger(rs, 1));
                    } else {
                        this.getManager().log("ATTENTION: Could not retrieve generated key!");
                    }
                } finally {
                    this.getManager().close(ps2, rs);
                }
            }

            bean.isNew(false);
            bean.resetIsModified();
            // listener callback
            this.listenerContainer.afterInsert(bean);
            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //14

    @Override
    public FlPersonBean update(FlPersonBean bean) throws DaoException
    {
        // mini checks
        if (null == bean || !bean.isModified()) {
            return bean;
        }
        if (bean.isNew()){
            return this.insert(bean);
        }

        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = null;

        try
        {
            c = this.getConnection();

            // listener callback
            this.listenerContainer.beforeUpdate(bean); 
            sql = new StringBuilder("UPDATE fl_person SET ");
            boolean useComma=false;

            if (bean.checkIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("id=?");
            }

            if (bean.checkGroupIdModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("group_id=?");
            }

            if (bean.checkNameModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("name=?");
            }

            if (bean.checkSexModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("sex=?");
            }

            if (bean.checkRankModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("rank=?");
            }

            if (bean.checkPasswordModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("password=?");
            }

            if (bean.checkBirthdateModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("birthdate=?");
            }

            if (bean.checkMobilePhoneModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("mobile_phone=?");
            }

            if (bean.checkPapersTypeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("papers_type=?");
            }

            if (bean.checkPapersNumModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("papers_num=?");
            }

            if (bean.checkImageMd5Modified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("image_md5=?");
            }

            if (bean.checkExpiryDateModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("expiry_date=?");
            }

            if (bean.checkRemarkModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("remark=?");
            }

            if (bean.checkExtBinModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_bin=?");
            }

            if (bean.checkExtTxtModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("ext_txt=?");
            }

            if (bean.checkCreateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("create_time=?");
            }

            if (bean.checkUpdateTimeModified()) {
                if (useComma) {
                    sql.append(", ");
                } else {
                    useComma=true;
                }
                sql.append("update_time=?");
            }
            sql.append(" WHERE ");
            sql.append("id=?");
            // System.out.println("update : " + sql.toString());
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);

            int dirtyCount = this.fillPreparedStatement(ps, bean, SEARCH_EXACT,true);

            if (dirtyCount == 0) {
                // System.out.println("The bean to look is not initialized... do not update.");
                return bean;
            }

            if (bean.getId() == null) { ps.setNull(++dirtyCount, Types.INTEGER); } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            ps.executeUpdate();
            // listener callback
            this.listenerContainer.afterUpdate(bean); 
            bean.resetIsModified();

            return bean;
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            // listener callback
            this.listenerContainer.done();
            sql = null;
            this.getManager().close(ps);
            this.freeConnection(c);
        }
    }

    //_____________________________________________________________________
    //
    // USING TEMPLATE
    //_____________________________________________________________________
    //18

    @Override
    public FlPersonBean loadUniqueUsingTemplate(FlPersonBean bean) throws DaoException
    {
         List<FlPersonBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             return null;
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //18-1

    @Override
    public FlPersonBean loadUniqueUsingTemplateChecked(FlPersonBean bean) throws DaoException
    {
         List<FlPersonBean> beans = this.loadUsingTemplateAsList(bean);
         switch(beans.size()){
         case 0:
             throw new ObjectRetrievalException("Not found element !!");
         case 1:
             return beans.get(0);
         default:
             throw new ObjectRetrievalException("More than one element !!");
         }
    }
    //20-5

    @Override
    public int loadUsingTemplate(FlPersonBean bean, int[] fieldList, int startRow, int numRows,int searchType, Action<FlPersonBean> action) throws DaoException
    {
        // System.out.println("loadUsingTemplate startRow:" + startRow + ", numRows:" + numRows + ", searchType:" + searchType);
        StringBuilder sqlWhere = new StringBuilder("");
        String sql=createSelectSql(fieldList,this.fillWhere(sqlWhere, bean, searchType) > 0?" WHERE "+sqlWhere.toString():null);
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }

    //21

    @Override
    public int deleteUsingTemplate(FlPersonBean bean) throws DaoException
    {
        if(bean.checkIdInitialized() && null != bean.getId()){
            return this.deleteByPrimaryKey(bean.getId());
        }
        if( !this.listenerContainer.isEmpty()){
            final DeleteBeanAction action=new DeleteBeanAction(); 
            this.loadUsingTemplate(bean,action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("DELETE FROM fl_person ");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... deleting all");
            }
            // System.out.println("deleteUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, SEARCH_EXACT, false);

            return ps.executeUpdate();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }


    //_____________________________________________________________________
    //
    // USING INDICES
    //_____________________________________________________________________


    /**
     * Retrieves an unique FlPersonBean using the image_md5 index.
     * 
     * @param imageMd5 the image_md5 column's value filter
     * @return an FlPersonBean,otherwise null if not found or exists null in input arguments
     * @throws DaoException
     */
    public FlPersonBean loadByIndexImageMd5(String imageMd5) throws DaoException
    {
        try{
            return loadByIndexImageMd5Checked(imageMd5);
        }catch(ObjectRetrievalException e){
            return null;
        }
    }
    /**
     * Retrieves an unique FlPersonBean using the image_md5 index.
     * 
     * @param imageMd5 the image_md5 column's value filter. must not be null
     * @return an FlPersonBean
     * @throws NullPointerException exists null in input arguments
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    public FlPersonBean loadByIndexImageMd5Checked(String imageMd5) throws DaoException
    {
        FlPersonBean bean = new FlPersonBean();
        if(null == imageMd5){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        
        bean.setImageMd5(imageMd5);
        
        return loadUniqueUsingTemplateChecked(bean);
    }
    /**
     * Retrieves an unique FlPersonBean for each image_md5 index.
     *
     * @param indexs index array
     * @return an list of FlPersonBean
     * @throws DaoException
     */
    public java.util.List<FlPersonBean> loadByIndexImageMd5(String... indexs)throws DaoException
    {
        if(null == indexs){
            return new java.util.ArrayList<FlPersonBean>();
        }
        java.util.ArrayList<FlPersonBean> list = new java.util.ArrayList<FlPersonBean>(indexs.length);
        for(int i = 0 ;i< indexs.length;++i){
            list.add(loadByIndexImageMd5(indexs[i]));
        }
        return list;
    }
    /**
     * Retrieves an unique FlPersonBean for each image_md5 index.
     *
     * @param indexs index array
     * @return an list of FlPersonBean
     * @throws DaoException
     */
    public java.util.List<FlPersonBean> loadByIndexImageMd5(java.util.Collection<String> indexs)throws DaoException
    {
        if(null == indexs ){
            return new java.util.ArrayList<FlPersonBean>();
        }
        java.util.ArrayList<FlPersonBean> list = new java.util.ArrayList<FlPersonBean>(indexs.size());
        if(indexs instanceof java.util.List){
            for(String key: indexs){
                list.add(loadByIndexImageMd5(key));
            }
        }else{
            FlPersonBean bean;
            for(String key: indexs){
                if(null != (bean = loadByIndexImageMd5(key))){
                    list.add(bean);
                }
            }
        }
        return list;
    }
    /**
     * Deletes rows for each image_md5 index.
     *
     * @param indexs index array
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexImageMd5(String... indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexImageMd5(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows for each image_md5 index.
     *
     * @param indexs index collection
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexImageMd5(java.util.Collection<String> indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexImageMd5(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows using the image_md5 index.
     *
     * @param imageMd5 the image_md5 column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexImageMd5(String imageMd5) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        bean.setImageMd5(imageMd5);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an unique FlPersonBean using the papers_num index.
     * 
     * @param papersNum the papers_num column's value filter
     * @return an FlPersonBean,otherwise null if not found or exists null in input arguments
     * @throws DaoException
     */
    public FlPersonBean loadByIndexPapersNum(String papersNum) throws DaoException
    {
        try{
            return loadByIndexPapersNumChecked(papersNum);
        }catch(ObjectRetrievalException e){
            return null;
        }
    }
    /**
     * Retrieves an unique FlPersonBean using the papers_num index.
     * 
     * @param papersNum the papers_num column's value filter. must not be null
     * @return an FlPersonBean
     * @throws NullPointerException exists null in input arguments
     * @throws ObjectRetrievalException if not found
     * @throws DaoException
     */
    public FlPersonBean loadByIndexPapersNumChecked(String papersNum) throws DaoException
    {
        FlPersonBean bean = new FlPersonBean();
        if(null == papersNum){
            throw new ObjectRetrievalException(new NullPointerException());
        }
        
        bean.setPapersNum(papersNum);
        
        return loadUniqueUsingTemplateChecked(bean);
    }
    /**
     * Retrieves an unique FlPersonBean for each papers_num index.
     *
     * @param indexs index array
     * @return an list of FlPersonBean
     * @throws DaoException
     */
    public java.util.List<FlPersonBean> loadByIndexPapersNum(String... indexs)throws DaoException
    {
        if(null == indexs){
            return new java.util.ArrayList<FlPersonBean>();
        }
        java.util.ArrayList<FlPersonBean> list = new java.util.ArrayList<FlPersonBean>(indexs.length);
        for(int i = 0 ;i< indexs.length;++i){
            list.add(loadByIndexPapersNum(indexs[i]));
        }
        return list;
    }
    /**
     * Retrieves an unique FlPersonBean for each papers_num index.
     *
     * @param indexs index array
     * @return an list of FlPersonBean
     * @throws DaoException
     */
    public java.util.List<FlPersonBean> loadByIndexPapersNum(java.util.Collection<String> indexs)throws DaoException
    {
        if(null == indexs ){
            return new java.util.ArrayList<FlPersonBean>();
        }
        java.util.ArrayList<FlPersonBean> list = new java.util.ArrayList<FlPersonBean>(indexs.size());
        if(indexs instanceof java.util.List){
            for(String key: indexs){
                list.add(loadByIndexPapersNum(key));
            }
        }else{
            FlPersonBean bean;
            for(String key: indexs){
                if(null != (bean = loadByIndexPapersNum(key))){
                    list.add(bean);
                }
            }
        }
        return list;
    }
    /**
     * Deletes rows for each papers_num index.
     *
     * @param indexs index array
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexPapersNum(String... indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexPapersNum(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows for each papers_num index.
     *
     * @param indexs index collection
     * @return the number of deleted rows
     * @throws DaoException
     */
    public int deleteByIndexPapersNum(java.util.Collection<String> indexs)throws DaoException
    {
        int count = 0;
        if(null != indexs){
            for(String index : indexs){
                count += deleteByIndexPapersNum(index);
            }
        }
        return count;
    }
    /**
     * Deletes rows using the papers_num index.
     *
     * @param papersNum the papers_num column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexPapersNum(String papersNum) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        bean.setPapersNum(papersNum);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlPersonBean using the expiry_date index.
     *
     * @param expiryDate the expiry_date column's value filter.
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public FlPersonBean[] loadByIndexExpiryDate(java.util.Date expiryDate) throws DaoException
    {
        return (FlPersonBean[])this.loadByIndexExpiryDateAsList(expiryDate).toArray(new FlPersonBean[0]);
    }
    
    /**
     * Retrieves a list of FlPersonBean using the expiry_date index.
     *
     * @param expiryDate the expiry_date column's value filter.
     * @return a list of FlPersonBean
     * @throws DaoException
     */
    public List<FlPersonBean> loadByIndexExpiryDateAsList(java.util.Date expiryDate) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        bean.setExpiryDate(expiryDate);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the expiry_date index.
     *
     * @param expiryDate the expiry_date column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexExpiryDate(java.util.Date expiryDate) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        bean.setExpiryDate(expiryDate);
        return deleteUsingTemplate(bean);
    }
    

    /**
     * Retrieves an array of FlPersonBean using the group_id index.
     *
     * @param groupId the group_id column's value filter.
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public FlPersonBean[] loadByIndexGroupId(Integer groupId) throws DaoException
    {
        return (FlPersonBean[])this.loadByIndexGroupIdAsList(groupId).toArray(new FlPersonBean[0]);
    }
    
    /**
     * Retrieves a list of FlPersonBean using the group_id index.
     *
     * @param groupId the group_id column's value filter.
     * @return a list of FlPersonBean
     * @throws DaoException
     */
    public List<FlPersonBean> loadByIndexGroupIdAsList(Integer groupId) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        bean.setGroupId(groupId);
        return loadUsingTemplateAsList(bean);
    }
    /**
     * Deletes rows using the group_id index.
     *
     * @param groupId the group_id column's value filter.
     * @return the number of deleted objects
     * @throws DaoException
     */
    public int deleteByIndexGroupId(Integer groupId) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        bean.setGroupId(groupId);
        return deleteUsingTemplate(bean);
    }
    
    
    /**
     * Retrieves a list of FlPersonBean using the index specified by keyIndex.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_PERSON_INDEX_IMAGE_MD5},{@link Constant#FL_PERSON_INDEX_PAPERS_NUM},{@link Constant#FL_PERSON_INDEX_EXPIRY_DATE},{@link Constant#FL_PERSON_INDEX_GROUP_ID}
     * @param keys key values of index
     * @return a list of FlPersonBean
     * @throws DaoException
     */
    @Override
    public List<FlPersonBean> loadByIndexAsList(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_PERSON_INDEX_IMAGE_MD5:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'image_md5' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            FlPersonBean bean= this.loadByIndexImageMd5((String)keys[0]);
            return null == bean ? new java.util.ArrayList<FlPersonBean>() : java.util.Arrays.asList(bean);
        }
        case FL_PERSON_INDEX_PAPERS_NUM:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'papers_num' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            FlPersonBean bean= this.loadByIndexPapersNum((String)keys[0]);
            return null == bean ? new java.util.ArrayList<FlPersonBean>() : java.util.Arrays.asList(bean);
        }
        case FL_PERSON_INDEX_EXPIRY_DATE:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'expiry_date' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof java.util.Date)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:java.util.Date");
            }
            return this.loadByIndexExpiryDateAsList((java.util.Date)keys[0]);        
        }
        case FL_PERSON_INDEX_GROUP_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'group_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.loadByIndexGroupIdAsList((Integer)keys[0]);        
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }
    }
    
    /**
     * Deletes rows using key.
     * @param keyIndex valid values: <br>
     *        {@link Constant#FL_PERSON_INDEX_IMAGE_MD5},{@link Constant#FL_PERSON_INDEX_PAPERS_NUM},{@link Constant#FL_PERSON_INDEX_EXPIRY_DATE},{@link Constant#FL_PERSON_INDEX_GROUP_ID}
     * @param keys key values of index
     * @return the number of deleted objects
     * @throws DaoException
     */
    @Override
    public int deleteByIndex(int keyIndex,Object ...keys)throws DaoException
    {
        if(null == keys){
            throw new NullPointerException();
        }
        switch(keyIndex){
        case FL_PERSON_INDEX_IMAGE_MD5:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'image_md5' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexImageMd5((String)keys[0]);
        }
        case FL_PERSON_INDEX_PAPERS_NUM:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'papers_num' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof String)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:String");
            }
            return this.deleteByIndexPapersNum((String)keys[0]);
        }
        case FL_PERSON_INDEX_EXPIRY_DATE:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'expiry_date' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof java.util.Date)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:java.util.Date");
            }
            return this.deleteByIndexExpiryDate((java.util.Date)keys[0]);
        }
        case FL_PERSON_INDEX_GROUP_ID:{
            if(keys.length != 1){
                throw new IllegalArgumentException("argument number mismatch with index 'group_id' column number");
            }
            
            if(null != keys[0] && !(keys[0] instanceof Integer)){
                throw new IllegalArgumentException("invalid type for the No.1 argument,expected type:Integer");
            }
            return this.deleteByIndexGroupId((Integer)keys[0]);
        }
        default:
            throw new IllegalArgumentException(String.format("invalid keyIndex %d", keyIndex));
        }        
    }


    //_____________________________________________________________________
    //
    // COUNT
    //_____________________________________________________________________

    //25

    @Override
    public int countWhere(String where) throws DaoException
    {
        String sql = new StringBuffer("SELECT COUNT(*) AS MCOUNT FROM fl_person ")
    		    .append(null == where ? "" : where).toString();
        // System.out.println("countWhere: " + sql);
        Connection c = null;
        Statement st = null;
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement();
            rs =  st.executeQuery(sql);
            if (rs.next())
            {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(st, rs);
            this.freeConnection(c);
            sql = null;
        }
        throw new DataAccessException("Error in countWhere where=[" + where + "]");
    }

    //26
    /**
     * Retrieves the number of rows of the table fl_person with a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return the number of rows returned
     * @throws DaoException
     */
    private int countByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        ResultSet rs =  null;
        try
        {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                return iReturn;
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(rs);
        }
       throw new DataAccessException("Error in countByPreparedStatement");
    }

    //20
    /**
     * count the number of elements of a specific FlPersonBean bean given the search type
     *
     * @param bean the FlPersonBean template to look for
     * @param searchType exact ?  like ? starting like ?
     * @return the number of rows returned
     * @throws DaoException
     */
    @Override
    public int countUsingTemplate(FlPersonBean bean, int searchType) throws DaoException
    {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM fl_person");
        StringBuilder sqlWhere = new StringBuilder("");

        try
        {
            if (this.fillWhere(sqlWhere, bean, SEARCH_EXACT) > 0)
            {
                sql.append(" WHERE ").append(sqlWhere);
            }
            else
            {
                // System.out.println("The bean to look is not initialized... counting all...");
            }
            // System.out.println("countUsingTemplate: " + sql.toString());

            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(),
                                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                                    ResultSet.CONCUR_READ_ONLY);
            this.fillPreparedStatement(ps, bean, searchType,false);

            return this.countByPreparedStatement(ps);
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        finally
        {
            this.getManager().close(ps);
            this.freeConnection(c);
            sql = null;
            sqlWhere = null;
        }
    }



    /**
     * fills the given StringBuilder with the sql where clauses constructed using the bean and the search type
     * @param sqlWhere the StringBuilder that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @return the number of clauses returned
     */
    protected int fillWhere(StringBuilder sqlWhere, FlPersonBean bean, int searchType)
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == SEARCH_EXACT ? "=" : " like ";
        try
        {
            if (bean.checkIdModified()) {
                dirtyCount ++;
                if (bean.getId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("id = ?");
                }
            }
            if (bean.checkGroupIdModified()) {
                dirtyCount ++;
                if (bean.getGroupId() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("group_id IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("group_id = ?");
                }
            }
            if (bean.checkNameModified()) {
                dirtyCount ++;
                if (bean.getName() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("name IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("name ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkSexModified()) {
                dirtyCount ++;
                if (bean.getSex() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("sex IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("sex = ?");
                }
            }
            if (bean.checkRankModified()) {
                dirtyCount ++;
                if (bean.getRank() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("rank IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("rank = ?");
                }
            }
            if (bean.checkPasswordModified()) {
                dirtyCount ++;
                if (bean.getPassword() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("password IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("password ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkBirthdateModified()) {
                dirtyCount ++;
                if (bean.getBirthdate() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("birthdate IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("birthdate = ?");
                }
            }
            if (bean.checkMobilePhoneModified()) {
                dirtyCount ++;
                if (bean.getMobilePhone() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mobile_phone IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("mobile_phone ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkPapersTypeModified()) {
                dirtyCount ++;
                if (bean.getPapersType() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("papers_type IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("papers_type = ?");
                }
            }
            if (bean.checkPapersNumModified()) {
                dirtyCount ++;
                if (bean.getPapersNum() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("papers_num IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("papers_num ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkImageMd5Modified()) {
                dirtyCount ++;
                if (bean.getImageMd5() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("image_md5 IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("image_md5 ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkExpiryDateModified()) {
                dirtyCount ++;
                if (bean.getExpiryDate() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("expiry_date IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("expiry_date = ?");
                }
            }
            if (bean.checkRemarkModified()) {
                dirtyCount ++;
                if (bean.getRemark() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("remark ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkExtBinModified()) {
                dirtyCount ++;
                if (bean.getExtBin() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_bin = ?");
                }
            }
            if (bean.checkExtTxtModified()) {
                dirtyCount ++;
                if (bean.getExtTxt() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("ext_txt ").append(sqlEqualsOperation).append("?");
                }
            }
            if (bean.checkCreateTimeModified()) {
                dirtyCount ++;
                if (bean.getCreateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("create_time = ?");
                }
            }
            if (bean.checkUpdateTimeModified()) {
                dirtyCount ++;
                if (bean.getUpdateTime() == null) {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("update_time IS NULL");
                } else {
                    sqlWhere.append((sqlWhere.length() == 0) ? " " : " AND ").append("update_time = ?");
                }
            }
        }
        finally
        {
            sqlEqualsOperation = null;
        }
        return dirtyCount;
    }

    /**
     * fill the given prepared statement with the bean values and a search type
     * @param ps the PreparedStatement that will be filled
     * @param bean the bean to use for creating the where clauses
     * @param searchType exact ?  like ? starting like ?
     * @param fillNull wether fill null for null field
     * @return the number of clauses returned
     * @throws DaoException
     */
    protected int fillPreparedStatement(PreparedStatement ps, FlPersonBean bean, int searchType,boolean fillNull) throws DaoException
    {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        try
        {
            if (bean.checkIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getId() + "]");
                if (bean.getId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getId()); }
            }
            if (bean.checkGroupIdModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getGroupId() + "]");
                if (bean.getGroupId() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.INTEGER);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getGroupId()); }
            }
            if (bean.checkNameModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getName() + "]");
                        if (bean.getName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getName()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getName() + "%]");
                        if ( bean.getName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getName() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getName() + "]");
                        if ( bean.getName() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getName()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getName() + "%]");
                        if (bean.getName()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getName() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkSexModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getSex() + "]");
                if (bean.getSex() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TINYINT);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getSex()); }
            }
            if (bean.checkRankModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getRank() + "]");
                if (bean.getRank() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TINYINT);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getRank()); }
            }
            if (bean.checkPasswordModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getPassword() + "]");
                        if (bean.getPassword() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getPassword()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getPassword() + "%]");
                        if ( bean.getPassword()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getPassword() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getPassword() + "]");
                        if ( bean.getPassword() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getPassword()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getPassword() + "%]");
                        if (bean.getPassword()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getPassword() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkBirthdateModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getBirthdate() + "]");
                if (bean.getBirthdate() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.DATE);} } else { ps.setDate(++dirtyCount, new java.sql.Date(bean.getBirthdate().getTime())); }
            }
            if (bean.checkMobilePhoneModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getMobilePhone() + "]");
                        if (bean.getMobilePhone() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getMobilePhone()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getMobilePhone() + "%]");
                        if ( bean.getMobilePhone()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getMobilePhone() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getMobilePhone() + "]");
                        if ( bean.getMobilePhone() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getMobilePhone()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getMobilePhone() + "%]");
                        if (bean.getMobilePhone()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getMobilePhone() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkPapersTypeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getPapersType() + "]");
                if (bean.getPapersType() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TINYINT);} } else { Manager.setInteger(ps, ++dirtyCount, bean.getPapersType()); }
            }
            if (bean.checkPapersNumModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getPapersNum() + "]");
                        if (bean.getPapersNum() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getPapersNum()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getPapersNum() + "%]");
                        if ( bean.getPapersNum()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getPapersNum() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getPapersNum() + "]");
                        if ( bean.getPapersNum() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getPapersNum()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getPapersNum() + "%]");
                        if (bean.getPapersNum()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getPapersNum() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkImageMd5Modified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getImageMd5() + "]");
                        if (bean.getImageMd5() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getImageMd5()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getImageMd5() + "%]");
                        if ( bean.getImageMd5()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getImageMd5() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getImageMd5() + "]");
                        if ( bean.getImageMd5() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getImageMd5()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getImageMd5() + "%]");
                        if (bean.getImageMd5()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.CHAR);} } else { ps.setString(++dirtyCount, bean.getImageMd5() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkExpiryDateModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getExpiryDate() + "]");
                if (bean.getExpiryDate() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.DATE);} } else { ps.setDate(++dirtyCount, new java.sql.Date(bean.getExpiryDate().getTime())); }
            }
            if (bean.checkRemarkModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "]");
                        if (bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "%]");
                        if ( bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getRemark() + "]");
                        if ( bean.getRemark() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getRemark()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getRemark() + "%]");
                        if (bean.getRemark()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.VARCHAR);} } else { ps.setString(++dirtyCount, bean.getRemark() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkExtBinModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtBin() + "]");
                if (bean.getExtBin() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARBINARY);} } else { Manager.setBytes(Types.LONGVARBINARY,ps, ++dirtyCount, bean.getExtBin()); }
            }
            if (bean.checkExtTxtModified()) {
                switch (searchType) {
                    case SEARCH_EXACT:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "]");
                        if (bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt()); }
                        break;
                    case SEARCH_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "%]");
                        if ( bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    case SEARCH_STARTING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [%" + bean.getExtTxt() + "]");
                        if ( bean.getExtTxt() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, SQL_LIKE_WILDCARD + bean.getExtTxt()); }
                        break;
                    case SEARCH_ENDING_LIKE:
                        // System.out.println("Setting for " + dirtyCount + " [" + bean.getExtTxt() + "%]");
                        if (bean.getExtTxt()  == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.LONGVARCHAR);} } else { ps.setString(++dirtyCount, bean.getExtTxt() + SQL_LIKE_WILDCARD); }
                        break;
                    default:
                        throw new DaoException("Unknown search type " + searchType);
                }
            }
            if (bean.checkCreateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getCreateTime() + "]");
                if (bean.getCreateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getCreateTime().getTime())); }
            }
            if (bean.checkUpdateTimeModified()) {
                // System.out.println("Setting for " + dirtyCount + " [" + bean.getUpdateTime() + "]");
                if (bean.getUpdateTime() == null) {if(fillNull){ ps.setNull(++dirtyCount, Types.TIMESTAMP);} } else { ps.setTimestamp(++dirtyCount, new java.sql.Timestamp(bean.getUpdateTime().getTime())); }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        return dirtyCount;
    }


    //_____________________________________________________________________
    //
    // DECODE RESULT SET
    //_____________________________________________________________________

    //28
    /**
     * decode a resultset in an array of FlPersonBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlPersonBean table
     * @throws DaoException
     */
    public FlPersonBean[] decodeResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return this.decodeResultSetAsList(rs, fieldList, startRow, numRows).toArray(new FlPersonBean[0]);
    }

    //28-1
    /**
     * decode a resultset in a list of FlPersonBean objects
     *
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @return the resulting FlPersonBean table
     * @throws DaoException
     */
    public List<FlPersonBean> decodeResultSetAsList(ResultSet rs, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        actionOnResultSet(rs, fieldList, numRows, numRows, action);
        return action.getList();
    }
    //28-2
    /** decode a resultset and call action
     * @param rs the resultset to decode
     * @param fieldList table of the field's associated constants
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param action interface obj for do something
     * @return the count dealt by action  
     * @throws DaoException
     * @throws IllegalArgumentException
     */
    public int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, Action<FlPersonBean> action) throws DaoException{
        try{
            int count = 0;
            if(0!=numRows){
                if( startRow<1 ){
                    throw new IllegalArgumentException("invalid argument:startRow (must >=1)");
                }
                if( null==action || null==rs ){
                    throw new IllegalArgumentException("invalid argument:action OR rs (must not be null)");
                }
                for(;startRow > 1 && rs.next();){
                    --startRow;
                    //skip to last of startRow
                }
                if (fieldList == null) {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, action.getBean()));
                        }
                    }
                }else {
                    if(numRows<0){
                        for(;rs.next();++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }else{
                        for(;rs.next() && count<numRows;++count){
                            action.call(decodeRow(rs, fieldList,action.getBean()));
                        }
                    }
                }
            }
            return count;
        }catch(DaoException e){
            throw e;
        }catch(SQLException e){
            throw new DataAccessException(e);
        }
    }

    //29
    /**
     * Transforms a ResultSet iterating on the fl_person on a FlPersonBean bean.
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlPersonBean bean
     * @throws DaoException
     */
    public FlPersonBean decodeRow(ResultSet rs,FlPersonBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        try
        {
            bean.setId(Manager.getInteger(rs, 1));
            bean.setGroupId(Manager.getInteger(rs, 2));
            bean.setName(rs.getString(3));
            bean.setSex(Manager.getInteger(rs, 4));
            bean.setRank(Manager.getInteger(rs, 5));
            bean.setPassword(rs.getString(6));
            bean.setBirthdate(rs.getDate(7));
            bean.setMobilePhone(rs.getString(8));
            bean.setPapersType(Manager.getInteger(rs, 9));
            bean.setPapersNum(rs.getString(10));
            bean.setImageMd5(rs.getString(11));
            bean.setExpiryDate(rs.getDate(12));
            bean.setRemark(rs.getString(13));
            bean.setExtBin(Manager.getBytes(rs, 14));
            bean.setExtTxt(rs.getString(15));
            bean.setCreateTime(rs.getTimestamp(16));
            bean.setUpdateTime(rs.getTimestamp(17));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //30
    /**
     * Transforms a ResultSet iterating on the fl_person table on a FlPersonBean bean according to a list of fields.
     *
     * @param rs the ResultSet to be transformed
     * @param fieldList table of the field's associated constants
     * @return bean resulting FlPersonBean bean
     * @throws DaoException
     */
    public FlPersonBean decodeRow(ResultSet rs, int[] fieldList,FlPersonBean bean) throws DaoException
    {
        if(null==bean){
            bean = this.createBean();
        }
        int pos = 0;
        try
        {
            for(int i = 0; i < fieldList.length; i++)
            {
                switch(fieldList[i])
                {
                    case FL_PERSON_ID_ID:
                        ++pos;
                        bean.setId(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_ID_GROUP_ID:
                        ++pos;
                        bean.setGroupId(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_ID_NAME:
                        ++pos;
                        bean.setName(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_SEX:
                        ++pos;
                        bean.setSex(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_ID_RANK:
                        ++pos;
                        bean.setRank(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_ID_PASSWORD:
                        ++pos;
                        bean.setPassword(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_BIRTHDATE:
                        ++pos;
                        bean.setBirthdate(rs.getDate(pos));
                        break;
                    case FL_PERSON_ID_MOBILE_PHONE:
                        ++pos;
                        bean.setMobilePhone(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_PAPERS_TYPE:
                        ++pos;
                        bean.setPapersType(Manager.getInteger(rs, pos));
                        break;
                    case FL_PERSON_ID_PAPERS_NUM:
                        ++pos;
                        bean.setPapersNum(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_IMAGE_MD5:
                        ++pos;
                        bean.setImageMd5(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_EXPIRY_DATE:
                        ++pos;
                        bean.setExpiryDate(rs.getDate(pos));
                        break;
                    case FL_PERSON_ID_REMARK:
                        ++pos;
                        bean.setRemark(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_EXT_BIN:
                        ++pos;
                        bean.setExtBin(Manager.getBytes(rs, pos));
                        break;
                    case FL_PERSON_ID_EXT_TXT:
                        ++pos;
                        bean.setExtTxt(rs.getString(pos));
                        break;
                    case FL_PERSON_ID_CREATE_TIME:
                        ++pos;
                        bean.setCreateTime(rs.getTimestamp(pos));
                        break;
                    case FL_PERSON_ID_UPDATE_TIME:
                        ++pos;
                        bean.setUpdateTime(rs.getTimestamp(pos));
                        break;
                    default:
                        throw new DaoException("Unknown field id " + fieldList[i]);
                }
            }
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //31
    /**
     * Transforms a ResultSet iterating on the fl_person on a FlPersonBean bean using the names of the columns
     *
     * @param rs the ResultSet to be transformed
     * @return bean resulting FlPersonBean bean
     * @throws DaoException
     */
    public FlPersonBean metaDataDecodeRow(ResultSet rs) throws DaoException
    {
        FlPersonBean bean = this.createBean();
        try
        {
            bean.setId(Manager.getInteger(rs, "id"));
            bean.setGroupId(Manager.getInteger(rs, "group_id"));
            bean.setName(rs.getString("name"));
            bean.setSex(Manager.getInteger(rs, "sex"));
            bean.setRank(Manager.getInteger(rs, "rank"));
            bean.setPassword(rs.getString("password"));
            bean.setBirthdate(rs.getDate("birthdate"));
            bean.setMobilePhone(rs.getString("mobile_phone"));
            bean.setPapersType(Manager.getInteger(rs, "papers_type"));
            bean.setPapersNum(rs.getString("papers_num"));
            bean.setImageMd5(rs.getString("image_md5"));
            bean.setExpiryDate(rs.getDate("expiry_date"));
            bean.setRemark(rs.getString("remark"));
            bean.setExtBin(Manager.getBytes(rs, "ext_bin"));
            bean.setExtTxt(rs.getString("ext_txt"));
            bean.setCreateTime(rs.getTimestamp("create_time"));
            bean.setUpdateTime(rs.getTimestamp("update_time"));
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }

        bean.isNew(false);
        bean.resetIsModified();

        return bean;
    }

    //////////////////////////////////////
    // PREPARED STATEMENT LOADER
    //////////////////////////////////////

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public FlPersonBean[] loadByPreparedStatement(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatement(ps, null);
    }

    //32
    /**
     * Loads all the elements using a prepared statement.
     *
     * @param ps the PreparedStatement to be used
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public List<FlPersonBean> loadByPreparedStatementAsList(PreparedStatement ps) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, null);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public FlPersonBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList) throws DaoException
    {
        return this.loadByPreparedStatementAsList(ps, fieldList).toArray(new FlPersonBean[0]);
    }

    //33
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved.
     *
     * @param ps the PreparedStatement to be used
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public List<FlPersonBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList) throws DaoException
    { 
        return loadByPreparedStatementAsList(ps,fieldList,1,-1);
    }

    //34
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public FlPersonBean[] loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        return loadByPreparedStatementAsList(ps,fieldList,startRow,numRows).toArray(new FlPersonBean[0]);
    }

    //34-1
    /**
     * Loads all the elements using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @return an array of FlPersonBean
     * @throws DaoException
     */
    public List<FlPersonBean> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException
    {
        ListAction action = new ListAction();
        loadByPreparedStatement(ps,fieldList,startRow,numRows,action);
        return action.getList();
    }
    //34-2
    /**
     * Loads each element using a prepared statement specifying a list of fields to be retrieved,
     * and specifying the start row and the number of rows 
     * and dealt by action.
     *
     * @param ps the PreparedStatement to be used
     * @param startRow the start row to be used (first row = 1, last row = -1)
     * @param numRows the number of rows to be retrieved (all rows = a negative number)
     * @param fieldList table of the field's associated constants
     * @param action Action object for do something(not null)
     * @return the count dealt by action
     * @throws DaoException
     */     
    public int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows,Action<FlPersonBean> action) throws DaoException
    {
        ResultSet rs =  null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            return this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(rs);
        }
    }
    //_____________________________________________________________________
    //
    // LISTENER
    //_____________________________________________________________________

    private final TableListener.ListenerContainer<FlPersonBean> listenerContainer = new TableListener.ListenerContainer<FlPersonBean>();

    //35

    @Override
    public TableListener<FlPersonBean> registerListener(TableListener<FlPersonBean> listener)
    {
        this.listenerContainer.add(listener);
        return listener;
    }

    //36
    /**
     * remove listener.
     */
    @Override
    public void unregisterListener(TableListener<FlPersonBean> listener)
    {
        this.listenerContainer.remove(listener);
    }

    //37

    @Override
    public void fire(TableListener.Event event, FlPersonBean bean) throws DaoException{
        if(null == event){
            throw new NullPointerException();
        }
        event.fire(listenerContainer, bean);
    }
    
    //37-1

    @Override
    public void fire(int event, FlPersonBean bean) throws DaoException{
        try{
            fire(TableListener.Event.values()[event],bean);
        }catch(ArrayIndexOutOfBoundsException e){
            throw new IllegalArgumentException("invalid event id " + event);
        }
    }

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonGroupBean,FlPersonBean> foreignKeyListenerByGroupId = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlPersonGroupBean,FlPersonBean>(){
                @Override
                protected List<FlPersonBean> getImportedBeans(FlPersonGroupBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlPersonBean>emptyList()
                            : instanceOfFlPersonGroupManager().getPersonBeansByGroupIdAsList(bean);
                }
                @Override
                protected void onRemove(List<FlPersonBean> effectBeans) throws DaoException {
                    for(FlPersonBean bean:effectBeans){
                        bean.setGroupId(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    /** foreign key listener for DEELTE RULE : SET_NULL */
    private final net.gdface.facelog.dborm.BaseForeignKeyListener<FlImageBean,FlPersonBean> foreignKeyListenerByImageMd5 = 
            new net.gdface.facelog.dborm.BaseForeignKeyListener<FlImageBean,FlPersonBean>(){
                @Override
                protected List<FlPersonBean> getImportedBeans(FlImageBean bean) throws DaoException {
                    return listenerContainer.isEmpty() 
                            ? java.util.Collections.<FlPersonBean>emptyList()
                            : instanceOfFlImageManager().getPersonBeansByImageMd5AsList(bean);
                }
                @Override
                protected void onRemove(List<FlPersonBean> effectBeans) throws DaoException {
                    for(FlPersonBean bean:effectBeans){
                        bean.setImageMd5(null);
                        Event.UPDATE.fire(listenerContainer, bean);
                        bean.resetIsModified();
                    }
                }};

    //37-2
    /**
     * bind foreign key listener to foreign table: <br>
     * DELETE RULE : SET_NULL {@code fl_person(group_id)- fl_person_group(id)} <br>
     * DELETE RULE : SET_NULL {@code fl_person(image_md5)- fl_image(md5)} <br>
     */
    public void bindForeignKeyListenerForDeleteRule(){
        instanceOfFlPersonGroupManager().registerListener(foreignKeyListenerByGroupId);
        instanceOfFlImageManager().registerListener(foreignKeyListenerByImageMd5);
        
    }
    //37-3
    /**
     * unbind foreign key listener from all of foreign tables <br>
     * @see #bindForeignKeyListenerForDeleteRule()
     */
    public void unbindForeignKeyListenerForDeleteRule(){
        instanceOfFlPersonGroupManager().unregisterListener(foreignKeyListenerByGroupId);
        instanceOfFlImageManager().unregisterListener(foreignKeyListenerByImageMd5);
        
    }
    //_____________________________________________________________________
    //
    // UTILS
    //_____________________________________________________________________

    //40
    /**
     * Retrieves the manager object used to get connections.
     *
     * @return the manager used
     */
    private Manager getManager()
    {
        return Manager.getInstance();
    }

    //41
    /**
     * Frees the connection.
     *
     * @param c the connection to release
     */
    private void freeConnection(Connection c)
    {
        // back to pool
        this.getManager().releaseConnection(c);
    }

    //42
    /**
     * Gets the connection.
     */
    private Connection getConnection() throws DaoException
    {
        try
        {
            return this.getManager().getConnection();
        }
        catch(SQLException e)
        {
            throw new DataAccessException(e);
        }
    }

    //43

    @Override
    public boolean isPrimaryKey(String column){
        for(String c:PRIMARYKEY_NAMES){
            if(c.equalsIgnoreCase(column)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Fill the given prepared statement with the values in argList
     * @param ps the PreparedStatement that will be filled
     * @param argList the arguments to use fill given prepared statement
     * @throws DaoException
     */
    private void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws DaoException{
        try {
            if (!(argList == null || ps == null)) {
                for (int i = 0; i < argList.length; i++) {
                    if (argList[i].getClass().equals(byte[].class)) {
                        ps.setBytes(i + 1, (byte[]) argList[i]);
                    } else {
                        ps.setObject(i + 1, argList[i]);
                    }
                }
            }
        } catch (SQLException e) {
            throw new DaoException(e);
        }
    }
    
    @Override    

    public int loadBySqlForAction(String sql, Object[] argList, int[] fieldList,int startRow, int numRows,Action<FlPersonBean> action) throws DaoException{
        PreparedStatement ps = null;
        Connection connection = null;
        // logger.debug("sql string:\n" + sql + "\n");
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql,
                    ResultSet.TYPE_FORWARD_ONLY,
                    ResultSet.CONCUR_READ_ONLY);
            fillPrepareStatement(ps, argList);
            return this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        } catch (DaoException e) {
            throw e;
        }catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            this.getManager().close(ps);
            this.freeConnection(connection);
        }
    }
   
    @Override

    public <T>T runAsTransaction(Callable<T> fun) throws DaoException{
        return Manager.getInstance().runAsTransaction(fun);
    }
    
    class DeleteBeanAction extends Action.BaseAdapter<FlPersonBean>{
        private final AtomicInteger count=new AtomicInteger(0);
        @Override
        public void call(FlPersonBean bean) throws DaoException {
                FlPersonManager.this.delete(bean);
                count.incrementAndGet();
        }
        int getCount(){
            return count.get();
        }
    }
    //45
    /**
     * return a primary key list from {@link FlPersonBean} array
     * @param array
     */
    public List<Integer> toPrimaryKeyList(FlPersonBean... array){        
        if(null == array){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(array.length);
        for(FlPersonBean bean:array){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
    //46
    /**
     * return a primary key list from {@link FlPersonBean} collection
     * @param collection
     */
    public List<Integer> toPrimaryKeyList(java.util.Collection<FlPersonBean> collection){        
        if(null == collection){
            return new java.util.ArrayList<Integer>();
        }
        java.util.ArrayList<Integer> list = new java.util.ArrayList<Integer>(collection.size());
        for(FlPersonBean bean:collection){
            list.add(null == bean ? null : bean.getId());
        }
        return list;
    }
}
