/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import net.gdface.license.RegStatus;
import net.gdface.license.RegisterException;

public class FSRegister {
    public static final String LICENSE_SERVER_HOST = "www.gdface.online";
    public static final int LICENSE_SERVER_PORT = 18080;
    private Socket socket;
    private OutputStream os;
    private InputStream is;

    private FSRegister() {
    }

    boolean connect(String host, int port) throws IOException {
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("host is null");
        }
        this.socket = new Socket(host, port);
        this.os = this.socket.getOutputStream();
        this.is = this.socket.getInputStream();
        byte[] responseData = new byte[128];
        int count = this.is.read(responseData);
        if (count > 0) {
            String connectreturnstr = new String(responseData, 0, count);
            return connectreturnstr.equals("Connect Success!");
        }
        return false;
    }

    int register(String serial, int[] result, String[] authorization) throws IOException {
        if (this.socket == null) {
            throw new IllegalArgumentException("socket must not be null,must call registerConnect firstly");
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        msg.write("gdface".getBytes());
        long packlength = serial.length() + 26;
        msg.write(String.format("%010d31", packlength).getBytes());
        msg.write(String.format("%08d", serial.length()).getBytes());
        msg.write(serial.getBytes());
        this.os.write(msg.toByteArray());
        this.os.flush();
        byte[] responseData = new byte[1024];
        int count = this.is.read(responseData);
        if (count < 0) {
            return 1;
        }
        if (count < 19) {
            return 2;
        }
        result[0] = responseData[18] - 48;
        if (result[0] == 0) {
            authorization[0] = new String(responseData, 27, count - 27);
            return 0;
        }
        return 3;
    }

    void close() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String onlineAuthorization(String licenseKey, String encryptionSerial, String host, int port) throws RegisterException {
        try (FSRegister register = new FSRegister();){
            InetAddress ia2 = InetAddress.getByName(host);
            if (!register.connect(ia2.getHostAddress(), port)) throw new RegisterException(RegStatus.REG_BLACKLIST);
            int[] result = new int[1];
            String[] authorization = new String[1];
            int retval = register.register(encryptionSerial, result, authorization);
            if (retval == 1 || retval == 2) {
                throw new RegisterException(RegStatus.REG_DATA_ERR);
            }
            if (retval == 3) {
                if (result[0] != 3) throw new RegisterException(RegStatus.REG_INVALID_SERIAL);
                throw new RegisterException(RegStatus.REG_REACH_UPLIMIT);
            }
            if (retval == 0) {
                String string = authorization[0];
                return string;
            }
            try {
                throw new RegisterException(RegStatus.REG_UNKNOW_ERROR);
            }
            catch (Exception e) {
                throw new RegisterException(e);
            }
        }
    }

    public static String onlineAuthorization(String licenseKey, String encryptionSerial) throws RegisterException {
        return FSRegister.onlineAuthorization(licenseKey, encryptionSerial, LICENSE_SERVER_HOST, 18080);
    }
}

