/*
 * Decompiled with CFR 0.152.
 */
package gu.doc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class ExtClassDoc {
    public static final String NEW_LINE = System.getProperty("line.separator");
    final ClassDoc classDoc;
    private static String indent = "    ";
    private final Map<String, Integer> excludeTags = Collections.synchronizedMap(new HashMap());
    private final HashBasedTable<String, AddColumn, Object> additionalTextTable = HashBasedTable.create();
    private static final String commentBody = "/**" + NEW_LINE + " */" + NEW_LINE;

    public ExtClassDoc(ClassDoc classDoc) {
        this.classDoc = (ClassDoc)Preconditions.checkNotNull((Object)classDoc, (Object)"classDoc is null");
    }

    private static int match(Method method, MethodDoc doc) {
        String[] signature;
        if (!method.getName().equals(doc.name())) {
            return -1;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        String s1 = doc.signature().replaceAll("\\((.*)\\)", "$1");
        String[] stringArray = signature = s1.isEmpty() ? new String[]{} : s1.replace(" ", "").split(",");
        if (paramTypes.length != signature.length) {
            return -1;
        }
        int score = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].getName().equals(signature[i])) {
                score += 2;
                continue;
            }
            if (paramTypes[i].getSimpleName().equals(signature[i])) {
                ++score;
                continue;
            }
            score = -1;
            break;
        }
        return score;
    }

    public MethodDoc getMethodDoc(Method method) {
        int index = this.indexOf(method);
        return index < 0 ? null : this.classDoc.methods()[index];
    }

    public FieldDoc getFieldDoc(String name) {
        for (FieldDoc field : this.classDoc.fields()) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public ParamTag paramTagOf(MethodDoc methodDoc, String name) {
        try {
            if (!Strings.isNullOrEmpty((String)name)) {
                for (Tag tag : methodDoc.tags("@param")) {
                    ParamTag paramTag = (ParamTag)tag;
                    if (!name.equals(paramTag.parameterName())) continue;
                    return paramTag;
                }
            }
            return null;
        }
        catch (AssertionError e) {
            return null;
        }
    }

    public int indexOf(Method method) {
        if (null == method) {
            return -1;
        }
        TreeMap<Integer, Integer> matched = new TreeMap<Integer, Integer>();
        MethodDoc[] methodDocs = this.classDoc.methods();
        for (int i = 0; i < methodDocs.length; ++i) {
            MethodDoc m = methodDocs[i];
            int score = ExtClassDoc.match(method, m);
            if (score < 0) continue;
            matched.put(score, i);
        }
        return matched.isEmpty() ? -1 : (Integer)matched.lastEntry().getValue();
    }

    public List<Method> sortByDefined(List<Method> methods) {
        if (null != methods) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method arg0, Method arg1) {
                    return ExtClassDoc.this.indexOf(arg0) - ExtClassDoc.this.indexOf(arg1);
                }
            });
        }
        return methods;
    }

    public Map<Method, Integer> indexOf(List<Method> methods) {
        if (null != methods) {
            return Maps.asMap((Set)Sets.newHashSet(methods), (Function)new Function<Method, Integer>(){

                public Integer apply(Method input) {
                    return ExtClassDoc.this.indexOf(input);
                }
            });
        }
        return ImmutableMap.of();
    }

    public void output(PrintStream out) {
        out.println(this.formatComment((Doc)this.classDoc, false));
        out.println(this.classDoc);
        for (MethodDoc method : this.classDoc.methods()) {
            out.println(this.formatComment((Doc)method, true));
            out.printf("%s%s\n", indent, method.toString());
        }
    }

    public String output() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.output(new PrintStream(out));
        return out.toString();
    }

    private static final Type typeOfDoc(Object doc) {
        if (doc instanceof ClassDoc) {
            return Type.CLASS;
        }
        if (doc instanceof MethodDoc) {
            return Type.METHOD;
        }
        if (doc instanceof FieldDoc) {
            return Type.FIELD;
        }
        throw new UnsupportedOperationException();
    }

    private Set<String> select(final Type type, final Action action) {
        return Maps.filterValues((Map)this.additionalTextTable.rowMap(), (Predicate)new Predicate<Map<AddColumn, Object>>(){

            public boolean apply(Map<AddColumn, Object> input) {
                return input.get((Object)AddColumn.ACTION) == action && type.check((Integer)input.get((Object)AddColumn.SCOPE));
            }
        }).keySet();
    }

    private final String commentText(StringBuffer buffer, String originText, Type type) {
        Set<String> addText = this.select(type, Action.ADD);
        Set<String> overwriteText = this.select(type, Action.OVERWRITE);
        Set<String> appendText = this.select(type, Action.APPEND);
        for (String text : addText) {
            buffer.append(text).append(NEW_LINE);
        }
        for (String text : overwriteText) {
            buffer.append(text).append(NEW_LINE);
        }
        if (overwriteText.isEmpty() && !originText.isEmpty()) {
            buffer.append(originText).append(NEW_LINE);
        }
        for (String text : appendText) {
            buffer.append(text).append(NEW_LINE);
        }
        return buffer.toString();
    }

    private final String formatComment0(Doc doc, boolean needIndent, boolean withBody) {
        Preconditions.checkNotNull((Object)doc, (Object)"doc is null");
        Type type = ExtClassDoc.typeOfDoc(doc);
        StringBuffer buffer = new StringBuffer();
        this.commentText(buffer, doc.commentText(), type);
        for (Tag tag : doc.tags()) {
            if (type.check(this.excludeTags.get(tag.name()))) continue;
            buffer.append(tag.name()).append(" ").append(tag.text()).append(NEW_LINE);
        }
        String cmt = buffer.toString();
        if (!cmt.isEmpty()) {
            cmt = Pattern.compile("(\r\n|\n|\r)\\s*", 8).matcher(cmt).replaceAll(NEW_LINE);
            if (withBody) {
                cmt = Pattern.compile("^", 8).matcher(cmt).replaceAll(" * ");
                cmt = commentBody.replaceFirst(NEW_LINE, "$0" + cmt);
            }
            if (needIndent) {
                cmt = Pattern.compile("^", 8).matcher(cmt).replaceAll(indent);
            }
        }
        return cmt;
    }

    public final String formatComment(Doc doc, boolean needIndent) {
        return this.formatComment0(doc, needIndent, true);
    }

    public final List<String> formatCommentAsList(Doc doc, boolean needIndent) {
        Object[] cmt = this.formatComment0(doc, needIndent, false).split(NEW_LINE);
        return Lists.newArrayList((Object[])cmt);
    }

    public String getClassComment() {
        return this.formatComment((Doc)this.classDoc, false);
    }

    public String getMethodComment(Method method) {
        MethodDoc doc = this.getMethodDoc(method);
        return null == doc ? null : this.formatComment((Doc)doc, true);
    }

    public String getFieldComment(String name) {
        FieldDoc doc = this.getFieldDoc(name);
        return null == doc ? null : this.formatComment((Doc)doc, true);
    }

    public List<String> getClassCommentAsList() {
        return this.formatCommentAsList((Doc)this.classDoc, false);
    }

    public List<String> getMethodCommentAsList(Method method) {
        MethodDoc doc = this.getMethodDoc(method);
        return null == doc ? null : this.formatCommentAsList((Doc)doc, true);
    }

    public List<String> getFieldCommentAsList(String name) {
        FieldDoc doc = this.getFieldDoc(name);
        return null == doc ? null : this.formatCommentAsList((Doc)doc, true);
    }

    public static String getIndent() {
        return indent;
    }

    public static void setIndent(String indent) {
        if (null != indent) {
            ExtClassDoc.indent = indent;
        }
    }

    public synchronized void setExcludeTags(Map<String, Integer> excludeTags) {
        if (null != excludeTags) {
            excludeTags.clear();
            excludeTags.putAll(excludeTags);
        }
    }

    public void addExcludeTag(String excludeTag, Integer scope) {
        if (!Strings.isNullOrEmpty((String)excludeTag)) {
            this.excludeTags.put(excludeTag, null == scope ? Type.ALL.mask : scope);
        }
    }

    public void removeExcludeTag(String excludeTag) {
        this.excludeTags.remove(excludeTag);
    }

    public void addExcludeTag(String excludeTag, Type type) {
        this.addExcludeTag(excludeTag, (null == type ? Type.ALL : type).mask);
    }

    public void addExcludeTag(String excludeTag, Collection<Type> type) {
        this.addExcludeTag(excludeTag, Type.sum(type));
    }

    public void addExcludeTag(String excludeTag, String type) {
        this.addExcludeTag(excludeTag, Strings.isNullOrEmpty((String)type) ? Type.ALL : Type.valueOf(type));
    }

    public void addExcludeTagString(String excludeTag, Collection<String> type) {
        if (null == type || type.isEmpty()) {
            this.addExcludeTag(excludeTag, Type.ALL);
        }
        this.addExcludeTag(excludeTag, Type.sumOfString(type));
    }

    public void addExcludeTag(String excludeTag) {
        this.addExcludeTag(excludeTag, Type.ALL);
    }

    public void addExcludeTags(Map<String, Integer> excludeTag) {
        if (null != excludeTag) {
            this.excludeTags.putAll(excludeTag);
        }
    }

    public void additionalText(String text, Action action, Integer scope) {
        if (!Strings.isNullOrEmpty((String)text)) {
            this.additionalTextTable.put((Object)text, (Object)AddColumn.ACTION, (Object)action);
            this.additionalTextTable.put((Object)text, (Object)AddColumn.SCOPE, (Object)scope);
        }
    }

    public void additionalText(String text, Action action, Type ... type) {
        this.additionalText(text, action, null == type ? Type.ALL.mask : Type.sum(type));
    }

    public void additionalText(String text, String action, String type) {
        this.additionalText(text, Strings.isNullOrEmpty((String)action) ? Action.ADD : Action.valueOf(action), null == type ? Type.ALL : Type.valueOf(type));
    }

    public void additionalText(String text, Action action, Collection<Type> type) {
        this.additionalText(text, action, null == type ? Type.ALL.mask : Type.sum(type));
    }

    public void additionalText(String text, String action, Collection<String> type) {
        this.additionalText(text, Strings.isNullOrEmpty((String)action) ? Action.ADD : Action.valueOf(action), null == type ? Type.ALL.mask : Type.sumOfString(type));
    }

    public ClassDoc getClassDoc() {
        return this.classDoc;
    }

    public static enum AddColumn {
        ACTION,
        SCOPE;

    }

    public static enum Action {
        ADD,
        OVERWRITE,
        APPEND;

    }

    static enum Type {
        CLASS,
        METHOD,
        FIELD,
        NONE(0),
        ALL(-1);

        private final int mask;

        private Type() {
            this.mask = 1 << this.ordinal();
        }

        private Type(int mask) {
            Preconditions.checkArgument((1 != Integer.bitCount(mask) ? 1 : 0) != 0, (Object)"bit count of mask must be not be 1");
            this.mask = mask;
        }

        public boolean check(Integer v) {
            return null == v ? false : this.mask == (this.mask & v);
        }

        public boolean check(Type v) {
            return null == v ? false : this.check(v.mask);
        }

        public int or(int v) {
            return this.mask | v;
        }

        public int reset(int v) {
            return ~this.mask & v;
        }

        public static int sum(Type ... values) {
            if (null == values) {
                return 0;
            }
            int m = 0;
            for (Type v : values) {
                if (null == v) continue;
                m |= v.mask;
            }
            return m;
        }

        public static int sum(Collection<Type> values) {
            return null == values ? 0 : Type.sum(Collections2.filter(values, (Predicate)new Predicate<Type>(){

                public boolean apply(Type input) {
                    return null != input;
                }
            }).toArray(new Type[0]));
        }

        public static int sumOfString(Collection<String> values) {
            return null == values ? 0 : Type.sum(Collections2.transform(values, (Function)new Function<String, Type>(){

                public Type apply(String input) {
                    try {
                        return Type.valueOf(input);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            }));
        }

        public static List<Type> checkAll(int value) {
            ArrayList<Type> list = new ArrayList<Type>();
            for (Type v : Type.values()) {
                if (!v.check(value) || Integer.bitCount(v.mask) != 1) continue;
                list.add(v);
            }
            return list;
        }

        static {
            int mask = 0;
            for (Type v : Type.values()) {
                if (1 != Integer.bitCount(v.mask)) continue;
                mask |= v.mask;
            }
            try {
                Field field = Type.class.getDeclaredField("mask");
                field.setAccessible(true);
                field.set((Object)ALL, mask);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
            for (Type v : Type.values()) {
                if (Integer.bitCount(v.mask) <= 1 || v == ALL || (~Type.ALL.mask & v.mask) == 0) continue;
                throw new ExceptionInInitializerError(String.format("%s: %s,invalid mask, out of ALL scope", v.name(), Integer.toBinaryString(v.mask)));
            }
        }
    }
}

