/*
 * Decompiled with CFR 0.152.
 */
package gu.doc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import gu.doc.ExtClassDoc;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class JavadocReader {
    private static RootDoc root = null;
    private static String sourcepath;
    private static String[] sourcepathList;
    private static String classpath;

    public static void show() {
        if (null == root) {
            return;
        }
        ClassDoc[] classes = root.classes();
        for (int i = 0; i < classes.length; ++i) {
            new ExtClassDoc(classes[i]).output(System.out);
        }
    }

    public static synchronized RootDoc readDocs(String source, String classpath, String sourcepath) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)source) ? 1 : 0) != 0, (Object)"source is null");
        ArrayList args = Lists.newArrayList((Object[])new String[]{"-doclet", Doclet.class.getName(), "-quiet", "-Xmaxerrs", "1", "-Xmaxwarns", "1", "-encoding", "utf-8"});
        if (!Strings.isNullOrEmpty((String)classpath)) {
            args.add("-classpath");
            args.add(classpath);
        }
        if (!Strings.isNullOrEmpty((String)sourcepath)) {
            args.add("-sourcepath");
            args.add(sourcepath);
        }
        args.add(source);
        int returnCode = Main.execute((ClassLoader)JavadocReader.class.getClassLoader(), (String[])args.toArray(new String[args.size()]));
        if (0 != returnCode) {
            System.out.printf("javadoc ERROR CODE = %d\n", returnCode);
            throw new IllegalStateException();
        }
        return root;
    }

    public static synchronized ExtClassDoc read(String source, String classpath, String sourcepath) {
        try {
            return new ExtClassDoc(JavadocReader.readDocs(source, classpath, sourcepath).classes()[0]);
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ExtClassDoc read(String source) {
        return JavadocReader.read(source, classpath);
    }

    public static ExtClassDoc read(String prefix, Class<?> clazz) {
        return JavadocReader.read(JavadocReader.getSourceFile(prefix, clazz), classpath);
    }

    public static ExtClassDoc read(Class<?> clazz) {
        return JavadocReader.read(JavadocReader.getSourceFile(clazz), classpath, null);
    }

    public static ExtClassDoc read(String source, List<String> classpath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join(classpath));
    }

    public static ExtClassDoc read(String source, String[] classpath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join((Object[])classpath));
    }

    public static synchronized ExtClassDoc read(String source, String classpath) {
        return JavadocReader.read(source, classpath, sourcepath);
    }

    public static ExtClassDoc read(String source, List<String> classpath, List<String> sourcepath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join(classpath), null == sourcepath ? null : Joiner.on((String)",").skipNulls().join(sourcepath));
    }

    public static ExtClassDoc read(String source, String[] classpath, String[] sourcepath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join((Object[])classpath), null == sourcepath ? null : Joiner.on((String)",").skipNulls().join((Object[])sourcepath));
    }

    public static String getSourceFile(String prefix, Class<?> clazz) {
        if (null != clazz) {
            String source = clazz.getName().replace('.', File.separatorChar) + ".java";
            return prefix == null ? source : prefix + File.separator + source;
        }
        return null;
    }

    public static String getSourceFile(Class<?> clazz) {
        for (String path : sourcepathList) {
            String source = JavadocReader.getSourceFile(path, clazz);
            if (!new File(source).isFile()) continue;
            return source;
        }
        return JavadocReader.getSourceFile(null, clazz);
    }

    public static String getSourcepath() {
        return sourcepath;
    }

    public static void setSourcepath(String sourcepath) {
        JavadocReader.sourcepath = sourcepath;
        if (!Strings.isNullOrEmpty((String)sourcepath)) {
            sourcepathList = sourcepath.split("\\s*[,;]\\s*");
        }
    }

    public static String getClasspath() {
        return classpath;
    }

    public static void setClasspath(String classpath) {
        JavadocReader.classpath = classpath;
    }

    static {
        sourcepathList = new String[0];
    }

    public static class Doclet {
        public static boolean start(RootDoc root) {
            root = root;
            return true;
        }
    }
}

