/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.l0km.javadocreader;

import com.gitee.l0km.com4j.base2.ClassCommentProvider;
import com.gitee.l0km.javadocreader.ExtClassDoc;
import com.gitee.l0km.javadocreader.JavadocReader;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;

public class ClassCommentProviderImpl
implements ClassCommentProvider {
    private final ExtClassDoc classDoc;
    private final Class<?> clazz;

    public ClassCommentProviderImpl(Class<?> clazz) {
        this.clazz = clazz;
        this.classDoc = JavadocReader.read(clazz);
    }

    public List<String> commentOfClass() {
        if (this.classDoc == null) {
            return ImmutableList.of();
        }
        List<String> cmt = this.classDoc.getClassCommentAsList(false, false);
        return cmt == null ? ImmutableList.of() : ImmutableList.copyOf(cmt);
    }

    public List<String> commentOfMethod(Method method) {
        if (this.classDoc == null) {
            return ImmutableList.of();
        }
        List<String> cmt = this.classDoc.getMethodCommentAsList(method, false, false);
        return cmt == null ? ImmutableList.of() : ImmutableList.copyOf(cmt);
    }

    public List<String> commentOfField(String name) {
        if (this.classDoc == null) {
            return ImmutableList.of();
        }
        List<String> cmt = this.classDoc.getFieldCommentAsList(name, false, false);
        if (cmt == null) {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, this.clazz);
                Method rm = propertyDescriptor.getReadMethod();
                if (rm != null) {
                    return this.commentOfMethod(rm);
                }
                Method wm = propertyDescriptor.getWriteMethod();
                if (wm != null) {
                    return this.commentOfMethod(wm);
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return cmt == null ? ImmutableList.of() : ImmutableList.copyOf(cmt);
    }
}

