/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.l0km.javadocreader;

import com.gitee.l0km.com4j.base.MiscellaneousUtils;
import com.gitee.l0km.com4j.base2.cache.FunctionCached;
import com.gitee.l0km.javadocreader.ExtClassDoc;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavadocReader {
    protected static final Logger logger = LoggerFactory.getLogger(JavadocReader.class);
    private static volatile RootDoc root = null;
    private static String sourcepath;
    private static String[] sourcepathList;
    private static String classpath;
    private static final FunctionCached<String, ExtClassDoc> DOC_CACHED;
    private static final FilenameFilter DIR_FILTER;

    public static void show() {
        if (null == root) {
            return;
        }
        ClassDoc[] classes = root.classes();
        for (int i = 0; i < classes.length; ++i) {
            new ExtClassDoc(classes[i]).output(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RootDoc getRoot() {
        if (null != root) return root;
        Class<JavadocReader> clazz = JavadocReader.class;
        synchronized (JavadocReader.class) {
            if (null != root) return root;
            JavadocReader.readDocs(null, classpath, sourcepath);
            // ** MonitorExit[var0] (shouldn't be in output)
            return root;
        }
    }

    public static void resetRoot() {
        root = null;
    }

    public static synchronized RootDoc readDocs(String source, String classpath, String sourcepath) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{"-doclet", Doclet.class.getName(), "-quiet", "-Xmaxerrs", "1", "-Xmaxwarns", "1", "-encoding", "utf-8", "-private"});
        if (Strings.isNullOrEmpty((String)source) || !source.endsWith(".java")) {
            args.add("-subpackages");
            args.add(JavadocReader.subpackages(sourcepath));
        }
        if (!Strings.isNullOrEmpty((String)classpath)) {
            args.add("-classpath");
            args.add(JavadocReader.normailzePathSeparator(classpath));
        }
        if (!Strings.isNullOrEmpty((String)sourcepath)) {
            args.add("-sourcepath");
            args.add(JavadocReader.normailzePathSeparator(sourcepath));
        }
        if (!Strings.isNullOrEmpty((String)source)) {
            args.add(source);
        }
        logger.debug("Javadoc Options:\n<<<<\n{}\n>>>>", (Object)Joiner.on((String)"\n").join((Iterable)args));
        int returnCode = Main.execute((ClassLoader)JavadocReader.class.getClassLoader(), (String[])args.toArray(new String[args.size()]));
        if (0 != returnCode) {
            logger.warn("javadoc ERROR CODE = {}", (Object)returnCode);
            throw new IllegalStateException();
        }
        return root;
    }

    public static synchronized ExtClassDoc read(String source, String classpath, String sourcepath) {
        try {
            return new ExtClassDoc(JavadocReader.readDocs(source, classpath, sourcepath).classes()[0]);
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ExtClassDoc read(String source) {
        return JavadocReader.read(source, classpath);
    }

    public static ExtClassDoc read(String prefix, Class<?> clazz) {
        return JavadocReader.read(JavadocReader.getSourceFile(prefix, clazz), classpath);
    }

    public static ExtClassDoc readQualifiedName(String qualifiedName) {
        if (null != qualifiedName) {
            try {
                if (JavadocReader.getRoot() == null) {
                    return null;
                }
                ClassDoc classDoc = JavadocReader.getRoot().classNamed(qualifiedName);
                if (null != classDoc) {
                    return new ExtClassDoc(classDoc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static ExtClassDoc read0(Class<?> clazz) {
        try {
            if (JavadocReader.getRoot() == null) {
                return null;
            }
            String qualifiedName = clazz.getName().replace('$', '.');
            return (ExtClassDoc)DOC_CACHED.get((Object)qualifiedName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ExtClassDoc read(Class<?> clazz) {
        return JavadocReader.read0(clazz);
    }

    public static ExtClassDoc read(String source, List<String> classpath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join(classpath));
    }

    public static ExtClassDoc read(String source, String[] classpath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join((Object[])classpath));
    }

    public static synchronized ExtClassDoc read(String source, String classpath) {
        return JavadocReader.read(source, classpath, sourcepath);
    }

    public static ExtClassDoc read(String source, List<String> classpath, List<String> sourcepath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join(classpath), null == sourcepath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join(sourcepath));
    }

    public static ExtClassDoc read(String source, String[] classpath, String[] sourcepath) {
        return JavadocReader.read(source, null == classpath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join((Object[])classpath), null == sourcepath ? null : Joiner.on((String)File.pathSeparator).skipNulls().join((Object[])sourcepath));
    }

    public static String getSourceFile(String prefix, Class<?> clazz) {
        if (null != clazz) {
            Class<?> innerClass = clazz;
            for (Class<?> declaringClass = innerClass.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
                innerClass = declaringClass;
            }
            String source = innerClass.getName().replace('.', File.separatorChar) + ".java";
            return prefix == null ? source : prefix + File.separator + source;
        }
        return null;
    }

    public static String findSourceFileInSourcepathList(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        for (String path : sourcepathList) {
            String source = JavadocReader.getSourceFile(path, clazz);
            if (!new File(source).isFile()) continue;
            return source;
        }
        return null;
    }

    public static boolean existSourceOf(Class<?> clazz) {
        String file = JavadocReader.findSourceFileInSourcepathList(clazz);
        return null != file;
    }

    public static String getSourceFile(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        String found = JavadocReader.findSourceFileInSourcepathList(clazz);
        if (null != found) {
            return found;
        }
        return JavadocReader.getSourceFile(null, clazz);
    }

    public static String getSourcepath() {
        return sourcepath;
    }

    public static void setSourcepath(String sourcepath) {
        JavadocReader.sourcepath = sourcepath;
        sourcepathList = JavadocReader.asPaths(sourcepath).toArray(new String[0]);
    }

    public static String getClasspath() {
        return classpath;
    }

    public static void setClasspath(String classpath) {
        JavadocReader.classpath = classpath;
    }

    private static String normailzePathSeparator(String input) {
        return Joiner.on((String)File.pathSeparator).join(JavadocReader.asPaths(input));
    }

    private static List<String> asPaths(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            List paths = File.pathSeparatorChar == ':' ? MiscellaneousUtils.elementsOf((String)input, (String)";,:") : MiscellaneousUtils.elementsOf((String)input, (String)";,");
            return FluentIterable.from((Iterable)paths).transform((Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.trim();
                }
            }).toList();
        }
        return Collections.emptyList();
    }

    private static String subpackages(String sourcepath) {
        FluentIterable subpackages = FluentIterable.of();
        for (String p : JavadocReader.asPaths(sourcepath)) {
            File path = new File(p);
            if (!path.isDirectory()) continue;
            subpackages = subpackages.append((Object[])path.list(DIR_FILTER));
        }
        return Joiner.on((String)":").join((Iterable)subpackages.copyInto(new TreeSet()));
    }

    static {
        sourcepathList = new String[0];
        DOC_CACHED = FunctionCached.builder().nullable().weakValues().getterFunction((Function)new Function<String, ExtClassDoc>(){

            public ExtClassDoc apply(String input) {
                return JavadocReader.readQualifiedName(input);
            }
        }).build();
        DIR_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        };
    }

    public static class Doclet {
        public static boolean start(RootDoc root) {
            root = root;
            return true;
        }
    }
}

