/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.l0km.javadocreader;

import com.gitee.l0km.com4j.basex.doc.ClassCommentProvider;
import com.gitee.l0km.javadocreader.ExtClassDoc;
import com.gitee.l0km.javadocreader.JavadocReader;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;

public class ClassCommentProviderImpl
implements ClassCommentProvider {
    private final ExtClassDoc classDoc;
    private final Class<?> clazz;

    public ClassCommentProviderImpl(Class<?> clazz) {
        this.clazz = clazz;
        this.classDoc = JavadocReader.read(clazz);
    }

    public List<String> commentOfClass() {
        if (this.classDoc == null) {
            return ImmutableList.of();
        }
        List<String> cmt = this.classDoc.getClassCommentAsList(false, false, true);
        return cmt == null ? ImmutableList.of() : ImmutableList.copyOf(cmt);
    }

    public List<String> commentOfMethod(Method method) {
        return this.commentOfMethod(method, true);
    }

    private List<String> commentOfMethod(Method method, boolean withTags) {
        if (this.classDoc == null) {
            return ImmutableList.of();
        }
        List<String> cmt = this.classDoc.getMethodCommentAsList(method, false, false, withTags);
        return cmt == null ? ImmutableList.of() : ImmutableList.copyOf(cmt);
    }

    public List<String> commentOfField(String name) {
        if (this.classDoc == null) {
            return ImmutableList.of();
        }
        List<String> cmt = this.classDoc.getFieldCommentAsList(name, false, false, false);
        if (cmt == null) {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, this.clazz);
                Method rm = propertyDescriptor.getReadMethod();
                if (rm != null) {
                    return this.commentOfMethod(rm, false);
                }
                Method wm = propertyDescriptor.getWriteMethod();
                if (wm != null) {
                    return this.commentOfMethod(wm, false);
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return cmt == null ? ImmutableList.of() : ImmutableList.copyOf(cmt);
    }
}

