/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.l0km.javadocreader;

import com.gitee.l0km.com4j.basex.TypeNameUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ExtClassDoc {
    public static final String NEW_LINE = System.getProperty("line.separator");
    final ClassDoc classDoc;
    private static String indent = "    ";
    private final Map<String, Integer> excludeTags = Collections.synchronizedMap(new HashMap());
    private final HashBasedTable<String, AddColumn, Object> additionalTextTable = HashBasedTable.create();
    private static final String commentBody = "/**" + NEW_LINE + "cmt */" + NEW_LINE;

    public ExtClassDoc(ClassDoc classDoc) {
        this.classDoc = (ClassDoc)Preconditions.checkNotNull((Object)classDoc, (Object)"classDoc is null");
    }

    private static boolean equalType(com.sun.javadoc.Type docType, java.lang.reflect.Type type) {
        String paramName;
        String typeName = TypeNameUtils.getTypeName((java.lang.reflect.Type)type);
        if (typeName.equals(paramName = docType.qualifiedTypeName() + docType.dimension())) {
            return true;
        }
        return docType.isPrimitive() && docType.qualifiedTypeName().equals(((Class)type).getSimpleName());
    }

    private static boolean match(Member member, MemberDoc doc) {
        Class<?>[] paramTypes;
        if (!member.getName().equals(doc.name())) {
            return false;
        }
        if (member instanceof Field) {
            return true;
        }
        if (member instanceof Method) {
            paramTypes = ((Method)member).getParameterTypes();
        } else if (member instanceof Constructor) {
            paramTypes = ((Constructor)member).getParameterTypes();
        } else {
            throw new IllegalArgumentException(String.format("INVALID member type %s,Method or Constructor required", member.getClass().getSimpleName()));
        }
        if (!(doc instanceof ExecutableMemberDoc)) {
            throw new IllegalArgumentException(String.format("INVALID doc type %s,ExecutableMemberDoc required", doc.getClass().getSimpleName()));
        }
        Parameter[] parameters = ((ExecutableMemberDoc)doc).parameters();
        if (paramTypes.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (ExtClassDoc.equalType(parameters[i].type(), paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    public MethodDoc getMethodDoc(Method method) {
        MethodDoc doc;
        for (doc = (MethodDoc)ExtClassDoc.getMemberDoc(this.classDoc, method); null != doc && Strings.isNullOrEmpty((String)doc.getRawCommentText()); doc = doc.overriddenMethod()) {
        }
        return doc;
    }

    private static MemberDoc getMemberDoc(ClassDoc classDoc, Member member) {
        if (null == classDoc || classDoc.position() == null || null == member) {
            return null;
        }
        MemberDoc matched = ExtClassDoc.findMember(classDoc, member);
        if (matched == null) {
            return ExtClassDoc.getMemberDoc(classDoc.superclass(), member);
        }
        return matched;
    }

    public ExecutableMemberDoc getExecutableMemberDoc(Executable executable) {
        return (ExecutableMemberDoc)ExtClassDoc.getMemberDoc(this.classDoc, executable);
    }

    public ExecutableMemberDoc getExecutableMemberDoc(Member member) {
        return this.getExecutableMemberDoc((Executable)member);
    }

    public MemberDoc getMemberDoc(Member member) {
        return ExtClassDoc.getMemberDoc(this.classDoc, member);
    }

    public String[] getParamerNames(Member member) {
        ExecutableMemberDoc memberDoc = this.getExecutableMemberDoc((Executable)member);
        if (memberDoc == null) {
            return null;
        }
        Parameter[] parameters = memberDoc.parameters();
        String[] names = new String[parameters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = parameters[i].name();
        }
        return names;
    }

    private static FieldDoc getFieldDoc(ClassDoc classDoc, String name) {
        if (null == classDoc || null == name) {
            return null;
        }
        for (FieldDoc field : classDoc.fields()) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return ExtClassDoc.getFieldDoc(classDoc.superclass(), name);
    }

    public FieldDoc getFieldDoc(String name) {
        return ExtClassDoc.getFieldDoc(this.classDoc, name);
    }

    ParamTag paramTagOf(MethodDoc methodDoc, String name) {
        if (null == methodDoc) {
            return null;
        }
        try {
            if (!Strings.isNullOrEmpty((String)name)) {
                boolean typeParameterRequrired = false;
                if (name.startsWith("<") && name.endsWith(">")) {
                    name = name.substring(1, name.length() - 1);
                    typeParameterRequrired = true;
                }
                for (Tag tag : methodDoc.tags("@param")) {
                    ParamTag paramTag = (ParamTag)tag;
                    if (typeParameterRequrired != paramTag.isTypeParameter() || !name.equals(paramTag.parameterName())) continue;
                    return paramTag;
                }
            }
            return null;
        }
        catch (AssertionError e) {
            return null;
        }
    }

    public boolean isDeprecated() {
        return this.isDeprecated((Doc)this.classDoc);
    }

    public boolean isDeprecated(Doc doc) {
        if (null == doc) {
            return false;
        }
        Tag[] tags = doc.tags("@deprecated");
        return null != tags && tags.length > 0;
    }

    private static MemberDoc findMember(ClassDoc classDoc, Member member) {
        FieldDoc[] memberDocs;
        if (null == classDoc || null == member) {
            return null;
        }
        if (!ExtClassDoc.equalType((com.sun.javadoc.Type)classDoc, member.getDeclaringClass())) {
            return null;
        }
        if (member instanceof Field) {
            memberDocs = classDoc.fields();
        } else if (member instanceof Method) {
            memberDocs = classDoc.methods();
        } else if (member instanceof Constructor) {
            memberDocs = classDoc.constructors();
        } else {
            throw new IllegalArgumentException(String.format("INVALID member type %s,Field,Method or Constructor required", member.getClass().getSimpleName()));
        }
        for (int i = 0; i < memberDocs.length; ++i) {
            if (!ExtClassDoc.match(member, (MemberDoc)memberDocs[i])) continue;
            return memberDocs[i];
        }
        return null;
    }

    public void output(PrintStream out) {
        out.println(this.formatComment((Doc)this.classDoc, false));
        out.println(this.classDoc);
        for (MethodDoc method : this.classDoc.methods()) {
            out.println(this.formatComment((Doc)method, true));
            out.printf("%s%s\n", indent, method.toString());
        }
    }

    public String output() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.output(new PrintStream(out));
        return out.toString();
    }

    private static final Type typeOfDoc(Object doc) {
        if (doc instanceof ClassDoc) {
            return Type.CLASS;
        }
        if (doc instanceof MethodDoc) {
            return Type.METHOD;
        }
        if (doc instanceof FieldDoc) {
            return Type.FIELD;
        }
        throw new UnsupportedOperationException();
    }

    private Set<String> select(final Type type, final Action action) {
        return Maps.filterValues((Map)this.additionalTextTable.rowMap(), (Predicate)new Predicate<Map<AddColumn, Object>>(){

            public boolean apply(Map<AddColumn, Object> input) {
                return input.get((Object)AddColumn.ACTION) == action && type.check((Integer)input.get((Object)AddColumn.SCOPE));
            }
        }).keySet();
    }

    private final String commentText(StringBuffer buffer, String originText, Type type) {
        Set<String> addText = this.select(type, Action.ADD);
        Set<String> overwriteText = this.select(type, Action.OVERWRITE);
        Set<String> appendText = this.select(type, Action.APPEND);
        for (String text : addText) {
            buffer.append(text).append(NEW_LINE);
        }
        for (String text : overwriteText) {
            buffer.append(text).append(NEW_LINE);
        }
        if (overwriteText.isEmpty() && !originText.isEmpty()) {
            buffer.append(originText).append(NEW_LINE);
        }
        for (String text : appendText) {
            buffer.append(text).append(NEW_LINE);
        }
        return buffer.toString();
    }

    private final String formatComment0(Doc doc, boolean needIndent, boolean withBody, boolean withLinePrefix, boolean withTags) {
        String cmt;
        Preconditions.checkNotNull((Object)doc, (Object)"doc is null");
        Type type = ExtClassDoc.typeOfDoc(doc);
        StringBuffer buffer = new StringBuffer();
        this.commentText(buffer, doc.commentText(), type);
        if (withTags) {
            for (Tag tag : doc.tags()) {
                if (type.check(this.excludeTags.get(tag.name()))) continue;
                buffer.append(tag.name()).append(" ").append(tag.text()).append(NEW_LINE);
            }
        }
        if (!(cmt = buffer.toString()).isEmpty()) {
            cmt = Pattern.compile("(\r\n|\n|\r)\\s*", 8).matcher(cmt).replaceAll(NEW_LINE);
            if (withBody || withLinePrefix) {
                cmt = Pattern.compile("^", 8).matcher(cmt).replaceAll(" * ");
            }
            if (withBody) {
                cmt = commentBody.replace("cmt", cmt);
            }
            if (needIndent) {
                cmt = Pattern.compile("^", 8).matcher(cmt).replaceAll(indent);
            }
        }
        return cmt;
    }

    public final String formatComment(Doc doc, boolean needIndent) {
        return this.formatComment0(doc, needIndent, true, true, true);
    }

    public final List<String> formatCommentAsList(Doc doc, boolean needIndent, boolean withLinePrefix, boolean withTags) {
        String cmtstr = this.formatComment0(doc, needIndent, false, withLinePrefix, withTags);
        if (cmtstr.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])cmtstr.split(NEW_LINE));
    }

    public String getClassComment(boolean withBody, boolean withLinePrefix, boolean withTags) {
        return this.formatComment0((Doc)this.classDoc, false, withBody, withLinePrefix, withTags);
    }

    public String getMethodComment(Method method, boolean withBody, boolean withLinePrefix, boolean withTags) {
        MethodDoc doc = this.getMethodDoc(method);
        return null == doc ? null : this.formatComment0((Doc)doc, true, withBody, withLinePrefix, withTags);
    }

    public String getFieldComment(String name, boolean withBody, boolean withLinePrefix, boolean withTags) {
        FieldDoc doc = this.getFieldDoc(name);
        return null == doc ? null : this.formatComment0((Doc)doc, true, withBody, withLinePrefix, withTags);
    }

    public String getClassComment() {
        return this.getClassComment(true, true, true);
    }

    public String getMethodComment(Method method) {
        return this.getMethodComment(method, true, true, true);
    }

    public String getFieldComment(String name) {
        return this.getFieldComment(name, true, true, true);
    }

    public List<String> getClassCommentAsList(boolean needIndent, boolean withLinePrefix, boolean withTags) {
        return this.formatCommentAsList((Doc)this.classDoc, needIndent, withLinePrefix, withTags);
    }

    public List<String> getMethodCommentAsList(Method method, boolean needIndent, boolean withLinePrefix, boolean withTags) {
        MethodDoc doc = this.getMethodDoc(method);
        return null == doc ? null : this.formatCommentAsList((Doc)doc, needIndent, withLinePrefix, withTags);
    }

    public List<String> getFieldCommentAsList(String name, boolean needIndent, boolean withLinePrefix, boolean withTags) {
        FieldDoc doc = this.getFieldDoc(name);
        return null == doc ? null : this.formatCommentAsList((Doc)doc, needIndent, withLinePrefix, withTags);
    }

    public List<String> getClassCommentAsList() {
        return this.getClassCommentAsList(false, true, true);
    }

    public List<String> getMethodCommentAsList(Method method) {
        return this.getMethodCommentAsList(method, true, true, true);
    }

    public List<String> getFieldCommentAsList(String name) {
        return this.getFieldCommentAsList(name, true, true, true);
    }

    public String commentTextOf(Method method) {
        MethodDoc methodDoc = this.getMethodDoc(method);
        return methodDoc == null ? "" : methodDoc.commentText();
    }

    public String commentText() {
        return this.classDoc.commentText();
    }

    public String parameterCommentOf(Method method, String name) {
        ParamTag paramTag = this.paramTagOf(this.getMethodDoc(method), name);
        return paramTag == null ? "" : paramTag.parameterComment();
    }

    public static String getIndent() {
        return indent;
    }

    public static void setIndent(String indent) {
        if (null != indent) {
            ExtClassDoc.indent = indent;
        }
    }

    public synchronized void setExcludeTags(Map<String, Integer> excludeTags) {
        if (null != excludeTags) {
            excludeTags.clear();
            excludeTags.putAll(excludeTags);
        }
    }

    public void addExcludeTag(String excludeTag, Integer scope) {
        if (!Strings.isNullOrEmpty((String)excludeTag)) {
            this.excludeTags.put(excludeTag, null == scope ? Type.ALL.mask : scope);
        }
    }

    public void removeExcludeTag(String excludeTag) {
        this.excludeTags.remove(excludeTag);
    }

    public void addExcludeTag(String excludeTag, Type type) {
        this.addExcludeTag(excludeTag, (null == type ? Type.ALL : type).mask);
    }

    public void addExcludeTag(String excludeTag, Collection<Type> type) {
        this.addExcludeTag(excludeTag, Type.sum(type));
    }

    public void addExcludeTag(String excludeTag, String type) {
        this.addExcludeTag(excludeTag, Strings.isNullOrEmpty((String)type) ? Type.ALL : Type.valueOf(type));
    }

    public void addExcludeTagString(String excludeTag, Collection<String> type) {
        if (null == type || type.isEmpty()) {
            this.addExcludeTag(excludeTag, Type.ALL);
        }
        this.addExcludeTag(excludeTag, Type.sumOfString(type));
    }

    public void addExcludeTag(String excludeTag) {
        this.addExcludeTag(excludeTag, Type.ALL);
    }

    public void addExcludeTags(Map<String, Integer> excludeTag) {
        if (null != excludeTag) {
            this.excludeTags.putAll(excludeTag);
        }
    }

    public void additionalText(String text, Action action, Integer scope) {
        if (!Strings.isNullOrEmpty((String)text)) {
            this.additionalTextTable.put((Object)text, (Object)AddColumn.ACTION, (Object)action);
            this.additionalTextTable.put((Object)text, (Object)AddColumn.SCOPE, (Object)scope);
        }
    }

    public void additionalText(String text, Action action, Type ... type) {
        this.additionalText(text, action, null == type ? Type.ALL.mask : Type.sum(type));
    }

    public void additionalText(String text, String action, String type) {
        this.additionalText(text, Strings.isNullOrEmpty((String)action) ? Action.ADD : Action.valueOf(action), null == type ? Type.ALL : Type.valueOf(type));
    }

    public void additionalText(String text, Action action, Collection<Type> type) {
        this.additionalText(text, action, null == type ? Type.ALL.mask : Type.sum(type));
    }

    public void additionalText(String text, String action, Collection<String> type) {
        this.additionalText(text, Strings.isNullOrEmpty((String)action) ? Action.ADD : Action.valueOf(action), null == type ? Type.ALL.mask : Type.sumOfString(type));
    }

    ClassDoc getClassDoc() {
        return this.classDoc;
    }

    public static enum AddColumn {
        ACTION,
        SCOPE;

    }

    public static enum Action {
        ADD,
        OVERWRITE,
        APPEND;

    }

    static enum Type {
        CLASS,
        METHOD,
        FIELD,
        NONE(0),
        ALL(-1);

        private final int mask;

        private Type() {
            this.mask = 1 << this.ordinal();
        }

        private Type(int mask) {
            Preconditions.checkArgument((1 != Integer.bitCount(mask) ? 1 : 0) != 0, (Object)"bit count of mask must be not be 1");
            this.mask = mask;
        }

        public boolean check(Integer v) {
            return null == v ? false : this.mask == (this.mask & v);
        }

        public boolean check(Type v) {
            return null == v ? false : this.check(v.mask);
        }

        public int or(int v) {
            return this.mask | v;
        }

        public int reset(int v) {
            return ~this.mask & v;
        }

        public static int sum(Type ... values) {
            if (null == values) {
                return 0;
            }
            int m = 0;
            for (Type v : values) {
                if (null == v) continue;
                m |= v.mask;
            }
            return m;
        }

        public static int sum(Collection<Type> values) {
            return null == values ? 0 : Type.sum(Collections2.filter(values, (Predicate)new Predicate<Type>(){

                public boolean apply(Type input) {
                    return null != input;
                }
            }).toArray(new Type[0]));
        }

        public static int sumOfString(Collection<String> values) {
            return null == values ? 0 : Type.sum(Collections2.transform(values, (Function)new Function<String, Type>(){

                public Type apply(String input) {
                    try {
                        return Type.valueOf(input);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            }));
        }

        public static List<Type> checkAll(int value) {
            ArrayList<Type> list = new ArrayList<Type>();
            for (Type v : Type.values()) {
                if (!v.check(value) || Integer.bitCount(v.mask) != 1) continue;
                list.add(v);
            }
            return list;
        }

        static {
            int mask = 0;
            for (Type v : Type.values()) {
                if (1 != Integer.bitCount(v.mask)) continue;
                mask |= v.mask;
            }
            try {
                Field field = Type.class.getDeclaredField("mask");
                field.setAccessible(true);
                field.set((Object)ALL, mask);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
            for (Type v : Type.values()) {
                if (Integer.bitCount(v.mask) <= 1 || v == ALL || (~Type.ALL.mask & v.mask) == 0) continue;
                throw new ExceptionInInitializerError(String.format("%s: %s,invalid mask, out of ALL scope", v.name(), Integer.toBinaryString(v.mask)));
            }
        }
    }
}

