/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.mtfsdk;

import java.util.Iterator;
import java.util.ServiceLoader;
import net.gdface.license.GfLicenseProvider;
import net.gdface.license.LicenseManager;
import net.gdface.license.LicenseUtils;
import net.gdface.mtfsdk.DefaultMtfAndroidConfig;
import net.gdface.mtfsdk.MtfAndroidConfigProvider;
import net.gdface.mtfsdk.SdkInitException;
import net.gdface.mtfsdk.SdkRuntimeException;
import net.gdface.mtfsdk.SdkStatus;
import net.gdface.utils.Judge;
import net.gdface.utils.SimpleLog;

public class MtfAndroidArmBridge {
    public static final MtfAndroidConfigProvider CONFIG = MtfAndroidArmBridge.getConfigProvider();
    public static final LicenseManager LICENSE_MANAGER = LicenseUtils.getLicenseManager();
    public static final String SDK_VERSION = "MTFSDK512V2";
    final long[] detectHandle = new long[1];
    final long[] featureHandle = new long[1];
    final long[] liveHandle = new long[1];
    private SdkStatus status = SdkStatus.SDK_UNINITIALIZED;

    MtfAndroidArmBridge() {
    }

    private static GfLicenseProvider getLicenseProvider() {
        ServiceLoader<GfLicenseProvider> providers = ServiceLoader.load(GfLicenseProvider.class);
        Iterator<GfLicenseProvider> itor = providers.iterator();
        if (!itor.hasNext()) {
            return null;
        }
        return itor.next();
    }

    private static MtfAndroidConfigProvider getConfigProvider() {
        ServiceLoader<MtfAndroidConfigProvider> providers = ServiceLoader.load(MtfAndroidConfigProvider.class);
        Iterator<MtfAndroidConfigProvider> itor = providers.iterator();
        if (!itor.hasNext()) {
            return new DefaultMtfAndroidConfig();
        }
        return itor.next();
    }

    SdkStatus getStatus() {
        return this.status;
    }

    private static String zeroEnd(String input) {
        if (input == null) {
            return null;
        }
        if (input.endsWith("\u0000")) {
            return input;
        }
        return input + "\u0000";
    }

    static SdkStatus fdInit(String licenseKey, String licenseCode, MtfAndroidArmBridge instance) {
        if (SdkStatus.SDK_INIT_OK == instance.status) {
            return instance.status;
        }
        licenseCode = MtfAndroidArmBridge.zeroEnd(licenseCode);
        String szFilePath = "\u0000";
        String szCompanyNames = MtfAndroidArmBridge.zeroEnd(licenseKey);
        int fdFlag = MtfAndroidArmBridge.FDInit(licenseCode.getBytes(), szCompanyNames.getBytes(), szFilePath.getBytes(), szFilePath, instance.detectHandle);
        return SdkStatus.jniCode(fdFlag);
    }

    private static SdkStatus ffInit(String licenseKey, String licenseCode, MtfAndroidArmBridge instance) {
        if (SdkStatus.SDK_INIT_OK == instance.status) {
            return instance.status;
        }
        licenseCode = MtfAndroidArmBridge.zeroEnd(licenseCode);
        String szFilePath = "\u0000";
        String szCompanyNames = MtfAndroidArmBridge.zeroEnd(licenseKey);
        int ffFlag = MtfAndroidArmBridge.FFInit(licenseCode.getBytes(), szCompanyNames.getBytes(), szFilePath.getBytes(), szFilePath, instance.featureHandle);
        return SdkStatus.jniCode(ffFlag);
    }

    private static SdkStatus flInit(String licenseKey, String licenseCode, MtfAndroidArmBridge instance) {
        if (SdkStatus.SDK_INIT_OK == instance.status) {
            return instance.status;
        }
        licenseCode = MtfAndroidArmBridge.zeroEnd(licenseCode);
        String szFilePath = "\u0000";
        String szCompanyNames = MtfAndroidArmBridge.zeroEnd(licenseKey);
        int ffFlag = MtfAndroidArmBridge.FLInit(licenseCode.getBytes(), szCompanyNames.getBytes(), szFilePath.getBytes(), instance.liveHandle);
        return SdkStatus.jniCode(ffFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sdkInit(String licenseKey, String licenseCode) throws SdkInitException {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            return;
        }
        SdkStatus fdStatus = SdkStatus.SDK_UNINITIALIZED;
        SdkStatus ffStatus = SdkStatus.SDK_UNINITIALIZED;
        SdkStatus flStatus = SdkStatus.SDK_UNINITIALIZED;
        try {
            int code;
            fdStatus = MtfAndroidArmBridge.fdInit(licenseKey, licenseCode, this);
            if (fdStatus != SdkStatus.SDK_INIT_OK) {
                this.status = fdStatus;
                SimpleLog.log((String)"detect module: {}", (Object[])new Object[]{this.status.msg});
                throw new SdkInitException(this.status);
            }
            int detectThreadNumber = CONFIG.getDetectThreadNumber();
            if (detectThreadNumber > 0 && (code = MtfAndroidArmBridge.FDSetThreadsNumber(this.detectHandle[0], detectThreadNumber)) != 0) {
                this.status = SdkStatus.jniCode(code);
                throw new SdkInitException(this.status);
            }
            int featureThreadNumber = CONFIG.getFeatureThreadNumber();
            if (featureThreadNumber > 0 && (code = MtfAndroidArmBridge.FFSetThreadsNumber(this.featureHandle[0], featureThreadNumber)) != 0) {
                this.status = SdkStatus.jniCode(code);
                throw new SdkInitException(this.status);
            }
            int minFaceSize = CONFIG.getMinFaceSize();
            if (minFaceSize >= 0 && (code = MtfAndroidArmBridge.FDSetMinFaceSize(this.detectHandle[0], minFaceSize)) != 0) {
                this.status = SdkStatus.jniCode(code);
                throw new SdkInitException(this.status);
            }
            ffStatus = MtfAndroidArmBridge.ffInit(licenseKey, licenseCode, this);
            if (ffStatus != SdkStatus.SDK_INIT_OK) {
                this.status = ffStatus;
                SimpleLog.log((String)"feature module: {}", (Object[])new Object[]{this.status.msg});
                throw new SdkInitException(this.status);
            }
            if (CONFIG.needLive()) {
                flStatus = MtfAndroidArmBridge.flInit(licenseKey, licenseCode, this);
                if (flStatus != SdkStatus.SDK_INIT_OK) {
                    this.status = flStatus;
                    SimpleLog.log((String)"live module: {}", (Object[])new Object[]{this.status.msg});
                    throw new SdkInitException(this.status);
                }
            } else {
                SimpleLog.log((String)"SKIP initialization for live module(\u8df3\u8fc7\u6d3b\u4f53\u68c0\u6d4b\u6a21\u5757\u521d\u59cb\u5316)", (Object[])new Object[0]);
            }
            this.status = SdkStatus.SDK_INIT_OK;
        }
        finally {
            if (this.status != SdkStatus.SDK_INIT_OK) {
                if (fdStatus != SdkStatus.SDK_INIT_OK) {
                    MtfAndroidArmBridge.FDDestroy(this.detectHandle[0]);
                }
                if (ffStatus != SdkStatus.SDK_INIT_OK) {
                    MtfAndroidArmBridge.FFDestroy(this.featureHandle[0]);
                }
                if (flStatus != SdkStatus.SDK_INIT_OK) {
                    MtfAndroidArmBridge.FLDestroy(this.liveHandle[0]);
                }
            }
        }
    }

    MtfAndroidArmBridge init() throws SdkInitException {
        String licenseKey = LICENSE_MANAGER.getLicenseKey();
        String licenseCode = LICENSE_MANAGER.getLicenseCode();
        if (Judge.isEmpty((String)licenseKey)) {
            throw new SdkInitException("EMPTY licenseKey,must call setLicenseKey() firstly");
        }
        if (Judge.isEmpty((String)licenseCode)) {
            throw new SdkInitException("EMPTY licenseCode,must call setLicenseCode() firstly");
        }
        this.sdkInit(licenseKey, licenseCode);
        return this;
    }

    void destroy() {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            this.status = SdkStatus.SDK_UNINITIALIZED;
            MtfAndroidArmBridge.FDDestroy(this.detectHandle[0]);
            MtfAndroidArmBridge.FFDestroy(this.featureHandle[0]);
            MtfAndroidArmBridge.FLDestroy(this.liveHandle[0]);
        }
    }

    public int detect(byte[] BGR, int width, int height, int detectMod, double[] rect) {
        int ret = MtfAndroidArmBridge.FDDetect(this.detectHandle[0], BGR, width, height, detectMod, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret;
    }

    public int detectMaxFace(byte[] BGR, int width, int height, int detectMod, double[] rect) {
        int ret = MtfAndroidArmBridge.FDDetectMaxFace(this.detectHandle[0], BGR, width, height, detectMod, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret;
    }

    public int getDetectInfo(byte[] BGR, int width, int height, double[] rect, double[] rectinfo) {
        int ret = MtfAndroidArmBridge.FDGetDetectInfo(this.detectHandle[0], BGR, width, height, rect, rectinfo);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret;
    }

    public double[] feaExtract(byte[] BGR, int width, int height, double[] rect) {
        double[] buffer = new double[128];
        int ret = MtfAndroidArmBridge.FFFeaExtract(this.featureHandle[0], BGR, width, height, buffer, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return buffer;
    }

    public byte[] feaExtractByte(byte[] BGR, int width, int height, double[] rect) {
        byte[] buffer = new byte[512];
        int ret = MtfAndroidArmBridge.FFFeaExtractByte(this.featureHandle[0], BGR, width, height, buffer, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return buffer;
    }

    public int facePosInterrelate(int faceNums, double rectRate, double[] faceRect, double[] faceRectInfo) {
        int ret = MtfAndroidArmBridge.FSFacePosInterrelate(this.detectHandle[0], faceNums, rectRate, faceRect, faceRectInfo);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret;
    }

    public int setFacePosStatus(int facePos, int flag) {
        int ret = MtfAndroidArmBridge.FSSetFacePosStatus(this.detectHandle[0], facePos, flag);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret;
    }

    public boolean liveProcess(byte[] BGR, int width, int height, double[] rect) {
        double[] socre = new double[1];
        int ret = MtfAndroidArmBridge.FLProcess(this.liveHandle[0], BGR, width, height, rect, socre);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode(ret));
        }
        return ret == 1;
    }

    public static native int FSGetDevicesSerial(byte[] var0, byte[] var1);

    private static native int FDInit(byte[] var0, byte[] var1, byte[] var2, String var3, long[] var4);

    static native void FDDestroy(long var0);

    private static native int FDDetect(long var0, byte[] var2, int var3, int var4, int var5, double[] var6);

    private static native int FDDetectMaxFace(long var0, byte[] var2, int var3, int var4, int var5, double[] var6);

    private static native int FDGetDetectInfo(long var0, byte[] var2, int var3, int var4, double[] var5, double[] var6);

    private static native int FDSetMinFaceSize(long var0, int var2);

    private static native int FDSetThreadsNumber(long var0, int var2);

    private static native int FFSetThreadsNumber(long var0, int var2);

    public static native String FDgetVersion();

    private static native int FFInit(byte[] var0, byte[] var1, byte[] var2, String var3, long[] var4);

    private static native void FFDestroy(long var0);

    private static native int FFFeaExtract(long var0, byte[] var2, int var3, int var4, double[] var5, double[] var6);

    public static native double FFSimilarity(double[] var0, double[] var1);

    private static native int FFFeaExtractByte(long var0, byte[] var2, int var3, int var4, byte[] var5, double[] var6);

    public static native double FFSimilarityByte(byte[] var0, byte[] var1);

    public static native String FFgetVersion();

    private static native int FSFacePosInterrelate(long var0, int var2, double var3, double[] var5, double[] var6);

    private static native int FSSetFacePosStatus(long var0, int var2, int var3);

    private static native int FLInit(byte[] var0, byte[] var1, byte[] var2, long[] var3);

    private static native void FLDestroy(long var0);

    private static native int FLProcess(long var0, byte[] var2, int var3, int var4, double[] var5, double[] var6);

    static {
        try {
            System.loadLibrary("FS_AndroidFaceSDK");
        }
        catch (Exception e) {
            SimpleLog.log((String)e.getMessage(), (Object[])new Object[0]);
            throw new ExceptionInInitializerError(e);
        }
        SimpleLog.log((String)"MtfAndroid Config INSTANCE:{}", (Object[])new Object[]{DefaultMtfAndroidConfig.toString(CONFIG)});
        LICENSE_MANAGER.installLicenseIfSPIAvailable();
    }
}

