package net.gdface.mtfsdk;

/**
 * SDK运行时异常<br>
 * 调用检测识别函数产生的异常
 * @author guyadong
 *
 */
public class SdkRuntimeException extends RuntimeException {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 异常状态
	 */
	public final SdkStatus status;

	public SdkRuntimeException(String msg) {
		this(msg,(Throwable)null,SdkStatus.UNKNOW_ERROR);
	}

	public SdkRuntimeException(Throwable throwable) {
		this(null,throwable,SdkStatus.UNKNOW_ERROR);
	}

	public SdkRuntimeException(String msg, Throwable throwable,SdkStatus status) {
		super(msg, throwable);
		this.status =  status == null ? SdkStatus.UNKNOW_ERROR : status;
	}

	public SdkRuntimeException(SdkStatus status) {
		super();
		this.status = status;
	}
	public SdkRuntimeException(Throwable throwable,SdkStatus status) {
		this(null,throwable,status);
	}

	@Override
	public String getMessage() {		
		String msg = super.getMessage();
		if(msg == null && status !=null){
			return status.msg;
		}
		return msg;
	}
}
