package net.gdface.mtfsdk;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

/**
 * 创建{@link MtfAndroidArmBridge}实例的工厂类,用于commons-pool2资源池的实例管理
 * @author guyadong
 *
 */
class BridgeInstanceFactory implements PooledObjectFactory<MtfAndroidArmBridge> {
	BridgeInstanceFactory() {
	}

	@Override
	public PooledObject<MtfAndroidArmBridge> makeObject() throws Exception {
		return new DefaultPooledObject<>(new MtfAndroidArmBridge().init());
	}

	@Override
	public void destroyObject(PooledObject<MtfAndroidArmBridge> p) throws Exception {
		p.getObject().destroy();
	}

	@Override
	public boolean validateObject(PooledObject<MtfAndroidArmBridge> p) {
		// 初始化成功的实例为有效实例
		return p.getObject().getStatus() == SdkStatus.SDK_INIT_OK;
	}

	@Override
	public void activateObject(PooledObject<MtfAndroidArmBridge> p) throws Exception {
		// DO NOTHING
	}

	@Override
	public void passivateObject(PooledObject<MtfAndroidArmBridge> p) throws Exception {
		// DO NOTHING
	}

}