package net.gdface.mtfsdk;

import net.gdface.utils.SimpleLog;

/**
 * {@link MtfAndroidConfigProvider}接口的默认实现,提供默认SDK初始化参数
 * @author guyadong
 *
 */
public class DefaultMtfAndroidConfig implements MtfAndroidConfigProvider {

	public DefaultMtfAndroidConfig() {
	}

	@Override
	public int getConcurrency() {
		return 0;
	}

	@Override
	public boolean needLive(){
		return true;
	}

	@Override
	public String toString() {
		return toString(this);
	}

	public static final String toString(MtfAndroidConfigProvider input){
		if(input != null){
			return SimpleLog.logString("{} [concurrency={},needLive={}]",
					input.getClass().getName(),
					input.getConcurrency(),
					input.needLive());
		}
		return "null";
	}
}
