package net.gdface.mtfsdk;

import net.gdface.sdk.fse.BaseFeatureSearchEngine;
import net.gdface.sdk.fse.FeatureSe;

/**
 * 基于MTFSDK Arm android算法的特征码内存搜索引擎(FSE,feature search engine)java接口类(JNI)
 * @author guyadong
 *
 */
public class FseMtfAndroidBridge extends BaseFeatureSearchEngine{
	private static final String DEFAULT_LIB_NAME = "FS_FaceFeatureCompare";

	private static final FeatureSe FSE_INSTANCE = new FeatureSeImpl(FseMtfAndroidBridge.class.getName());
	static {
		try{
			System.loadLibrary(DEFAULT_LIB_NAME);
			init(DEFAULT_MODE,256,DEFAULT_LOAD_FACTOR,DEFAULT_OVERBLOCK_CAPACITY);

			libraryLoaded = true;
		}catch(Exception e){
			throw new ExceptionInInitializerError(e);
		}
	}
	protected FseMtfAndroidBridge() {
	}
	
	/**
	 * 返回FSE搜索引擎的单实例
	 * @return
	 */
	public static FeatureSe getFeatureSe(){
		return isLibraryLoaded() ? FSE_INSTANCE : null;
	}
}
