package net.gdface.mtfsdk;

/**
 * MTFSDK android/arm平台参数配置接口<br>
 * SDK初始化时以SPI(Service Provider Interface)机制加载应用层提供的
 * {@link MtfAndroidConfigProvider}实例,并通过接口实例获取的参数初始化SDK<br>
 * 参见 {@link MtfAndroidArmBridge}的{@code config}字段.<br>
 * NOTE:一般情况下无需修改SDK初始化参数.
 * @author guyadong
 *
 */
public interface MtfAndroidConfigProvider {
    /**
	 * 人脸检测数据的(double)数组长度
	 */
	public static final int FDDATA_LEN = 21;
	/**
	 * 人脸检测数据的(byte)数组长度
	 */
	public static final int FDDATA_BYTES=FDDATA_LEN*(Double.SIZE/8);
	/**
	 * 最大检测人脸数目
	 */
	public static final int MAX_FACE_COUNT = 3;
	/**
	 * 人脸特征数据数组(double[])长度
	 */
	public static final int FEATURE_LEN = 128;
	/**
	 * 人脸特征数据数组(byte[])长度
	 */
	public static final int FEATURE_BYTES=FEATURE_LEN*(Float.SIZE/8);
	
	/**
	 * 默认的人脸检测并发线程数
	 */
	public static final int DEFAULT_DETECT_THREAD_NUMBER=2;
	/**
	 * 默认的特征提取并发线程数
	 */
	public static final int DEFAULT_FEATURE_THREAD_NUMBER=2;
	/**
	 * 默认最小人脸检测(宽/高)尺寸(像素)
	 */
	public static final int DEFAULT_DETECT_MIN_FACE_SIZE=60;

	/**
	 * 指定最大调用并发线程数,返回0使用默认值(CPU核数)
	 * @return
	 */
	int getConcurrency();
	/**
	 * 指定是否需要活体检测功能,<br>
	 * 返回{@code false}则关闭活体检测功能，SDK不会初始化活体检测模块，活体检测模块将不可用.
	 * 活体检测模块需要占用较多内存资源，在不需要使用该功能的情况，关闭该功能可以减少内存资源占用.<br>
	 * 默认提供的参数为{@code true},参见{@link DefaultMtfAndroidConfig#needLive()}
	 * @return
	 */
	boolean needLive();
	
}
