package net.gdface.mtfsdk;

/**
 * SDK初始化异常<br>
 * SDK初始化阶段产生的异常
 * @author guyadong
 *
 */
public class SdkInitException extends Exception {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 初始化异常状态
	 */
	public final SdkStatus status;

	public SdkInitException(String msg) {
		this(msg,(Throwable)null,SdkStatus.UNKNOW_ERROR);
	}

	public SdkInitException(Throwable throwable) {
		this(null,throwable,SdkStatus.UNKNOW_ERROR);
	}

	public SdkInitException(String msg, Throwable throwable,SdkStatus status) {
		super(msg, throwable);
		this.status =  status == null ? SdkStatus.UNKNOW_ERROR : status;
	}

	public SdkInitException(SdkStatus status) {
		super();
		this.status = status;
	}
	public SdkInitException(Throwable throwable,SdkStatus status) {
		this(null,throwable,status);
	}
	@Override
	public String getMessage() {		
		String msg = super.getMessage();
		if(msg == null && status !=null){
			return status.msg;
		}
		return msg;
	}
}
