/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.mtfsdk;

import java.util.Arrays;
import net.gdface.license.BaseLicenseManager;
import net.gdface.license.RegStatus;
import net.gdface.license.RegisterException;
import net.gdface.mtfsdk.MtfAndroidArmBridge;
import net.gdface.mtfsdk.SdkStatus;
import net.gdface.utils.Judge;

public class DefaultMtfLicenseManager
extends BaseLicenseManager {
    public boolean validateLicense(String licenseKey, String licenseCode) {
        MtfAndroidArmBridge tmp;
        SdkStatus fdSdkStatus;
        if (!Judge.isEmpty((String)licenseKey) && !Judge.isEmpty((String)licenseCode) && (fdSdkStatus = MtfAndroidArmBridge.fdInit(licenseKey, licenseCode, tmp = new MtfAndroidArmBridge())) == SdkStatus.SDK_INIT_OK) {
            MtfAndroidArmBridge.FDDestroy(tmp.detectHandle[0]);
            return true;
        }
        return false;
    }

    public String getDevicesSerial(String licenseKey) throws RegisterException {
        byte[] buffer = new byte[128];
        Arrays.fill(buffer, (byte)0);
        int res = MtfAndroidArmBridge.FSGetDevicesSerial(buffer, licenseKey.getBytes());
        if (res > 0) {
            return new String(buffer, 0, res);
        }
        throw new RegisterException(RegStatus.REG_FAIL_TO_GET_DEVICE_SERIAL);
    }

    public boolean licenseOnlineSupported() {
        return true;
    }
}

