/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.mtfsdk;

import android.graphics.Bitmap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.gdface.image.BaseLazyImage;
import net.gdface.image.ImageErrorException;
import net.gdface.image.LazyImage;
import net.gdface.license.LicenseManager;
import net.gdface.mtfsdk.BridgeInstanceFactory;
import net.gdface.mtfsdk.FseMtfAndroidBridge;
import net.gdface.mtfsdk.MtfAndroidArmBridge;
import net.gdface.mtfsdk.NativeFaceInfo;
import net.gdface.sdk.BaseFaceApiLocal;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.FaceApi;
import net.gdface.sdk.FaceApiGenericDecorator;
import net.gdface.sdk.NotFaceDetectedException;
import net.gdface.sdk.fse.FeatureSe;
import net.gdface.utils.Assert;
import net.gdface.utils.ShareLock;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FaceApiMtfAndroid
extends BaseFaceApiLocal {
    private static final ThreadLocal<double[]> faceBuffer = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return new double[63];
        }
    };
    private static final FaceApiMtfAndroid INSTANCE = new FaceApiMtfAndroid();
    private static final FaceApiGenericDecorator GENERIC_INSTANCE = new FaceApiGenericDecorator((FaceApi)INSTANCE);
    private final HashMap<MtfAndroidArmBridge.RuntimeParam, Object> globalRuntimeParams = new HashMap();
    private final ReentrantReadWriteLock globalParamLock = new ReentrantReadWriteLock();
    private static final ThreadLocal<Map<MtfAndroidArmBridge.RuntimeParam, Object>> localRuntimeParams = new ThreadLocal();
    private static final GenericObjectPool<MtfAndroidArmBridge> pool;

    protected FaceApiMtfAndroid() {
    }

    public static FaceApiMtfAndroid getInstance() {
        return INSTANCE;
    }

    public static FaceApiGenericDecorator getGenericInstance() {
        return GENERIC_INSTANCE;
    }

    public static LicenseManager licenseManager() {
        return MtfAndroidArmBridge.LICENSE_MANAGER;
    }

    public final String sdkVersion() {
        return "MTFSDK512V2";
    }

    protected double nativeCompareCode(byte[] code1, byte[] code2) {
        return MtfAndroidArmBridge.FFSimilarityByte(code1, code2);
    }

    public void nativeDetectFace(byte[] imgMatrix, int width, int height, List<CodeInfo> faceInfo) {
        this.nativeDetectFace(imgMatrix, width, height, faceInfo, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nativeGetFaceFeature(byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
        NativeFaceInfo nativeFaceInfo = NativeFaceInfo.toNative(faceInfo);
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            this.setInstanceParam(instance, MtfAndroidArmBridge.RuntimeParam.featureThreadNumber);
            byte[] byArray = instance.feaExtractByte(imgMatrix, width, height, nativeFaceInfo.nativeData);
            return byArray;
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nativeDetectFace(byte[] imgMatrix, int width, int height, List<CodeInfo> faceInfo, int detectMod) {
        double[] buffer = faceBuffer.get();
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            this.setInstanceParam(instance, MtfAndroidArmBridge.RuntimeParam.detectThreadNumber);
            this.setInstanceParam(instance, MtfAndroidArmBridge.RuntimeParam.minFaceSize);
            int res = instance.detect(imgMatrix, width, height, detectMod, buffer);
            for (int i = 0; i < res; ++i) {
                faceInfo.add(new NativeFaceInfo(buffer, i * 21));
            }
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    public NativeFaceInfo nativeDetectMaxFace(byte[] imgMatrix, int width, int height) {
        return this.nativeDetectMaxFace(imgMatrix, width, height, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeFaceInfo nativeDetectMaxFace(byte[] imgMatrix, int width, int height, int detectMod) {
        double[] buffer = faceBuffer.get();
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            this.setInstanceParam(instance, MtfAndroidArmBridge.RuntimeParam.detectThreadNumber);
            this.setInstanceParam(instance, MtfAndroidArmBridge.RuntimeParam.minFaceSize);
            int res = instance.detectMaxFace(imgMatrix, width, height, detectMod, buffer);
            NativeFaceInfo nativeFaceInfo = res == 0 ? null : new NativeFaceInfo(buffer, 0);
            return nativeFaceInfo;
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    public NativeFaceInfo detectMaxFace(Bitmap bitmap) {
        return this.detectMaxFace(bitmap, 0);
    }

    public NativeFaceInfo detectMaxFace(Bitmap bitmap, int detectMod) {
        try {
            byte[] matrix = this.getMatrixData((BaseLazyImage)LazyImage.create((Bitmap)bitmap));
            return this.nativeDetectMaxFace(matrix, bitmap.getWidth(), bitmap.getHeight(), detectMod);
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int facePosInterrelate(int faceNums, double rectRate, double[] faceRect, double[] faceRectInfo) {
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            int n = instance.facePosInterrelate(faceNums, rectRate, faceRect, faceRectInfo);
            return n;
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDetectInfo(byte[] BGR, int width, int height, double[] rect, double[] rectinfo) {
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            int n = instance.getDetectInfo(BGR, width, height, rect, rectinfo);
            return n;
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFacePosStatus(int facePos, int flag) {
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            int n = instance.setFacePosStatus(facePos, flag);
            return n;
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nativeLiveProcess(byte[] BGR, int width, int height, double[] rect) {
        MtfAndroidArmBridge instance = FaceApiMtfAndroid.applyInstance();
        try {
            boolean bl = instance.liveProcess(BGR, width, height, rect);
            return bl;
        }
        finally {
            FaceApiMtfAndroid.returnInstance(instance);
        }
    }

    public boolean liveProcess(Bitmap bitmap, NativeFaceInfo faceinfo) {
        try {
            byte[] matrix = this.getMatrixData((BaseLazyImage)LazyImage.create((Bitmap)bitmap));
            return this.nativeLiveProcess(matrix, bitmap.getWidth(), bitmap.getHeight(), faceinfo.nativeData);
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public List<CodeInfo> detectFace(Bitmap bitmap) {
        try {
            return this.detectFace((BaseLazyImage)LazyImage.create((Bitmap)bitmap));
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public List<CodeInfo> getCodeInfo(Bitmap bitmap, int faceNum, List<CodeInfo> facePos) throws NotFaceDetectedException {
        return this.getCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap), faceNum, facePos);
    }

    public CodeInfo getCodeInfo(Bitmap bitmap, CodeInfo facePos) {
        return this.getCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap), facePos);
    }

    public CodeInfo[] detectAndGetCodeInfo(Bitmap bitmap, int faceNum) throws NotFaceDetectedException {
        try {
            return this.detectAndGetCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap).open(), faceNum);
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceApiMtfAndroid setGlobalRuntimeParam(MtfAndroidArmBridge.RuntimeParam name, Object value) {
        Assert.notNull((Object)((Object)name), (String)"name");
        this.globalParamLock.writeLock().lock();
        try {
            this.globalRuntimeParams.put(name, value);
        }
        finally {
            this.globalParamLock.writeLock().unlock();
        }
        return this;
    }

    public FaceApiMtfAndroid setLocalRuntimeParam(MtfAndroidArmBridge.RuntimeParam name, Object value) {
        Assert.notNull((Object)((Object)name), (String)"name");
        Map<MtfAndroidArmBridge.RuntimeParam, Object> m = localRuntimeParams.get();
        if (m == null) {
            m = new HashMap<MtfAndroidArmBridge.RuntimeParam, Object>();
            localRuntimeParams.set(m);
        }
        m.put(name, value);
        return this;
    }

    public FaceApiMtfAndroid removeLocalRunTimeParam() {
        localRuntimeParams.remove();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstanceParam(MtfAndroidArmBridge instance, MtfAndroidArmBridge.RuntimeParam name) {
        Map<MtfAndroidArmBridge.RuntimeParam, Object> m = localRuntimeParams.get();
        if (null != m && m.containsKey((Object)name)) {
            instance.setRuntimeParam(name, m.get((Object)name));
        } else {
            this.globalParamLock.readLock().lock();
            try {
                if (this.globalRuntimeParams.containsKey((Object)name)) {
                    instance.setRuntimeParam(name, this.globalRuntimeParams.get((Object)name));
                }
            }
            finally {
                this.globalParamLock.readLock().unlock();
            }
        }
    }

    public FeatureSe getFeatureSe() {
        return FseMtfAndroidBridge.getFeatureSe();
    }

    private static MtfAndroidArmBridge applyInstance() {
        try {
            return (MtfAndroidArmBridge)pool.borrowObject();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void returnInstance(MtfAndroidArmBridge obj) {
        pool.returnObject((Object)obj);
    }

    static {
        try {
            Class.forName(MtfAndroidArmBridge.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        pool = new GenericObjectPool((PooledObjectFactory)new BridgeInstanceFactory(), config);
        int concurrency = MtfAndroidArmBridge.CONFIG.getConcurrency();
        if (concurrency > 0) {
            concurrentLock = new ShareLock(concurrency);
        }
    }
}

