/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.mtfsdk;

import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.EyeInfo;
import net.gdface.sdk.FAngle;
import net.gdface.sdk.FInt2;
import net.gdface.sdk.FRect;
import net.gdface.utils.Assert;
import net.gdface.utils.BufferUtils;

public class NativeFaceInfo
extends CodeInfo {
    private static final long serialVersionUID = 1L;
    double confidence;
    double[] nativeData;

    public NativeFaceInfo(double[] nativeData) {
        this(nativeData, 0);
    }

    public NativeFaceInfo(double[] nativeData, int start) {
        this.init(nativeData, start);
    }

    public NativeFaceInfo(CodeInfo codeInfo) {
        Assert.notNull((Object)codeInfo, (String)"codeinfo");
        byte[] facialData = codeInfo.getFacialData();
        Assert.notNull((Object)facialData, (String)"facialData");
        this.init(BufferUtils.asDoubleArray((byte[])facialData), 0);
    }

    private void init(double[] nativeData, int start) {
        Assert.isTrue((start >= 0 ? 1 : 0) != 0, (String)"start>=0", (String)"invalid start");
        Assert.isTrue((nativeData != null && nativeData.length - start >= 21 ? 1 : 0) != 0, (String)"nativeData!=null && nativeData.length-start>=CaffeMobile.FDDATA_LEN", (String)"invalid nativeData");
        this.nativeData = new double[21];
        System.arraycopy(nativeData, start, this.nativeData, 0, this.nativeData.length);
        FRect pos = this.getPos();
        if (pos == null) {
            pos = new FRect();
        }
        pos.setLeft((int)this.nativeData[FieldIndex.FRECT_LEFT.ordinal()]);
        pos.setTop((int)this.nativeData[FieldIndex.FRECT_TOP.ordinal()]);
        pos.setWidth((int)this.nativeData[FieldIndex.FRECT_WIDTH.ordinal()]);
        pos.setHeight((int)this.nativeData[FieldIndex.FRECT_HEIGHT.ordinal()]);
        this.setPos(pos);
        FAngle angle = this.getAngle();
        if (angle == null) {
            angle = new FAngle();
        }
        angle.setRoll((int)this.nativeData[FieldIndex.FD_ANGLE_ROLL.ordinal()]);
        angle.setYaw((int)this.nativeData[FieldIndex.FD_ANGLE_YAW.ordinal()]);
        angle.setPitch((int)this.nativeData[FieldIndex.FD_ANGLE_PITCH.ordinal()]);
        angle.setConfidence((float)((int)(this.nativeData[FieldIndex.FD_CONFIDENCE.ordinal()] * 100.0)));
        this.setAngle(angle);
        EyeInfo ei = this.getEi();
        if (ei == null) {
            ei = new EyeInfo();
        }
        ei.setLeftx((int)this.nativeData[FieldIndex.FD_LEFT_EYE_X.ordinal()]);
        ei.setLefty((int)this.nativeData[FieldIndex.FD_LEFT_EYE_Y.ordinal()]);
        ei.setRightx((int)this.nativeData[FieldIndex.FD_RIGHT_EYE_X.ordinal()]);
        ei.setRighty((int)this.nativeData[FieldIndex.FD_RIGHT_EYE_Y.ordinal()]);
        this.setEi(ei);
        FInt2 mouth = this.getMouth();
        if (mouth == null) {
            mouth = new FInt2();
        }
        double x = (this.nativeData[FieldIndex.FD_MOUTH_LEFT_X.ordinal()] + this.nativeData[FieldIndex.FD_MOUTH_RIGHT_X.ordinal()]) / 2.0;
        double y = (this.nativeData[FieldIndex.FD_MOUTH_LEFT_Y.ordinal()] + this.nativeData[FieldIndex.FD_MOUTH_RIGHT_Y.ordinal()]) / 2.0;
        mouth.setX((int)x);
        mouth.setY((int)y);
        this.setMouth(mouth);
        FInt2 nose = this.getNose();
        if (nose == null) {
            nose = new FInt2();
        }
        nose.setX((int)this.nativeData[FieldIndex.FD_NOSE_X.ordinal()]);
        nose.setY((int)this.nativeData[FieldIndex.FD_NOSE_Y.ordinal()]);
        this.setNose(nose);
        this.confidence = this.nativeData[FieldIndex.FD_CONFIDENCE.ordinal()];
        this.setFacialData(BufferUtils.asByteArray((double[])this.nativeData));
    }

    public static NativeFaceInfo toNative(CodeInfo code) {
        if (code == null) {
            return null;
        }
        if (code instanceof NativeFaceInfo) {
            return (NativeFaceInfo)code;
        }
        return new NativeFaceInfo(code);
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double[] getNativeData() {
        return this.nativeData;
    }

    static enum FieldIndex {
        FRECT_LEFT,
        FRECT_TOP,
        FRECT_WIDTH,
        FRECT_HEIGHT,
        FD_LEFT_EYE_X,
        FD_LEFT_EYE_Y,
        FD_RIGHT_EYE_X,
        FD_RIGHT_EYE_Y,
        FD_NOSE_X,
        FD_NOSE_Y,
        FD_MOUTH_LEFT_X,
        FD_MOUTH_LEFT_Y,
        FD_MOUTH_RIGHT_X,
        FD_MOUTH_RIGHT_Y,
        FD_CONFIDENCE,
        FD_FACE_OFFSET_Y,
        FD_FACE_OFFSET_X,
        FD_ANGLE_ROLL,
        FD_ANGLE_YAW,
        FD_ANGLE_PITCH,
        FD_DETECTED_FLAG;

    }
}

