/*
 * Decompiled with CFR 0.152.
 */
package net.facelib.mtfsdk;

import net.facelib.jni.BaseJniBridge;
import net.facelib.jni.SdkInitException;
import net.facelib.jni.SdkRuntime;
import net.facelib.jni.SdkRuntimeException;
import net.facelib.jni.SdkStatus;
import net.gdface.utils.Assert;
import net.gdface.utils.SimpleLog;

public class V1AndroidBridge
extends BaseJniBridge {
    public static final String SDK_VERSION = "MTFSDK512";
    final long[] featureHandle = new long[1];
    private SdkStatus status = SdkStatus.SDK_UNINITIALIZED;

    protected SdkStatus getStatus() {
        return this.status;
    }

    static SdkStatus ffInit(String licenseKey, String licenseCode, V1AndroidBridge instance) {
        if (SdkStatus.SDK_INIT_OK == instance.status) {
            return instance.status;
        }
        licenseCode = V1AndroidBridge.zeroEnd((String)licenseCode);
        String szFilePath = "\u0000";
        String szCompanyNames = V1AndroidBridge.zeroEnd((String)licenseKey);
        int ffFlag = V1AndroidBridge.FFInit(licenseCode.getBytes(), szCompanyNames.getBytes(), szFilePath.getBytes(), szFilePath, instance.featureHandle);
        return SdkStatus.jniCode((int)ffFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sdkInit(String licenseKey, String licenseCode) throws SdkInitException {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            return;
        }
        SdkStatus ffStatus = SdkStatus.SDK_UNINITIALIZED;
        try {
            ffStatus = V1AndroidBridge.ffInit(licenseKey, licenseCode, this);
            if (ffStatus != SdkStatus.SDK_INIT_OK) {
                this.status = ffStatus;
                SimpleLog.log((String)"feature module: {}", (Object[])new Object[]{this.status.msg});
                throw new SdkInitException(this.status);
            }
            this.status = SdkStatus.SDK_INIT_OK;
        }
        finally {
            if (this.status != SdkStatus.SDK_INIT_OK && ffStatus != SdkStatus.SDK_INIT_OK) {
                V1AndroidBridge.FFDestroy(this.featureHandle[0]);
            }
        }
    }

    protected void destroy() {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            this.status = SdkStatus.SDK_UNINITIALIZED;
            V1AndroidBridge.FFDestroy(this.featureHandle[0]);
        }
    }

    public byte[] feaExtractByte(byte[] BGR, int width, int height, double[] rect) {
        byte[] buffer = new byte[512];
        int ret = V1AndroidBridge.FFFeaExtractByte(this.featureHandle[0], BGR, width, height, buffer, rect);
        if (ret < 0) {
            throw new SdkRuntimeException(SdkStatus.jniCode((int)ret));
        }
        return buffer;
    }

    public V1AndroidBridge setRuntimeParam(SdkRuntime.RuntimeParam name, Object value) throws SdkRuntimeException {
        Assert.notNull((Object)name, (String)"name");
        switch (name) {
            case featureThreadNumber: {
                int code;
                int featureThreadNumber;
                int n = featureThreadNumber = value != null ? (Integer)value : 2;
                if (featureThreadNumber <= 0 || (code = V1AndroidBridge.FFSetThreadsNumber(this.featureHandle[0], featureThreadNumber)) == 0) break;
                this.status = SdkStatus.jniCode((int)code);
                throw new SdkRuntimeException(this.status);
            }
            default: {
                throw new IllegalArgumentException(SimpleLog.logString((String)"INVALID parameter name: {}", (Object[])new Object[]{name}));
            }
        }
        return this;
    }

    private static native int FFInit(byte[] var0, byte[] var1, byte[] var2, String var3, long[] var4);

    static native void FFDestroy(long var0);

    private static native int FFFeaExtractByte(long var0, byte[] var2, int var3, int var4, byte[] var5, double[] var6);

    public static native double FFSimilarityByte(byte[] var0, byte[] var1);

    public static native String FFgetVersion();

    private static native int FFSetThreadsNumber(long var0, int var2);

    static {
        try {
            System.loadLibrary("FS_AndroidFeaV1SDK");
        }
        catch (Exception e) {
            SimpleLog.log((String)e.getMessage(), (Object[])new Object[0]);
            throw new ExceptionInInitializerError(e);
        }
    }
}

