package net.facelib.mtfsdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import net.facelib.jni.BridgePool;
import net.facelib.jni.SdkRuntime.RuntimeParam;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.ContextLoader.ContextField;

/**
 * MTFSDK V1 android/arm平台 {@link net.gdface.sdk.FaceApi}接口实现抽象类(线程安全)<br>
 * @author guyadong
 *
 */
public class FaceApiMtfV1Android extends BaseFaceApiMtfAndroid{
	public static final FaceApiMtfV1Android INSTANCE = new FaceApiMtfV1Android();
	static final Map<ContextField, Object> CONTEXT;
	private final BridgePool<V1AndroidBridge> poolWrap = new BridgePool<>(V1AndroidBridge.class);
	protected FaceApiMtfV1Android() {
		super();
		capacity.put(C_SDK_VERSION, V1AndroidBridge.SDK_VERSION);
	}
	
	public static FaceApiMtfV1Android getInstance(){
		return INSTANCE;
	}

	static {
		try {
			// MTFSDK JNI接口静态区初始化
			Class.forName(net.facelib.mtfsdk.V1AndroidBridge.class.getName());
		} catch (ClassNotFoundException e) {
			throw new ExceptionInInitializerError(e);
		}
		HashMap<ContextField, Object> m = new HashMap<>();
		m.put(ContextField.INSTANCE, getInstance());
		m.put(ContextField.LICENCE_MANAGER, licenseManager());
		CONTEXT = Collections.unmodifiableMap(m);
	}

	@Override
	protected double nativeCompareCode(byte[] code1, byte[] code2) {
		return V1AndroidBridge.FFSimilarityByte(code1,code2);
	}


	@Override
	public byte[] nativeGetFaceFeature(byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
		NativeFaceInfo nativeFaceInfo = NativeFaceInfo.toNative(faceInfo);
		V1AndroidBridge instance = poolWrap.applyInstance();
		try{
			sdkRuntime.setInstanceParam(instance,RuntimeParam.featureThreadNumber);
			 return instance.feaExtractByte(imgMatrix, width, height, nativeFaceInfo.nativeData);
		}finally{
			poolWrap.returnInstance(instance);
		}
	}
}
