package net.facelib.mtfsdk;

import net.facelib.jni.BridgePool;
import net.facelib.jni.SdkRuntime.RuntimeParam;
import net.gdface.sdk.CodeInfo;

/**
 * MTFSDK V2 android/arm平台 {@link net.gdface.sdk.FaceApi}接口实现抽象类(线程安全)<br>
 * @author guyadong
 *
 */
public class FaceApiMtfV2Android extends BaseFaceApiMtfAndroid{
	public static final FaceApiMtfV2Android INSTANCE = new FaceApiMtfV2Android();
	private final BridgePool<V2AndroidBridge> poolWrap = new BridgePool<>(V2AndroidBridge.class);
	protected FaceApiMtfV2Android() {
	}
	
	public static FaceApiMtfV2Android getInstance(){
		return INSTANCE;
	}
	@Override
	public final String sdkVersion() {
		return V2AndroidBridge.SDK_VERSION;
	}

	static {
		try {
			// MTFSDK JNI接口静态区初始化
			Class.forName(net.facelib.mtfsdk.V2AndroidBridge.class.getName());
		} catch (ClassNotFoundException e) {
			throw new ExceptionInInitializerError(e);
		}
	}

	@Override
	protected double nativeCompareCode(byte[] code1, byte[] code2) {
		return V2AndroidBridge.FFSimilarityByteV2(code1,code2);
	}


	@Override
	public byte[] nativeGetFaceFeature(byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
		NativeFaceInfo nativeFaceInfo = NativeFaceInfo.toNative(faceInfo);
		V2AndroidBridge instance = poolWrap.applyInstance();
		try{
			sdkRuntime.setInstanceParam(instance,RuntimeParam.featureThreadNumber);
			 return instance.feaExtractByte(imgMatrix, width, height, nativeFaceInfo.nativeData);
		}finally{
			poolWrap.returnInstance(instance);
		}
	}
}
