package net.facelib.mtfsdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import net.facelib.jni.BridgePool;
import net.facelib.jni.SdkRuntime.RuntimeParam;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.ContextLoader.ContextField;

/**
 * MTFSDK V2 android/arm平台 {@link net.gdface.sdk.FaceApi}接口实现抽象类(线程安全)<br>
 * @author guyadong
 *
 */
public class FaceApiMtfV2Android extends BaseFaceApiMtfAndroid{
	public static final FaceApiMtfV2Android INSTANCE = new FaceApiMtfV2Android();
	static final Map<ContextField, Object> CONTEXT;
	private final BridgePool<V2AndroidBridge> poolWrap = new BridgePool<>(V2AndroidBridge.class);
	protected FaceApiMtfV2Android() {
		super();
		capacity.put(C_SDK_VERSION, V2AndroidBridge.SDK_VERSION);
	}
	
	public static FaceApiMtfV2Android getInstance(){
		return INSTANCE;
	}

	static {
		try {
			// MTFSDK JNI接口静态区初始化
			Class.forName(net.facelib.mtfsdk.V2AndroidBridge.class.getName());
		} catch (ClassNotFoundException e) {
			throw new ExceptionInInitializerError(e);
		}
		HashMap<ContextField, Object> m = new HashMap<>();
		m.put(ContextField.INSTANCE, getInstance());
		m.put(ContextField.LICENCE_MANAGER, licenseManager());
		CONTEXT = Collections.unmodifiableMap(m);
	}

	@Override
	protected double nativeCompareCode(byte[] code1, byte[] code2) {
		return V2AndroidBridge.FFSimilarityByteV2(code1,code2);
	}


	@Override
	public byte[] nativeGetFaceFeature(byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
		NativeFaceInfo nativeFaceInfo = NativeFaceInfo.toNative(faceInfo);
		V2AndroidBridge instance = poolWrap.applyInstance();
		try{
			sdkRuntime.setInstanceParam(instance,RuntimeParam.featureThreadNumber);
			 return instance.feaExtractByte(imgMatrix, width, height, nativeFaceInfo.nativeData);
		}finally{
			poolWrap.returnInstance(instance);
		}
	}
}
