package gu.simplemq.activemq;

import static javax.naming.Context.PROVIDER_URL;
import static org.apache.activemq.ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL;

import java.util.Properties;

import gu.simplemq.MQConstProvider;

public class ActivemqConstProvider implements MQConstProvider,ActivemqConstants{
	public static final ActivemqConstProvider APROVIDER = new ActivemqConstProvider();
	private static final String[] optionalLocationNames = new String[]{PROVIDER_URL,ACON_BROKER_URL};
	
	private ActivemqConstProvider() {
		super();
	}

	@Override
	public String getDefaultSchema() {
		return DEFAULT_AMQ_SCHEMA;
	}

	@Override
	public String getDefaultHost() {
		return DEFAULT_AMQ_HOST;
	}

	@Override
	public int getDefaultPort() {
		return DEFAULT_AMQ_PORT;
	}

	@Override
	public String getDefaultMQLocation() {
		return DEFAULT_BROKER_BIND_URL;
	}
	
	@Override
	public String getMainLocationName() {
		return ACON_BROKER_URL;
	}
	
	@Override
	public String getMainUserName() {
		return ACON_USERNAME;
	}

	@Override
	public String getMainPassword() {
		return ACON_PASSWORD;
	}

	@Override
	public String getMainClientID() {
		return ACON_CLIENTID;
	}

	@Override
	public String[] getOptionalLocationNames(){
		return optionalLocationNames;
	}
	@Override
	public Properties getDefaultMQProperties(){
		return ActivemqPoolLazys.DEFAULT_PARAMETERS;
	}
}
