package gu.simplemq.activemq;

import gu.simplemq.Constant;
import gu.simplemq.pool.BaseMQInstance;

/**
 * redis对象工厂类用于获取producer/consumer,publisher/subscriber,table对象<br>
 * 应用程序结束时会自动清除所有subscriber和consumer
 * @author guyadong
 *
 */
public class ActivemqFactory implements Constant {

	private ActivemqFactory() {}
	private static  final BaseMQInstance<ActivemqConsumer,ActivemqPoolLazy> CONSUMERS = 
			new BaseMQInstance<ActivemqConsumer,ActivemqPoolLazy>(){
		@Override
		protected void beforeDelete(ActivemqConsumer r) {
			try {
				r.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
	}};
	private static final BaseMQInstance<ActivemqSubscriber,ActivemqPoolLazy> SUBSCRIBERS = 
			new BaseMQInstance<ActivemqSubscriber,ActivemqPoolLazy>(){
		@Override
		protected void beforeDelete(ActivemqSubscriber r) {
			try {
				r.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
	}};
	private static final BaseMQInstance<ActivemqProducer,ActivemqPoolLazy> PRODUCERS = 
			new BaseMQInstance<ActivemqProducer,ActivemqPoolLazy>(){
		@Override
		protected void beforeDelete(ActivemqProducer r) {
			r.close();
	}};
	private static final BaseMQInstance<ActivemqPublisher,ActivemqPoolLazy> PUBLISHERS = 
			new BaseMQInstance<ActivemqPublisher,ActivemqPoolLazy>(){};
	/**
	 * 返回 {@link ActivemqPoolLazy}对应的{@link ActivemqConsumer}实例
	 * @param jedisPoolLazy
	 * @return
	 * @see gu.simplemq.pool.BaseMQInstance#getInstance(gu.simplemq.activemq.ActivemqPoolLazy)
	 */
	public static ActivemqConsumer getConsumer(ActivemqPoolLazy jedisPoolLazy) {
		return CONSUMERS.getInstance(jedisPoolLazy);
	}
	
	/** 
	 * 返回{@link ActivemqPoolLazy}默认实例对应的{@link ActivemqConsumer}实例
	 * @see  {@link ActivemqPoolLazy#getDefaultInstance()}
	 */
	public static ActivemqConsumer getConsumer() {
		return CONSUMERS.getInstance(ActivemqPoolLazys.getDefaultInstance());
	}
	/**
	 * 返回 {@link ActivemqPoolLazy}对应的{@link ActivemqSubscriber}实例
	 * @param jedisPoolLazy
	 * @return
	 * @see gu.simplemq.pool.BaseMQInstance#getInstance(gu.simplemq.activemq.ActivemqPoolLazy)
	 */
	public static ActivemqSubscriber getSubscriber(ActivemqPoolLazy jedisPoolLazy) {
		return SUBSCRIBERS.getInstance(jedisPoolLazy);
	}
	/** 
	 * 返回{@link ActivemqPoolLazy}默认实例对应的{@link ActivemqSubscriber}实例
	 * @see  {@link ActivemqPoolLazy#getDefaultInstance()}
	 */
	public static ActivemqSubscriber getSubscriber() {
		return SUBSCRIBERS.getInstance(ActivemqPoolLazys.getDefaultInstance());
	}
	/**
	 * 返回 {@link ActivemqPoolLazy}对应的{@link ActivemqProducer}实例
	 * @param jedisPoolLazy
	 * @return
	 * @see gu.simplemq.pool.BaseMQInstance#getInstance(gu.simplemq.activemq.ActivemqPoolLazy)
	 */
	public static ActivemqProducer getProducer(ActivemqPoolLazy jedisPoolLazy) {
		return PRODUCERS.getInstance(jedisPoolLazy);
	}
	/** 
	 * 返回{@link ActivemqPoolLazy}默认实例对应的{@link ActivemqProducer}实例
	 * @see  {@link ActivemqPoolLazy#getDefaultInstance()}
	 */
	public static ActivemqProducer getProducer() {
		return PRODUCERS.getInstance(ActivemqPoolLazys.getDefaultInstance());
	}
	/**
	 * 返回 {@link ActivemqPoolLazy}对应的{@link ActivemqPublisher}实例
	 * @param jedisPoolLazy
	 * @return
	 * @see gu.simplemq.pool.BaseMQInstance#getInstance(gu.simplemq.activemq.ActivemqPoolLazy)
	 */
	public static ActivemqPublisher getPublisher(ActivemqPoolLazy jedisPoolLazy) {
		return PUBLISHERS.getInstance(jedisPoolLazy);
	}
	/** 
	 * 返回{@link ActivemqPoolLazy}默认实例对应的{@link ActivemqPublisher}实例
	 * @see  {@link ActivemqPoolLazy#getDefaultInstance()}
	 */
	public static ActivemqPublisher getPublisher() {
		return PUBLISHERS.getInstance(ActivemqPoolLazys.getDefaultInstance());
	}
	/**
	 * 关闭并删除所有consumer,subscriber,producer
	 */
	public synchronized static void closeAll(){
		CONSUMERS.clearInstances();
		SUBSCRIBERS.clearInstances();
		PRODUCERS.clearInstances();
	}
	static {
		// JVM 结束时自动清除所有consumer和subscriber,producer对象
		Runtime.getRuntime().addShutdownHook(new Thread(){

			@Override
			public void run() {
				try {
					AdvisoryMessageManager.closeAll();
					closeAll();
					// 毁连接池对象
					ActivemqPoolLazys.closeAll();
				} catch (Exception e) {
					logger.error(e.toString());
				}
			}			
		});
	}
}
