package gu.simplemq.activemq;

import java.net.URI;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;

import org.apache.activemq.pool.PooledConnectionFactory;

import gu.simplemq.pool.BaseMQPool;
import static gu.simplemq.activemq.ActivemqPoolLazys.POOLS;
import static gu.simplemq.activemq.ActivemqPoolLazys.setDefaultInstance;
/**
 * 延迟初始化的 {@link Connection}资源池（线程安全）,使用方法:<br>
 * 通过 {@link #getDefaultInstance()} 和getInstance(...)系列静态方法获取{@link ActivemqPoolLazy}实例<br>
 * 通过{@link #apply()} 和 {@link #free()}方法实现{@link Connection}对象的申请和释放
 * @author guyadong
 *
 */
public class ActivemqPoolLazy extends BaseMQPool<Connection> implements ActivemqConstants{
	private final Properties parameters;
	
	public Properties getParameters() {
		return new Properties(parameters);
	}

	private volatile PooledConnectionFactory pool;
	protected ActivemqPoolLazy (Properties props) {
		this.parameters = PropertiesHelper.AHELPER.initParameters(props);
		URI uri =  PropertiesHelper.AHELPER.getLocationlURI(props);
		POOLS.put(uri,this);
	}
	
	/**
	 * 将当前实例指定为默认实例
	 * @return
	 * @see #setDefaultInstance(ActivemqPoolLazy)
	 */
	public ActivemqPoolLazy asDefaultInstance(){
		setDefaultInstance(this);
		return this;
	}
	private PooledConnectionFactory createPool(){
		URI uri = this.getCanonicalURI();
		PooledConnectionFactory pool = new PooledConnectionFactory();	
		pool.setProperties(parameters);
		logger.info("activemq pool initialized(连接池初始化)  {} ",uri);
		return pool;
	}

	@Override
	public Connection borrow(){
		// double-checked locking
		if(null == pool){
			synchronized (this){
				if(null == pool){
					pool = createPool();
				}
			}
		}
        try {
			return pool.createConnection();
		} catch (JMSException e) {
			throw new RuntimeException(e);
		}
    }
    
	@Override
    public void release(Connection r) {
        if (r != null){
            try {
				r.close();
			} catch (JMSException e) {
				throw new RuntimeException(e);
			}
        }
    }
	@Override
	public URI getCanonicalURI(){
		return  PropertiesHelper.AHELPER.getLocationlURI(parameters);
	}
	
	@Override
	public void close(){
		// double check
		if(pool != null){
			synchronized (this){
				if(pool != null){
					pool.stop();
					logger.info("discard activemq pool: {}",this);
					pool = null;					
					closed = true;
				}
			}
		}
	}
}
