package gu.simplemq.activemq;

import javax.jms.Connection;
import gu.simplemq.BaseMQProducer;
import gu.simplemq.IConsumerAdvisor;
import gu.simplemq.IProducer;
import gu.simplemq.activemq.BaseSender.ProducerSender;
/**
 * {@link IProducer} ACTIVEMQ实现
 * @author guyadong
 *
 */
public class ActivemqProducer extends BaseMQProducer<Connection> implements AutoCloseable,ActivemqConstants{
	private final AdvisoryMessageManager advisoryMessageManager;
	private final ProducerSender sender;
	public ActivemqProducer(ActivemqPoolLazy poolLazy) {
		super(poolLazy);
		this.advisoryMessageManager = AdvisoryMessageManager.instanceOf(poolLazy);
		this.sender = new ProducerSender(advisoryMessageManager);
	}

	@Override
	public IConsumerAdvisor getAdvisor() {
		return advisoryMessageManager;
	}

	@Override
	protected void doSend(Connection c, String channel, Iterable<String> messages) throws Exception {
		sender.doSend(c, channel, messages);		
	}

	@Override
	public void close()  {
		advisoryMessageManager.close();
	}

}
