package gu.simplemq.activemq;

import javax.jms.Connection;
import gu.simplemq.BaseMQPublisher;
import gu.simplemq.IConsumerAdvisor;
import gu.simplemq.IPublisher;
import gu.simplemq.activemq.BaseSender.PublishSender;

/**
 * 
 * {@link IPublisher} ACTIVEMQ实现
 * @author guyadong
 *
 */
public class ActivemqPublisher extends BaseMQPublisher<Connection> implements ActivemqConstants{
	private final PublishSender sender;
	private final AdvisoryMessageManager advisoryMessageManager;
	public ActivemqPublisher(ActivemqPoolLazy poolLazy) {
		super(poolLazy);
		this.advisoryMessageManager = AdvisoryMessageManager.instanceOf(poolLazy);
		sender = new PublishSender(advisoryMessageManager);
	}
	@Override
	protected void doSend(Connection c, String channel, Iterable<String> messages) throws Exception {
		sender.doSend(c, channel, messages);		
	}
	@Override
	public IConsumerAdvisor getConsumerAdvisor() {
		return advisoryMessageManager;
	}
}
