package gu.simplemq.activemq;

import javax.jms.Destination;
import javax.jms.JMSException;

/**
 * ACTIVEMQ 消息订阅实现(线程安全)<br>
 * 每个 {@link ActivemqPoolLazy} 实例对应保持一个 {@link ActivemqSubscriber} 对象<br>
 * 对象可以复用(反复打开关闭) <br>
 * @author guyadong
 *
 */
public class ActivemqSubscriber extends BaseActivemqDispatcher {
	ActivemqSubscriber(ActivemqPoolLazy pool) {
		super(pool);
	}

	@Override
	protected Destination makeDestination(String name) throws JMSException {
		return getSession().createTopic(name);
	}
	
}
