package gu.simplemq.activemq;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import com.google.common.net.HostAndPort;

import gu.simplemq.BaseMessageQueueFactory;
import gu.simplemq.IConsumer;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.IProducer;
import gu.simplemq.IPublisher;
import gu.simplemq.ISubscriber;
import gu.simplemq.MQLocationType;
import gu.simplemq.MessageQueueType;
import gu.simplemq.mqtt.MqttConstants;
import gu.simplemq.utils.MQProperties;
import gu.simplemq.utils.URISupport;

import static gu.simplemq.activemq.ActivemqPoolLazys.createInstance;
import static gu.simplemq.activemq.PropertiesHelper.AHELPER;

/**
 * {@link IMessageQueueFactory}接口的activemq实现类
 * @author guyadong
 *
 */
public final class MessageQueueFactoryImpl extends BaseMessageQueueFactory<ActivemqPoolLazy> implements ActivemqConstants,MqttConstants {
	public static final String MQTT_SCHEMA = "mqtt";

	private volatile MQProperties props;
	private IMessageQueueFactory mqttFactory;

	private AdvisoryMessageManager advisoryMessageManager;
	
	public MessageQueueFactoryImpl() {
	}

	@SuppressWarnings({ "unchecked", "rawtypes", "resource" })
	@Override
	protected void doInit(Map<String, Object> properties){
		mqConnParams = properties;
		props =  AHELPER.with(MQLocationType.QUEUE).initParameters(properties);
		pool = createInstance(props);
		advisoryMessageManager = AdvisoryMessageManager.instanceOf(pool);

		String pubsub = AHELPER.with(MQLocationType.PUBSUB).getLocationAsString(properties);
		if(pubsub != null){
			URI uri = URI.create(pubsub);
			if(MQTT_SCHEMA.equals(uri.getScheme())){
				try {
					uri = URISupport.changeScheme(uri, DEFAULT_MQTT_SCHEMA);
				} catch (URISyntaxException e) {
					throw new RuntimeException(e);
				}
				MQProperties p = gu.simplemq.mqtt.PropertiesHelper.MHELPER.initParameters(properties).initURI(uri);
				mqttFactory = new gu.simplemq.mqtt.MessageQueueFactoryImpl().init((Map)p).forPubsub(advisoryMessageManager);
			}
		}
	}
	@Override
	protected HostAndPort doGetHostAndPort() {
		return AHELPER.getHostAndPort(props);
	}

	@Override
	public ISubscriber getSubscriber() {
		if(mqttFactory != null){
			return mqttFactory.getSubscriber();
		}
		return ActivemqFactory.getSubscriber(getPool());
	}

	@Override
	public IPublisher getPublisher() {
		if(mqttFactory != null){
			return mqttFactory.getPublisher();
		}
		return ActivemqFactory.getPublisher(getPool());
	}

	@Override
	public IProducer getProducer() {
		return ActivemqFactory.getProducer(getPool());
	}

	@Override
	public IConsumer getConsumer() {
		return ActivemqFactory.getConsumer(getPool());
	}

	@Override
	public final MessageQueueType getImplType(){
		return MessageQueueType.ACTIVEMQ;
	}

	@Override
	public boolean testConnect(){
		return AHELPER.testConnect(props);
	}

	@Override
	public void close() throws IOException {
		if(mqttFactory != null){
			((gu.simplemq.mqtt.MessageQueueFactoryImpl)mqttFactory).close();
		}
		advisoryMessageManager.close();
		super.close();
	}
}
