package gu.simplemq.activemq;

import java.util.Properties;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;

import gu.simplemq.MQConstProvider;
import gu.simplemq.utils.MQPropertiesHelper;

/**
 * @author guyadong
 *
 */
public class PropertiesHelper extends MQPropertiesHelper {
	public static final PropertiesHelper AHELPER = new PropertiesHelper();
	PropertiesHelper() {}
	
	@Override
	public MQConstProvider getConstProvider() {
		return ActivemqConstProvider.APROVIDER;
	}	
	@Override
	public void checkConnect(Properties input) throws JMSException{
		Properties props = initParameters(input);
	    ActiveMQConnectionFactory facetory = new ActiveMQConnectionFactory();
	    facetory.setProperties(props);
	    Connection con = null;
	    Session session = null;
	    try {
	    	con = facetory.createConnection();
	    	session = con.createSession(Boolean.FALSE, Session.AUTO_ACKNOWLEDGE);
	    } finally{
	    	if(session != null){
	    		session.close();
	    	}
	    	if(con != null){
				con.close();
	    	}
	    }

	}

	@Override
	public boolean testConnect(Properties props){
		try {
			checkConnect(props);
			return true;
		} catch (JMSException je) {	      
		      return false;
		}
	}
}
