/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class IMessageAdapterDecorator<T>
implements IMessageAdapter<T> {
    private IMessageAdapter<T> adapter;
    private static final Executor executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("message-adapter-%d").build()));

    public IMessageAdapterDecorator() {
        this(null);
    }

    public IMessageAdapterDecorator(IMessageAdapter<T> adapter) {
        this.setAdapter(adapter);
    }

    public IMessageAdapter<T> getAdapter() {
        return this.adapter;
    }

    public IMessageAdapterDecorator<T> setAdapter(IMessageAdapter<T> adapter) {
        this.adapter = adapter;
        return this;
    }

    @Override
    public void onSubscribe(final T t) throws SmqUnsubscribeException {
        if (this.adapter != null) {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    IMessageAdapterDecorator.this.adapter.onSubscribe(t);
                }
            });
        }
    }

    protected Executor getExecutor() {
        return executor;
    }

    public static <T> IMessageAdapterDecorator<T> makeInstance(IMessageAdapter<T> adapter) {
        if (adapter instanceof IMessageAdapterDecorator) {
            return (IMessageAdapterDecorator)adapter;
        }
        return new IMessageAdapterDecorator<T>(adapter);
    }
}

