/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import gu.simplemq.IMessageQueueConfigManager;
import gu.simplemq.MessageQueueType;
import gu.simplemq.SimpleLog;
import java.util.Iterator;
import java.util.ServiceLoader;

public class MessageQueueConfigManagers {
    private static volatile ImmutableMap<MessageQueueType, IMessageQueueConfigManager> managers;
    private static volatile IMessageQueueConfigManager defaultManager;

    private MessageQueueConfigManagers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean setDefaultManager(IMessageQueueConfigManager defaultManager) {
        if (MessageQueueConfigManagers.defaultManager == null) {
            Class<MessageQueueConfigManagers> clazz = MessageQueueConfigManagers.class;
            // MONITORENTER : gu.simplemq.MessageQueueConfigManagers.class
            if (MessageQueueConfigManagers.defaultManager == null) {
                if (defaultManager != null) {
                    MessageQueueConfigManagers.defaultManager = defaultManager;
                    // MONITOREXIT : clazz
                    return true;
                }
                SimpleLog.log("input argument 'defaultFactory' is null", new Object[0]);
                // MONITOREXIT : clazz
                return false;
            }
            // MONITOREXIT : clazz
        }
        SimpleLog.log("INVALID INVOCATION,default manager was initialized already before this invocation", new Object[0]);
        return false;
    }

    public static IMessageQueueConfigManager getDefaultManager() {
        return (IMessageQueueConfigManager)Preconditions.checkNotNull((Object)defaultManager, (Object)"defaultManager is uninitialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImmutableMap<MessageQueueType, IMessageQueueConfigManager> getManagers() {
        if (managers != null) return managers;
        Class<MessageQueueConfigManagers> clazz = MessageQueueConfigManagers.class;
        synchronized (MessageQueueConfigManagers.class) {
            if (managers != null) return managers;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ServiceLoader<IMessageQueueConfigManager> providers = ServiceLoader.load(IMessageQueueConfigManager.class);
            Iterator<IMessageQueueConfigManager> itor = providers.iterator();
            int count = 0;
            IMessageQueueConfigManager manager = null;
            while (itor.hasNext()) {
                manager = itor.next();
                builder.put((Object)manager.getImplType(), (Object)manager);
                ++count;
            }
            Preconditions.checkState((count > 0 ? 1 : 0) != 0, (String)"NOT FOUND instance of %s", (Object)IMessageQueueConfigManager.class.getName());
            managers = builder.build();
            if (count != 1) return managers;
            MessageQueueConfigManagers.setDefaultManager(manager);
            // ** MonitorExit[var0] (shouldn't be in output)
            return managers;
        }
    }

    public static IMessageQueueConfigManager getManager(String implType) {
        return MessageQueueConfigManagers.getManager(MessageQueueType.valueOf(implType));
    }

    public static IMessageQueueConfigManager getManager(MessageQueueType implType) {
        return (IMessageQueueConfigManager)Preconditions.checkNotNull((Object)MessageQueueConfigManagers.getManagers().get((Object)implType), (String)"INVALID impltype,INVALID VALUES:%", (Object)Joiner.on((String)".").join((Iterable)MessageQueueConfigManagers.getManagers().keySet()));
    }
}

